package com.stonecrusher.add;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetHeadNameByHeadId;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class AddDailyExpense extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 4314678329260462055L;
	private SessionMap<String,Object> sessionMap;
	private String expenseDate;
	private String expenseReason;
	private Float amount;
	private String typeOfPayment;
	private String description;
	private File expenseImage;
	private List<String> paymentTypeList = new ArrayList<String>();
	private HttpSession session;
	private String addSideBarJs;
	private String accountId;
	
	private String chequeNumber;
	private String chequePayDate;
	private String chequePayee;
	private String bankName;
	private String branchName;
	private String accountHeadCode;
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeList = new ArrayList<String>();

	private Map<String,String> accountHeadList = new LinkedHashMap<String,String>();
	private Map<String,String> accountList = new LinkedHashMap<String,String>();

	
	private Map<String,String> siteList = new LinkedHashMap<String,String>();
	
	private String siteCode;
	
	private String expenseId;
	private boolean expenseSaved;
	
	
	public String execute() throws IOException{
		 
		String result = "login";
		this.setSession(ServletActionContext.getRequest().getSession(false)); 
		
	        if(this.getSession()==null || this.getSession().getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) this.getSession().getAttribute("db");
				FileInputStream fis  = null;
				
				Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	
	        	String today = dateFormat.format(d);
				
	        	  java.util.Date date = new java.util.Date();
        	      long t = date.getTime();	        	     
        	      java.sql.Time time = new java.sql.Time(t);
        	      
				if(this.getExpenseImage() != null)
				{
				 fis =  new FileInputStream(this.getExpenseImage());
				}
			
					try
					{
						String user = (String) session.getAttribute("userFullName");
						String shortName = "";
						
						try
						{
							shortName = user.split(" ")[0];
						}catch(Exception e)
						{
							shortName = user;
						}
					
						connection = GetDBConnection.getDBConnection(db);
						connection.setAutoCommit(false);
						
						sql = "SELECT "
								+ "entry_id "
								+ "FROM "
								+ "crusher_daily_expenses "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY "
								+ "entry_id "
								+ "DESC LIMIT 1;";
						
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					int nextExpenseId = 0;
					
					if(resultSet.next())
					{
						if(!(resultSet.getString(1) == null))
						{
							nextExpenseId = Integer.parseInt(resultSet.getString(1));
							
							
							nextExpenseId = nextExpenseId+1;
						}
						else
						{
							nextExpenseId =1;
						}
					}
						
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(preparedStatement != null)
					{
						preparedStatement.close();
						preparedStatement = null;
					}
					
					
						if(this.getExpenseImage() != null)
						{
							sql = "INSERT INTO "
									+ "crusher_daily_expenses "
									+ "("
									+ "entry_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "head_id,"
									+ "head_name,"
									+ "expense_date,"
									+ "expense_time,"
									+ "expense_reason,"
									+ "expense_amount,"
									+ "type_of_payment,"
									+ "account_id,"
									+ "expense_details,"
									+ "expense_bill_image,"
									+ "expense_entry_by,"
									+ "site_code)"
									+ "values "
									+ "(?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?,?,?)";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setString(1, ""+nextExpenseId);
							preparedStatement.setString(2, crusherId);
			        		preparedStatement.setString(3, crusherCode);
			        		preparedStatement.setString(4, this.getAccountHeadCode());
							preparedStatement.setString(5, GetHeadNameByHeadId.getTaxPercentageById(this.getAccountHeadCode(), connection, this.getSessionMap()));
							preparedStatement.setString(6, this.getExpenseDate());
							preparedStatement.setTime(7, time);
							preparedStatement.setString(8, this.getExpenseReason().trim().toUpperCase());
							preparedStatement.setFloat(9, this.getAmount());
							preparedStatement.setString(10, this.getTypeOfPayment());
							preparedStatement.setString(11, this.getAccountId());
							preparedStatement.setString(12, this.getDescription().trim().toUpperCase());							
							preparedStatement.setBinaryStream(13, fis,(int)this.getExpenseImage().length() );
							preparedStatement.setString(14, shortName);
							preparedStatement.setString(15, this.getSiteCode());
						
						}						
						else if(this.getExpenseImage() == null)
						{
							sql = "INSERT INTO "
									+ "crusher_daily_expenses "
									+ "("
									+ "entry_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "head_id,"
									+ "head_name,"
									+ "expense_date,"
									+ "expense_time,"
									+ "expense_reason,"
									+ "expense_amount,"
									+ "type_of_payment,"
									+ "account_id,"
									+ "expense_details,"
									+ "expense_entry_by,"
									+ "site_code,"
									+ "credit_debit_id)"
									+ "values "
									+ "(?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?,?,?)";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setString(1, ""+nextExpenseId);
							preparedStatement.setString(2, crusherId);
			        		preparedStatement.setString(3, crusherCode);
			        		preparedStatement.setString(4, this.getAccountHeadCode());
							preparedStatement.setString(5, GetHeadNameByHeadId.getTaxPercentageById(this.getAccountHeadCode(), connection, this.getSessionMap()));							
							preparedStatement.setString(6, this.getExpenseDate());
							preparedStatement.setTime(7, time);
							preparedStatement.setString(8, this.getExpenseReason().trim().toUpperCase());
							preparedStatement.setFloat(9, this.getAmount());
							preparedStatement.setString(10, this.getTypeOfPayment());
							preparedStatement.setString(11, this.getAccountId());
							preparedStatement.setString(12, this.getDescription().trim().toUpperCase());
							preparedStatement.setString(13, shortName);
							preparedStatement.setString(14, this.getSiteCode());
							preparedStatement.setString(15, "0");
						}
						
						int i = preparedStatement.executeUpdate();
						
						
    	        		if(i>0)	
    	        		{
    	        			
    	        			if(this.getTypeOfPayment().equals("CHEQUE"))
    	        			{
	    	        			
	    	        			if(preparedStatement != null)
	    	        			{
	    	        				preparedStatement.close();
	    	        				preparedStatement = null;
	    	        			}
	    	        			
	    	        			sql = "UPDATE "
	    	        					+ "cheque_book_details_master "
	    	        					+ "SET "
	    	        					+ "cheuqe_pay_date = STR_TO_DATE(?,'%d-%m-%Y'),"
	    	        					+ "cheque_payee = ?,"
	    	        					+ "cheque_amount = ?,"
	    	        					+ "cheque_status = 'GIVEN',"
	    	        					+ "chaque_status_change_date = STR_TO_DATE(?,'%d-%m-%Y'),"
	    	        					+ "reason_for_cheque_given = ?,"
	    	        					+ "status_changed_by = ? "
	    	        					+ "WHERE "
	    	        					+ "cheque_number = ? "
	    	        					+ "AND "
	    	        					+ "cheque_book_bank_name = ? "
	    	        					+ "AND "
	    	        					+ "cheque_book_branch_name = ? "
	    	        					+ "AND "
	    								+ "crusher_id = ? "
	    								+ "AND "
	    								+ "crusher_code = ? ";
	    	        			
	    	        			preparedStatement = connection.prepareStatement(sql);
	    	        			
	    	        			preparedStatement.setString(1, this.getChequePayDate());
	    	        			preparedStatement.setString(2, this.getChequePayee().trim().toUpperCase());
	    	        			preparedStatement.setFloat(3, this.getAmount());
	    	        			preparedStatement.setString(4, today);
	    	        			preparedStatement.setString(5, this.getExpenseReason().trim().toUpperCase());
	    	        			preparedStatement.setString(6, shortName);
	    	        			preparedStatement.setString(7, this.getChequeNumber());
	    	        			preparedStatement.setString(8, this.getBankName());
	    	        			preparedStatement.setString(9, this.getBranchName());
	    	        			preparedStatement.setString(10, crusherId);
	    	    				preparedStatement.setString(11, crusherCode);
	    	    				
	    	        			int rowCountUpdated = preparedStatement.executeUpdate();
	    	        			
	    	        			if(rowCountUpdated > 0)
	    	        			{
	    	        				addActionMessage(this.getText("message.success.chequeDetailsUpdatedSuccessfully"));
	    	        			}
	    	        			else
	    	        			{
	    	        				addActionError(this.getText("message.error.couldNotUpdateChequeDetails"));
	    	        			}
    	        			}
    	        		
    	        			
    	        			
    	        			
    	        			if(!this.getTypeOfPayment().equals("CHEQUE"))
    	        			{

    							
    							
    							
    	        				sql = "SELECT "
    									+ "entry_id "
    									+ "FROM "
    									+ "bank_account_credit_debit_master "
    									+ "WHERE "
    									+ "crusher_id = ? "
    									+ "AND "
    									+ "crusher_code = ? "
    									+ "ORDER BY "
    									+ "entry_id "
    									+ "DESC LIMIT 1;";
    							
    						
    						preparedStatement = connection.prepareStatement(sql);
    						preparedStatement.setString(1, crusherId);
    						preparedStatement.setString(2, crusherCode);
    						
    						resultSet = preparedStatement.executeQuery();
    						
    						int entryId = 1;
    					
    						if(resultSet.next())
    						{
    							if(!(resultSet.getString(1) == null))
    							{
    								entryId = Integer.parseInt(resultSet.getString(1));
    								entryId = entryId + 1;
    								
    							}
    							
    						}
    						else
    						{	entryId =1;
    							
    						}
    						
    		        		
    	        				
    	        				if(resultSet != null)
    	    	        		{
    	    	        			resultSet.close();
    	    	        			resultSet = null;
    	    	        		}
    	    	        		if(preparedStatement!= null)
    	    	        		{
    	    	        			preparedStatement.close();
    	    	        			preparedStatement = null;
    	    	        		}
    	        				
    	    	        		String accountNumber = "";
    	    	        		sql = "SELECT "
    	    	        				+ "account_number "
    	    	        				+ "FROM "
    	    	        				+ "crusher_bank_account "
    	    	        				+ "WHERE "
    	    	        				+ "account_id  = ? "
    	    	        				+ "AND "
    									+ "crusher_id = ? "
    									+ "AND "
    									+ "crusher_code = ? ";
    	    	        			
    	    	        		preparedStatement = connection.prepareStatement(sql);
    	    	        		
    	    	        		preparedStatement.setString(1, this.getAccountId());
    	    	        		preparedStatement.setString(2, crusherId);
    	    					preparedStatement.setString(3, crusherCode);
    	    					
    	    	        		resultSet = preparedStatement.executeQuery();
    	    	        		if(resultSet.next())
    	    	        		{
    	    	        			accountNumber = resultSet.getString(1);
    	    	        		}
    	    	        		

    	    	        		if(resultSet != null)
    	    	        		{
    	    	        			resultSet.close();
    	    	        			resultSet = null;
    	    	        		}
    	    	        		if(preparedStatement!= null)
    	    	        		{
    	    	        			preparedStatement.close();
    	    	        			preparedStatement = null;
    	    	        		}
    	    						
    	    						sql = "INSERT "
    	    								+ "INTO "
    	    								+ "bank_account_credit_debit_master "
    	    								+ "("
    	    								+ "entry_id,"
    	    								+ "crusher_id,"
    	    		        				+ "crusher_code,"
    	    		        				+ "account_id,"
    	    								+ "account_number,"
    	    								+ "entry_date,"
    	    								+ "entry_time,"
    	    								+ "entry_type,"
    	    								+ "amount,"
    	    								+ "payment_type,"
    	    								+ "entry_by,"
    	    								+ "entry_details,"
    	    								+ "entry_source)"
    	    								+ "VALUES "
    	    								+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
    	    						
    	    						preparedStatement = connection.prepareStatement(sql);
    	    						
    	    						preparedStatement.setInt(1, entryId);
    	    						preparedStatement.setString(2, crusherId);
    	    		        		preparedStatement.setString(3, crusherCode);
    	    		        		preparedStatement.setString(4, this.getAccountId());
    	    						preparedStatement.setString(5, accountNumber);
    	    						preparedStatement.setString(6, this.getExpenseDate());
    	    						preparedStatement.setTime(7, time);
    	    						preparedStatement.setString(8, "DEBIT");
    	    						preparedStatement.setFloat(9, this.getAmount());
    	    						preparedStatement.setString(10, this.getTypeOfPayment());
    	    						preparedStatement.setString(11, user);
    	    						preparedStatement.setString(12, this.getExpenseReason());
    	    						preparedStatement.setString(13, "ADD EXPENSE ");
    								
    	    						int rowInsetred = preparedStatement.executeUpdate();
    	    						
    	    						
    								boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId(),"DEBIT", this.getExpenseDate(), this.getAmount(), user, connection, this.getSessionMap());
    							
    	        				
    	    						if(rowInsetred > 0 && isCloseingBalMaintained)
    	    						{
    	    							
    	    							sql = "UPDATE "
    	        	        					+ "crusher_daily_expenses "
    	        	        					+ "SET "
    	        	        					+ "credit_debit_id = ? "
    	        	        					+ "WHERE "
    	    									+ "entry_id = ? "
    	    									+ "AND "
    	    									+ "crusher_id = ? "
    	    									+ "AND "
    	    									+ "crusher_code = ? ";
    	        	        			
    	        	        			
    		    						preparedStatement = connection.prepareStatement(sql);
    		    						
    		    						preparedStatement.setInt(1, entryId);
    		    						preparedStatement.setInt(2, nextExpenseId);
    		    						preparedStatement.setString(3, crusherId);
    		    		        		preparedStatement.setString(4, crusherCode);
    		    		        		
    		    						int rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
    		        				
    		    						
    		    						
    		    						if(rowCreditDebitIdInsetred > 0 )
    		    						{
    		    							
    		    	        				connection.commit();
    		    	        				result = SUCCESS;
    		    	        				addActionMessage(this.getText("message.success.expenseDetailsAddedSuccessfully"));
    		    						}
    		    						else
    		    						{
    		    							connection.rollback();
        	    							result = ERROR;
        	    							addActionMessage(this.getText("message.error.expenseDetailsCouldNotAddedPlzTryAgainErrorWhileAddingCrDrId"));
    		    						}
    		    						
    		    					
    	    						}
    	    						else
    	    						{
    	    							connection.rollback();
    	    							result = ERROR;
    	    							addActionMessage(this.getText("message.error.expenseDetailsCouldNotBeAddedPlzTryAgain"));
    	    						}
    	        			}
    	        			
    	        			else if(this.getTypeOfPayment().equals("CHEQUE") && !hasActionErrors())
    	        			{
    	        				addActionMessage(this.getText("message.success.expenseDetailsAddedSuccessfully"));
    	        				connection.commit();
    	        				result = "success";
    	        			}
    	        			else
    	        			{
    	        				this.setExpenseReason("");
    	        				this.setAmount(0.0F);
    	        				this.setDescription("");
    	        				connection.rollback();
    	        				result = "error";
    	        				addActionMessage(this.getText("message.error.expenseDetailsCouldNotAdded(cheque)PlzTryAgain"));
    	        			}
							
						}
						else
						{
							result = "error";
							addActionError(this.getText("message.error.errorExpenseDetailsNotAddedPlzTryAgain"));
						}
						
    	        		this.setExpenseReason("");
	        			this.setExpenseImage(null);
	        			this.setDescription("");
	        			this.setAmount(0.0F);
	        			this.setTypeOfPayment("CASH");
	        		
	        			this.setExpenseId(EncryptionDecryption.encrypt(""+nextExpenseId));
	        			this.setExpenseSaved(true);
	        			
	        			
						
					}catch (SQLException e) {
						result = "error";
						e.printStackTrace();
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.expenseDetailsNotAdded"));
					} catch (Exception e) {
						e.printStackTrace();
						result = "error";						
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.expenseDetailsNotAdded"));
					}finally {
						if(resultSet != null)
						{
							try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
						}
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close(); connection = null;}catch (SQLException e) {}
						}
						
					}
	        	
	        	
	        	if(fis != null)
	        	{
	        		fis.close();
	        		fis = null;
	        	}
	        	
	        }
	        return result;
	}

	
	public void validate() {
		this.setAddSideBarJs("FALSE");
		if(this.getExpenseDate().equals("") || this.getExpenseReason().equals("") || this.getAmount() == null  
				|| this.getTypeOfPayment().equals(""))
		{
			addActionError(this.getText("message.error.PlzProvideDetailsForFields*Astrick"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getExpenseReason().length() > 99)
			{
				addActionError(this.getText("message.error.lenghtOfExpenseReasnIsMoreThan100Characters"));
			}
		}
		if(!hasActionErrors())
		{
					
			if(this.getDescription().length() > 199)
			{
				addActionError(this.getText("message.error.lenghtOfDescriptionIsMoreThan200Characters"));
			}
		}
		if(!hasActionErrors())
		{
			if(this.getExpenseImage() != null)
				{
					int sizeOfImage =(int)this.getExpenseImage().length();
					
					if(sizeOfImage >  300000)
					{
						addActionError(this.getText("message.error.sizeOfImagelargeThan300kbPlzReduceSizeOfImage"));
					}
				}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getTypeOfPayment().equals("CHEQUE"))
			{
				if(this.getChequePayDate().equals(""))
				{
					addActionError(this.getText("message.error.plzProvideChequePayDate"));
				}
				if(this.getChequePayee().equals(""))
				{
					addActionError(this.getText("message.error.plzProvideChequePayeeName"));
				}
				if(this.getBankName().equals(""))
				{
					addActionError(this.getText("message.error.plzSelectBank"));
				}
				else if(this.getBranchName().equals(""))
				{
					addActionError(this.getText("message.error.plzSelectBranch"));
				}
				else if(this.getChequeNumber().equals(""))
				{
					addActionError(this.getText("message.error.plzSelectCheque"));
				}
			}
			
		}
		paymentTypeList.add("CASH");
    	paymentTypeList.add("UPI");
    	paymentTypeList.add("RTGS");
    	paymentTypeList.add("NEFT");
    	paymentTypeList.add("CHEQUE");
    	

		this.setAccountHeadList(GetListResource.getAccountHeadList());
	
    	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));  
    
   	 
		this.setSiteList(GetListResource.getSiteList());

	}

	public Map<String, String> getSiteList() {
		return siteList;
	}


	public void setSiteList(Map<String, String> siteList) {
		this.siteList = siteList;
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public String getExpenseDate() {
		return expenseDate;
	}


	public void setExpenseDate(String expenseDate) {
		this.expenseDate = expenseDate;
	}


	public String getExpenseReason() {
		return expenseReason;
	}


	public void setExpenseReason(String expenseReason) {
		this.expenseReason = expenseReason;
	}


	public Float getAmount() {
		return amount;
	}


	public void setAmount(Float amount) {
		this.amount = amount;
	}


	public String getTypeOfPayment() {
		return typeOfPayment;
	}


	public void setTypeOfPayment(String typeOfPayment) {
		this.typeOfPayment = typeOfPayment;
	}


	public String getDescription() {
		return description;
	}


	public void setDescription(String description) {
		this.description = description;
	}


	public File getExpenseImage() {
		return expenseImage;
	}


	public void setExpenseImage(File expenseImage) {
		this.expenseImage = expenseImage;
	}


	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}


	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}


	public String getBankName() {
		return bankName;
	}


	public void setBankName(String bankName) {
		this.bankName = bankName;
	}


	public String getBranchName() {
		return branchName;
	}


	public void setBranchName(String branchName) {
		this.branchName = branchName;
	}


	public String getChequeNumber() {
		return chequeNumber;
	}


	public void setChequeNumber(String chequeNumber) {
		this.chequeNumber = chequeNumber;
	}


	public List<String> getBankList() {
		return bankList;
	}


	public void setBankList(List<String> bankList) {
		this.bankList = bankList;
	}


	public List<String> getBranchList() {
		return branchList;
	}


	public void setBranchList(List<String> branchList) {
		this.branchList = branchList;
	}


	public List<String> getChequeList() {
		return chequeList;
	}


	public void setChequeList(List<String> chequeList) {
		this.chequeList = chequeList;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public String getChequePayee() {
		return chequePayee;
	}


	public void setChequePayee(String chequePayee) {
		this.chequePayee = chequePayee;
	}


	public String getChequePayDate() {
		return chequePayDate;
	}


	public void setChequePayDate(String chequePayDate) {
		this.chequePayDate = chequePayDate;
	}


	public String getAccountId() {
		return accountId;
	}


	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}


	public Map<String, String> getAccountList() {
		return accountList;
	}


	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public Map<String, String> getAccountHeadList() {
		return accountHeadList;
	}


	public void setAccountHeadList(Map<String, String> accountHeadList) {
		this.accountHeadList = accountHeadList;
	}


	public String getAccountHeadCode() {
		return accountHeadCode;
	}


	public void setAccountHeadCode(String accountHeadCode) {
		this.accountHeadCode = accountHeadCode;
	}


	public String getSiteCode() {
		return siteCode;
	}


	public void setSiteCode(String siteCode) {
		this.siteCode = siteCode;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	public String getExpenseId() {
		return expenseId;
	}


	public void setExpenseId(String expenseId) {
		this.expenseId = expenseId;
	}


	public boolean isExpenseSaved() {
		return expenseSaved;
	}


	public void setExpenseSaved(boolean expenseSaved) {
		this.expenseSaved = expenseSaved;
	}
	
	

}

	
