package com.stonecrusher.add;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.infrawhatsappmsg.CheckBalance;
import com.stonecrusher.infrawhatsappmsg.SendWhatsAppMessage;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetTypeOfPaymentList;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class AddCustomerPaymentDetails extends ActionSupport implements SessionAware{

	

	/**
	 * 
	 */
	private static final long serialVersionUID = -6951193318057332729L;
	private SessionMap<String,Object> sessionMap;
	private HttpSession session;
	private String key;
	private String paymentDate;
	private String custName;
	private Float totalAmount; 
	private String paymentDetails;
	private Float outstandingAmount;
	private boolean sendSMS;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private String accountId1;
	private String typeOfPayment1;
	private Float amount1;
	
	private String accountId2;
	private String typeOfPayment2;
	private Float amount2;
	
	
	private String addSideBarJs;
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private List<String> paymentTypeList = new ArrayList<String>();
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;

				  java.util.Date date = new java.util.Date();
        	      long t = date.getTime();	        	     
        	      java.sql.Time time = new java.sql.Time(t);
        	   
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				String customerMobileNumber="";
					try
					{
						
						String user = (String) session.getAttribute("userFullName");
						String userName = "";
						
						try
						{
							userName = user.split(" ")[0];
						}catch(Exception e)
						{
							userName = user;
						}
						
						
						String custId = EncryptionDecryption.decrypt(getKey());
						
						connection = GetDBConnection.getDBConnection(db);
						connection.setAutoCommit(false);
						
						
						sql = "SELECT "
								+ "payement_entry_id "
								+ "FROM "
								+ "crusher_customer_payment_details_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY "
								+ "payement_entry_id "
								+ "DESC LIMIT 1;";
						
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					int entryId = 1;
				
					if(resultSet.next())
					{
						if(!(resultSet.getString(1) == null))
						{
							entryId = Integer.parseInt(resultSet.getString(1));
							entryId = entryId + 1;
							
						}
						
					}
					else
					{	entryId =1;
						
					}
					
	        		if(resultSet != null)
	        		{
	        			resultSet.close();
	        			resultSet = null;
	        		}
	        		if(preparedStatement!= null)
	        		{
	        			preparedStatement.close();
	        			preparedStatement = null;
	        		}
						
						
						sql = "SELECT mobile_number "
								+ "FROM "
								+ "crusher_customer_master "
								+ "WHERE "
								+ "customer_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, custId);
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						
						resultSet = preparedStatement.executeQuery();
						
						if(resultSet.next())
						{
							customerMobileNumber = resultSet.getString(1);
						}
						
						
						
						sql = "INSERT INTO "
								+ "crusher_customer_payment_details_master "
								+ "("
								+ "payement_entry_id,"
								+ "crusher_id,"
		        				+ "crusher_code,"
		        				+ "payment_date,"
								+ "customer_id,"
								+ "customer_name,"
								+ "amount,"
								+ "payemnt_details,"
								+ "payment_entry_by,"
								+ "amount_debit_account1_id,"
								+ "payment_type1,"
								+ "account1_amount,"
								+ "amount_debit_account2_id,"
								+ "payment_type2,"
								+ "account2_amount) "  
								+ "values "
								+ "(?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?)";
						
						
						if(preparedStatement != null)
						{
							preparedStatement.close();
							preparedStatement = null;
						}
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, ""+entryId);
						preparedStatement.setString(2, crusherId);
		        		preparedStatement.setString(3, crusherCode);
		        		preparedStatement.setString(4, getPaymentDate());
						preparedStatement.setString(5, custId);
						preparedStatement.setString(6, this.getCustName());
						preparedStatement.setFloat(7, this.getTotalAmount());
						preparedStatement.setString(8, getPaymentDetails());
						preparedStatement.setString(9, userName);
						
						if(this.getAccountId1() == null || this.getAccountId1().equals(""))
						{
							preparedStatement.setString(10, null);
						}else {
							preparedStatement.setString(10, this.getAccountId1());
						}
						if(this.getTypeOfPayment1() == null || this.getTypeOfPayment1().equals(""))
						{
							preparedStatement.setString(11, null);
						}else {
							preparedStatement.setString(11, this.getTypeOfPayment1());
						}
						if(this.getAmount1() == null || this.getAmount1().equals(""))
						{
							preparedStatement.setString(12, null);
							
						}else {
							preparedStatement.setFloat(12, this.getAmount1());
							
						}
						
						if(this.getAccountId2() == null || this.getAccountId2().equals(""))
						{
							preparedStatement.setString(13, null);
							
						}else {
							preparedStatement.setString(13, this.getAccountId2());
							
						}
						if(this.getTypeOfPayment2() == null || this.getTypeOfPayment2().equals(""))
						{
							preparedStatement.setString(14, null);
							
						}else {
							preparedStatement.setString(14, this.getTypeOfPayment2());
							
						}
						if(this.getAmount2() == null || this.getAmount2().equals(""))
						{
							preparedStatement.setString(15, null);
							
						}else {
							preparedStatement.setFloat(15, this.getAmount2());
							
						}
						
						int rowsInserted = preparedStatement.executeUpdate();
						
						if(rowsInserted>0)
						{
							
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							
							
		        		int rowCreditDebitIdInsetred = 0;
		        		
		        		if(!this.getTypeOfPayment1().equals("CHEQUE") && !this.getTypeOfPayment2().equals("CHEQUE") )
	        			{
		        		if(this.getAccountId1() != null && !this.getAccountId1().equals("") && this.getTypeOfPayment1() != null && !this.getTypeOfPayment1().equals(""))
			    		{
		        			
		        			sql = "SELECT "
									+ "entry_id "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? "
									+ "ORDER BY "
									+ "entry_id "
									+ "DESC LIMIT 1;";
							
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						
						resultSet = preparedStatement.executeQuery();
						
						
						int bankEntryId = 1;
					
						if(resultSet.next())
						{
							if(!(resultSet.getString(1) == null))
							{
								bankEntryId = Integer.parseInt(resultSet.getString(1));
								bankEntryId = bankEntryId + 1;
								
							}
							
						}
						else
						{	bankEntryId =1;
							
						}
						
		        		if(resultSet != null)
		        		{
		        			resultSet.close();
		        			resultSet = null;
		        		}
		        		if(preparedStatement!= null)
		        		{
		        			preparedStatement.close();
		        			preparedStatement = null;
		        		}
		        		
		        		String accountNumber = "";
		        		sql = "SELECT "
		        				+ "account_number "
		        				+ "FROM "
		        				+ "crusher_bank_account "
		        				+ "WHERE "
		        				+ "account_id  = ? "
		        				+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
		        			
		        		preparedStatement = connection.prepareStatement(sql);
		        		
		        		preparedStatement.setString(1, this.getAccountId1());
		        		preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						
		        		resultSet = preparedStatement.executeQuery();
		        		if(resultSet.next())
		        		{
		        			accountNumber = resultSet.getString(1);
		        		}
		        		
		        		if(resultSet != null)
		        		{
		        			resultSet.close();
		        			resultSet = null;
		        		}
		        		if(preparedStatement!= null)
		        		{
		        			preparedStatement.close();
		        			preparedStatement = null;
		        		}
		        		
		        		
							sql = "INSERT "
									+ "INTO "
									+ "bank_account_credit_debit_master "
									+ "("
									+ "entry_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details,"
									+ "entry_source) "
									+ "VALUES "
									+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setInt(1, bankEntryId);
							preparedStatement.setString(2, crusherId);
			        		preparedStatement.setString(3, crusherCode);
			        		preparedStatement.setString(4, this.getAccountId1());
							preparedStatement.setString(5, accountNumber);
							preparedStatement.setString(6, this.getPaymentDate());
							preparedStatement.setTime(7, time);
							preparedStatement.setString(8, "CREDIT");
							preparedStatement.setFloat(9, this.getAmount1());
							preparedStatement.setString(10, this.getTypeOfPayment1());
							preparedStatement.setString(11, userName);
							preparedStatement.setString(12, "PAID BY "+this.getCustName()+" Against Outstanding amount: "+this.getOutstandingAmount());
							preparedStatement.setString(13, "CUSTOMER PAYMENT ");
							
							int rowInsetred = preparedStatement.executeUpdate();
							
							
							boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId1(),"CREDIT", this.getPaymentDate(), this.getAmount1(), userName, connection, this.getSessionMap());
							
							if(isCloseingBalMaintained && rowInsetred > 0)
							{
								
								sql = "UPDATE "
        	        					+ "crusher_customer_payment_details_master "
        	        					+ "SET "
        	        					+ "account1_credit_debit_id = ? "
        	        					+ "WHERE "
    									+ "payement_entry_id = ? "
    									+ "AND "
    									+ "crusher_id = ? "
    									+ "AND "
    									+ "crusher_code = ? ";
        	        			
        	        			
	    						preparedStatement = connection.prepareStatement(sql);
	    						
	    						preparedStatement.setInt(1, bankEntryId);
	    						preparedStatement.setInt(2, entryId);
	    						preparedStatement.setString(3, crusherId);
	    		        		preparedStatement.setString(4, crusherCode);
	    		        		
	    						 rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
	        				
							}
	    						
	    					
									
							}
		        		
		        		
		        		
		        		if(this.getAccountId2() != null && !this.getAccountId2().equals("") && this.getTypeOfPayment2() != null && !this.getTypeOfPayment2().equals(""))
			    		{
		        			
		        			sql = "SELECT "
									+ "entry_id "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? "
									+ "ORDER BY "
									+ "entry_id "
									+ "DESC LIMIT 1;";
							
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						
						resultSet = preparedStatement.executeQuery();
						
						
						int bankEntryId = 1;
					
						if(resultSet.next())
						{
							if(!(resultSet.getString(1) == null))
							{
								bankEntryId = Integer.parseInt(resultSet.getString(1));
								bankEntryId = bankEntryId + 1;
								
							}
							
						}
						else
						{	bankEntryId =1;
							
						}
						
		        		if(resultSet != null)
		        		{
		        			resultSet.close();
		        			resultSet = null;
		        		}
		        		if(preparedStatement!= null)
		        		{
		        			preparedStatement.close();
		        			preparedStatement = null;
		        		}
		        		
		        		String accountNumber = "";
		        		sql = "SELECT "
		        				+ "account_number "
		        				+ "FROM "
		        				+ "crusher_bank_account "
		        				+ "WHERE "
		        				+ "account_id  = ? "
		        				+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
		        			
		        		preparedStatement = connection.prepareStatement(sql);
		        		
		        		preparedStatement.setString(1, this.getAccountId2());
		        		preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						
		        		resultSet = preparedStatement.executeQuery();
		        		if(resultSet.next())
		        		{
		        			accountNumber = resultSet.getString(1);
		        		}
		        		
		        		if(resultSet != null)
		        		{
		        			resultSet.close();
		        			resultSet = null;
		        		}
		        		if(preparedStatement!= null)
		        		{
		        			preparedStatement.close();
		        			preparedStatement = null;
		        		}
		        		
							sql = "INSERT "
									+ "INTO "
									+ "bank_account_credit_debit_master "
									+ "("
									+ "entry_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details,"
									+ "entry_source) "
									+ "VALUES "
									+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setInt(1, bankEntryId);
							preparedStatement.setString(2, crusherId);
			        		preparedStatement.setString(3, crusherCode);
			        		preparedStatement.setString(4, this.getAccountId2());
							preparedStatement.setString(5, accountNumber);
							preparedStatement.setString(6, this.getPaymentDate());
							preparedStatement.setTime(7, time);
							preparedStatement.setString(8, "CREDIT");
							preparedStatement.setFloat(9, this.getAmount2());
							preparedStatement.setString(10, this.getTypeOfPayment2());
							preparedStatement.setString(11, userName);
							preparedStatement.setString(12, "PAID BY "+this.getCustName()+" Against Outstanding amount: "+this.getOutstandingAmount());
							preparedStatement.setString(13, "CUSTOMER PAYMENT ");
							
							int rowInsetred = preparedStatement.executeUpdate();
							
							
							boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId2(),"CREDIT", this.getPaymentDate(), this.getAmount2(), userName, connection, this.getSessionMap());
							
							if(isCloseingBalMaintained && rowInsetred > 0)
							{
								
								sql = "UPDATE "
        	        					+ "crusher_customer_payment_details_master "
        	        					+ "SET "
        	        					+ "account2_credit_debit_id = ? "
        	        					+ "WHERE "
    									+ "payement_entry_id = ? "
    									+ "AND "
    									+ "crusher_id = ? "
    									+ "AND "
    									+ "crusher_code = ? ";
        	        			
        	        			
	    						preparedStatement = connection.prepareStatement(sql);
	    						
	    						preparedStatement.setInt(1, bankEntryId);
	    						preparedStatement.setInt(2, entryId);
	    						preparedStatement.setString(3, crusherId);
	    		        		preparedStatement.setString(4, crusherCode);
	    		        		
	    						 rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
	        				
							}
	    						
	    					
									
							}
		        		
	        			}
		        		
		        		if(rowCreditDebitIdInsetred > 0 )
						{
							
							if(this.isSendSMS())
							{
								String crusherNameMarathi = (String) this.getSessionMap().get("crushernamemarathi");
    							String crusherNameEnglish = (String) this.getSessionMap().get("crushernameenglish");
								
								String customerCareNumber = (String) this.getSessionMap().get("crushercustcarenumber");
								
								String defaultWhatsAppNumber = (String) this.getSessionMap().get("defaultWhatsAppNumber");
								
								HashMap<String, String> tokenList = (HashMap<String, String>) this.getSessionMap().get("whatsappmsgtokenlist");
								
								String tokenNumberWithUsername = tokenList.get(defaultWhatsAppNumber);
								
								String [] tokenData = tokenNumberWithUsername.split("#");
								
								String userNameMsg = tokenData[0];
								String tokenNumber = tokenData[1];
								String balanceCheckTokenNumber = tokenData[2];
							
    							String msg = "";
    							
    							String defaultMessageLang = "MARATHI";
    							
    							
    							float totalBalAmt = this.getOutstandingAmount() - this.getTotalAmount();
		    					
    							if(defaultMessageLang.equals("MARATHI"))
    							{
    								
    								msg = "*प्रिय ग्राहक,*";
    								msg += "\n*आपणाकडून एकूण* : "+this.getTotalAmount()+" *रु. मिळाले. धन्यवाद !*";
    								msg += "\n*एकूण येणे बाकी रु.* : "+totalBalAmt;
    								msg += "\n*"+crusherNameMarathi+"*";			    							
    								msg += "\n*संपर्क* : "+customerCareNumber;
    								
    								
    								//System.out.println(fileUrl);
    								String whatsAppResp = SendWhatsAppMessage.sendMessageOnly(userNameMsg, customerMobileNumber, msg, tokenNumber);
    								
    								
    								int bal = CheckBalance.checkBal(userNameMsg, balanceCheckTokenNumber);
    								
    								//System.out.println(whatsAppResp);
    								
    								if(whatsAppResp.contains("success"))
    								{
    									addActionMessage("WhatsApp Message Sent Successfully! Remaining balance : "+bal);
    								}
    								
    							}
							}
							
						
							connection.commit();
							result = "success";
							addActionMessage(this.getText("message.success.paymentDetailsAddedSuccessfully"));
						}
						
						
		        		
		        		
							else
							{
								connection.rollback();
								result = "error";
								addActionError(this.getText("message.error.errorPaymentDetailsNotAddedPlzTryAgain"));
							}
						
						}
					}catch (SQLException e) {
						try {
							connection.rollback();
						} catch (SQLException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
						result = "error";
						e.printStackTrace();
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.customerDetailsNotAdded"));
					} catch (Exception e) {
						e.printStackTrace();
						result = "error";						
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.customerDetailsNotAdded"));
					}finally {
						if(resultSet != null)
		   				{
		   					try {resultSet.close();}catch(SQLException sqe){}   					
		   				}
						if(preparedStatement != null)
						{
							try {preparedStatement.close();} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close();}catch (SQLException e) {}
						}
						
					}
	        	
	        	
	        	
	        	
	        }
	        
	        return result;
	}
	
	@Override
	public void validate() {
		
		this.setAddSideBarJs("FALSE");
		this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap())); 
		this.setPaymentTypeList(GetTypeOfPaymentList.getPaymentTypeList());
    	
		
		if(this.getTotalAmount() == null || this.getTotalAmount().equals("")){
			addActionError(this.getText("message.error.plzProvideAmount"));
		}
		
		
		if(this.getAmount1() == null || this.getAmount1().equals("")){
			addActionError(this.getText("message.error.plzProvideAmount")+"1");
		}
		
		
		
		if(!hasActionErrors()){
    		if(this.getAccountId1() == null || this.getAccountId1().equals(""))
    		{
    			addActionError(this.getText("message.error.plzSelectAccount")+"1");
    		}
    	}
		
		if(!hasActionErrors()){
    		if(this.getAccountId1() != null || !this.getAccountId1().equals(""))
    		{
    			if(this.getTypeOfPayment1() == null || this.getTypeOfPayment1().equals("")){
    				addActionError("Please Provide Type Of Payment 1");
    			}
    			
    			
    		}
    	}
		
		
		if (!hasActionErrors()) {
		    if (this.getAccountId1() != null && this.getAccountId2() != null &&
		        this.getAccountId1().equals(this.getAccountId2())) {
		        
		        addActionError("Account 1 and Account 2 cannot be the same. Please select different accounts.");
		    }
		}
    		
    		
		if(!hasActionErrors()){
    		if(this.getAccountId2().trim() != null && !this.getAccountId2().trim().equals(""))
    		{
    			
    			if(this.getTypeOfPayment2() == null || this.getTypeOfPayment2().equals("")){
    				addActionError("Please Provide Type Of Payment 2");
    			}
    			
    			if(this.getAmount2() == null || this.getAmount2().equals("")){
    				addActionError(this.getText("message.error.plzProvideAmount")+"2");
    			}
    		}
    	}
		
		
		
		if (!hasActionErrors()) {
		    double amt1 = this.getAmount1() != null ? this.getAmount1() : 0;
		    double amt2 = this.getAmount2() != null ? this.getAmount2() : 0;
		    double totalAmt = this.getTotalAmount() != null ? this.getTotalAmount() : 0;

		    if ((amt1 + amt2) != totalAmt) {
		        addActionError("Total of Amount Received (Amount1 + Amount2) must be equal to Total Amount.");
		    }
		}

		
		
		
		
		if(!hasActionErrors())
		{
			if(!getTotalAmount().equals(""))
			{
				float floatAmt = 0.0F;
				float floatOutstandingAmt  = getOutstandingAmount();
				try
				
				{
					
					if(this.getTotalAmount() < 0)
					{
						addActionError(this.getText("message.error.amountCannotBeLessThan0"));
					}
					
					else
					{
						float accepatblePaymentAmount = 0.0F;
						
						accepatblePaymentAmount = floatOutstandingAmt - floatAmt;
						
						/*if(accepatblePaymentAmount <0)
						{
							addActionError("Amount cannot be greater than total outstanding amount !");
						}*/
						
					}
				}
				catch(NumberFormatException nfe)
				{
					addActionError(this.getText("message.error.plzProvideCorrectAmountToAddDetails"));
				}
			}
		}
	}
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public String getKey() {
		return key;
	}
	public void setKey(String key) {
		this.key = key;
	}
	public String getPaymentDate() {
		return paymentDate;
	}
	public void setPaymentDate(String paymentDate) {
		this.paymentDate = paymentDate;
	}
	public String getCustName() {
		return custName;
	}
	public void setCustName(String custName) {
		this.custName = custName;
	}
	
	



	public String getPaymentDetails() {
		return paymentDetails;
	}
	public void setPaymentDetails(String paymentDetails) {
		this.paymentDetails = paymentDetails;
	}


	public Float getOutstandingAmount() {
		return outstandingAmount;
	}

	public void setOutstandingAmount(Float outstandingAmount) {
		this.outstandingAmount = outstandingAmount;
	}

	public boolean isSendSMS() {
		return sendSMS;
	}

	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	

	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	
	
	
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public String getAccountId1() {
		return accountId1;
	}

	public void setAccountId1(String accountId1) {
		this.accountId1 = accountId1;
	}

	public String getTypeOfPayment1() {
		return typeOfPayment1;
	}

	public void setTypeOfPayment1(String typeOfPayment1) {
		this.typeOfPayment1 = typeOfPayment1;
	}

	
	public String getAccountId2() {
		return accountId2;
	}

	public void setAccountId2(String accountId2) {
		this.accountId2 = accountId2;
	}

	public String getTypeOfPayment2() {
		return typeOfPayment2;
	}

	public void setTypeOfPayment2(String typeOfPayment2) {
		this.typeOfPayment2 = typeOfPayment2;
	}

	public Float getAmount1() {
		return amount1;
	}

	public void setAmount1(Float amount1) {
		this.amount1 = amount1;
	}

	public Float getAmount2() {
		return amount2;
	}

	public void setAmount2(Float amount2) {
		this.amount2 = amount2;
	}

	public Float getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(Float totalAmount) {
		this.totalAmount = totalAmount;
	}

	


	
	
	

}
