package com.stonecrusher.add;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetNewIdForNewEntry;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class AddBoulderSupplierPaymentDetails extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -6802538530805180042L;
	private HttpSession session;
	private String defaultValue;
	private String paymentDate;
	private String key;
	private Float debtAmount;
	private Float amountPaid;
	private String boulderSupplierName;
	private String typeOfPayment;
	private String accountId;

	private SessionMap<String,Object> sessionMap;
	
	private String chequePayDate;
	private String chequePayee;
	private String bankName;
	private String branchName;
	private String chequeNumber;
	
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeList = new ArrayList<String>();
	private String details;
	
	
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private List<String> paymentTypeList = new ArrayList<String>();
	private String addSideBarJs;
	
	private boolean sendSMS;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	
	
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				String supplierMobileNumber = "";
				
				

        		String fullUserName = (String) session.getAttribute("userFullName");
	        	
	        	String splitUserName [] = new String[5];
	        	
	        	String entryBy = "";
	        	try
	        	{
	        		splitUserName = fullUserName.split(" ");
	        		entryBy = splitUserName[0];
	        		
	        	}catch(Exception e)
	        	{
	        		entryBy =fullUserName;
	        	}
				
				try
				{
					
					connection = GetDBConnection.getDBConnection(db);
					connection.setAutoCommit(false);
					
					String boulderSupplierId = EncryptionDecryption.decrypt(getKey());
					
					
					
					
	       			sql = "SELECT "
	       					+ "boulder_supplier_id,"
	       					+ "boulder_supplier_name,"
	       					+ "boulder_supplier_mobile_number,"
	       					+ "boulder_supplier_address "
	       					+ "FROM "
	       					+ "crusher_boulder_supplier_master "
	       					+ "WHERE "
	       					+ "boulder_supplier_id =  ? "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, boulderSupplierId);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{
						supplierMobileNumber = resultSet.getString(3);
					}
					else
					{
						addActionError(this.getText("message.error.supplierNotFoundUrlTempered"));						
					}
					
					
					
						
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(preparedStatement != null)
						{
							preparedStatement.close();
							preparedStatement = null;
						}
						
						
						int newEntryId = GetNewIdForNewEntry.getNewIdForNewEntry("crusher_supplier_payment_details_master", "entry_id", this.getSessionMap(), connection);
						
					
						Date d = new Date();
			        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
		        
						  java.util.Date date = new java.util.Date();
		        	      long t = date.getTime();	        	     
		        	      java.sql.Time time = new java.sql.Time(t);
		        	      
						sql = "INSERT INTO "
								+ "crusher_boulder_supplier_payment_master "
								+ "(entry_id,"
								+ "crusher_id,"
		        				+ "crusher_code,"
		        				+ "boulder_supplier_id,"
								+ "boulder_supplier_name,"
								+ "entry_date,"
								+ "payment_entry_date,"
								+ "payment_entry_time,"
								+ "amount,"
								+ "payment_type,"
								+ "payment_details,"
								+ "entry_by,"
								+ "amount_debit_account_id) "
								+ "VALUES "
								+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?)";
						
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setInt(1, newEntryId);
						preparedStatement.setString(2, crusherId);
		        		preparedStatement.setString(3, crusherCode);
		        		preparedStatement.setString(4, boulderSupplierId);
						preparedStatement.setString(5, this.getBoulderSupplierName());
						preparedStatement.setString(6, dateFormat.format(d));
						preparedStatement.setString(7, this.getPaymentDate());
						preparedStatement.setTime(8, time);
						preparedStatement.setFloat(9, this.getAmountPaid());
						preparedStatement.setString(10, this.getTypeOfPayment());
						preparedStatement.setString(11, this.getDetails());
						preparedStatement.setString(12, entryBy);
						preparedStatement.setString(13, this.getAccountId());
						
						int rowCount = preparedStatement.executeUpdate();
						
						if(rowCount > 0)
						{


							
							if(this.getTypeOfPayment().equals("CHEQUE"))
		        			{
								if(preparedStatement != null)
	    	        			{
	    	        				preparedStatement.close();
	    	        				preparedStatement = null;
	    	        			}
	    	        			
	    	        			
	    	        			sql = "UPDATE "
	    	        					+ "cheque_book_details_master "
	    	        					+ "SET "
	    	        					+ "cheuqe_pay_date = STR_TO_DATE(?,'%d-%m-%Y'),"
	    	        					+ "cheque_payee = ?,"
	    	        					+ "cheque_amount = ?,"
	    	        					+ "cheque_status = 'GIVEN',"
	    	        					+ "chaque_status_change_date = STR_TO_DATE(?,'%d-%m-%Y'),"
	    	        					+ "reason_for_cheque_given = ?,"
	    	        					+ "status_changed_by = ? "
	    	        					+ "WHERE "
	    	        					+ "cheque_number = ? "
	    	        					+ "AND "
	    	        					+ "cheque_book_bank_name = ? "
	    	        					+ "AND "
	    	        					+ "cheque_book_branch_name = ? "
	    	        					+ "AND "
	    								+ "crusher_id = ? "
	    								+ "AND "
	    								+ "crusher_code = ? ";
	    	        			
	    	        			preparedStatement = connection.prepareStatement(sql);
	    	        			
	    	        			preparedStatement.setString(1, this.getChequePayDate());
	    	        			preparedStatement.setString(2, this.getChequePayee().trim().toUpperCase());
	    	        			preparedStatement.setFloat(3, this.getAmountPaid());
	    	        			preparedStatement.setString(4, this.getPaymentDate());
	    	        			preparedStatement.setString(5, "Boulder Supplier PAYMENT TO "+this.getBoulderSupplierName().trim().toUpperCase());
	    	        			preparedStatement.setString(6, entryBy);
	    	        			preparedStatement.setString(7, this.getChequeNumber());
	    	        			preparedStatement.setString(8, this.getBankName());
	    	        			preparedStatement.setString(9, this.getBranchName());
	    	        			preparedStatement.setString(10, crusherId);
	    	    				preparedStatement.setString(11, crusherCode);
	    	    				
	    	        			int rowCountUpdated = preparedStatement.executeUpdate();
	    	        			
	    	        			if(rowCountUpdated > 0)
	    	        			{
	    	        				
	    	        				if(preparedStatement != null)
	        	        			{
	        	        				preparedStatement.close();
	        	        				preparedStatement = null;
	        	        			}
	        	        			
	        	        			sql = "UPDATE crusher_boulder_supplier_payment_master "
	        	        					+ "SET "
	        	        					+ "cheque_number = ? "
	        	        					+ "WHERE "
	        	        					+ "entry_id = ? "
	        	        					+ "AND "
	        	        					+ "supplier_id = ? "
	        	        					+ "AND "
	        								+ "crusher_id = ? "
	        								+ "AND "
	        								+ "crusher_code = ? ";
	        	        			
	        	        			
	        	        			preparedStatement = connection.prepareStatement(sql);
	        	        			preparedStatement.setString(1, this.getChequeNumber());
	        	        			preparedStatement.setInt(2, newEntryId);
	        	        			preparedStatement.setString(3, boulderSupplierId);
	        	        			preparedStatement.setString(4, crusherId);
	        	        			preparedStatement.setString(5, crusherCode);
	        	        			
	        	        			
	        	        			int mln = preparedStatement.executeUpdate();
	        	        			
	        	        			if(mln > 0)
	        	        			{
	        	        				connection.commit();
	        	        				result = SUCCESS;
	        	        				addActionMessage(this.getText("message.success.chequeDetailsUpdatedSuccessfully"));connection.commit();
	        	        				
	        	        			}
	        	        			else
	        	        			{
	        	        				
	        	        				connection.rollback();
	        	        				result = ERROR;
	        	        				addActionError(this.getText("message.error.couldNotUpdateChequeDetails"));
	        	        				
	        	        			}
	    	        				
	    	        			}
	    	        			else
	    	        			{
	    	        				connection.rollback();
        	        				result = ERROR;
	    	        				addActionError(this.getText("message.error.couldNotUpdateChequeDetails"));
	    	        			}
		        			}
		        		
		        			
							
							
							
							if(!this.getTypeOfPayment().equals("CHEQUE"))
		        			{
							sql = "SELECT "
									+ "entry_id "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? "
									+ "ORDER BY "
									+ "entry_id "
									+ "DESC LIMIT 1;";
							
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						
						resultSet = preparedStatement.executeQuery();
						
						int bankEntryId = 1;
					
						if(resultSet.next())
						{
							if(!(resultSet.getString(1) == null))
							{
								bankEntryId = Integer.parseInt(resultSet.getString(1));
								bankEntryId = bankEntryId + 1;
								
							}
							
						}
						else
						{	bankEntryId =1;
							
						}
						
		        		if(resultSet != null)
		        		{
		        			resultSet.close();
		        			resultSet = null;
		        		}
		        		if(preparedStatement!= null)
		        		{
		        			preparedStatement.close();
		        			preparedStatement = null;
		        		}
		        		
		        		String accountNumber = "";
		        		sql = "SELECT "
		        				+ "account_number "
		        				+ "FROM "
		        				+ "crusher_bank_account "
		        				+ "WHERE "
		        				+ "account_id  = ? "
		        				+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
		        			
		        		preparedStatement = connection.prepareStatement(sql);
		        		
		        		preparedStatement.setString(1, this.getAccountId());
		        		preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						
		        		resultSet = preparedStatement.executeQuery();
		        		if(resultSet.next())
		        		{
		        			accountNumber = resultSet.getString(1);
		        		}
		        		
		        		if(resultSet != null)
		        		{
		        			resultSet.close();
		        			resultSet = null;
		        		}
		        		if(preparedStatement!= null)
		        		{
		        			preparedStatement.close();
		        			preparedStatement = null;
		        		}
		        		
		        		
							sql = "INSERT "
									+ "INTO "
									+ "bank_account_credit_debit_master "
									+ "("
									+ "entry_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details,"
									+ "entry_source) "
									+ "VALUES "
									+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setInt(1, bankEntryId);
							preparedStatement.setString(2, crusherId);
			        		preparedStatement.setString(3, crusherCode);
			        		preparedStatement.setString(4, this.getAccountId());
							preparedStatement.setString(5, accountNumber);
							preparedStatement.setString(6, this.getPaymentDate());
							preparedStatement.setTime(7, time);
							preparedStatement.setString(8, "DEBIT");
							preparedStatement.setFloat(9, this.getAmountPaid());
							preparedStatement.setString(10, this.getTypeOfPayment());
							preparedStatement.setString(11, entryBy);
							preparedStatement.setString(12, "BOULDER SUPPLIER PAYMENT TO "+this.getBoulderSupplierName().trim().toUpperCase());
							preparedStatement.setString(13, "BOULDER SUPPLIER PAYMENT ");
							
							int rowInsetred = preparedStatement.executeUpdate();
							
							
							boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId(),"DEBIT", this.getPaymentDate(), this.getAmountPaid(), entryBy, connection, this.getSessionMap());
							
							if(isCloseingBalMaintained && rowInsetred > 0)
							{
								
								sql = "UPDATE "
        	        					+ "crusher_boulder_supplier_payment_master "
        	        					+ "SET "
        	        					+ "credit_debit_id = ? "
        	        					+ "WHERE "
    									+ "entry_id = ? "
    									+ "AND "
    									+ "crusher_id = ? "
    									+ "AND "
    									+ "crusher_code = ? ";
        	        			
        	        			
	    						preparedStatement = connection.prepareStatement(sql);
	    						
	    						preparedStatement.setInt(1, bankEntryId);
	    						preparedStatement.setInt(2, newEntryId);
	    						preparedStatement.setString(3, crusherId);
	    		        		preparedStatement.setString(4, crusherCode);
	    		        		
	    						int rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
	        				
	    						
	    						
	    						if(rowCreditDebitIdInsetred > 0 )
	    						{
	    							connection.commit();
									result = "success";
									addActionMessage(this.getText("message.success.supplierPaymentDetailsAddedSuccessfully"));
	    						}
	    						
							}
							else
							{
								connection.rollback();
								result = "error";
								addActionError(this.getText("message.error.errorSupplierPaymentDetailsNotAddedPlzTryAgain"));
							}
						
						}
						
						
						else if(this.getTypeOfPayment().equals("CHEQUE") && !hasActionErrors())
	        			{
	        				addActionMessage(this.getText("message.success.supplierPaymentDetailsAddedSuccessfully"));
	        				connection.commit();
	        				result = "success";
	        			}
	        			else
	        			{
	        				connection.rollback();
	        				result = "error";
	        				addActionError(this.getText("message.error.errorSupplierPaymentDetailsNotAddedPlzTryAgain"));
	        			}
						
					
						
							
						
					}
						
					
					else
					{
						connection.rollback();
						result = "error";
						addActionError(this.getText("message.error.supplierPaymentDetailsNotAdded(cheque)PlzTryAgain"));
					}
					
				}
				
					
				catch (SQLException e) {
					try {
						connection.rollback();
					} catch (SQLException e1) {}
					result = "error";
					//e.printStackTrace();
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.supplierPaymentDetailsNotAdded"));
				} catch (Exception e) {
					//e.printStackTrace();
					result = "error";						
					addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.supplierPaymentDetailsNotAdded"));
				}finally {
				if(resultSet != null)
   				{
   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
   				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
			}
    	
	        }
	        
	        return result;
	 }
	
	@Override
	public void validate() {
		
		
		
		if(!hasActionErrors())
		{
    		if(this.getAccountId() == null || this.getAccountId().equals(""))
    		{
    			addActionError(this.getText("message.error.plzSelectAccount"));
    		}
    	}
		
		
		
		if(this.getDebtAmount()== null)
		{
			addActionError(this.getText("message.error.somethingwentWrongDebtAmountNotDisplayed"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getAmountPaid() ==null)
			{
				addActionError(this.getText("message.error.plzProvideCorrectAmountPaid"));
			}
			else if(this.getAmountPaid() <= 0 )
			{
				addActionError(this.getText("message.error.amountPaidCannnotBeLessThanEqualto0"));
			}
		}
		
		

    	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));
   		
    	
    	
   		paymentTypeList.add("CASH");
    	paymentTypeList.add("UPI");
    	paymentTypeList.add("RTGS");
    	paymentTypeList.add("NEFT");
    	paymentTypeList.add("CHEQUE");
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getPaymentDate() {
		return paymentDate;
	}

	public void setPaymentDate(String paymentDate) {
		this.paymentDate = paymentDate;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Float getDebtAmount() {
		return debtAmount;
	}

	public void setDebtAmount(Float debtAmount) {
		this.debtAmount = debtAmount;
	}

	public Float getAmountPaid() {
		return amountPaid;
	}

	public void setAmountPaid(Float amountPaid) {
		this.amountPaid = amountPaid;
	}

	public String getTypeOfPayment() {
		return typeOfPayment;
	}

	public void setTypeOfPayment(String typeOfPayment) {
		this.typeOfPayment = typeOfPayment;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	public String getBoulderSupplierName() {
		return boulderSupplierName;
	}

	public void setBoulderSupplierName(String boulderSupplierName) {
		this.boulderSupplierName = boulderSupplierName;
	}

	public boolean isSendSMS() {
		return sendSMS;
	}

	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}
	


public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}

@Override  
public void setSession(Map<String, Object> map) {  
    sessionMap=(SessionMap<String, Object>)map;  
}

public String getAccountId() {
	return accountId;
}

public void setAccountId(String accountId) {
	this.accountId = accountId;
}

public Map<String, String> getCustomerSearchOptionList() {
	return customerSearchOptionList;
}

public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
	this.customerSearchOptionList = customerSearchOptionList;
}

public String getCustomerSearchOption() {
	return customerSearchOption;
}

public void setCustomerSearchOption(String customerSearchOption) {
	this.customerSearchOption = customerSearchOption;
}



public String getChequePayDate() {
	return chequePayDate;
}

public void setChequePayDate(String chequePayDate) {
	this.chequePayDate = chequePayDate;
}

public String getChequePayee() {
	return chequePayee;
}

public void setChequePayee(String chequePayee) {
	this.chequePayee = chequePayee;
}

public String getBankName() {
	return bankName;
}

public void setBankName(String bankName) {
	this.bankName = bankName;
}

public String getBranchName() {
	return branchName;
}

public void setBranchName(String branchName) {
	this.branchName = branchName;
}

public String getChequeNumber() {
	return chequeNumber;
}

public void setChequeNumber(String chequeNumber) {
	this.chequeNumber = chequeNumber;
}

public List<String> getBankList() {
	return bankList;
}

public void setBankList(List<String> bankList) {
	this.bankList = bankList;
}

public List<String> getBranchList() {
	return branchList;
}

public void setBranchList(List<String> branchList) {
	this.branchList = branchList;
}

public List<String> getChequeList() {
	return chequeList;
}

public void setChequeList(List<String> chequeList) {
	this.chequeList = chequeList;
}

public String getDetails() {
	return details;
}

public void setDetails(String details) {
	this.details = details;
}


}
