package com.stonecrusher.add;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetTypeOfPaymentList;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class AddAccountCreditEntry extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4016487215961786633L;
	
	private HttpSession session;
	private String entryDate;
	private String accountId;
	private Float amount;
	private String typeOfPayment;
	private String entryDetails;
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	
	Map<String,String> accountList = new LinkedHashMap<String,String>();
	List<String> paymentTypeList = new ArrayList<String>();
	private SessionMap<String,Object> sessionMap;  
	
	
	private String entryId;
	private boolean entrySaved;
	
	
	
	public String execute(){
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
					try
					{
						java.util.Date date = new java.util.Date();
		        	      long t = date.getTime();	        	     
		        	      java.sql.Time time = new java.sql.Time(t);
						
						String user = (String) session.getAttribute("userFullName");
						String userName = "";
						
						try
						{
							userName = user.split(" ")[0];
						}catch(Exception e)
						{
							userName = user;
						}
						
					
						connection = GetDBConnection.getDBConnection(db);
						
						
						sql = "SELECT "
								+ "entry_id "
								+ "FROM "
								+ "bank_account_credit_debit_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY "
								+ "entry_id "
								+ "DESC LIMIT 1;";
						
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					int entryId = 1;
				
					if(resultSet.next())
					{
						if(!(resultSet.getString(1) == null))
						{
							entryId = Integer.parseInt(resultSet.getString(1));
							entryId = entryId + 1;
							
						}
						
					}
					else
					{	entryId =1;
						
					}
					
	        		if(resultSet != null)
	        		{
	        			resultSet.close();
	        			resultSet = null;
	        		}
	        		if(preparedStatement!= null)
	        		{
	        			preparedStatement.close();
	        			preparedStatement = null;
	        		}
	        		String accountNumber = "";
	        		sql = "SELECT "
	        				+ "account_number "
	        				+ "FROM "
	        				+ "crusher_bank_account "
	        				+ "WHERE "
	        				+ "account_id  = ? "
	        				+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
	        	
	        			
	        		preparedStatement = connection.prepareStatement(sql);
	        		
	        		preparedStatement.setString(1, this.getAccountId());
	        		preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					
	        		resultSet = preparedStatement.executeQuery();
	        		if(resultSet.next())
	        		{
	        			accountNumber = resultSet.getString(1);
	        		}
	        		
	        		if(resultSet != null)
	        		{
	        			resultSet.close();
	        			resultSet = null;
	        		}
	        		if(preparedStatement!= null)
	        		{
	        			preparedStatement.close();
	        			preparedStatement = null;
	        		}
						
						sql = "INSERT "
								+ "INTO "
								+ "bank_account_credit_debit_master "
								+ "("
								+ "entry_id,"
								+ "crusher_id,"
		        				+ "crusher_code,"
		        				+ "account_id,"
								+ "account_number,"
								+ "entry_date,"
								+ "entry_time,"
								+ "entry_type,"
								+ "amount,"
								+ "payment_type,"
								+ "entry_by,"
								+ "entry_details,"
								+ "entry_source) "
								+ "VALUES "
								+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setInt(1, entryId);
						preparedStatement.setString(2, crusherId);
		        		preparedStatement.setString(3, crusherCode);
		        		preparedStatement.setString(4, this.getAccountId());
						preparedStatement.setString(5, accountNumber);
						preparedStatement.setString(6, this.getEntryDate());
						preparedStatement.setTime(7, time);
						preparedStatement.setString(8, "CREDIT");
						preparedStatement.setFloat(9, this.getAmount());
						preparedStatement.setString(10, this.getTypeOfPayment());
						preparedStatement.setString(11, userName);
						preparedStatement.setString(12, this.getEntryDetails());
						preparedStatement.setString(13, "BANK CREDIT ");
						
						int rowInsetred = preparedStatement.executeUpdate();
						
						
						boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId(),"CREDIT", this.getEntryDate(), this.getAmount(), userName, connection, this.getSessionMap());
						
						
						if(isCloseingBalMaintained && (rowInsetred > 0))
						{
							this.setAccountId("");
							this.setAmount(0.0f);
							this.setTypeOfPayment("");
							this.setEntryDetails("");
							
							
							this.setEntrySaved(true);
							this.setEntryId(EncryptionDecryption.encrypt(String.valueOf(entryId)));
							
							
							result = "success";
							addActionMessage(this.getText("message.success.accountCreditDetailsAddedSuccessfully"));
							
						}
						else
						{
							result = "error";
							addActionError(this.getText("message.success.sryAccountCreditNotAddedPlzTryAgain"));
						}
						
						
						
					}catch (SQLException e) {
						result = "error";
						
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.success.entryDetailsNotAdded"));
					} catch (IOException e) {
						
						result = "error";						
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.success.entryDetailsNotAdded"));
					}finally {
						if(resultSet != null)
		   				{
		   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
		   				}
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close(); connection = null;}catch (SQLException e) {}
						}
						
					}
	        	
	        	
	        	
	        	
	        }
	        return result;
	}
	
	@Override
	public void validate() {
		
		session=ServletActionContext.getRequest().getSession(false); 
		
		customerSearchOptionList.put("BYNAME", "BY NAME");
    	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
    	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
		setCustomerSearchOption("BYNAME");
		setDefaultValue("BYNAME");
		
		this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));        	
    	this.setPaymentTypeList(GetTypeOfPaymentList.getTypeOfPaymentList());
		
		if(this.getAccountId().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectAccountNumber"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getAmount() == null || this.getAmount().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectAmount"));
			}
		}
	}
	
	
	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}
	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}
	public String getCustomerSearchOption() {
		return customerSearchOption;
	}
	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}
	public String getDefaultValue() {
		return defaultValue;
	}
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public String getEntryDate() {
		return entryDate;
	}
	public void setEntryDate(String entryDate) {
		this.entryDate = entryDate;
	}
	public String getAccountId() {
		return accountId;
	}
	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}
	public Float getAmount() {
		return amount;
	}
	public void setAmount(Float amount) {
		this.amount = amount;
	}
	public String getTypeOfPayment() {
		return typeOfPayment;
	}
	public void setTypeOfPayment(String typeOfPayment) {
		this.typeOfPayment = typeOfPayment;
	}
	public String getEntryDetails() {
		return entryDetails;
	}
	public void setEntryDetails(String entryDetails) {
		this.entryDetails = entryDetails;
	}



public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}

public void setSession(Map<String, Object> map) {  
    sessionMap=(SessionMap<String, Object>)map;  
}

public String getEntryId() {
	return entryId;
}

public void setEntryId(String entryId) {
	this.entryId = entryId;
}

public boolean isEntrySaved() {
	return entrySaved;
}

public void setEntrySaved(boolean entrySaved) {
	this.entrySaved = entrySaved;
}

	
}
