/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Comparator;
import java.util.function.Supplier;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.vandeseer.easytable.TableDrawerFunction;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.util.PdfUtil;

public class TableDrawer {
    protected final Table table;
    protected PDPageContentStream contentStream;
    protected float startX;
    protected float startY;
    protected float endY;
    protected int rowToDraw = 0;
    protected boolean isFinished = false;

    protected TableDrawer(float startX, float startY, PDPageContentStream contentStream, Table table, float endY) {
        this.contentStream = contentStream;
        this.table = table;
        this.startX = startX;
        this.startY = startY - PdfUtil.getFontHeight(table.getSettings().getFont(), table.getSettings().getFontSize());
        this.endY = endY;
    }

    public void draw() throws IOException {
        this.drawWithFunction(new Point2D.Float(this.startX, this.startY), this::drawBackgroundColorAndCellContent, false);
        this.drawWithFunction(new Point2D.Float(this.startX, this.startY), this::drawBorders, true);
    }

    public void draw(Supplier<PDDocument> documentSupplier, Supplier<PDPage> pageSupplier, float yOffset) throws IOException {
        PDDocument document = documentSupplier.get();
        int i = 0;
        while (!this.isFinished()) {
            PDPage page;
            if (i > 0 || document.getNumberOfPages() == 0) {
                page = pageSupplier.get();
                document.addPage(page);
            } else {
                page = document.getPage(document.getNumberOfPages() - 1);
            }
            try (PDPageContentStream newPageContentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, false);){
                this.contentStream(newPageContentStream).draw();
            }
            this.startY(page.getMediaBox().getHeight() - yOffset);
            ++i;
        }
    }

    protected void drawWithFunction(Point2D.Float startingPoint, TableDrawerFunction function, boolean isLastAction) throws IOException {
        float y = startingPoint.y;
        for (int i = this.rowToDraw; i < this.table.getRows().size(); ++i) {
            Row row = this.table.getRows().get(i);
            int columnCounter = 0;
            float lowestPoint = y - row.getCells().stream().map(AbstractCell::getHeight).max(Comparator.naturalOrder()).orElse(Float.valueOf(row.getHeight())).floatValue();
            if (lowestPoint < this.endY) {
                if (isLastAction) {
                    this.rowToDraw = i;
                }
                return;
            }
            float x = startingPoint.x;
            y -= row.getHeight();
            for (AbstractCell cell : row.getCells()) {
                while (this.table.isRowSpanAt(i, columnCounter)) {
                    x += this.table.getColumns().get(columnCounter).getWidth();
                    ++columnCounter;
                }
                function.accept(new Point2D.Float(x, y), cell);
                x += cell.getWidth();
                columnCounter += cell.getColSpan();
            }
        }
        if (isLastAction) {
            this.isFinished = true;
        }
    }

    protected void drawBackgroundColorAndCellContent(Point2D.Float start, AbstractCell cell) throws IOException {
        float y;
        float rowHeight = cell.getRow().getHeight();
        float height = cell.getHeight() > rowHeight ? cell.getHeight() : rowHeight;
        float f = y = cell.getHeight() > rowHeight ? start.y + rowHeight - cell.getHeight() : start.y;
        if (cell.hasBackgroundColor()) {
            this.drawCellBackground(cell, new Point2D.Float(start.x, y), height);
        }
        cell.getDrawer().draw(new DrawingContext(this.contentStream, start));
    }

    protected void drawBorders(Point2D.Float start, AbstractCell cell) throws IOException {
        float rowHeight = cell.getRow().getHeight();
        float cellWidth = cell.getWidth();
        float height = cell.getHeight() > rowHeight ? cell.getHeight() : rowHeight;
        float sY = cell.getHeight() > rowHeight ? start.y + rowHeight - cell.getHeight() : start.y;
        Color cellBorderColor = cell.getBorderColor();
        Color rowBorderColor = cell.getRow().getSettings().getBorderColor();
        if (cell.hasBorderTop() || cell.hasBorderBottom()) {
            float correctionLeft = cell.getBorderWidthLeft() / 2.0f;
            float correctionRight = cell.getBorderWidthRight() / 2.0f;
            if (cell.hasBorderTop()) {
                this.contentStream.moveTo(start.x - correctionLeft, start.y + rowHeight);
                this.drawLine(cellBorderColor, cell.getBorderWidthTop(), start.x + cellWidth + correctionRight, start.y + rowHeight);
                this.contentStream.setStrokingColor(rowBorderColor);
            }
            if (cell.hasBorderBottom()) {
                this.contentStream.moveTo(start.x - correctionLeft, sY);
                this.drawLine(cellBorderColor, cell.getBorderWidthBottom(), start.x + cellWidth + correctionRight, sY);
                this.contentStream.setStrokingColor(rowBorderColor);
            }
        }
        if (cell.hasBorderLeft() || cell.hasBorderRight()) {
            float correctionTop = cell.getBorderWidthTop() / 2.0f;
            float correctionBottom = cell.getBorderWidthBottom() / 2.0f;
            if (cell.hasBorderLeft()) {
                this.contentStream.moveTo(start.x, sY - correctionBottom);
                this.drawLine(cellBorderColor, cell.getBorderWidthLeft(), start.x, sY + height + correctionTop);
                this.contentStream.setStrokingColor(rowBorderColor);
            }
            if (cell.hasBorderRight()) {
                this.contentStream.moveTo(start.x + cellWidth, sY - correctionBottom);
                this.drawLine(cellBorderColor, cell.getBorderWidthRight(), start.x + cellWidth, sY + height + correctionTop);
                this.contentStream.setStrokingColor(rowBorderColor);
            }
        }
    }

    protected void drawLine(Color color, float width, float toX, float toY) throws IOException {
        this.contentStream.setLineWidth(width);
        this.contentStream.lineTo(toX, toY);
        this.contentStream.setStrokingColor(color);
        this.contentStream.stroke();
    }

    protected void drawCellBackground(AbstractCell cell, Point2D.Float start, float height) throws IOException {
        this.contentStream.setNonStrokingColor(cell.getBackgroundColor());
        this.contentStream.addRect(start.x, start.y, cell.getWidth(), height);
        this.contentStream.fill();
        this.contentStream.closePath();
        this.contentStream.setNonStrokingColor(Color.BLACK);
    }

    protected TableDrawer(TableDrawerBuilder<?, ?> b) {
        this.table = ((TableDrawerBuilder)b).table;
        this.contentStream = ((TableDrawerBuilder)b).contentStream;
        this.startX = ((TableDrawerBuilder)b).startX;
        this.startY = ((TableDrawerBuilder)b).startY;
        this.endY = ((TableDrawerBuilder)b).endY;
        this.rowToDraw = ((TableDrawerBuilder)b).rowToDraw;
        this.isFinished = ((TableDrawerBuilder)b).isFinished;
    }

    public static TableDrawerBuilder<?, ?> builder() {
        return new TableDrawerBuilderImpl();
    }

    public TableDrawerBuilder<?, ?> toBuilder() {
        return new TableDrawerBuilderImpl().$fillValuesFrom(this);
    }

    public TableDrawer contentStream(PDPageContentStream contentStream) {
        this.contentStream = contentStream;
        return this;
    }

    public TableDrawer startX(float startX) {
        this.startX = startX;
        return this;
    }

    public TableDrawer startY(float startY) {
        this.startY = startY;
        return this;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    private static final class TableDrawerBuilderImpl
    extends TableDrawerBuilder<TableDrawer, TableDrawerBuilderImpl> {
        private TableDrawerBuilderImpl() {
        }

        @Override
        protected TableDrawerBuilderImpl self() {
            return this;
        }

        @Override
        public TableDrawer build() {
            return new TableDrawer(this);
        }
    }

    public static abstract class TableDrawerBuilder<C extends TableDrawer, B extends TableDrawerBuilder<C, B>> {
        private Table table;
        private PDPageContentStream contentStream;
        private float startX;
        private float startY;
        private float endY;
        private int rowToDraw;
        private boolean isFinished;

        protected B $fillValuesFrom(C instance) {
            TableDrawerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(TableDrawer instance, TableDrawerBuilder<?, ?> b) {
            b.table(instance.table);
            b.contentStream(instance.contentStream);
            b.startX(instance.startX);
            b.startY(instance.startY);
            b.endY(instance.endY);
            b.rowToDraw(instance.rowToDraw);
            b.isFinished(instance.isFinished);
        }

        protected abstract B self();

        public abstract C build();

        public B table(Table table) {
            this.table = table;
            return this.self();
        }

        public B contentStream(PDPageContentStream contentStream) {
            this.contentStream = contentStream;
            return this.self();
        }

        public B startX(float startX) {
            this.startX = startX;
            return this.self();
        }

        public B startY(float startY) {
            this.startY = startY;
            return this.self();
        }

        public B endY(float endY) {
            this.endY = endY;
            return this.self();
        }

        public B rowToDraw(int rowToDraw) {
            this.rowToDraw = rowToDraw;
            return this.self();
        }

        public B isFinished(boolean isFinished) {
            this.isFinished = isFinished;
            return this.self();
        }

        public String toString() {
            return "TableDrawer.TableDrawerBuilder(table=" + this.table + ", contentStream=" + this.contentStream + ", startX=" + this.startX + ", startY=" + this.startY + ", endY=" + this.endY + ", rowToDraw=" + this.rowToDraw + ", isFinished=" + this.isFinished + ")";
        }
    }
}

