/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.util.IntHashtable;
import java.io.IOException;
import java.io.Serializable;

public class OtfClass
implements Serializable {
    public static final int GLYPH_BASE = 1;
    public static final int GLYPH_LIGATURE = 2;
    public static final int GLYPH_MARK = 3;
    private static final long serialVersionUID = -7584495836452964728L;
    private IntHashtable mapClass = new IntHashtable();

    public OtfClass(RandomAccessFileOrArray rf, int classLocation) throws IOException {
        rf.seek(classLocation);
        int classFormat = rf.readUnsignedShort();
        if (classFormat == 1) {
            int startGlyph = rf.readUnsignedShort();
            int glyphCount = rf.readUnsignedShort();
            int endGlyph = startGlyph + glyphCount;
            for (int k = startGlyph; k < endGlyph; ++k) {
                int cl = rf.readUnsignedShort();
                this.mapClass.put(k, cl);
            }
        } else if (classFormat == 2) {
            int classRangeCount = rf.readUnsignedShort();
            for (int k = 0; k < classRangeCount; ++k) {
                int glyphEnd = rf.readUnsignedShort();
                int cl = rf.readUnsignedShort();
                for (int glyphStart = rf.readUnsignedShort(); glyphStart <= glyphEnd; ++glyphStart) {
                    this.mapClass.put(glyphStart, cl);
                }
            }
        } else {
            throw new IOException("Invalid class format " + classFormat);
        }
    }

    public int getOtfClass(int glyph) {
        return this.mapClass.get(glyph);
    }

    public boolean isMarkOtfClass(int glyph) {
        return this.hasClass(glyph) && this.getOtfClass(glyph) == 3;
    }

    public boolean hasClass(int glyph) {
        return this.mapClass.containsKey(glyph);
    }

    public int getOtfClass(int glyph, boolean strict) {
        if (strict) {
            if (this.mapClass.containsKey(glyph)) {
                return this.mapClass.get(glyph);
            }
            return -1;
        }
        return this.mapClass.get(glyph);
    }
}

