/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.servlet.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.tiles.context.MapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServletSessionScopeMap
implements Map<String, Object> {
    private HttpServletRequest request = null;

    public ServletSessionScopeMap(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public void clear() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            Iterator<String> keys = this.keySet().iterator();
            while (keys.hasNext()) {
                session.removeAttribute(keys.next());
            }
        }
    }

    @Override
    public boolean containsKey(Object key) {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        return session.getAttribute(this.key(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        HttpSession session = this.request.getSession(false);
        if (session == null || value == null) {
            return false;
        }
        Enumeration keys = session.getAttributeNames();
        while (keys.hasMoreElements()) {
            Object next = session.getAttribute((String)keys.nextElement());
            if (next != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HttpSession session = this.request.getSession(false);
        HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>();
        if (session != null) {
            Enumeration keys = session.getAttributeNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                set.add(new MapEntry<String, Object>(key, session.getAttribute(key), true));
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        HttpSession session;
        boolean retValue = true;
        HttpSession httpSession = session = this.request.getSession(false);
        synchronized (httpSession) {
            HttpSession otherSession = ((ServletSessionScopeMap)o).request.getSession(false);
            if (session == null) {
                retValue = otherSession == null;
            } else {
                Enumeration attribs = session.getAttributeNames();
                while (attribs.hasMoreElements() && retValue) {
                    String attributeName = (String)attribs.nextElement();
                    retValue = session.getAttribute(attributeName).equals(otherSession.getAttribute(attributeName));
                }
            }
        }
        return retValue;
    }

    @Override
    public Object get(Object key) {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return null;
        }
        return session.getAttribute(this.key(key));
    }

    @Override
    public int hashCode() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return 0;
        }
        return session.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    public Set<String> keySet() {
        HttpSession session = this.request.getSession(false);
        HashSet<String> set = new HashSet<String>();
        if (session != null) {
            Enumeration keys = session.getAttributeNames();
            while (keys.hasMoreElements()) {
                set.add((String)keys.nextElement());
            }
        }
        return set;
    }

    @Override
    public Object put(String key, Object value) {
        HttpSession session = this.request.getSession();
        if (value == null) {
            return this.remove(key);
        }
        String skey = this.key(key);
        Object previous = session.getAttribute(skey);
        session.setAttribute(skey, value);
        return previous;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        HttpSession session = this.request.getSession();
        for (String string : map.keySet()) {
            session.setAttribute(string, map.get(string));
        }
    }

    @Override
    public Object remove(Object key) {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return null;
        }
        String skey = this.key(key);
        Object previous = session.getAttribute(skey);
        session.removeAttribute(skey);
        return previous;
    }

    @Override
    public int size() {
        HttpSession session = this.request.getSession(false);
        int n = 0;
        if (session != null) {
            Enumeration keys = session.getAttributeNames();
            while (keys.hasMoreElements()) {
                keys.nextElement();
                ++n;
            }
        }
        return n;
    }

    @Override
    public Collection<Object> values() {
        HttpSession session = this.request.getSession(false);
        ArrayList<Object> list = new ArrayList<Object>();
        if (session != null) {
            Enumeration keys = session.getAttributeNames();
            while (keys.hasMoreElements()) {
                list.add(session.getAttribute((String)keys.nextElement()));
            }
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }
}

