function showLoader() {
    var loader = document.getElementById('pageLoader');
    if (!loader) {
        loader = document.createElement('div');
        loader.id = 'pageLoader';
        loader.className = 'loader-container';
        loader.innerHTML = '<div class="loader"></div>';
        document.body.appendChild(loader);
    }
    loader.style.display = 'flex';
}

function hideLoader() {
    var loader = document.getElementById('pageLoader');
    if (loader) {
        loader.style.display = 'none';
    }
}

// Legacy support for class-based approach
class PageLoader {
    show() {
        showLoader();
    }
    
    hide() {
        hideLoader();
    }
}

// Create a global instance for backward compatibility
const pageLoader = new PageLoader();


// Add utility function to handle async operations with loader
const withLoader = async function(asyncFunction) {
    try {
        showLoader();
        await asyncFunction();
    } finally {
        hideLoader();
    }
};
