<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>500 - Server Error | Samarth Stone Crusher</title>
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700;900&family=Roboto:wght@300;400;500&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Roboto', sans-serif;
            background: #0a0a0a;
            min-height: 100vh;
            overflow-x: hidden;
            position: relative;
            color: #00ff41;
        }

        /* Matrix Rain Background */
        .matrix-bg {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: 1;
            opacity: 0.3;
        }

        .matrix-column {
            position: absolute;
            top: -100%;
            font-family: 'Orbitron', monospace;
            font-size: 20px;
            color: #00ff41;
            animation: matrix-rain 3s linear infinite;
            text-shadow: 0 0 5px #00ff41;
        }

        @keyframes matrix-rain {
            0% {
                top: -100%;
                opacity: 0;
            }
            10% {
                opacity: 1;
            }
            90% {
                opacity: 1;
            }
            100% {
                top: 100vh;
                opacity: 0;
            }
        }

        /* Circuit Board Background Pattern */
        .circuit-bg {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                radial-gradient(circle at 25% 25%, #00ff41 2px, transparent 2px),
                radial-gradient(circle at 75% 75%, #ff0040 2px, transparent 2px),
                linear-gradient(45deg, transparent 40%, rgba(0, 255, 65, 0.1) 50%, transparent 60%);
            background-size: 100px 100px, 100px 100px, 50px 50px;
            background-position: 0 0, 50px 50px, 0 0;
            animation: circuitMove 20s linear infinite;
            opacity: 0.1;
            z-index: 1;
        }

        @keyframes circuitMove {
            0% { background-position: 0 0, 50px 50px, 0 0; }
            100% { background-position: 100px 100px, 150px 150px, 50px 50px; }
        }

        /* Main Container */
        .error-container {
            position: relative;
            z-index: 2;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .error-content {
            text-align: center;
            max-width: 800px;
            animation: powerUp 2s ease-out;
        }

        @keyframes powerUp {
            0% {
                opacity: 0;
                transform: scale(0.8) rotateX(90deg);
                filter: brightness(0);
            }
            50% {
                filter: brightness(2);
            }
            100% {
                opacity: 1;
                transform: scale(1) rotateX(0deg);
                filter: brightness(1);
            }
        }

        /* Cyber 500 Number */
        .error-number {
            font-family: 'Orbitron', monospace;
            font-size: 180px;
            font-weight: 900;
            margin-bottom: 30px;
            position: relative;
            background: linear-gradient(45deg, #ff0040, #00ff41, #0080ff, #ff0040);
            background-size: 400% 400%;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            animation: cyberGlow 3s ease-in-out infinite, colorShift 4s ease-in-out infinite;
            text-shadow: 0 0 30px #ff0040, 0 0 60px #00ff41, 0 0 90px #0080ff;
            filter: drop-shadow(0 0 20px #ff0040);
        }

        @keyframes cyberGlow {
            0%, 100% {
                filter: brightness(1) drop-shadow(0 0 20px #ff0040);
                transform: scale(1);
            }
            50% {
                filter: brightness(1.5) drop-shadow(0 0 40px #00ff41);
                transform: scale(1.05);
            }
        }

        @keyframes colorShift {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        /* Holographic Elements */
        .hologram {
            position: relative;
            display: inline-block;
        }

        .hologram::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(90deg, transparent, rgba(0, 255, 65, 0.4), transparent);
            animation: scan 2s linear infinite;
        }

        @keyframes scan {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }

        /* Error Messages */
        .error-title {
            font-family: 'Orbitron', monospace;
            font-size: 42px;
            font-weight: 700;
            margin-bottom: 20px;
            color: #ff0040;
            text-shadow: 0 0 10px #ff0040;
            animation: glitchText 0.1s infinite;
        }

        .error-subtitle {
            font-size: 24px;
            font-weight: 400;
            margin-bottom: 30px;
            color: #00ff41;
            opacity: 0.9;
            animation: typewriter 3s steps(40) 1s both;
            overflow: hidden;
            white-space: nowrap;
            border-right: 2px solid #00ff41;
        }

        @keyframes typewriter {
            from { width: 0; }
            to { width: 100%; }
        }

        @keyframes glitchText {
            0%, 90%, 100% {
                transform: translate(0);
                filter: hue-rotate(0deg);
            }
            10% {
                transform: translate(-1px, 1px);
                filter: hue-rotate(90deg);
            }
            20% {
                transform: translate(1px, -1px);
                filter: hue-rotate(180deg);
            }
            30% {
                transform: translate(-1px, -1px);
                filter: hue-rotate(270deg);
            }
            40% {
                transform: translate(1px, 1px);
                filter: hue-rotate(360deg);
            }
        }

        .error-description {
            font-size: 18px;
            font-weight: 300;
            margin-bottom: 40px;
            color: #ccc;
            line-height: 1.6;
            animation: fadeInUp 1s ease-out 2s both;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Cyber Terminal */
        .terminal {
            background: rgba(0, 0, 0, 0.8);
            border: 2px solid #00ff41;
            border-radius: 10px;
            padding: 20px;
            margin: 30px 0;
            font-family: 'Orbitron', monospace;
            text-align: left;
            max-width: 500px;
            margin: 30px auto;
            box-shadow: 0 0 20px rgba(0, 255, 65, 0.3);
            animation: terminalBoot 2s ease-out 1.5s both;
        }

        @keyframes terminalBoot {
            0% {
                opacity: 0;
                transform: scaleY(0);
            }
            50% {
                opacity: 1;
                transform: scaleY(0.5);
            }
            100% {
                opacity: 1;
                transform: scaleY(1);
            }
        }

        .terminal-line {
            margin: 10px 0;
            font-size: 14px;
            color: #00ff41;
        }

        .terminal-prompt {
            color: #ff0040;
        }

        .terminal-cursor {
            animation: blink 1s infinite;
        }

        @keyframes blink {
            0%, 50% { opacity: 1; }
            51%, 100% { opacity: 0; }
        }

        /* Floating Cyber Elements */
        .cyber-element {
            position: absolute;
            color: #00ff41;
            font-family: 'Orbitron', monospace;
            animation: floatCyber 6s ease-in-out infinite;
            opacity: 0.7;
        }

        .cyber-element.element-1 {
            top: 15%;
            left: 10%;
            animation-delay: 0s;
        }

        .cyber-element.element-2 {
            top: 25%;
            right: 15%;
            animation-delay: 2s;
        }

        .cyber-element.element-3 {
            bottom: 25%;
            left: 8%;
            animation-delay: 4s;
        }

        .cyber-element.element-4 {
            bottom: 15%;
            right: 12%;
            animation-delay: 6s;
        }

        @keyframes floatCyber {
            0%, 100% {
                transform: translateY(0px) rotate(0deg);
                opacity: 0.7;
            }
            50% {
                transform: translateY(-30px) rotate(180deg);
                opacity: 1;
            }
        }

        /* Action Buttons */
        .action-buttons {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
            animation: slideInBottom 1s ease-out 3s both;
        }

        @keyframes slideInBottom {
            from {
                opacity: 0;
                transform: translateY(50px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .cyber-btn {
            padding: 15px 30px;
            border: 2px solid #00ff41;
            background: transparent;
            color: #00ff41;
            font-family: 'Orbitron', monospace;
            font-size: 16px;
            font-weight: 700;
            text-decoration: none;
            text-transform: uppercase;
            letter-spacing: 2px;
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
            clip-path: polygon(10px 0%, 100% 0%, calc(100% - 10px) 100%, 0% 100%);
        }

        .cyber-btn:hover {
            background: #00ff41;
            color: #000;
            box-shadow: 0 0 30px #00ff41;
            transform: translateY(-5px);
        }

        .cyber-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(0, 255, 65, 0.4), transparent);
            transition: left 0.5s;
        }

        .cyber-btn:hover::before {
            left: 100%;
        }

        .cyber-btn.danger {
            border-color: #ff0040;
            color: #ff0040;
        }

        .cyber-btn.danger:hover {
            background: #ff0040;
            color: #000;
            box-shadow: 0 0 30px #ff0040;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .error-number {
                font-size: 120px;
            }
            
            .error-title {
                font-size: 28px;
            }
            
            .error-subtitle {
                font-size: 18px;
            }
            
            .terminal {
                padding: 15px;
                font-size: 12px;
            }
            
            .cyber-element {
                display: none;
            }
        }

        @media (max-width: 480px) {
            .error-number {
                font-size: 80px;
            }
            
            .error-title {
                font-size: 24px;
            }
            
            .action-buttons {
                flex-direction: column;
                align-items: center;
            }
            
            .cyber-btn {
                width: 250px;
            }
        }

        /* Loading Bar */
        .loading-bar {
            width: 300px;
            height: 4px;
            background: rgba(0, 255, 65, 0.2);
            margin: 20px auto;
            border-radius: 2px;
            overflow: hidden;
        }

        .loading-progress {
            width: 0%;
            height: 100%;
            background: linear-gradient(90deg, #ff0040, #00ff41);
            border-radius: 2px;
            animation: loading 3s ease-in-out infinite;
        }

        @keyframes loading {
            0% { width: 0%; }
            50% { width: 70%; }
            100% { width: 100%; }
        }
    </style>
</head>
<body>
    <!-- Matrix Rain Background -->
    <div class="matrix-bg" id="matrixBg"></div>
    
    <!-- Circuit Background -->
    <div class="circuit-bg"></div>

    <!-- Floating Cyber Elements -->
    <div class="cyber-element element-1">
        &lt;ERROR/&gt;
    </div>
    <div class="cyber-element element-2">
        {SYSTEM_FAILURE}
    </div>
    <div class="cyber-element element-3">
        [WARNING]
    </div>
    <div class="cyber-element element-4">
        &lt;/RESTART&gt;
    </div>

    <!-- Main Error Container -->
    <div class="error-container">
        <div class="error-content">
            <div class="hologram">
                <div class="error-number">500</div>
            </div>
            
            <h1 class="error-title">SYSTEM MALFUNCTION</h1>
            <h2 class="error-subtitle">Internal Server Error Detected...</h2>
            
            <div class="terminal">
                <div class="terminal-line">
                    <span class="terminal-prompt">root@samarth-crusher:~$</span> systemctl status server
                </div>
                <div class="terminal-line">
                    ● server.service - Stone Crusher Management System
                </div>
                <div class="terminal-line">
                    &nbsp;&nbsp;&nbsp;Loaded: loaded (/etc/systemd/system/server.service)
                </div>
                <div class="terminal-line">
                    &nbsp;&nbsp;&nbsp;Active: <span style="color: #ff0040;">failed</span> (Result: exit-code)
                </div>
                <div class="terminal-line">
                    <span class="terminal-prompt">root@samarth-crusher:~$</span> <span class="terminal-cursor">_</span>
                </div>
            </div>

            <div class="loading-bar">
                <div class="loading-progress"></div>
            </div>
            
            <p class="error-description">
                Our servers are experiencing technical difficulties. 
                The system is attempting to self-repair. Please try again shortly.
            </p>
            
            <div class="action-buttons">
                <a href="login.jsp" class="cyber-btn">
                    <i class="fas fa-power-off"></i> REBOOT SYSTEM
                </a>
                <a href="javascript:location.reload()" class="cyber-btn danger">
                    <i class="fas fa-sync-alt"></i> RETRY CONNECTION
                </a>
            </div>
        </div>
    </div>

    <script>
        // Matrix Rain Effect
        function createMatrixRain() {
            const matrixBg = document.getElementById('matrixBg');
            const characters = '01アイウエオカキクケコサシスセソタチツテトナニヌネノハヒフヘホマミムメモヤユヨラリルレロワヲン';
            
            for (let i = 0; i < 50; i++) {
                const column = document.createElement('div');
                column.className = 'matrix-column';
                column.style.left = Math.random() * 100 + '%';
                column.style.animationDelay = Math.random() * 3 + 's';
                column.style.animationDuration = (Math.random() * 2 + 2) + 's';
                
                let text = '';
                for (let j = 0; j < 10; j++) {
                    text += characters[Math.floor(Math.random() * characters.length)] + '<br>';
                }
                column.innerHTML = text;
                
                matrixBg.appendChild(column);
            }
        }

        // Initialize matrix rain
        createMatrixRain();

        // Regenerate matrix rain periodically
        setInterval(() => {
            document.getElementById('matrixBg').innerHTML = '';
            createMatrixRain();
        }, 10000);

        // Cyber glitch effect for buttons
        document.querySelectorAll('.cyber-btn').forEach(btn => {
            btn.addEventListener('mouseenter', function() {
                this.style.animation = 'glitchText 0.1s infinite';
            });
            
            btn.addEventListener('mouseleave', function() {
                this.style.animation = 'none';
            });
        });

        // Random error number glitch
        setInterval(() => {
            const errorNumber = document.querySelector('.error-number');
            const originalText = errorNumber.textContent;
            const glitchChars = ['5Ø0', '5００', '5○○', '５００'];
            
            errorNumber.textContent = glitchChars[Math.floor(Math.random() * glitchChars.length)];
            
            setTimeout(() => {
                errorNumber.textContent = originalText;
            }, 100);
        }, 3000);

        // Cyber sound effect simulation (visual feedback)
        function createSoundWave() {
            const wave = document.createElement('div');
            wave.style.position = 'fixed';
            wave.style.top = '50%';
            wave.style.left = '50%';
            wave.style.width = '0px';
            wave.style.height = '0px';
            wave.style.border = '2px solid #00ff41';
            wave.style.borderRadius = '50%';
            wave.style.transform = 'translate(-50%, -50%)';
            wave.style.animation = 'soundWave 1s ease-out';
            wave.style.pointerEvents = 'none';
            wave.style.zIndex = '9999';
            
            document.body.appendChild(wave);
            
            setTimeout(() => {
                wave.remove();
            }, 1000);
        }

        // Add sound wave animation
        const style = document.createElement('style');
        style.textContent = `
            @keyframes soundWave {
                0% {
                    width: 0px;
                    height: 0px;
                    opacity: 1;
                }
                100% {
                    width: 300px;
                    height: 300px;
                    opacity: 0;
                }
            }
        `;
        document.head.appendChild(style);

        // Trigger sound wave on button click
        document.querySelectorAll('.cyber-btn').forEach(btn => {
            btn.addEventListener('click', createSoundWave);
        });

        // Auto refresh attempt after 30 seconds
        let countdown = 30;
        const countdownInterval = setInterval(() => {
            countdown--;
            if (countdown <= 0) {
                clearInterval(countdownInterval);
                // Uncomment below line for auto-refresh
                // location.reload();
            }
        }, 1000);
    </script>
</body>
</html>