
<%@ page language="java" pageEncoding="UTF-8"%>
<%@ page contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib uri="/struts-dojo-tags" prefix="sx"%>  
<%@ taglib prefix="sj" uri="/struts-jquery-tags"  %>

<!-- Modern Mobile-Responsive CSS -->
<style>
    :root {
        --primary-color: #667eea;
        --secondary-color: #764ba2;
        --success-color: #28a745;
        --danger-color: #dc3545;
        --warning-color: #ffc107;
        --info-color: #17a2b8;
        --light-color: #f8f9fa;
        --dark-color: #343a40;
        --white: #ffffff;
        --border-radius: 12px;
        --box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
        padding: 0;
        margin: 0;
    }

    .modern-container {
        max-width: 100%;
        margin: 0 auto;
        padding: 15px;
        background: transparent;
    }

    /* Page Header */
    .page-header {
        background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
        color: white;
        padding: 20px;
        border-radius: var(--border-radius);
        margin-bottom: 20px;
        box-shadow: var(--box-shadow);
        text-align: center;
        position: relative;
        overflow: hidden;
    }

    .page-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        animation: shimmer 3s infinite;
    }

    @keyframes shimmer {
        0% { left: -100%; }
        100% { left: 100%; }
    }

    .page-title {
        font-size: 1.5rem;
        font-weight: 700;
        margin: 0;
        position: relative;
        z-index: 1;
    }

    /* Alert Messages */
    .modern-alert {
        border: none;
        border-radius: var(--border-radius);
        padding: 15px 20px;
        margin-bottom: 20px;
        font-weight: 500;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        animation: slideInDown 0.5s ease-out;
    }

    @keyframes slideInDown {
        from {
            opacity: 0;
            transform: translateY(-20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .alert-danger {
        background: linear-gradient(135deg, #ffecee, #ffd6da);
        color: var(--danger-color);
        border-left: 4px solid var(--danger-color);
    }

    .alert-success {
        background: linear-gradient(135deg, #d4edda, #b8e6c1);
        color: var(--success-color);
        border-left: 4px solid var(--success-color);
    }

    /* Card Layout */
    .modern-card {
        background: white;
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow);
        margin-bottom: 20px;
        overflow: hidden;
        transition: var(--transition);
        border: 1px solid rgba(0,0,0,0.05);
    }

    .modern-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 30px rgba(0,0,0,0.15);
    }

    .card-header {
        background: linear-gradient(135deg, #f8f9fa, #e9ecef);
        padding: 15px 20px;
        border-bottom: 1px solid rgba(0,0,0,0.1);
        font-weight: 600;
        color: var(--dark-color);
    }

    .card-body {
        padding: 20px;
    }

    /* Form Styling */
    .form-row {
        display: flex;
        flex-wrap: wrap;
        margin: 0 -10px 20px -10px;
    }

    .form-col {
        flex: 1;
        min-width: 280px;
        padding: 0 10px;
        margin-bottom: 15px;
    }

    .form-col.half {
        flex: 0 0 50%;
        min-width: 250px;
    }

    .form-col.third {
        flex: 0 0 33.33%;
        min-width: 200px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-label {
        font-weight: 600;
        color: var(--dark-color);
        margin-bottom: 8px;
        display: block;
        font-size: 0.9rem;
    }

    .required {
        color: var(--danger-color);
    }

    .form-control {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e1e5e9;
        border-radius: 8px;
        font-size: 16px;
        transition: var(--transition);
        background: white;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .form-control:focus {
        outline: none;
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        transform: translateY(-1px);
    }

    .form-control:hover {
        border-color: #c1c7cd;
    }

    /* Radio Button Styling */
    .radio-group {
        display: flex;
        gap: 20px;
        flex-wrap: wrap;
        margin-top: 8px;
    }

    .radio-item {
        display: flex;
        align-items: center;
        cursor: pointer;
        padding: 8px 12px;
        border-radius: 6px;
        transition: var(--transition);
        background: #f8f9fa;
        border: 2px solid transparent;
    }

    .radio-item:hover {
        background: #e9ecef;
        border-color: var(--primary-color);
    }

    .radio-item input[type="radio"] {
        margin-right: 8px;
        transform: scale(1.2);
    }

    /* Button Styling */
    .modern-btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        font-size: 16px;
        cursor: pointer;
        transition: var(--transition);
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        min-height: 48px;
        position: relative;
        overflow: hidden;
    }

    .modern-btn::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
        transition: left 0.5s;
    }

    .modern-btn:hover::before {
        left: 100%;
    }

    .btn-primary {
        background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
        color: white;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
    }

    .btn-success {
        background: linear-gradient(135deg, #28a745, #20c997);
        color: white;
        box-shadow: 0 4px 15px rgba(40, 167, 69, 0.3);
    }

    .btn-success:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(40, 167, 69, 0.4);
    }

    .btn-danger {
        background: linear-gradient(135deg, #dc3545, #e74c3c);
        color: white;
        box-shadow: 0 4px 15px rgba(220, 53, 69, 0.3);
    }

    .btn-danger:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(220, 53, 69, 0.4);
    }

    .btn-block {
        width: 100%;
    }

    /* File Upload Styling */
    .file-upload {
        position: relative;
        display: inline-block;
        width: 100%;
    }

    .file-upload input[type="file"] {
        position: absolute;
        opacity: 0;
        width: 100%;
        height: 100%;
        cursor: pointer;
    }

    .file-upload-label {
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
        border: 2px dashed #d1d5db;
        border-radius: 8px;
        background: #f9fafb;
        cursor: pointer;
        transition: var(--transition);
        gap: 10px;
    }

    .file-upload-label:hover {
        border-color: var(--primary-color);
        background: #f0f9ff;
    }

    .file-upload-icon {
        font-size: 24px;
        color: var(--primary-color);
    }

    /* Table Styling */
    .modern-table-container {
        background: white;
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow);
        overflow: hidden;
        margin-top: 20px;
    }

    .modern-table {
        width: 100%;
        border-collapse: collapse;
        margin: 0;
    }

    .modern-table th {
        background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
        color: white;
        padding: 15px 12px;
        font-weight: 600;
        text-align: left;
        border: none;
    }

    .modern-table td {
        padding: 15px 12px;
        border-bottom: 1px solid #f1f3f4;
        vertical-align: middle;
    }

    .modern-table tr:hover {
        background: #f8f9fa;
    }

    .table-stats {
        background: linear-gradient(135deg, #e3f2fd, #bbdefb);
        padding: 15px;
        text-align: center;
        font-weight: 600;
        color: var(--dark-color);
    }

    /* Mobile Responsive */
    @media (max-width: 768px) {
        .modern-container {
            padding: 10px;
        }

        .page-title {
            font-size: 1.3rem;
        }

        .form-row {
            margin: 0 0 15px 0;
        }

        .form-col {
            padding: 0;
            min-width: 100%;
            flex: 1 1 100%;
        }

        .form-col.half,
        .form-col.third {
            flex: 1 1 100%;
            min-width: 100%;
        }

        .radio-group {
            flex-direction: column;
            gap: 10px;
        }

        .radio-item {
            justify-content: flex-start;
        }

        /* Mobile Table */
        .modern-table-container {
            overflow-x: auto;
        }

        .modern-table {
            min-width: 500px;
        }

        .modern-table th,
        .modern-table td {
            padding: 10px 8px;
            font-size: 14px;
        }
    }

    @media (max-width: 480px) {
        .card-body {
            padding: 15px;
        }

        .modern-btn {
            font-size: 14px;
            padding: 10px 20px;
        }

        .form-control {
            font-size: 16px; /* Prevents zoom on iOS */
            padding: 10px 12px;
        }
    }

    /* Loading Animation */
    .loading {
        pointer-events: none;
        opacity: 0.7;
    }

    .loading::after {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 20px;
        height: 20px;
        margin: -10px 0 0 -10px;
        border: 2px solid transparent;
        border-top: 2px solid white;
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Focus Management */
    .form-control:focus,
    .modern-btn:focus {
        outline: 2px solid var(--primary-color);
        outline-offset: 2px;
    }

    /* Touch Targets */
    .modern-btn,
    .form-control,
    .radio-item {
        min-height: 44px;
        min-width: 44px;
    }
</style>

<!-- Focus Management Script -->
<s:if test="challanProductInfoList.size()>0">
<script type="text/javascript"> 
window.onload = function() {
    document.getElementById("productName").focus();
};
</script>
</s:if>
<s:else>
<script type="text/javascript"> 
window.onload = function() {
    document.getElementById("challanNumber").focus();
};
</script>
</s:else>

<div class="modern-container">
    <!-- Page Header -->
    <div class="page-header">
        <h1 class="page-title">📋 Add New Delivery Challan</h1>
    </div>

    <!-- Error Messages -->
    <s:if test="hasActionErrors()">
        <div class="modern-alert alert-danger">
            <strong>⚠️ Error!</strong>
            <s:iterator var="error" value="%{errorMessages}">
                <div><s:property value="%{error}"/></div>
            </s:iterator>
        </div>
    </s:if>

    <!-- Success Messages -->
    <s:if test="hasActionMessages()">
        <div class="modern-alert alert-success">
            <strong>✅ Success!</strong>
            <s:iterator var="message" value="%{actionMessages}">
                <div><s:property value="%{message}"/></div>
            </s:iterator>
        </div>
    </s:if>

    <!-- Main Form -->
    <div class="modern-card">
        <div class="card-header">
            📅 Delivery Challan Information
        </div>
        <div class="card-body">
            <s:form method="post" name="addProductToDeliveryAndroidChallanList" 
                    action="addProductToDeliveryAndroidChallanList" theme="simple" 
                    enctype="multipart/form-data" acceptcharset="UTF-8">

                <!-- Date Section -->
                <div class="form-row">
                    <div class="form-col half">
                        <div class="form-group">
                            <label class="form-label">Delivery Challan Date <span class="required">*</span></label>
                            <sj:datepicker displayFormat="dd-mm-yy" 
                                         timepicker="true" 
                                         name="challanDateTime"
                                         id="challanDateTime"
                                         maxDate="+1"
                                         minDate="1"
                                         changeMonth="true"
                                         changeYear="true" 
                                         readonly="true"
                                         placeholder="Select Challan Date" 
                                         cssClass="form-control" 
                                         tabindex="1" />
                        </div>
                    </div>
                </div>

                <!-- Challan Details Section -->
                <s:if test="viewBill=='true' || challanProductInfoList.size()>0">
                    <div class="form-row">
                        <div class="form-col half">
                            <div class="form-group">
                                <label class="form-label">Challan No. <span class="required">*</span></label>
                                <s:textfield id="challanNumber" name="challanNumber" theme="simple" 
                                            cssClass="form-control" tabindex="1" 
                                            placeholder="Challan Number" readonly="true"/>
                            </div>
                        </div>
                        <div class="form-col half">
                            <div class="form-group">
                                <label class="form-label">Payment Type <span class="required">*</span></label>
                                <div class="radio-group">
                                    <s:radio list="paymentTypeList" name="paymentType" id="paymentType" 
                                            theme="simple" tabindex="2" cssClass="radio-item"/>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-col">
                            <div class="form-group">
                                <label class="form-label">Customer Name <span class="required">*</span></label>
                                <s:textfield id="customerName" name="customerName" theme="simple" 
                                            cssClass="form-control" tabindex="3" 
                                            placeholder="Customer Name" readonly="true"/>
                            </div>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-col">
                            <div class="form-group">
                                <label class="form-label">Vehicle Details <span class="required">*</span></label>
                                <s:textfield id="vehicleId" name="vehicleId" theme="simple" 
                                            cssClass="form-control" tabindex="4" 
                                            placeholder="Vehicle Details" readonly="true"/>
                            </div>
                        </div>
                    </div>
                </s:if>
                <s:else>
                    <div class="form-row">
                        <div class="form-col half">
                            <div class="form-group">
                                <label class="form-label">Challan No. <span class="required">*</span></label>
                                <s:textfield id="challanNumber" name="challanNumber" theme="simple" 
                                            cssClass="form-control" tabindex="1" placeholder="Challan Number"/>
                            </div>
                        </div>
                        <div class="form-col half">
                            <div class="form-group">
                                <label class="form-label">Payment Type <span class="required">*</span></label>
                                <div class="radio-group">
                                    <s:radio list="paymentTypeList" name="paymentType" id="paymentType" 
                                            theme="simple" tabindex="2" cssClass="radio-item"/>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-col">
                            <div class="form-group">
                                <label class="form-label">Customer Name <span class="required">*</span></label>
                                <s:url id="customerList" action="databaseCustomerJSON" />
                                <sj:autocompleter href="%{customerList}" 
                                                name="customerName" list="customerList" 
                                                id="customerName" 
                                                loadMinimumCount="3"								
                                                placeholder="Type customer name (min 3 chars)"		
                                                cssClass="form-control"				 
                                                tabindex="3" 
                                                onfocus="this.select();"/>
                            </div>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-col">
                            <div class="form-group">
                                <label class="form-label">Vehicle Details <span class="required">*</span></label>
                                <s:url id="vehicleList1" action="databaseVehicleJSON" />
                                <sj:autocompleter href="%{vehicleList1}" 
                                                name="vehicleId" list="vehicleList" 
                                                id="vehicleId" 
                                                loadMinimumCount="1"								
                                                placeholder="Type vehicle details"							 
                                                tabindex="4" 
                                                cssClass="form-control"			
                                                onfocus="this.select();"/>
                            </div>
                        </div>
                    </div>
                </s:else>
            </s:form>
        </div>
    </div>

    <!-- Trip Details Card -->
    <div class="modern-card">
        <div class="card-header">
            🚛 Trip & Journey Details
        </div>
        <div class="card-body">
            <s:form method="post" name="addProductToDeliveryAndroidChallanList" 
                    action="addProductToDeliveryAndroidChallanList" theme="simple" 
                    enctype="multipart/form-data" acceptcharset="UTF-8">

                <div class="form-row">
                    <div class="form-col third">
                        <div class="form-group">
                            <label class="form-label">KM Start <span class="required">*</span></label>
                            <s:textfield id="kmStart" name="kmStart" theme="simple" 
                                        cssClass="form-control" tabindex="5" 
                                        placeholder="Starting KM Reading"/>
                        </div>
                    </div>
                    <div class="form-col third">
                        <div class="form-group">
                            <label class="form-label">KM End <span class="required">*</span></label>
                            <s:textfield id="kmEnd" name="kmEnd" theme="simple" 
                                        cssClass="form-control" tabindex="6" 
                                        placeholder="Ending KM Reading"/>
                        </div>
                    </div>
                    <div class="form-col third">
                        <div class="form-group">
                            <label class="form-label">Total KM <span class="required">*</span></label>
                            <s:textfield id="totalKm" name="totalKm" theme="simple" 
                                        cssClass="form-control" tabindex="7" 
                                        placeholder="Auto-calculated" readonly="true"/>
                        </div>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-col half">
                        <div class="form-group">
                            <label class="form-label">Trip From <span class="required">*</span></label>
                            <s:textfield id="tripFrom" name="tripFrom" theme="simple" 
                                        cssClass="form-control" tabindex="8" 
                                        placeholder="Starting location"/>
                        </div>
                    </div>
                    <div class="form-col half">
                        <div class="form-group">
                            <label class="form-label">Trip To <span class="required">*</span></label>
                            <s:textfield id="tripTo" name="tripTo" theme="simple" 
                                        cssClass="form-control" tabindex="9" 
                                        placeholder="Destination"/>
                        </div>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-col half">
                        <div class="form-group">
                            <label class="form-label">Total Trip Count <span class="required">*</span></label>
                            <s:textfield id="totalTrips" name="totalTrips" theme="simple" 
                                        cssClass="form-control" tabindex="10" 
                                        placeholder="Number of trips"/>
                        </div>
                    </div>
                </div>
            </s:form>
        </div>
    </div>

    <!-- Product Details Card -->
    <div class="modern-card">
        <div class="card-header">
            📦 Product Information
        </div>
        <div class="card-body">
            <s:form method="post" name="addProductToDeliveryAndroidChallanList" 
                    action="addProductToDeliveryAndroidChallanList" theme="simple" 
                    enctype="multipart/form-data" acceptcharset="UTF-8">

                <div class="form-row">
                    <div class="form-col half">
                        <div class="form-group">
                            <label class="form-label">Product Name <span class="required">*</span></label>
                            <s:url id="productList" action="databaseProductJSON" />
                            <sj:autocompleter href="%{productList}" 
                                            name="productName" list="productList" 
                                            id="productName" 
                                            loadMinimumCount="2"								
                                            placeholder="Type product name (min 2 chars)" 
                                            cssClass="form-control"
                                            tabindex="11" 
                                            onfocus="this.select();"/>
                        </div>
                    </div>
                    <div class="form-col half">
                        <div class="form-group">
                            <label class="form-label">Quantity <span class="required">*</span></label>
                            <s:textfield id="quantity" name="quantity" theme="simple" 
                                        cssClass="form-control" tabindex="12" 
                                        placeholder="Enter quantity"/>
                        </div>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-col half">
                        <div class="form-group">
                            <label class="form-label">Select Unit <span class="required">*</span></label>
                            <s:select list="unitList" name="salesUnit" id="salesUnit" 
                                     headerKey="" headerValue="Choose sales unit" 
                                     cssClass="form-control" />
                        </div>
                    </div>
                    <div class="form-col half">
                        <div class="form-group">
                            <label class="form-label">Alternate Mobile No.</label>
                            <s:textfield name="alternateMobileNumber" id="alternateMobileNumber" 
                                        cssClass="form-control" tabindex="13"
                                        placeholder="Optional mobile number"
                                        readonly="${challanProductInfoList.size() > 0}"/>
                        </div>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-col">
                        <div class="form-group">
                            <label class="form-label">Comments</label>
                            <s:textarea rows="3" id="comments" tabindex="14" name="comments"  
                                       placeholder="Enter any additional comments..." 
                                       cssClass="form-control"/>
                        </div>
                    </div>
                </div>

                <s:hidden id="discountPercentage" name="discountPercentage"/>

                <div class="form-row">
                    <div class="form-col">
                        <button type='submit' class='modern-btn btn-primary btn-block' tabindex="15">
                            ➕ Add Product to List
                        </button>
                    </div>
                </div>
            </s:form>
        </div>
    </div>

    <!-- Product List & Actions -->
    <s:if test="challanProductInfoList.size()>0">
        
        <!-- Vehicle Images Card -->
        <div class="modern-card">
            <div class="card-header">
                📷 Vehicle Images (Optional)
            </div>
            <div class="card-body">
                <s:form method="post" name="saveDCAndPrintAndroid" action="saveDCAndPrintAndroid" 
                        theme="simple" enctype="multipart/form-data" acceptcharset="UTF-8">

                    <div class="form-row">
                        <div class="form-col third">
                            <div class="form-group">
                                <label class="form-label">Vehicle Image 1</label>
                                <div class="file-upload">
                                    <s:file accept="image/*" capture="camera" name="image1" id="image1" 
                                           tabindex="16" />
                                    <label for="image1" class="file-upload-label">
                                        <span class="file-upload-icon">📷</span>
                                        <span>Take/Choose Photo</span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="form-col third">
                            <div class="form-group">
                                <label class="form-label">Vehicle Image 2</label>
                                <div class="file-upload">
                                    <s:file accept="image/*" capture="camera" name="image2" id="image2" 
                                           tabindex="17" />
                                    <label for="image2" class="file-upload-label">
                                        <span class="file-upload-icon">📷</span>
                                        <span>Take/Choose Photo</span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="form-col third">
                            <div class="form-group">
                                <label class="form-label">Vehicle Image 3</label>
                                <div class="file-upload">
                                    <s:file accept="image/*" capture="camera" name="image3" id="image3" 
                                           tabindex="18" />
                                    <label for="image3" class="file-upload-label">
                                        <span class="file-upload-icon">📷</span>
                                        <span>Take/Choose Photo</span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Save/Print Action -->
                    <div class="form-row">
                        <div class="form-col">
                            <s:if test="challanSaved">
                                <s:url var="printChallanA5" action="printChallan">
                                    <s:param name="challanNumber"><s:property value="challanNumber"/></s:param>
                                    <s:param name="size">A5</s:param>
                                    <s:param name="lang">eng</s:param>
                                </s:url>
                                <a href="${printChallanA5}" target="_blank" class="modern-btn btn-danger btn-block" tabindex="19">
                                    🖨️ Print Challan (A5 English)
                                </a>
                            </s:if>
                            <s:else>
                                <button type='submit' class='modern-btn btn-success btn-block' tabindex="19">
                                    💾 Save Delivery Challan
                                </button>
                            </s:else>
                        </div>
                    </div>
                </s:form>
            </div>
        </div>

        <!-- Products Table -->
        <div class="modern-table-container">
            <div class="table-stats">
                📊 Total Items: <s:property value="%{challanProductInfoList.size()}"/>
            </div>
            
            <table class="modern-table">
                <thead>
                    <tr>
                        <th>📦 Product Name</th>
                        <th>📏 Quantity</th>
                        <th>⚖️ Unit</th>
                        <th style="text-align: center;">⚙️ Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <s:iterator value="challanProductInfoList">
                        <tr>
                            <td><s:property value="productName"/></td>
                            <td><s:property value="quantity"/></td>
                            <td><s:property value="salesUnit"/></td>
                            <td style="text-align: center;">
                                <s:url var="deleteEditProduct" action="deleteEditProductFromChallanAndroidList">
                                    <s:param name="productNameForDelete"><s:property value="productName"/></s:param>
                                </s:url>
                                <a href="${deleteEditProduct}" class="modern-btn btn-danger" tabindex="21">
                                    🗑️ Delete/Edit
                                </a>
                            </td>
                        </tr>
                    </s:iterator>
                </tbody>
            </table>
        </div>
    </s:if>
</div>

<!-- Enhanced JavaScript -->
<script type="text/javascript">
$(document).ready(function() {
    jQuery.noConflict();
    
    // Enhanced form navigation
    const formFields = [
        '#challanNumber', '#customerName', '#vehicleId', '#kmStart', '#kmEnd', 
        '#tripFrom', '#tripTo', '#totalTrips', '#productName', '#quantity', 
        '#salesUnit', '#alternateMobileNumber', '#comments'
    ];

    // Add smooth focus transitions
    formFields.forEach((field, index) => {
        $(field).on('focus', function() {
            $(this).parent().addClass('focused');
        }).on('blur', function() {
            $(this).parent().removeClass('focused');
        });

        // Enhanced Enter key navigation
        $(field).keypress(function(e) {
            if (e.which == 13) {
                e.preventDefault();
                const nextIndex = index + 1;
                if (nextIndex < formFields.length) {
                    $(formFields[nextIndex]).focus();
                } else {
                    $('button[type="submit"]').first().focus();
                }
            }
        });
    });

    // Enhanced AJAX calls with loading states
    function showLoading(element) {
        $(element).addClass('loading').prop('disabled', true);
    }

    function hideLoading(element) {
        $(element).removeClass('loading').prop('disabled', false);
    }

    // Product name autocomplete with enhanced UX
    $('#productName').focusout(function() {
        const productName = $(this).val();
        if (productName.length >= 2) {
            showLoading(this);
            $.ajax({
                url: 'getAliasFullName',
                data: "aliasValue=" + productName,
                dataType: "json",
                success: function(data) {
                    $('#productName').val(data.fullName);
                    $('#productMarathiName').val(data.fullNameMarathi);
                    $('#salesUnit').val(data.salesUnit);
                    $('#taxPercentage').val(data.tax);
                    $('#salesRate').val(data.salesRate);
                    
                    // Visual feedback
                    $('#productName').css('border-color', '#28a745');
                    setTimeout(() => {
                        $('#productName').css('border-color', '');
                    }, 2000);
                },
                error: function() {
                    $('#productName').css('border-color', '#dc3545');
                    setTimeout(() => {
                        $('#productName').css('border-color', '');
                    }, 2000);
                },
                complete: function() {
                    hideLoading('#productName');
                }
            });
        }
    });

    // Vehicle capacity lookup with enhanced UX
    $('#vehicleId').focusout(function() {
        const vehicleId = $(this).val();
        if (vehicleId.length >= 1) {
            showLoading(this);
            $.ajax({
                url: 'getVehicleBrassCapacity',
                data: "vehicleId=" + vehicleId,
                dataType: "json",
                success: function(data) {
                    if (data.quantity) {
                        $('#quantity').val(data.quantity);
                        $('#quantity').css('border-color', '#28a745');
                        setTimeout(() => {
                            $('#quantity').css('border-color', '');
                        }, 2000);
                    }
                },
                error: function() {
                    console.log('Error fetching vehicle capacity');
                },
                complete: function() {
                    hideLoading('#vehicleId');
                }
            });
        }
    });

    // Auto-calculate total KM with enhanced UX
    $('#kmEnd').focusout(function() {
        const kmStart = parseFloat($('#kmStart').val()) || 0;
        const kmEnd = parseFloat($('#kmEnd').val()) || 0;
        
        if (kmEnd > kmStart) {
            const totalKm = kmEnd - kmStart;
            $('#totalKm').val(totalKm);
            
            // Visual feedback
            $('#totalKm').css('border-color', '#28a745');
            setTimeout(() => {
                $('#totalKm').css('border-color', '');
            }, 2000);
        } else if (kmEnd < kmStart && kmEnd > 0) {
            alert('⚠️ End KM should be greater than Start KM');
            $(this).focus();
        }
    });

    // Enhanced button interactions
    $('.modern-btn').on('mousedown', function() {
        $(this).css('transform', 'scale(0.98)');
    }).on('mouseup mouseleave', function() {
        $(this).css('transform', '');
    });

    // Form validation with enhanced UX
    $('form').on('submit', function(e) {
        const requiredFields = $(this).find('[required], .required').siblings('input, select, textarea');
        let hasErrors = false;

        requiredFields.each(function() {
            if (!$(this).val().trim()) {
                $(this).css('border-color', '#dc3545');
                hasErrors = true;
            } else {
                $(this).css('border-color', '');
            }
        });

        if (hasErrors) {
            e.preventDefault();
            alert('⚠️ Please fill all required fields');
            requiredFields.filter(function() {
                return !$(this).val().trim();
            }).first().focus();
        }
    });

    // File upload preview
    $('input[type="file"]').on('change', function() {
        const file = this.files[0];
        const label = $(this).siblings('label');
        
        if (file) {
            label.find('span:last').text(file.name);
            label.css('border-color', '#28a745');
        } else {
            label.find('span:last').text('Take/Choose Photo');
            label.css('border-color', '');
        }
    });

    // Smooth scroll to error messages
    if ($('.modern-alert').length) {
        $('html, body').animate({
            scrollTop: $('.modern-alert').offset().top - 20
        }, 500);
    }

    // Touch-friendly interactions for mobile
    if ('ontouchstart' in window) {
        $('.modern-btn, .form-control').on('touchstart', function() {
            $(this).addClass('touched');
        }).on('touchend', function() {
            setTimeout(() => {
                $(this).removeClass('touched');
            }, 150);
        });
    }

    console.log('✅ Modern DC Form initialized successfully!');
});
</script>

<!-- Enhanced CSS for touched states -->
<style>
    .touched {
        background-color: #f8f9fa !important;
        transform: scale(0.98) !important;
    }
    
    .focused {
        transform: translateY(-2px);
        transition: var(--transition);
    }
    
    .form-control:invalid {
        border-color: #dc3545;
        box-shadow: 0 0 0 3px rgba(220, 53, 69, 0.1);
    }
    
    .form-control:valid {
        border-color: #28a745;
    }
</style>
