
<%@ page language="java" pageEncoding="UTF-8"%>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sx" uri="/struts-dojo-tags"%>  
<%@ taglib prefix="sjs" uri="/struts-jquery-tags"  %>
<script lang="javascript" type="text/javascript"> 

 window.onload = function() {
	 <s:if test="#session.weight_scale_online =='TRUE'">
	 document.getElementById("start").focus();
	 </s:if>
	 <s:else>
	  document.getElementById("entryDate").focus();
	  </s:else>
	};

</script>





<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-cookie/1.4.1/jquery.cookie.min.js"></script>



<s:if test="#session.online_weight_scale_allowed==true">

<s:if test="#session.weight_scale_online =='TRUE'">

<script lang="javascript" type="text/javascript">

window.onload = function() {
    checkAndOpenPort();
}

let serialPort;
let reader;
let writer;
let readableStreamClosed;
let writableStreamClosed;
let keepReading = false;
let currentLine = "";

// Function to check and open the port
async function checkAndOpenPort() {
    try {
        const ports = await navigator.serial.getPorts();
        
        if (ports.length > 0) {
            // If a port has been granted access before, use it
            serialPort = ports[0];
            await openPort();
        } else {
            // If no port has been granted access, ask the user to select one
            await startReading();
        }
    } catch (error) {
        alert("There was an error accessing the serial port: " + error.message);
        console.error("Error accessing the serial port: ", error);
    }
}

async function openPort() {
    // Retrieve session values as strings
    const baudRate = '<s:property value="#session.bits_per_second"/>'; // Baud rate
    const dataBits = '<s:property value="#session.data_bits"/>'; // Data bits
    const parity = '<s:property value="#session.parity"/>'.toLowerCase(); // Parity
    const stopBits = '<s:property value="#session.stop_bits"/>'; // Stop bits
    const flowControl = '<s:property value="#session.flow_control"/>'.toLowerCase(); // Flow control

    await serialPort.open({
        baudRate: parseInt(baudRate),
        dataBits: parseInt(dataBits),
        
        parity: parity.toLowerCase(),
        stopBits: parseInt(stopBits),
        flowControl: flowControl.toLowerCase()
    });

    const textDecoder = new TextDecoderStream();
    readableStreamClosed = serialPort.readable.pipeTo(textDecoder.writable);
    reader = textDecoder.readable.getReader();

    const textEncoder = new TextEncoderStream();
    writableStreamClosed = textEncoder.readable.pipeTo(serialPort.writable);
    writer = textEncoder.writable.getWriter();

    <s:if test="#session.auto_zero_mode == 'TRUE'">
        sendTareZeroCommand();
        alert("Weight Scale Is Connected Successfully & Current Weight = 0.0");
    </s:if>
}

async function startReading() {
    try {
        if (!("serial" in navigator)) {
            alert("Your browser does not support the Web Serial API");
            return;
        }

        // User selects the port
        serialPort = await navigator.serial.requestPort();
        await openPort();

    } catch (error) {
        alert("There was an error opening the serial port: " + error.message);
        console.error("Error opening the serial port: ", error);
    }
}

async function readLoop() {
    try {
        while (keepReading) {
            const { value, done } = await reader.read();

            if (done) {
                console.log("Stream closed");
                break;
            }

            if (value) {
                currentLine += value;
                
                if (value.includes('\n')) {
                    appendData(currentLine.trim());
                    currentLine = "";
                }
            }
        }
    } catch (error) {
        console.error("Error reading from the serial port: ", error);
        appendData("Error reading data");
    }
}

function appendData(data) {
    const milkInLiterElement = document.getElementById("vehicleEmptyWeight");
    let numericData = data.replace(/[^\d.-]/g, '');  // Remove non-numeric characters except dot and minus
    numericData = numericData.replace(/^0+(?=\d)/, '');  // Remove leading zeros
    milkInLiterElement.value = numericData;  // Set the value of the text field
}

async function sendTareZeroCommand() {
    if (!serialPort) {
        alert("Serial port not open");
        return;
    }

    try {
        const command = ["Z"];
        await writer.write(command + "\n"); // Append newline if required by your device
        console.log("Sent TARE/ZERO command:", command);
    } catch (error) {
        alert("Error sending TARE/ZERO command: " + error.message);
        console.error("Error sending TARE/ZERO command:", error);
    }
}

async function stopReading() {
    keepReading = false;  // Stop the reading loop
    try {
        if (reader) {
            await reader.cancel();
            reader.releaseLock();
        }
        if (writer) {
            await writer.close();
            writer.releaseLock();
        }
        if (readableStreamClosed) {
            await readableStreamClosed.catch(() => {});
        }
        if (writableStreamClosed) {
            await writableStreamClosed.catch(() => {});
        }
        if (serialPort) {
            await serialPort.close();
            alert("Serial port closed");
        } else {
            alert("Serial port already closed");
        }
    } catch (error) {
        alert("Error closing the serial port: " + error.message);
        console.error("Error closing the serial port: ", error);
    }
}

function startReadLoop() {
    keepReading = true;
    currentLine = "";  // Reset currentLine to avoid partial data from previous reads
    readLoop();
}

function stopReadLoop() {
    keepReading = false;
}

</script>

</s:if>
</s:if>




<div align="center" style="margin-top: 10px; font-size: 14px;">
		<div class="ui-widget">
		
<table class="table table-bordered" style="height: 10px; width: 800px;">


<tr  style="font-weight: bold; background-color: rgb(234,234,234);">
<td colspan="4" align="center">
<s:property value="getText('header.addVehicleEmptyEntryDetails')" />


</td>
</tr>


<s:if test="hasActionErrors()" >
<tr>
<td colspan="4" align="center" >  
     
    <div class="alert alert-danger">
 	 <strong><s:property value="getText('header.error')" />! </strong>
     
      <s:iterator var="error" value="%{errorMessages}">
        <s:property value="%{error}"/>
    </s:iterator>
	</div>
      
</td>
</tr>
</s:if>

<s:if test="hasActionMessages()" >
<tr>
<td colspan="4" style="font-size: medium; height:30px; color: green;" align="center" >  
    
    <div class="alert alert-success">
  	<strong><s:property value="getText('header.success')" />! </strong>
   	<s:iterator var="message" value="%{actionMessages}">
        <s:property value="%{message}"/>
    </s:iterator>
    </div>
  
 



</td>
</tr>
</s:if>





    <s:if test="#session.online_weight_scale_allowed==true">
	           
<s:if test="#session.weight_scale_online =='TRUE'">

<tr align="center">

<tr align="center">


<td  colspan="4" >
                    <button onclick="startReading()" id="start" name="start" class="btn btn-danger btn-sm"><s:property value="getText('button.connectToWeightScale')" /></button>
                 
                    <button onclick="sendTareZeroCommand()" id="tareZeroButton" class="btn btn-danger btn-sm"><s:property value="getText('button.tareZero')" /></button>
                
                 <button onclick="stopReading()" id="stop" name="stop" class="btn btn-danger btn-sm"><s:property value="getText('button.disconnect')" /></button>
                
                </td>

</tr>
</s:if>
</s:if>


</table>

<s:form method="post" name="addVehicleEntryDetails" action="addVehicleEntryDetails" theme="simple" enctype="multipart/form-data" acceptcharset="UTF-8" >
	
<table class="table table-bordered" style="height: 10px; width: 800px;">



<tr >

<td ><s:property value="getText('text.lable.entryDate')" /> *</td>
<td  align="left">
<sjs:datepicker displayFormat="dd-mm-yy" 
               timepicker="true" 
               name="entryDate"
			   id="entryDate"
			   maxDate="1"
			   changeMonth="true"
			   changeYear="true" 
			   readonly="true"
			   placeholder="Entry Date" cssClass="textBoxDate" tabindex="1" />
 
</td>


<tr >
<td ><s:property value="getText('text.lable.selectVehicle')" />*</td>
<td align="left"><s:url id="vehicleList1" action="databaseVehicleJSON" />
<sjs:autocompleter 				href="%{vehicleList1}" 
								name="vehicleId" list="vehicleList" 
								id="vehicleId" 
								loadMinimumCount="1"								
								placeholder="Vehicle Details"							 
								tabindex="2" 
								cssClass="textBox"		
								onfocus="this.select();"/>
								</td>
								
								
								</tr>
<tr>

<td ><s:property value="getText('text.lable.vehicleEmptyWeight')" /> *</td>
<td align="left">



<s:if test="#session.online_weight_scale_allowed==true">
<s:if test="#session.weight_scale_online =='TRUE'">
<s:textfield name="vehicleEmptyWeight" id="vehicleEmptyWeight" cssClass="textBoxSmall" tabindex="3" readonly="true"/>

</s:if>
<s:else>
<s:textfield name="vehicleEmptyWeight" id="vehicleEmptyWeight" cssClass="textBoxSmall" tabindex="3"/>

</s:else>
</s:if>
<s:else>
<s:textfield name="vehicleEmptyWeight" id="vehicleEmptyWeight" cssClass="textBoxSmall" tabindex="3"/>

</s:else>	



</td>


</tr>

  
    <tr >
<td  >
 <s:property value="getText('text.lable.uploadPhoto')" />
   </td>
<td  align="left">
<s:file name="photo1PDF" id="photo1PDF" placeholder="Upload Photo" />
 
 </td>
</tr>
  
 
    
    
    <tr align="center" >
  <td colspan="4" align="center">
   <button  type='submit' id="submit" class='btn btn-primary btn-sm' tabindex="4"><s:property value="getText('button.addDetails')" /></button>
  </td>
  </tr>

</table>



</s:form>


</div>
</div>





<script type="text/javascript">


$(document).ready(function () 
{
	
	jQuery.noConflict();(function( $ ) {
		
		
		
		<s:if test="#session.weight_scale_online =='TRUE'">
		$('#start').keypress(function (e) {
	        if (e.which == 13) {
	            e.preventDefault();            
	            $('#entryDate').focus();
	            
	        }
	    });
		$('#entryDate').keypress(function (e) 
				{
				    if (e.which == 13) {
				        e.preventDefault();            
				        $('#vehicleId').focus();
				    }
				});
		</s:if>
		<s:else>								
		$('#entryDate').keypress(function (e) 
				{
				    if (e.which == 13) {
				        e.preventDefault();            
				        $('#vehicleId').focus();
				    }
				});
	    </s:else>
	    <s:if test="#session.weight_scale_online =='TRUE'">
	    $('#vehicleEmptyWeight').focus(function () {
	        startReadLoop();
	    });

	    $('#vehicleEmptyWeight').focusout(function () {
	        stopReadLoop();
	    });
	    </s:if>
	    
	    
	    
	    $('#vehicleId').keypress(function (e) 
	    		{
	    		    if (e.which == 13) {
	    		        e.preventDefault();            
	    		        $('#vehicleEmptyWeight').focus();
	    		    }
	    		});
		

		
$('#vehicleEmptyWeight').keypress(function (e) 
		{
		    if (e.which == 13) {
		        e.preventDefault();            
		        $('#submit').focus();
		    }
		});



	})( jQuery );

	
	  
});
  
</script>



