<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<!-- Fancy Loader CSS with Multiple Animation Options -->
<style>
.loader-container {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.7);
    display: none;
    justify-content: center;
    align-items: center;
    z-index: 9999;
    backdrop-filter: blur(5px);
}

/* Option 1: Pulsing Dots */
.loader-dots {
    display: flex;
    gap: 8px;
}

.loader-dots .dot {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    background: linear-gradient(45deg, #ff6b6b, #4ecdc4);
    animation: pulse-dots 1.4s infinite ease-in-out;
}

.loader-dots .dot:nth-child(1) { animation-delay: 0s; }
.loader-dots .dot:nth-child(2) { animation-delay: 0.2s; }
.loader-dots .dot:nth-child(3) { animation-delay: 0.4s; }

@keyframes pulse-dots {
    0%, 80%, 100% { transform: scale(0.8); opacity: 0.5; }
    40% { transform: scale(1.2); opacity: 1; }
}

/* Option 2: Modern Spinner */
.loader-modern {
    width: 60px;
    height: 60px;
    border: 3px solid transparent;
    border-top: 3px solid #fff;
    border-right: 3px solid #fff;
    border-radius: 50%;
    animation: modern-spin 1s linear infinite;
    position: relative;
}

.loader-modern::before {
    content: '';
    position: absolute;
    top: 5px;
    left: 5px;
    right: 5px;
    bottom: 5px;
    border: 3px solid transparent;
    border-top: 3px solid #ff6b6b;
    border-radius: 50%;
    animation: modern-spin 1.5s linear infinite reverse;
}

@keyframes modern-spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Option 3: Bouncing Balls */
.loader-bounce {
    display: flex;
    gap: 5px;
}

.loader-bounce .ball {
    width: 15px;
    height: 15px;
    background: linear-gradient(45deg, #667eea, #764ba2);
    border-radius: 50%;
    animation: bounce-balls 0.8s infinite alternate;
}

.loader-bounce .ball:nth-child(1) { animation-delay: 0s; }
.loader-bounce .ball:nth-child(2) { animation-delay: 0.1s; }
.loader-bounce .ball:nth-child(3) { animation-delay: 0.2s; }

@keyframes bounce-balls {
    from { transform: translateY(0px); }
    to { transform: translateY(-30px); }
}

/* Option 4: Rotating Squares */
.loader-squares {
    width: 50px;
    height: 50px;
    position: relative;
}

.loader-squares .square {
    position: absolute;
    width: 20px;
    height: 20px;
    background: linear-gradient(45deg, #f093fb, #f5576c);
    animation: rotate-squares 2s infinite ease-in-out;
}

.loader-squares .square:nth-child(1) {
    top: 0;
    left: 0;
    animation-delay: 0s;
}

.loader-squares .square:nth-child(2) {
    top: 0;
    right: 0;
    animation-delay: 0.5s;
}

.loader-squares .square:nth-child(3) {
    bottom: 0;
    right: 0;
    animation-delay: 1s;
}

.loader-squares .square:nth-child(4) {
    bottom: 0;
    left: 0;
    animation-delay: 1.5s;
}

@keyframes rotate-squares {
    0%, 100% { transform: scale(1) rotate(0deg); }
    50% { transform: scale(0.5) rotate(180deg); }
}

/* Option 5: Heartbeat Pulse */
.loader-heart {
    width: 60px;
    height: 60px;
    background: linear-gradient(45deg, #ff9a9e, #fecfef);
    border-radius: 50%;
    position: relative;
    animation: heartbeat 1.2s infinite;
}

.loader-heart::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 30px;
    height: 30px;
    background: rgba(255, 255, 255, 0.8);
    border-radius: 50%;
    transform: translate(-50%, -50%);
    animation: heartbeat-inner 1.2s infinite;
}

@keyframes heartbeat {
    0%, 100% { transform: scale(1); }
    25% { transform: scale(1.1); }
    50% { transform: scale(1.2); }
    75% { transform: scale(1.1); }
}

@keyframes heartbeat-inner {
    0%, 100% { transform: translate(-50%, -50%) scale(1); }
    50% { transform: translate(-50%, -50%) scale(0.8); }
}

/* Option 6: Wave Loading */
.loader-wave {
    display: flex;
    gap: 4px;
    align-items: flex-end;
}

.loader-wave .bar {
    width: 6px;
    height: 40px;
    background: linear-gradient(to top, #a8edea, #fed6e3);
    border-radius: 3px;
    animation: wave-bars 1s infinite ease-in-out;
}

.loader-wave .bar:nth-child(1) { animation-delay: 0s; }
.loader-wave .bar:nth-child(2) { animation-delay: 0.1s; }
.loader-wave .bar:nth-child(3) { animation-delay: 0.2s; }
.loader-wave .bar:nth-child(4) { animation-delay: 0.3s; }
.loader-wave .bar:nth-child(5) { animation-delay: 0.4s; }

@keyframes wave-bars {
    0%, 40%, 100% { transform: scaleY(0.4); }
    20% { transform: scaleY(1); }
}

/* Option 7: Rotating Orbit */
.loader-orbit {
    width: 60px;
    height: 60px;
    position: relative;
}

.loader-orbit::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 8px;
    height: 8px;
    background: #fff;
    border-radius: 50%;
    transform: translate(-50%, -50%);
}

.loader-orbit::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    border: 2px solid transparent;
    border-top: 2px solid #4ecdc4;
    border-radius: 50%;
    animation: orbit-spin 1s linear infinite;
}

@keyframes orbit-spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Option 8: Glowing Ring */
.loader-glow {
    width: 60px;
    height: 60px;
    border: 4px solid rgba(255, 255, 255, 0.1);
    border-top: 4px solid #fff;
    border-radius: 50%;
    animation: glow-spin 1s linear infinite;
    box-shadow: 0 0 20px rgba(255, 255, 255, 0.3);
}

@keyframes glow-spin {
    0% { 
        transform: rotate(0deg); 
        box-shadow: 0 0 20px rgba(255, 255, 255, 0.3);
    }
    50% { 
        box-shadow: 0 0 40px rgba(255, 255, 255, 0.6);
    }
    100% { 
        transform: rotate(360deg); 
        box-shadow: 0 0 20px rgba(255, 255, 255, 0.3);
    }
}

/* Loading text styles */
.loader-text {
    color: white;
    font-family: 'Arial', sans-serif;
    font-size: 18px;
    margin-top: 20px;
    text-align: center;
    font-weight: 300;
    letter-spacing: 2px;
}

.loader-container-with-text {
    display: flex;
    flex-direction: column;
    align-items: center;
}
</style>

<!-- Common CSS and other resources can go here -->

<!-- Loader JavaScript -->
<script>
// Basic loader functions
function showLoader(animationType = 'modern') {
    var loader = document.getElementById('globalPageLoader');
    if (!loader) {
        loader = document.createElement('div');
        loader.id = 'globalPageLoader';
        loader.className = 'loader-container';
        document.body.appendChild(loader);
    }
    
    // Set the loader content based on animation type
    var loaderContent = getLoaderAnimation(animationType);
    loader.innerHTML = loaderContent;
    loader.style.display = 'flex';
}

function hideLoader() {
    var loader = document.getElementById('globalPageLoader');
    if (loader) {
        loader.style.display = 'none';
    }
}

function getLoaderAnimation(type) {
    var animations = {
        'dots': '<div class="loader-container-with-text"><div class="loader-dots"><div class="dot"></div><div class="dot"></div><div class="dot"></div></div><div class="loader-text">Loading...</div></div>',
        'modern': '<div class="loader-container-with-text"><div class="loader-modern"></div><div class="loader-text">Please wait...</div></div>',
        'bounce': '<div class="loader-container-with-text"><div class="loader-bounce"><div class="ball"></div><div class="ball"></div><div class="ball"></div></div><div class="loader-text">Processing...</div></div>',
        'squares': '<div class="loader-container-with-text"><div class="loader-squares"><div class="square"></div><div class="square"></div><div class="square"></div><div class="square"></div></div><div class="loader-text">Loading...</div></div>',
        'heart': '<div class="loader-container-with-text"><div class="loader-heart"></div><div class="loader-text">Loading with ❤️</div></div>',
        'wave': '<div class="loader-container-with-text"><div class="loader-wave"><div class="bar"></div><div class="bar"></div><div class="bar"></div><div class="bar"></div><div class="bar"></div></div><div class="loader-text">Processing...</div></div>',
        'orbit': '<div class="loader-container-with-text"><div class="loader-orbit"></div><div class="loader-text">Loading...</div></div>',
        'glow': '<div class="loader-container-with-text"><div class="loader-glow"></div><div class="loader-text">Please wait...</div></div>'
    };
    
    return animations[type] || animations['modern'];
}

// Test function to preview different animations
function testAnimation(type) {
    showLoader(type);
    setTimeout(function() {
        hideLoader();
    }, 3000);
}

// Function to check if a link should show the loader
function shouldShowLoaderForLink(link) {
    var href = link.getAttribute('href');
    var linkText = link.textContent.toLowerCase().trim();
    
    if (!href || href === '#' || href.indexOf('javascript:') === 0 || 
        href.indexOf('mailto:') === 0 || href.indexOf('tel:') === 0) {
        return false;
    }
    
    if (link.getAttribute('target') === '_blank') {
        return false;
    }
    
    // Exclude statistics cards actions (Customer Count, Vehicle Count, etc.)
    var statisticsActions = ['downloadListOfCustomer', 'listVehiclesJsp', 'listSupplierJsp', 'listEmployeeJsp', 'getCustCreditReport', 'getSupplierDebtReport', 'dailyExpenseReportJsp', 'employeeBalanceReportJsp'];
    for (var i = 0; i < statisticsActions.length; i++) {
        if (href.indexOf(statisticsActions[i]) !== -1) {
            return false;
        }
    }
    
    var strutsActions = ['logout', 'showNotificationsJsp', 'showCustomerPaymentReminderNotificationsJsp'];
    for (var i = 0; i < strutsActions.length; i++) {
        if (href.indexOf(strutsActions[i]) !== -1) {
            return false;
        }
    }
    
    // Exclude statistics cards by text content
    var statisticsTexts = ['customer count', 'vehicle count', 'supplier count', 'employee count'];
    for (var i = 0; i < statisticsTexts.length; i++) {
        if (linkText.indexOf(statisticsTexts[i]) !== -1) {
            return false;
        }
    }
    
    var menuTexts = ['logout', 'profile', 'settings', 'about', 'contact', 'help', 'notification'];
    for (var i = 0; i < menuTexts.length; i++) {
        if (linkText.indexOf(menuTexts[i]) !== -1) {
            return false;
        }
    }
    
    // Exclude statistics cards by icon classes
    var iconElement = link.querySelector('i.fa-bell, i.fa-user, i.fa-cog, i.fa-sign-out, i.fa-users, i.fa-car, i.fa-truck, i.fa-user-tie');
    if (iconElement) {
        return false;
    }
    
    var buttonElement = link.querySelector('button');
    if (buttonElement) {
        var buttonText = buttonElement.textContent.toLowerCase().trim();
        var navButtonTexts = ['logout', 'profile', 'settings', 'notification'];
        for (var i = 0; i < navButtonTexts.length; i++) {
            if (buttonText.indexOf(navButtonTexts[i]) !== -1) {
                return false;
            }
        }
    }
    
    // Exclude menu and sidebar links by parent container class
    var parentElement = link.parentElement;
    while (parentElement) {
        var className = parentElement.className || '';
        var id = parentElement.id || '';
        
        if (className.indexOf('menu') !== -1 || 
            className.indexOf('sidebar') !== -1 ||
            className.indexOf('stat-card') !== -1 ||
            className.indexOf('stats-grid') !== -1 ||
            id.indexOf('menu') !== -1 || 
            id.indexOf('sidebar') !== -1) {
            return false;
        }
        
        parentElement = parentElement.parentElement;
    }
    
    return true;
}

// Initialize when page loads
window.addEventListener('load', function() {
    console.log('Modern loader system initialized');
    
    // Handle forms, submit buttons, and links
    var forms = document.querySelectorAll('form');
    for (var i = 0; i < forms.length; i++) {
        forms[i].addEventListener('submit', function(e) {
            showLoader('modern');
        });
    }
    
    var submitButtons = document.querySelectorAll('button[type="submit"], input[type="submit"]');
    for (var i = 0; i < submitButtons.length; i++) {
        submitButtons[i].addEventListener('click', function(e) {
            showLoader('modern');
        });
    }
    
    var links = document.querySelectorAll('a[href]');
    for (var i = 0; i < links.length; i++) {
        var link = links[i];
        if (shouldShowLoaderForLink(link)) {
            link.addEventListener('click', function(e) {
                showLoader('modern');
            });
        }
    }
});
</script>

<!-- Initialize any common scripts -->
<script>
    // You can add any common initialization code here
</script> 