package com.stonecrusher.view;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.CustomerAccountDetailsDAO;
import com.stonecrusher.DAO.SupplierAccountDetailsDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import java.text.ParseException;

public class ViewSuppAccountDetails extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3694238914060913156L;

	
	private HttpSession session;
	private String key;
	private String supplierName;
	private String supplierMobile;
	private String supplierAddress;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private String fromDate;
	private String toDate;
	
	
	private Float totalPurchaseAmountBeforeDate;
	private Float totalAmountPaidBeforeDate;
	private Float totalDebtAmountBeforeDate;
	
	private Float totalPurchaseAmountAllTheTime;
	private Float totalAmountPaidAllTheTime;
	private Float totalDebtAmountAllTheTime;
	
	private Float totalPurchaseAmountBetweenDates = 0.0f;
	private Float totalAmountPaidBetweenDates = 0.0f;
	private Float totalDebtAmountBetweenDates = 0.0f;
	
	
	
	private List<SupplierAccountDetailsDAO> supplierAccountDetailsList = new ArrayList<SupplierAccountDetailsDAO>();
	private List<SupplierAccountDetailsDAO> supplierAccountDetailsSortedList = new ArrayList<SupplierAccountDetailsDAO>();
	
	private Float supplierOpeningBalnce = 0.0F;
	private String opeingBalancUpdatedBy;
	private String opeingBalanceUpdateDate;
	private String addSideBarJs;
	private List<Map<String, Object>> productQuantityList = new ArrayList<>();
	
	
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";
	        }  
	        else{
	        	this.setAddSideBarJs("FALSE");
	        	
	        	customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        
	        	String supplierId = EncryptionDecryption.decrypt(getKey());
	        
	        	setKey(EncryptionDecryption.encrypt(supplierId));
	        	

	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String crusherId = (String) session.getAttribute("crusherId");
				String crusherCode = (String) session.getAttribute("crusherCode");

	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
	       		
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			
	       			
	       			PreparedStatement getOpeningBalPSMT = null;
       				ResultSet getOpeningBalRs = null;
       				String getOpeningBalSQL = "SELECT "
       						+ "opening_balance,"
       						+ "DATE_FORMAT(opening_balance_date,'%d/%m/%Y'),"
       						+ "update_by "
       						+ "FROM "
       						+ "crusher_supplier_close_open_bal_master "
       						+ "WHERE "
       						+ "supplier_id = ? "
       						+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";

       				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
       				
       				getOpeningBalPSMT.setString(1, supplierId);
       				getOpeningBalPSMT.setString(2, crusherId);
       				getOpeningBalPSMT.setString(3, crusherCode);

       				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
       				
       				if(getOpeningBalRs.next())
       				{
       					this.setSupplierOpeningBalnce(getOpeningBalRs.getFloat(1));
       					this.setOpeingBalanceUpdateDate(getOpeningBalRs.getString(2));
       					this.setOpeingBalancUpdatedBy(getOpeningBalRs.getString(3));
       				}
       				else
       				{
       					this.setSupplierOpeningBalnce(0.0F);
       				}
       				if(getOpeningBalRs != null)
       				{
       					getOpeningBalRs.close();
       					getOpeningBalRs = null;
       				}
       				if(getOpeningBalPSMT != null)
       				{
       					getOpeningBalPSMT.close();
       					getOpeningBalPSMT = null;
       				}
       				
	       			
	       			
	       			sql = "SELECT "
	       					+ "SUM(amount) "
	       					+ "FROM "
	       					+ "crusher_supplier_payment_details_master "
	       					+ "WHERE "
	       					+ "supplier_id = ? "
	       					+ "and "
	       					+ "payment_entry_date < STR_TO_DATE(?, '%d-%m-%Y') "
	       					+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, supplierId);
	       			preparedStatement.setString(2, this.getFromDate());
	       			preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);

	       			resultSet = preparedStatement.executeQuery();
	       			
	       			if(resultSet.next())
	       			{
	       				if(resultSet.getString(1) != null)
	       				{
	       					this.setTotalAmountPaidBeforeDate(resultSet.getFloat(1));
	       				}
	       				else
	       				{
	       					this.setTotalAmountPaidBeforeDate(0.0F);
	       				}
	       			}
	       			else
	       			{
	       				this.setTotalAmountPaidBeforeDate(0.0F);
	       			}
	       			
	       			if(resultSet != null)
	       			{
	       				resultSet.close();
	       				resultSet = null;
	       			}
	       			if(preparedStatement != null)
	       			{
	       				preparedStatement.close();
	       				preparedStatement = null;
	       			}
	       			
	       			
	       			float floatPurchaseAmt = 0.0F;
       				float floatAmtPaid = 0.0F;
       				float floatBalanceAmt = 0.0F;
       				float totalBalanceAmt = 0.0F;
       				float totalAmountPaid = this.getTotalAmountPaidBeforeDate();
       				float totalPurchaseAmountBeforeDate = 0.0F;
       				
       				
       				sql = "SELECT "
       						+ "purchase_total_amount,"
       						+ "purchase_amount_paid "
       						+ "FROM "
       						+ "crusher_purchase_master "
       						+ "WHERE "
	       					+ "supplier_id = ? "
	       					+ "AND "
	       					+ "purchase_date < STR_TO_DATE(?, '%d-%m-%Y') "
	       					+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, supplierId);
	       			preparedStatement.setString(2, this.getFromDate());
	       			preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);

	       			resultSet = preparedStatement.executeQuery();
	       			
	       			while(resultSet.next())
	       			{
	       				
	       				try
	       				{
	       					floatPurchaseAmt = resultSet.getFloat(1);
	       					floatAmtPaid =  resultSet.getFloat(2);
	       				
	       					totalPurchaseAmountBeforeDate = totalPurchaseAmountBeforeDate + floatPurchaseAmt;
	       					
	       					floatBalanceAmt = resultSet.getFloat(1) - resultSet.getFloat(2);
	       					
	       					if(floatBalanceAmt > 0 )
	       					{
	       						totalBalanceAmt = totalBalanceAmt + floatBalanceAmt;
	       						totalAmountPaid = totalAmountPaid + floatAmtPaid;
	       					}
	       					else
	       					{
	       						totalAmountPaid = totalAmountPaid + floatAmtPaid;
	       					}
	       					
	       				}
	       				catch(Exception e)
	       				{
	       					
	       					addActionError("One Of the purchase invoice could not be processed!");
	       				}
	       				
	       			}
	       			if(!hasActionErrors())
	       			{
	       				this.setTotalPurchaseAmountBeforeDate(totalPurchaseAmountBeforeDate);
	       				this.setTotalAmountPaidBeforeDate(totalAmountPaid);
	       				this.setTotalDebtAmountBeforeDate((totalPurchaseAmountBeforeDate-totalAmountPaid));
	       				
       				
	       				if(resultSet != null)
	       				{
	       					resultSet.close();
	       					resultSet = null;
	       				}
	       				
	       				if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
	       				
	       				
	       				sql = "SELECT "
	       						+ "entry_id,"
	       						+ "supplier_id,"
	       						+ "DATE_FORMAT(payment_entry_date, '%d/%m/%Y'),"
	       						+ "amount,"
	       						+ "payment_details,"
	       						+ "entry_by "
	       						+ "FROM "
	       						+ "crusher_supplier_payment_details_master "
	       						+ "WHERE "
	       						+ "supplier_id = ?"
			       				+ "AND "
		       					+ "(payment_entry_date BETWEEN "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y') "
			   					+ "AND "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
			   					+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				
	       				preparedStatement.setString(1, supplierId);
	       				preparedStatement.setString(2, this.getFromDate());
	       				preparedStatement.setString(3, this.getToDate());
	       				preparedStatement.setString(4, crusherId);
						preparedStatement.setString(5, crusherCode);

	       				resultSet = preparedStatement.executeQuery();
	       				
	       				while(resultSet.next())
	       				{
	       					Date date1=new SimpleDateFormat("dd/MM/yyyy").parse(resultSet.getString(3)); 
	    	       			
	       				
	       					SupplierAccountDetailsDAO dao = new SupplierAccountDetailsDAO();
	       					dao.setPaymentPurchaseId(resultSet.getString(1));
	       					dao.setDate(date1);
	       					dao.setAmountPaid(resultSet.getFloat(4));
	       					dao.setComments(resultSet.getString(5));
	       					dao.setEntryBy(resultSet.getString(6));
	       					dao.setBalanceAmount(0.0F);
	       					dao.setPurchaseAmount("0.0");       					
	       					dao.setEntryType("PAYMENT");
	       					this.getSupplierAccountDetailsList().add(dao);
	       				}
	       				

		       			if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
		       			
		       			
	       				sql = "SELECT "
	       						+ "purchase_id,"
	       						+ "purchase_invoice_number,"
	       						+ "DATE_FORMAT(purchase_date,'%d/%m/%Y'),"
	       						+ "tarnsportation_charges,"
	       						+ "other_expenses,"
	       						+ "purchase_total_amount,"
	       						+ "purchase_amount_paid,"
	       						+ "comments,"
	       						+ "purcahsed_by,"
	       						+ "purchase_entry_by,"
	       						+ "entry_type "
	       						+ "FROM "
	       						+ "crusher_purchase_master "
	       						+ "WHERE "
	       						+ "supplier_id = ? "
	       						+ "AND "
		       					+ "(purchase_date BETWEEN "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y') "
			   					+ "AND "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
			   					+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				
	       				preparedStatement.setString(1, supplierId);
	       				preparedStatement.setString(2, this.getFromDate());
	       				preparedStatement.setString(3, this.getToDate());
	       				preparedStatement.setString(4, crusherId);
						preparedStatement.setString(5, crusherCode);
						
						
						
						
	       				resultSet = preparedStatement.executeQuery();
	       				while(resultSet.next())
	       				{
	       					SupplierAccountDetailsDAO dao = new SupplierAccountDetailsDAO();
	       					Date date1=new SimpleDateFormat("dd/MM/yyyy").parse(resultSet.getString(3)); 
    	       				
	       					dao.setEntryType("PURCHASE");
	       					dao.setPaymentPurchaseId(resultSet.getString(1));
							
							  dao.setPuchaseNumber(resultSet.getString(1));
							 dao.setInvoiceNumber(resultSet.getString(2));
	       					dao.setDate(date1);
	       					dao.setPurchaseAmount(resultSet.getString(6));
	       					dao.setAmountPaid(resultSet.getFloat(7));
	       					dao.setBalanceAmount(resultSet.getFloat(6) - resultSet.getFloat(7));
	       					dao.setComments(resultSet.getString(8));
	       					dao.setPurchaseBy(resultSet.getString(9));
	       					dao.setEntryBy(resultSet.getString(10));
	       					dao.setEntryAddedBy(resultSet.getString(11));
	       					
	       					dao.setDebtAmount(0.0F);
	       					this.getSupplierAccountDetailsList().add(dao);
	       					
	       				}
	       				
	       				
	       				for(SupplierAccountDetailsDAO dao : this.getSupplierAccountDetailsList())
	       				{
	       				 DateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy");  
						 Date d = dao.getDate();
						 dao.setDateAsString(dateFormat.format(d));
	       					
	       					try
	       					{
	       						this.setTotalAmountPaidBetweenDates(this.getTotalAmountPaidBetweenDates() + dao.getAmountPaid());
		       					this.setTotalPurchaseAmountBetweenDates(this.getTotalPurchaseAmountBetweenDates() + Float.parseFloat(dao.getPurchaseAmount()));
		       					
	       					}
	       					catch(NumberFormatException nfe)
	       					{
	       						addActionError("Error while nuber formation!");
	       						
	       					}
	       				}
	       				this.setTotalDebtAmountBetweenDates(this.getTotalPurchaseAmountBetweenDates() - this.getTotalAmountPaidBetweenDates());
	       				
	       				this.setTotalAmountPaidAllTheTime(this.getTotalAmountPaidBeforeDate() + this.getTotalAmountPaidBetweenDates());
	       				this.setTotalPurchaseAmountAllTheTime(this.getTotalPurchaseAmountBeforeDate()+ this.getTotalPurchaseAmountBetweenDates());
	       				this.setTotalDebtAmountAllTheTime(this.getTotalDebtAmountBeforeDate() + this.getTotalDebtAmountBetweenDates());
	       				if(!hasActionErrors())
	       				{
	       					

   						 
   						 Collections.sort(this.getSupplierAccountDetailsList(), new Comparator<SupplierAccountDetailsDAO>() {
   							  public int compare(SupplierAccountDetailsDAO o1, SupplierAccountDetailsDAO o2) {
   							      if (o1.getDate() == null || o2.getDate() == null)
   							        return 0;
   							      return o1.getDate().compareTo(o2.getDate());
   							  }
   							});
	       					
   						 
   						 float currentDebtAmount = this.getSupplierOpeningBalnce() + this.getTotalDebtAmountBeforeDate();
   						 
   						this.setTotalDebtAmountAllTheTime(this.getTotalDebtAmountAllTheTime()+this.getSupplierOpeningBalnce());
   						for(SupplierAccountDetailsDAO dao : this.getSupplierAccountDetailsList())
	       				{
   							if(dao.getEntryType().equals("PURCHASE"))
   							{
   								dao.setDebtAmount(currentDebtAmount + dao.getBalanceAmount());
   								
   								currentDebtAmount = currentDebtAmount + dao.getBalanceAmount();
   							}
   							else if(dao.getEntryType().equals("PAYMENT"))
   							{
   								dao.setDebtAmount(currentDebtAmount - dao.getAmountPaid());
   								currentDebtAmount = currentDebtAmount -  dao.getAmountPaid();
   							}
	       				}
	       					
   						
   						
   						for(SupplierAccountDetailsDAO dao : this.getSupplierAccountDetailsList())
	       				{
						 
						  String getProductInfoSQL = "";
						  PreparedStatement getProductInfoPSMT = null;
						  ResultSet getProductInfoRS = null;
						 
						 
						  getProductInfoSQL = "SELECT "
							  		+ "product_name,"
							  		+ "purchase_quantity,"
							  		+ "purchase_rate "
							  		+ "FROM "
							  		+ "crusher_purchase_product_info_master "
							  		+ "WHERE "
							  		+ "purchase_id = ? "
							  		+ "AND "
							  		+ "crusher_id = ? "
							  		+ "AND "
							  		+ "crusher_code = ? ";
						  
						  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
						  
						  getProductInfoPSMT.setString(1, dao.getPuchaseNumber());
						  getProductInfoPSMT.setString(2, crusherId);
						  getProductInfoPSMT.setString(3, crusherCode);
						 
						  
						  getProductInfoRS = getProductInfoPSMT.executeQuery();
					 
						
						  StringBuilder productNames = new StringBuilder();
						  StringBuilder quantities = new StringBuilder();
						  
						  
						  while(getProductInfoRS.next())
						  {
							  
							  String productName = getProductInfoRS.getString(1);
							    float quantity = getProductInfoRS.getFloat(2);

							     boolean found = false;
							    for (Map<String, Object> productInfo : productQuantityList) {
							        if (productInfo.get("productName").equals(productName)) {
							            float existingQuantity = (float) productInfo.get("quantity");
							            productInfo.put("quantity", existingQuantity + quantity);
							            found = true;
							            break;
							        }
							    }

							   if (!found) {
							        Map<String, Object> newProduct = new LinkedHashMap<>();
							        newProduct.put("productName", productName);
							        newProduct.put("quantity", quantity);
							        productQuantityList.add(newProduct);
							    }
							   
							   
							   if (productNames.length() > 0) {
							        productNames.append(" / ");
							        quantities.append(" / ");
							    }
							  
							  productNames.append(getProductInfoRS.getString(1));  
							    quantities.append(getProductInfoRS.getString(2));    

							    dao.setItemNameAll(productNames.toString());  
							    dao.setItemQuantityAll(quantities.toString());
							    
							   
							    
							    
							  dao.setItemRate(getProductInfoRS.getString(3));
							 
							 
							 
						  }
						  
						  
						  
						  
						  
						  
	       				}
						  
   						result = "success";
	       				}
	       				else
	       				{
	       					result = "error";
	       				}
       				
	       			}
	       			else
	       			{
	       				result = "error";
	       			}
       				
       				
       				
	       			
	       		}catch(ParseException pe)
	       		{
	       			result = "error";
	    			addActionError(pe.getMessage() +" || DETAILS NOT FOUND !");
	       		}
	       		catch (SQLException e) {
	       			e.printStackTrace();
	    			result = "error";
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || DETAILS NOT FOUND !");
	    		} catch (Exception e) {
	    			e.printStackTrace();
	    			result = "error";
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || DETAILS NOT FOUND !");
	    		}finally {
	    			if(resultSet != null)
					{
						try {
							resultSet.close();
						} catch (SQLException e) {
							
						}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close();} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close();}catch (SQLException e) {}
	    			}
	    			
	    		}
	       		
	        }
	        
	        return result;
}



public HttpSession getSession() {
	return session;
}



public void setSession(HttpSession session) {
	this.session = session;
}



public String getKey() {
	return key;
}



public void setKey(String key) {
	this.key = key;
}



public String getSupplierName() {
	return supplierName;
}



public void setSupplierName(String supplierName) {
	this.supplierName = supplierName;
}



public String getSupplierMobile() {
	return supplierMobile;
}



public void setSupplierMobile(String supplierMobile) {
	this.supplierMobile = supplierMobile;
}



public String getSupplierAddress() {
	return supplierAddress;
}



public void setSupplierAddress(String supplierAddress) {
	this.supplierAddress = supplierAddress;
}



public Map<String, String> getCustomerSearchOptionList() {
	return customerSearchOptionList;
}



public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
	this.customerSearchOptionList = customerSearchOptionList;
}



public String getCustomerSearchOption() {
	return customerSearchOption;
}



public void setCustomerSearchOption(String customerSearchOption) {
	this.customerSearchOption = customerSearchOption;
}



public String getDefaultValue() {
	return defaultValue;
}



public void setDefaultValue(String defaultValue) {
	this.defaultValue = defaultValue;
}



public String getFromDate() {
	return fromDate;
}



public void setFromDate(String fromDate) {
	this.fromDate = fromDate;
}



public String getToDate() {
	return toDate;
}



public void setToDate(String toDate) {
	this.toDate = toDate;
}

public static long getSerialversionuid() {
	return serialVersionUID;
}



public Float getTotalPurchaseAmountBeforeDate() {
	return totalPurchaseAmountBeforeDate;
}



public void setTotalPurchaseAmountBeforeDate(Float totalPurchaseAmountBeforeDate) {
	this.totalPurchaseAmountBeforeDate = totalPurchaseAmountBeforeDate;
}



public Float getTotalAmountPaidBeforeDate() {
	return totalAmountPaidBeforeDate;
}



public void setTotalAmountPaidBeforeDate(Float totalAmountPaidBeforeDate) {
	this.totalAmountPaidBeforeDate = totalAmountPaidBeforeDate;
}



public Float getTotalDebtAmountBeforeDate() {
	return totalDebtAmountBeforeDate;
}



public void setTotalDebtAmountBeforeDate(Float totalDebtAmountBeforeDate) {
	this.totalDebtAmountBeforeDate = totalDebtAmountBeforeDate;
}



public Float getTotalPurchaseAmountAllTheTime() {
	return totalPurchaseAmountAllTheTime;
}



public void setTotalPurchaseAmountAllTheTime(Float totalPurchaseAmountAllTheTime) {
	this.totalPurchaseAmountAllTheTime = totalPurchaseAmountAllTheTime;
}



public Float getTotalAmountPaidAllTheTime() {
	return totalAmountPaidAllTheTime;
}



public void setTotalAmountPaidAllTheTime(Float totalAmountPaidAllTheTime) {
	this.totalAmountPaidAllTheTime = totalAmountPaidAllTheTime;
}



public Float getTotalDebtAmountAllTheTime() {
	return totalDebtAmountAllTheTime;
}



public void setTotalDebtAmountAllTheTime(Float totalDebtAmountAllTheTime) {
	this.totalDebtAmountAllTheTime = totalDebtAmountAllTheTime;
}



public List<SupplierAccountDetailsDAO> getSupplierAccountDetailsList() {
	return supplierAccountDetailsList;
}



public void setSupplierAccountDetailsList(List<SupplierAccountDetailsDAO> supplierAccountDetailsList) {
	this.supplierAccountDetailsList = supplierAccountDetailsList;
}



public List<SupplierAccountDetailsDAO> getSupplierAccountDetailsSortedList() {
	return supplierAccountDetailsSortedList;
}



public void setSupplierAccountDetailsSortedList(List<SupplierAccountDetailsDAO> supplierAccountDetailsSortedList) {
	this.supplierAccountDetailsSortedList = supplierAccountDetailsSortedList;
}



public Float getSupplierOpeningBalnce() {
	return supplierOpeningBalnce;
}



public void setSupplierOpeningBalnce(Float supplierOpeningBalnce) {
	this.supplierOpeningBalnce = supplierOpeningBalnce;
}



public String getOpeingBalancUpdatedBy() {
	return opeingBalancUpdatedBy;
}



public void setOpeingBalancUpdatedBy(String opeingBalancUpdatedBy) {
	this.opeingBalancUpdatedBy = opeingBalancUpdatedBy;
}



public String getOpeingBalanceUpdateDate() {
	return opeingBalanceUpdateDate;
}



public void setOpeingBalanceUpdateDate(String opeingBalanceUpdateDate) {
	this.opeingBalanceUpdateDate = opeingBalanceUpdateDate;
}



public String getAddSideBarJs() {
	return addSideBarJs;
}



public void setAddSideBarJs(String addSideBarJs) {
	this.addSideBarJs = addSideBarJs;
}



public List<Map<String, Object>> getProductQuantityList() {
	return productQuantityList;
}



public void setProductQuantityList(List<Map<String, Object>> productQuantityList) {
	this.productQuantityList = productQuantityList;
}



public Float getTotalPurchaseAmountBetweenDates() {
	return totalPurchaseAmountBetweenDates;
}



public void setTotalPurchaseAmountBetweenDates(Float totalPurchaseAmountBetweenDates) {
	this.totalPurchaseAmountBetweenDates = totalPurchaseAmountBetweenDates;
}



public Float getTotalAmountPaidBetweenDates() {
	return totalAmountPaidBetweenDates;
}



public void setTotalAmountPaidBetweenDates(Float totalAmountPaidBetweenDates) {
	this.totalAmountPaidBetweenDates = totalAmountPaidBetweenDates;
}



public Float getTotalDebtAmountBetweenDates() {
	return totalDebtAmountBetweenDates;
}



public void setTotalDebtAmountBetweenDates(Float totalDebtAmountBetweenDates) {
	this.totalDebtAmountBetweenDates = totalDebtAmountBetweenDates;
}



	
	
	
}
