package com.stonecrusher.view;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.LaborAccountDetailsDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class ViewLaborAccountDetails extends ActionSupport implements SessionAware{

	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -7753667789346409584L;
	private SessionMap<String,Object> sessionMap;
	
	private HttpSession session;
	private String key;
	private String laborName;
	private String laborMobile;
	private String defaultValue;
	private String fromDate;
	private String toDate;
	
	
	private Float totalSalaryAmountBeforeDate;
	private Float totalSalaryPaidBeforeDate;
	private Float totalUnpaidSalaryAmountBeforeDate;
	private String hiddenKey;
	private Float totalSalaryAmountAllTheTime;
	private Float totalSalaryAmountPaidAllTheTime;
	private Float totalUnpaidAmountAllTheTime;
	
	private List<LaborAccountDetailsDAO> laborAccountDetailsList = new ArrayList<LaborAccountDetailsDAO>();
	private List<LaborAccountDetailsDAO> laborAccountDetailsSortedList = new ArrayList<LaborAccountDetailsDAO>();
	
	private Float laborBalancePending = 0.0F;
	private Float laborBalanceAdvance = 0.0f;
	private Float totalSalaryAmount = 0.0f;
	private Float totalAmount = 0.0f;
	private Float totalAdditionalDeductionAmount = 0.0f;
	private Float totalAdditionalPaymentAmount = 0.0f;

	private String opeingBalancUpdatedBy;
	private String opeingBalanceUpdateDate;
	private String addSideBarJs;
	
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	this.setAddSideBarJs("FALSE");
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	String laborId = EncryptionDecryption.decrypt(getKey());
	        
	        	setKey(EncryptionDecryption.encrypt(laborId));
	        	

	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		
	       		String sql = "";
	       		String db = (String) this.getSessionMap().get("db");
	       		try {
	       			
	       			
	       			
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			
	       			
	       			PreparedStatement getPendingAdvBalPSMT = null;
       				ResultSet getPendingAdvBalRs = null;
       				
       				String getPendingAdvBalSQL = "SELECT "
       						+ "opening_bal_type,"
       						+ "opening_balance_amount "
       						+ "FROM "
       						+ "crusher_employee_salary_details "
       						+ "WHERE "
       						+ "employee_id = ?"
       						+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
							
       				getPendingAdvBalPSMT = connection.prepareStatement(getPendingAdvBalSQL);
       				
       				getPendingAdvBalPSMT.setString(1, laborId);
       				getPendingAdvBalPSMT.setString(2, crusherId);
       				getPendingAdvBalPSMT.setString(3, crusherCode);
    				
       				getPendingAdvBalRs = getPendingAdvBalPSMT.executeQuery();
       				
       				if(getPendingAdvBalRs.next())
       				{
       					if(getPendingAdvBalRs.getString(1).equals("ADVANCE"))
       					{
       						this.setLaborBalanceAdvance(getPendingAdvBalRs.getFloat(2));
       						this.setLaborBalancePending(0.0F);
       					}
       					else
       					{
       						this.setLaborBalanceAdvance(0.0F);
       						this.setLaborBalancePending(getPendingAdvBalRs.getFloat(2));
       					}
       					
       				
       				}
       				else
       				{
       					this.setLaborBalanceAdvance(0.0F);
   						this.setLaborBalancePending(0.0F);
       				}
       				if(getPendingAdvBalRs != null)
       				{
       					getPendingAdvBalRs.close();
       					getPendingAdvBalRs = null;
       				}
       				if(getPendingAdvBalPSMT != null)
       				{
       					getPendingAdvBalPSMT.close();
       					getPendingAdvBalPSMT = null;
       				}
       				
	       			
	       			
	       			sql = "SELECT "
	       					+ "SUM(payment_amount) "
	       					+ "FROM "
	       					+ "crusher_employee_payment_details "
	       					+ "WHERE "
	       					+ "employee_id = ? "
	       					+ "and "
	       					+ "payment_date < STR_TO_DATE(?, '%d-%m-%Y')"
	       					+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, laborId);
	       			preparedStatement.setString(2, this.getFromDate());
	       			preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);
					
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			if(resultSet.next())
	       			{
	       				if(resultSet.getString(1) != null)
	       				{
	       					this.setTotalSalaryPaidBeforeDate(resultSet.getFloat(1));
	       				}
	       				else
	       				{
	       					this.setTotalSalaryPaidBeforeDate(0.0F);
	       				}
	       			}
	       			else
	       			{
	       				this.setTotalSalaryPaidBeforeDate(0.0F);
	       			}
	       			
	       			if(resultSet != null)
	       			{
	       				resultSet.close();
	       				resultSet = null;
	       			}
	       			if(preparedStatement != null)
	       			{
	       				preparedStatement.close();
	       				preparedStatement = null;
	       			}
	       			
	       			
	       			float floatSalaryAmt = 0.0F;
       				
       				float totalSalaryAmountPaid = this.getTotalSalaryPaidBeforeDate();
       				float totalSalaryAmountBeforeDate = 0.0F;
       				
       				
       				sql = "SELECT "
       						+ "total_calculated_salary_amount "
       						+ "FROM "
       						+ "crusher_employee_salary_calculation_details "
       						+ "WHERE "
	       					+ "employee_id = ? "
	       					+ "AND "
	       					+ "salary_to_date < STR_TO_DATE(?, '%d-%m-%Y')"
	       					+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, laborId);
	       			preparedStatement.setString(2, this.getFromDate());
	       			preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);
					
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			while(resultSet.next())
	       			{
	       				
	       				try
	       				{
	       					floatSalaryAmt = resultSet.getFloat(1);
	       					totalSalaryAmountBeforeDate = totalSalaryAmountBeforeDate + floatSalaryAmt;
	       					
	       				}
	       				catch(Exception e)
	       				{
	       					
	       					addActionError(this.getText("message.error.oneOfThePurchaseInvoiceCouldNotProcessed"));
	       				}
	       				
	       			}
	       			if(!hasActionErrors())
	       			{
	       				this.setTotalSalaryAmountBeforeDate(totalSalaryAmountBeforeDate);
	       			
	       				if(resultSet != null)
	       				{
	       					resultSet.close();
	       					resultSet = null;
	       				}
	       				
	       				if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
	       				
	       				
	       				sql = "SELECT "
	       						+ "entry_id,"
	       						+ "employee_id,"
	       						+ "DATE_FORMAT(payment_date, '%d/%m/%Y'),"
	       						+ "payment_amount,"
	       						+ "payment_details "
	       						+ "FROM "
	       						+ "crusher_employee_payment_details "
	       						+ "WHERE "
	       						+ "employee_id = ?"
			       				+ "AND "
		       					+ "(payment_date BETWEEN "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y') "
			   					+ "AND "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y'))"
			   					+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				
	       				preparedStatement.setString(1, laborId);
	       				preparedStatement.setString(2, this.getFromDate());
	       				preparedStatement.setString(3, this.getToDate());
	       				preparedStatement.setString(4, crusherId);
	    				preparedStatement.setString(5, crusherCode);
	    				
	       				resultSet = preparedStatement.executeQuery();
	       				
	       				while(resultSet.next())
	       				{
	       					Date date1=new SimpleDateFormat("dd/MM/yyyy").parse(resultSet.getString(3)); 
	    	       			
	       				
	       					LaborAccountDetailsDAO dao = new LaborAccountDetailsDAO();
	       					dao.setEntryId(resultSet.getString(1));
	       					dao.setDate(resultSet.getString(3));
	       					dao.setEntryDate(date1);
	       					dao.setSalaryAmount(0.0F);
	       					dao.setAmount(resultSet.getFloat(4));
	       			        dao.setAmountType("PAYMENT");
	       					dao.setDueAmount(0.0F);
	       					
	       					dao.setSalaryFromDate("-");
	       					dao.setSalaryToDate("-");
	       					dao.setComments(resultSet.getString(5));
	       					dao.setAdditionalDeductionAmount(0.0f);
	       					dao.setAdditionalPaymentAmount(0.0f);
	       					
	       					dao.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)+"#"+laborId));
	       					
	       					
	       					this.setTotalSalaryAmount(this.getTotalSalaryAmount() + dao.getSalaryAmount());
	       					this.setTotalAmount(this.getTotalAmount() + dao.getAmount());
	       					
	       					
	       					this.getLaborAccountDetailsList().add(dao);
	       					
	       				}
	       				
	       				if(resultSet != null)
	       				{
	       					resultSet.close();
	       					resultSet = null;
	       				}
	       				
	       				if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
	       				
	       				sql = "SELECT "
	       						+ "entry_id,"
	       						+ "DATE_FORMAT(salary_from_date,'%d/%m/%Y'),"
	       						+ "DATE_FORMAT(salary_to_date,'%d/%m/%Y'),"
	       						+ "total_calculated_salary_amount,"
	       						+ "comments,"
	       						+ "additional_deduction_amount,"
	       						+ "additional_payment_amount "
	       						+ "FROM "
	       						+ "crusher_employee_salary_calculation_details "
	       						+ "WHERE "
	       						+ "employee_id = ? "
	       						+ "AND "
		       					+ "(salary_to_date BETWEEN "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y') "
			   					+ "AND "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y'))"
			   					+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				
	       				preparedStatement.setString(1, laborId);
	       				preparedStatement.setString(2, this.getFromDate());
	       				preparedStatement.setString(3, this.getToDate());
	       				preparedStatement.setString(4, crusherId);
	    				preparedStatement.setString(5, crusherCode);
	    				
	       				resultSet = preparedStatement.executeQuery();
	       				while(resultSet.next())
	       				{
	       					Date date1=new SimpleDateFormat("dd/MM/yyyy").parse(resultSet.getString(3)); 
	    	       			
		       				
	       					LaborAccountDetailsDAO dao = new LaborAccountDetailsDAO();
	       					dao.setEntryId(resultSet.getString(1));
	       					dao.setDate(resultSet.getString(2) + " - TO -"+resultSet.getString(3));
	       					dao.setSalaryFromDate(resultSet.getString(2));
	       					dao.setSalaryToDate(resultSet.getString(3));
	       					dao.setEntryDate(date1);
	       					dao.setSalaryAmount(resultSet.getFloat(4));
	       					dao.setAmount(0.0F);	       					
	       		       	    dao.setAmountType("SALARY");
	       					dao.setComments(resultSet.getString(5));
	       					dao.setAdditionalDeductionAmount(resultSet.getFloat(6));
	       					dao.setAdditionalPaymentAmount(resultSet.getFloat(7));
	       					dao.setDueAmount(0.0F);
	       					dao.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)+"#"+laborId));
	       					
	       					this.setTotalSalaryAmount(this.getTotalSalaryAmount() + dao.getSalaryAmount());
	       					this.setTotalAmount(this.getTotalAmount() + dao.getAmount());
	       					this.setTotalAdditionalDeductionAmount(this.getTotalAdditionalDeductionAmount() + dao.getAdditionalDeductionAmount());
	       					this.setTotalAdditionalPaymentAmount(this.getTotalAdditionalPaymentAmount()  + dao.getAdditionalPaymentAmount());
	       					
	       					
	       					this.getLaborAccountDetailsList().add(dao);
	       					
	       				}
	       				
	       				
	       		
	       				if(!hasActionErrors())
	       				{
	       					

   						 
   						 Collections.sort(this.getLaborAccountDetailsList(), new Comparator<LaborAccountDetailsDAO>() {
   							  public int compare(LaborAccountDetailsDAO o1, LaborAccountDetailsDAO o2) {
   							      if (o1.getEntryDate() == null || o2.getEntryDate() == null)
   							        return 0;
   							      return o1.getEntryDate().compareTo(o2.getEntryDate());
   							  }
   							});
   						 
   						
   						 float dueAmountBeforeDates = this.getTotalSalaryAmountBeforeDate() - this.getTotalSalaryPaidBeforeDate();
   						 float currentSalaryAmtDue = 0.0F;
   					
   						this.setTotalUnpaidSalaryAmountBeforeDate(dueAmountBeforeDates);
						if(this.getLaborBalanceAdvance() > 0)
						{
							currentSalaryAmtDue = dueAmountBeforeDates - this.getLaborBalanceAdvance();
						} 
						else if(this.getLaborBalancePending() > 0 )
						{
							currentSalaryAmtDue = dueAmountBeforeDates + this.getLaborBalancePending(); 
						}
						 else
						 {
							currentSalaryAmtDue = dueAmountBeforeDates;
						 }
	   						      
   						for(LaborAccountDetailsDAO dao : this.getLaborAccountDetailsList())
	       				{
   							if(dao.getAmountType().equals("SALARY"))
   							{
   								dao.setDueAmount(currentSalaryAmtDue + dao.getSalaryAmount());
   								
   								currentSalaryAmtDue = currentSalaryAmtDue + dao.getSalaryAmount();
   							}
   							else if(dao.getAmountType().equals("PAYMENT"))
   							{
   								dao.setDueAmount(currentSalaryAmtDue - dao.getAmount());
   								currentSalaryAmtDue = currentSalaryAmtDue -  dao.getAmount();
   							}
	       				}
   						
   						this.setHiddenKey(this.getKey());
	       					
	       					result = SUCCESS;
	       				}
	       				else
	       				{
	       					result = ERROR;
	       				}
       				
	       			}
	       			else
	       			{
	       				result = ERROR;
	       			}
       				
       				
       				
	       			
	       		}catch(ParseException pe)
	       		{
	       			result = "error";
	    			addActionError(pe.getMessage() +" || "+this.getText("message.error.detailsNotFound"));
	       		}
	       		catch (SQLException e) {
	    			result = "error";
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.detailsNotFound"));
	    		} catch (IOException e) {
	    			
	    			result = "error";
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.detailsNotFound"));
	    		}finally {
	    			if(resultSet != null)
					{
						try {
							resultSet.close(); resultSet = null;
						} catch (SQLException e) {
							
						}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection= null;}catch (SQLException e) {}
	    			}
	    			
	    		}
	       		
	        }
	       return result;
}



public HttpSession getSession() {
	return session;
}



public void setSession(HttpSession session) {
	this.session = session;
}



public String getKey() {
	return key;
}



public void setKey(String key) {
	this.key = key;
}





public String getLaborName() {
	return laborName;
}



public void setLaborName(String laborName) {
	this.laborName = laborName;
}



public String getLaborMobile() {
	return laborMobile;
}



public void setLaborMobile(String laborMobile) {
	this.laborMobile = laborMobile;
}



public Float getTotalSalaryAmountBeforeDate() {
	return totalSalaryAmountBeforeDate;
}



public void setTotalSalaryAmountBeforeDate(Float totalSalaryAmountBeforeDate) {
	this.totalSalaryAmountBeforeDate = totalSalaryAmountBeforeDate;
}



public Float getTotalSalaryPaidBeforeDate() {
	return totalSalaryPaidBeforeDate;
}



public void setTotalSalaryPaidBeforeDate(Float totalSalaryPaidBeforeDate) {
	this.totalSalaryPaidBeforeDate = totalSalaryPaidBeforeDate;
}



public Float getTotalUnpaidSalaryAmountBeforeDate() {
	return totalUnpaidSalaryAmountBeforeDate;
}



public void setTotalUnpaidSalaryAmountBeforeDate(Float totalUnpaidSalaryAmountBeforeDate) {
	this.totalUnpaidSalaryAmountBeforeDate = totalUnpaidSalaryAmountBeforeDate;
}



public Float getTotalSalaryAmountAllTheTime() {
	return totalSalaryAmountAllTheTime;
}



public void setTotalSalaryAmountAllTheTime(Float totalSalaryAmountAllTheTime) {
	this.totalSalaryAmountAllTheTime = totalSalaryAmountAllTheTime;
}



public Float getTotalSalaryAmountPaidAllTheTime() {
	return totalSalaryAmountPaidAllTheTime;
}



public void setTotalSalaryAmountPaidAllTheTime(Float totalSalaryAmountPaidAllTheTime) {
	this.totalSalaryAmountPaidAllTheTime = totalSalaryAmountPaidAllTheTime;
}



public Float getTotalUnpaidAmountAllTheTime() {
	return totalUnpaidAmountAllTheTime;
}



public void setTotalUnpaidAmountAllTheTime(Float totalUnpaidAmountAllTheTime) {
	this.totalUnpaidAmountAllTheTime = totalUnpaidAmountAllTheTime;
}



public List<LaborAccountDetailsDAO> getLaborAccountDetailsList() {
	return laborAccountDetailsList;
}



public void setLaborAccountDetailsList(List<LaborAccountDetailsDAO> laborAccountDetailsList) {
	this.laborAccountDetailsList = laborAccountDetailsList;
}



public List<LaborAccountDetailsDAO> getLaborAccountDetailsSortedList() {
	return laborAccountDetailsSortedList;
}



public void setLaborAccountDetailsSortedList(List<LaborAccountDetailsDAO> laborAccountDetailsSortedList) {
	this.laborAccountDetailsSortedList = laborAccountDetailsSortedList;
}



public Float getLaborBalancePending() {
	return laborBalancePending;
}



public void setLaborBalancePending(Float laborBalancePending) {
	this.laborBalancePending = laborBalancePending;
}



public Float getLaborBalanceAdvance() {
	return laborBalanceAdvance;
}



public void setLaborBalanceAdvance(Float laborBalanceAdvance) {
	this.laborBalanceAdvance = laborBalanceAdvance;
}



public String getDefaultValue() {
	return defaultValue;
}



public void setDefaultValue(String defaultValue) {
	this.defaultValue = defaultValue;
}



public String getFromDate() {
	return fromDate;
}



public void setFromDate(String fromDate) {
	this.fromDate = fromDate;
}



public String getToDate() {
	return toDate;
}



public void setToDate(String toDate) {
	this.toDate = toDate;
}

public static long getSerialversionuid() {
	return serialVersionUID;
}



public String getOpeingBalancUpdatedBy() {
	return opeingBalancUpdatedBy;
}



public void setOpeingBalancUpdatedBy(String opeingBalancUpdatedBy) {
	this.opeingBalancUpdatedBy = opeingBalancUpdatedBy;
}



public String getOpeingBalanceUpdateDate() {
	return opeingBalanceUpdateDate;
}



public void setOpeingBalanceUpdateDate(String opeingBalanceUpdateDate) {
	this.opeingBalanceUpdateDate = opeingBalanceUpdateDate;
}
	
public String getHiddenKey() {
	return hiddenKey;
}



public void setHiddenKey(String hiddenKey) {
	this.hiddenKey = hiddenKey;
}



@Override  
public void setSession(Map<String, Object> map) {  
    sessionMap=(SessionMap<String, Object>)map;  
}


public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}



public String getAddSideBarJs() {
	return addSideBarJs;
}



public void setAddSideBarJs(String addSideBarJs) {
	this.addSideBarJs = addSideBarJs;
}



public Float getTotalSalaryAmount() {
	return totalSalaryAmount;
}



public void setTotalSalaryAmount(Float totalSalaryAmount) {
	this.totalSalaryAmount = totalSalaryAmount;
}



public Float getTotalAmount() {
	return totalAmount;
}



public void setTotalAmount(Float totalAmount) {
	this.totalAmount = totalAmount;
}



public Float getTotalAdditionalDeductionAmount() {
	return totalAdditionalDeductionAmount;
}



public void setTotalAdditionalDeductionAmount(Float totalAdditionalDeductionAmount) {
	this.totalAdditionalDeductionAmount = totalAdditionalDeductionAmount;
}



public Float getTotalAdditionalPaymentAmount() {
	return totalAdditionalPaymentAmount;
}



public void setTotalAdditionalPaymentAmount(Float totalAdditionalPaymentAmount) {
	this.totalAdditionalPaymentAmount = totalAdditionalPaymentAmount;
}





	
}
