package com.stonecrusher.view;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BoulderSupplierAccountDetailsDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import java.text.ParseException;

public class ViewBoulderSuppAccountDetails extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3694238914060913156L;

	
	private HttpSession session;
	private String key;
	private String boulderSupplierName;
	private String boulderSupplierMobile;
	private String boulderSupplierAddress;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private String fromDate;
	private String toDate;
	
	
	private Float totalBillAmountBeforeDate;
	private Float totalAmountPaidBeforeDate;
	private Float totalDebtAmountBeforeDate;
	
	private Float totalBillAmountAllTheTime;
	private Float totalAmountPaidAllTheTime;
	private Float totalDebtAmountAllTheTime;
	
	private Float totalBillAmountBetweenDates = 0.0f;
	private Float totalAmountPaidBetweenDates = 0.0f;
	private Float totalDebtAmountBetweenDates = 0.0f;
	
	
	
	private List<BoulderSupplierAccountDetailsDAO> boulderSupplierAccountDetailsList = new ArrayList<BoulderSupplierAccountDetailsDAO>();
	private List<BoulderSupplierAccountDetailsDAO> boulderSupplierAccountDetailsSortedList = new ArrayList<BoulderSupplierAccountDetailsDAO>();
	
	private Float supplierOpeningBalnce = 0.0F;
	private String opeingBalancUpdatedBy;
	private String opeingBalanceUpdateDate;
	private String addSideBarJs;
	private List<Map<String, Object>> productQuantityList = new ArrayList<>();
	
	
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";
	        }  
	        else{
	        	this.setAddSideBarJs("FALSE");
	        	
	        	customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        
	        	String boulderSupplierId = EncryptionDecryption.decrypt(getKey());
	        
	        	setKey(EncryptionDecryption.encrypt(boulderSupplierId));
	        	

	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String crusherId = (String) session.getAttribute("crusherId");
				String crusherCode = (String) session.getAttribute("crusherCode");

	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
	       		
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			
	       			
	       			PreparedStatement getOpeningBalPSMT = null;
       				ResultSet getOpeningBalRs = null;
       				String getOpeningBalSQL = "SELECT "
       						+ "opening_balance,"
       						+ "DATE_FORMAT(opening_balance_date,'%d/%m/%Y'),"
       						+ "update_by "
       						+ "FROM "
       						+ "crusher_boulder_supplier_close_open_bal_master "
       						+ "WHERE "
       						+ "boulder_supplier_id = ? "
       						+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";

       				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
       				
       				getOpeningBalPSMT.setString(1, boulderSupplierId);
       				getOpeningBalPSMT.setString(2, crusherId);
       				getOpeningBalPSMT.setString(3, crusherCode);

       				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
       				
       				if(getOpeningBalRs.next())
       				{
       					this.setSupplierOpeningBalnce(getOpeningBalRs.getFloat(1));
       					this.setOpeingBalanceUpdateDate(getOpeningBalRs.getString(2));
       					this.setOpeingBalancUpdatedBy(getOpeningBalRs.getString(3));
       				}
       				else
       				{
       					this.setSupplierOpeningBalnce(0.0F);
       				}
       				if(getOpeningBalRs != null)
       				{
       					getOpeningBalRs.close();
       					getOpeningBalRs = null;
       				}
       				if(getOpeningBalPSMT != null)
       				{
       					getOpeningBalPSMT.close();
       					getOpeningBalPSMT = null;
       				}
       				
	       			
	       			
	       			sql = "SELECT "
	       					+ "SUM(amount) "
	       					+ "FROM "
	       					+ "crusher_boulder_supplier_payment_master "
	       					+ "WHERE "
	       					+ "boulder_supplier_id = ? "
	       					+ "and "
	       					+ "payment_entry_date < STR_TO_DATE(?, '%d-%m-%Y') "
	       					+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, boulderSupplierId);
	       			preparedStatement.setString(2, this.getFromDate());
	       			preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);

	       			resultSet = preparedStatement.executeQuery();
	       			
	       			if(resultSet.next())
	       			{
	       				if(resultSet.getString(1) != null)
	       				{
	       					this.setTotalAmountPaidBeforeDate(resultSet.getFloat(1));
	       				}
	       				else
	       				{
	       					this.setTotalAmountPaidBeforeDate(0.0F);
	       				}
	       			}
	       			else
	       			{
	       				this.setTotalAmountPaidBeforeDate(0.0F);
	       			}
	       			
	       			if(resultSet != null)
	       			{
	       				resultSet.close();
	       				resultSet = null;
	       			}
	       			if(preparedStatement != null)
	       			{
	       				preparedStatement.close();
	       				preparedStatement = null;
	       			}
	       			
	       			
	       			float floatBillAmt = 0.0F;
       				float floatBalanceAmt = 0.0F;
       				float totalBalanceAmt = 0.0F;
       				float totalAmountPaid = this.getTotalAmountPaidBeforeDate();
       				float totalBillAmountBeforeDate = 0.0F;
       				
       				
       				sql = "SELECT "
       						+ "sum(total_bill_amount) "
       						+ "FROM "
       						+ "boulder_inward_bill_info "
       						+ "WHERE "
	       					+ "boulder_supp_id = ? "
	       					+ "AND "
	       					+ "bill_calculation_to_date < STR_TO_DATE(?, '%d-%m-%Y') "
	       					+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, boulderSupplierId);
	       			preparedStatement.setString(2, this.getFromDate());
	       			preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);

	       			resultSet = preparedStatement.executeQuery();
	       			
	       			while(resultSet.next())
	       			{
	       				
	       				try
	       				{
	       					floatBillAmt = resultSet.getFloat(1);
	       				
	       					totalBillAmountBeforeDate = totalBillAmountBeforeDate + floatBillAmt;
	       					
	       					floatBalanceAmt = resultSet.getFloat(1);
	       					
	       					if(floatBalanceAmt > 0 )
	       					{
	       						totalBalanceAmt = totalBalanceAmt + floatBalanceAmt;
	       						totalAmountPaid = 0.0f;
	       					}
	       					else
	       					{
	       						totalAmountPaid = 0.0f;
	       					}
	       					
	       				}
	       				catch(Exception e)
	       				{
	       					
	       					addActionError("One Of the purchase invoice could not be processed!");
	       				}
	       				
	       			}
	       			if(!hasActionErrors())
	       			{
	       				this.setTotalBillAmountBeforeDate(totalBillAmountBeforeDate);
	       				this.setTotalAmountPaidBeforeDate(totalAmountPaid);
	       				this.setTotalDebtAmountBeforeDate((totalBillAmountBeforeDate-totalAmountPaid));
	       				
       				
	       				if(resultSet != null)
	       				{
	       					resultSet.close();
	       					resultSet = null;
	       				}
	       				
	       				if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
	       				
	       				
	       				sql = "SELECT "
	       						+ "entry_id,"
	       						+ "boulder_supplier_id,"
	       						+ "DATE_FORMAT(payment_entry_date, '%d/%m/%Y'),"
	       						+ "amount,"
	       						+ "payment_details,"
	       						+ "entry_by "
	       						+ "FROM "
	       						+ "crusher_boulder_supplier_payment_master "
	       						+ "WHERE "
	       						+ "boulder_supplier_id = ?"
			       				+ "AND "
		       					+ "(payment_entry_date BETWEEN "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y') "
			   					+ "AND "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
			   					+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				
	       				preparedStatement.setString(1, boulderSupplierId);
	       				preparedStatement.setString(2, this.getFromDate());
	       				preparedStatement.setString(3, this.getToDate());
	       				preparedStatement.setString(4, crusherId);
						preparedStatement.setString(5, crusherCode);

	       				resultSet = preparedStatement.executeQuery();
	       				
	       				while(resultSet.next())
	       				{
	       					Date date1=new SimpleDateFormat("dd/MM/yyyy").parse(resultSet.getString(3)); 
	    	       			
	       				
	       					BoulderSupplierAccountDetailsDAO dao = new BoulderSupplierAccountDetailsDAO();
	       					dao.setSupplierPaymentId(resultSet.getString(1));
	       					dao.setDate(date1);
	       					dao.setAmountPaid(resultSet.getFloat(4));
	       					dao.setComments(resultSet.getString(5));
	       					dao.setEntryBy(resultSet.getString(6));
	       					dao.setBalanceAmount(0.0F);
	       					dao.setBillAmount("0.0");       					
	       					dao.setEntryType("PAYMENT");
	       					this.getBoulderSupplierAccountDetailsList().add(dao);
	       				}
	       				

		       			if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
		       			
		       			
	       				sql = "SELECT "
	       						+ "entry_id,"
	       						+ "DATE_FORMAT(bill_calculation_from_date,'%d/%m/%Y'),"
	       						+ "DATE_FORMAT(bill_calculation_to_date,'%d/%m/%Y'),"
	       						+ "total_bill_amount,"
	       						+ "total_trip_count,"
	       						+ "brass_quantity,"
	       						+ "brass_rate,"
	       						+ "brass_amount,"
	       						+ "mton_quantity,"
	       						+ "mton_rate,"
	       						+ "mton_amount,"
	       						+ "details,"
	       						+ "entry_by "
	       						+ "FROM "
	       						+ "boulder_inward_bill_info "
	       						+ "WHERE "
	       						+ "boulder_supp_id = ? "
	       						+ "AND "
		       					+ "(bill_calculation_to_date BETWEEN "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y') "
			   					+ "AND "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
			   					+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				
	       				preparedStatement.setString(1, boulderSupplierId);
	       				preparedStatement.setString(2, this.getFromDate());
	       				preparedStatement.setString(3, this.getToDate());
	       				preparedStatement.setString(4, crusherId);
						preparedStatement.setString(5, crusherCode);
						
						
						
						
	       				resultSet = preparedStatement.executeQuery();
	       				while(resultSet.next())
	       				{
	       					BoulderSupplierAccountDetailsDAO dao = new BoulderSupplierAccountDetailsDAO();
	       					Date date1=new SimpleDateFormat("dd/MM/yyyy").parse(resultSet.getString(3)); 
    	       				
	       					dao.setDate(date1);
	       					dao.setEntryType("BILL");
	       					dao.setSupplierPaymentId(resultSet.getString(1));
							
	       					dao.setBillNumber(resultSet.getString(1));
	       					dao.setFromDate(resultSet.getString(2));
	       					dao.setToDate(resultSet.getString(3));	       					
	       					dao.setBillAmount(resultSet.getString(4));
	       					dao.setTotalTrips(resultSet.getString(5));
	       					dao.setAmountPaid(0.0f);
	       					dao.setBalanceAmount(resultSet.getFloat(4));
	       					dao.setComments(resultSet.getString(12));
	       					dao.setEntryBy(resultSet.getString(13));
	       					dao.setDebtAmount(0.0F);
	       				
	       					this.getBoulderSupplierAccountDetailsList().add(dao);
	       					
	       				}
	       				
	       				
	       				for(BoulderSupplierAccountDetailsDAO dao : this.getBoulderSupplierAccountDetailsList())
	       				{
		       				 DateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy");  
							 Date d = dao.getDate();
							 dao.setDateAsString(dateFormat.format(d));
		       					
	       					try
	       					{
	       						this.setTotalAmountPaidBetweenDates(this.getTotalAmountPaidBetweenDates() + 0.0f);
		       					this.setTotalBillAmountBetweenDates(this.getTotalBillAmountBetweenDates() + Float.parseFloat(dao.getBillAmount()));
		       					
	       					}
	       					catch(NumberFormatException nfe)
	       					{
	       						addActionError("Error while nuber formation!");
	       						
	       					}
	       				}
	       				this.setTotalDebtAmountBetweenDates(this.getTotalBillAmountBetweenDates() - this.getTotalAmountPaidBetweenDates());
	       				
	       				this.setTotalAmountPaidAllTheTime(this.getTotalAmountPaidBeforeDate() + this.getTotalAmountPaidBetweenDates());
	       				this.setTotalBillAmountAllTheTime(this.getTotalBillAmountBeforeDate()+ this.getTotalBillAmountBetweenDates());
	       				this.setTotalDebtAmountAllTheTime(this.getTotalDebtAmountBeforeDate() + this.getTotalDebtAmountBetweenDates());
	       				if(!hasActionErrors())
	       				{
	       					

   						 
   						 Collections.sort(this.getBoulderSupplierAccountDetailsList(), new Comparator<BoulderSupplierAccountDetailsDAO>() {
   							  public int compare(BoulderSupplierAccountDetailsDAO o1, BoulderSupplierAccountDetailsDAO o2) {
   							      if (o1.getDate() == null || o2.getDate() == null)
   							        return 0;
   							      return o1.getDate().compareTo(o2.getDate());
   							  }
   							});
	       					
   						 
   						 float currentDebtAmount = this.getSupplierOpeningBalnce() + this.getTotalDebtAmountBeforeDate();
   						 
   						this.setTotalDebtAmountAllTheTime(this.getTotalDebtAmountAllTheTime()+this.getSupplierOpeningBalnce());
   						for(BoulderSupplierAccountDetailsDAO dao : this.getBoulderSupplierAccountDetailsList())
	       				{
   							if(dao.getEntryType().equals("BILL"))
   							{
   								dao.setDebtAmount(currentDebtAmount + dao.getBalanceAmount());
   								
   								currentDebtAmount = currentDebtAmount + dao.getBalanceAmount();
   							}
   							else if(dao.getEntryType().equals("PAYMENT"))
   							{
   								dao.setDebtAmount(currentDebtAmount - dao.getAmountPaid());
   								currentDebtAmount = currentDebtAmount -  dao.getAmountPaid();
   							}
	       				}
	       					
   						
   						
						  
   						result = "success";
	       				}
	       				else
	       				{
	       					result = "error";
	       				}
       				
	       			}
	       			else
	       			{
	       				result = "error";
	       			}
       				
       				
       				
	       			
	       		}catch(ParseException pe)
	       		{
	       			result = "error";
	    			addActionError(pe.getMessage() +" || DETAILS NOT FOUND !");
	       		}
	       		catch (SQLException e) {
	       			e.printStackTrace();
	    			result = "error";
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || DETAILS NOT FOUND !");
	    		} catch (Exception e) {
	    			e.printStackTrace();
	    			result = "error";
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || DETAILS NOT FOUND !");
	    		}finally {
	    			if(resultSet != null)
					{
						try {
							resultSet.close();
						} catch (SQLException e) {
							
						}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close();} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close();}catch (SQLException e) {}
	    			}
	    			
	    		}
	       		
	        }
	        
	        return result;
}



public HttpSession getSession() {
	return session;
}



public void setSession(HttpSession session) {
	this.session = session;
}



public String getKey() {
	return key;
}



public void setKey(String key) {
	this.key = key;
}




public String getBoulderSupplierName() {
	return boulderSupplierName;
}



public void setBoulderSupplierName(String boulderSupplierName) {
	this.boulderSupplierName = boulderSupplierName;
}



public String getBoulderSupplierMobile() {
	return boulderSupplierMobile;
}



public void setBoulderSupplierMobile(String boulderSupplierMobile) {
	this.boulderSupplierMobile = boulderSupplierMobile;
}



public String getBoulderSupplierAddress() {
	return boulderSupplierAddress;
}



public void setBoulderSupplierAddress(String boulderSupplierAddress) {
	this.boulderSupplierAddress = boulderSupplierAddress;
}



public Map<String, String> getCustomerSearchOptionList() {
	return customerSearchOptionList;
}



public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
	this.customerSearchOptionList = customerSearchOptionList;
}



public String getCustomerSearchOption() {
	return customerSearchOption;
}



public void setCustomerSearchOption(String customerSearchOption) {
	this.customerSearchOption = customerSearchOption;
}



public String getDefaultValue() {
	return defaultValue;
}



public void setDefaultValue(String defaultValue) {
	this.defaultValue = defaultValue;
}



public String getFromDate() {
	return fromDate;
}



public void setFromDate(String fromDate) {
	this.fromDate = fromDate;
}



public String getToDate() {
	return toDate;
}



public void setToDate(String toDate) {
	this.toDate = toDate;
}

public static long getSerialversionuid() {
	return serialVersionUID;
}





public Float getTotalAmountPaidBeforeDate() {
	return totalAmountPaidBeforeDate;
}



public void setTotalAmountPaidBeforeDate(Float totalAmountPaidBeforeDate) {
	this.totalAmountPaidBeforeDate = totalAmountPaidBeforeDate;
}



public Float getTotalDebtAmountBeforeDate() {
	return totalDebtAmountBeforeDate;
}



public void setTotalDebtAmountBeforeDate(Float totalDebtAmountBeforeDate) {
	this.totalDebtAmountBeforeDate = totalDebtAmountBeforeDate;
}






public Float getTotalAmountPaidAllTheTime() {
	return totalAmountPaidAllTheTime;
}



public void setTotalAmountPaidAllTheTime(Float totalAmountPaidAllTheTime) {
	this.totalAmountPaidAllTheTime = totalAmountPaidAllTheTime;
}



public Float getTotalDebtAmountAllTheTime() {
	return totalDebtAmountAllTheTime;
}



public void setTotalDebtAmountAllTheTime(Float totalDebtAmountAllTheTime) {
	this.totalDebtAmountAllTheTime = totalDebtAmountAllTheTime;
}



public Float getSupplierOpeningBalnce() {
	return supplierOpeningBalnce;
}



public void setSupplierOpeningBalnce(Float supplierOpeningBalnce) {
	this.supplierOpeningBalnce = supplierOpeningBalnce;
}



public String getOpeingBalancUpdatedBy() {
	return opeingBalancUpdatedBy;
}



public void setOpeingBalancUpdatedBy(String opeingBalancUpdatedBy) {
	this.opeingBalancUpdatedBy = opeingBalancUpdatedBy;
}



public String getOpeingBalanceUpdateDate() {
	return opeingBalanceUpdateDate;
}



public void setOpeingBalanceUpdateDate(String opeingBalanceUpdateDate) {
	this.opeingBalanceUpdateDate = opeingBalanceUpdateDate;
}



public String getAddSideBarJs() {
	return addSideBarJs;
}



public void setAddSideBarJs(String addSideBarJs) {
	this.addSideBarJs = addSideBarJs;
}



public List<Map<String, Object>> getProductQuantityList() {
	return productQuantityList;
}



public void setProductQuantityList(List<Map<String, Object>> productQuantityList) {
	this.productQuantityList = productQuantityList;
}





public Float getTotalBillAmountBeforeDate() {
	return totalBillAmountBeforeDate;
}



public void setTotalBillAmountBeforeDate(Float totalBillAmountBeforeDate) {
	this.totalBillAmountBeforeDate = totalBillAmountBeforeDate;
}



public Float getTotalBillAmountAllTheTime() {
	return totalBillAmountAllTheTime;
}



public void setTotalBillAmountAllTheTime(Float totalBillAmountAllTheTime) {
	this.totalBillAmountAllTheTime = totalBillAmountAllTheTime;
}



public Float getTotalBillAmountBetweenDates() {
	return totalBillAmountBetweenDates;
}



public void setTotalBillAmountBetweenDates(Float totalBillAmountBetweenDates) {
	this.totalBillAmountBetweenDates = totalBillAmountBetweenDates;
}



public Float getTotalAmountPaidBetweenDates() {
	return totalAmountPaidBetweenDates;
}



public void setTotalAmountPaidBetweenDates(Float totalAmountPaidBetweenDates) {
	this.totalAmountPaidBetweenDates = totalAmountPaidBetweenDates;
}



public Float getTotalDebtAmountBetweenDates() {
	return totalDebtAmountBetweenDates;
}



public void setTotalDebtAmountBetweenDates(Float totalDebtAmountBetweenDates) {
	this.totalDebtAmountBetweenDates = totalDebtAmountBetweenDates;
}



public List<BoulderSupplierAccountDetailsDAO> getBoulderSupplierAccountDetailsList() {
	return boulderSupplierAccountDetailsList;
}



public void setBoulderSupplierAccountDetailsList(
		List<BoulderSupplierAccountDetailsDAO> boulderSupplierAccountDetailsList) {
	this.boulderSupplierAccountDetailsList = boulderSupplierAccountDetailsList;
}



public List<BoulderSupplierAccountDetailsDAO> getBoulderSupplierAccountDetailsSortedList() {
	return boulderSupplierAccountDetailsSortedList;
}



public void setBoulderSupplierAccountDetailsSortedList(
		List<BoulderSupplierAccountDetailsDAO> boulderSupplierAccountDetailsSortedList) {
	this.boulderSupplierAccountDetailsSortedList = boulderSupplierAccountDetailsSortedList;
}





	
	
	
}
