package com.stonecrusher.utils;




import java.text.NumberFormat;
import java.util.Scanner;

public class NumberToWordsConverter {

public static final String[] units = { "", "One", "Two", "Three", "Four",
"Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve",
"Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen",
"Eighteen", "Nineteen" };

public static final String[] tens = { 
        "",         // 0
        "",     // 1
        "Twenty",   // 2
        "Thirty",   // 3
        "Forty",    // 4
        "Fifty",    // 5
        "Sixty",    // 6
        "Seventy",  // 7
        "Eighty",   // 8
        "Ninety"    // 9
};

public static String convertPaise(final String s)
{
	int n= Integer.parseInt(s);
	
	
	 if (n == 0) {
	        return "Zero";
	    }

	    if (n < 20) {
	        return units[n];
	    }

	  
	        return tens[n / 10] + ((n % 10 != 0) ? " " : "") + units[n % 10];
	    
	
}

public static String convert(final int n) {
    if (n < 0) {
        return "Minus " + convert(-n);
    }

    if (n < 20) {
        return units[n];
    }

    if (n < 100) {
        return tens[n / 10] + ((n % 10 != 0) ? " " : "") + units[n % 10];
    }

    if (n < 1000) {
        return units[n / 100] + " Hundred" + ((n % 100 != 0) ? " " : "") + convert(n % 100);
    }

    if (n < 100000) {
        return convert(n / 1000) + " Thousand" + ((n % 10000 != 0) ? " " : "") + convert(n % 1000);
    }

    if (n < 10000000) {
        return convert(n / 100000) + " Lakh" + ((n % 100000 != 0) ? " " : "") + convert(n % 100000);
    }

    return convert(n / 10000000) + " Crore" + ((n % 10000000 != 0) ? " " : "") + convert(n % 10000000);
}

public static String getConverted(String value) {

    int n;
    
    if(!value.contains("."))
    {
    	value = value + ".0";
    }
    
    Scanner s=new Scanner(value);
    
    String s2 = s.next();  
    String[] values = new String[10];
    try{
    
    	values = s2.split("\\.");
    
    if(values.length == 1)
    {
    	values[0] = value;
    	values[1] = "0";
    }
    
    }catch(Exception e)
    {
    	values[0] = value;
    	values[1] = "0";
    }
    n =Integer.parseInt(values[0]);
    String wordValue = "";
    try
    {
    	wordValue = ("INR "+convert(n) + " and "+convertPaise(values[1])+" Paise Only");
    }catch (Exception e) {
    	wordValue = ("INR "+convert(n) + " and 0 Paise Only");
	}
    s.close();
    return wordValue;
}




public static String getConverted2(String value) {

  
    String wordValue = convert(Integer.parseInt(value)) ;
  
    return wordValue;
}
}