package com.stonecrusher.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

import org.apache.struts2.dispatcher.SessionMap;

public class GetVehicleDetailsById {
	
	
	public static HashMap<String,String> getVehicleDetailsById(String vehicleId, SessionMap<String, Object> sessionMap, Connection connection)
	{
		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");
		
    
		
		HashMap<String,String> vehicleDetailsMap = new HashMap<String,String>();
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
		
		try
		{
			sql = "SELECT "
					+ "vehicle_make,"
					+ "vehicle_registration_number,"
					+ "owner_name,"
					+ "owner_mobile_number,"
					+ "driver_name,"
					+ "driver_mobile_number,"
					+ "brass_quantity "
					+ "FROM "
					+ "crusher_vehicle_details_master "
					+ "WHERE "
					+ "vehicle_id = ? "
					+ "AND "
					+ "crusher_id = ? "
					+ "AND "
					+ "crusher_code = ? ";
			
			
			preparedStatement = connection.prepareStatement(sql);
			preparedStatement.setString(1, vehicleId);
			preparedStatement.setString(2, crusherId);
			preparedStatement.setString(3, crusherCode);
			
			resultSet = preparedStatement.executeQuery();
			
			while(resultSet.next())
			{
				vehicleDetailsMap.put("VEHICLEMAKE", resultSet.getString(1));
				vehicleDetailsMap.put("REGISTRATIONNUMBER", resultSet.getString(2));
				vehicleDetailsMap.put("OWNERNAME", resultSet.getString(3));
				vehicleDetailsMap.put("OWNERMOBILE", resultSet.getString(4));
				vehicleDetailsMap.put("DRIVERNAME", resultSet.getString(5));
				vehicleDetailsMap.put("DRIVERMOBILE", resultSet.getString(6));
				vehicleDetailsMap.put("BRASSQTY", resultSet.getString(7));
			}
			
		}
		catch (SQLException e) 
		{
			e.printStackTrace();
			
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		finally 
		{
			if(resultSet != null)
			{
				try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
			}
			if(preparedStatement != null)
			{
				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
			}
			
			
		}
		
		return vehicleDetailsMap;
		
	}

}
