package com.stonecrusher.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.struts2.dispatcher.SessionMap;

public class GetTaxPercentageByTaxId {
	
	public static Float getTaxPercentageById(String taxId, Connection connection, SessionMap<String, Object> sessionMap)
	{
	PreparedStatement preparedStatement= null;
	ResultSet resultSet = null;
	String crusherId = (String) sessionMap.get("crusherId");
	String crusherCode = (String) sessionMap.get("crusherCode");

	Float taxPercentage = 0.0F;
	
	String sql = "";
	
	try
	{
		sql = "SELECT "
				+ "tax_percentage "
				+ "FROM "
				+ "crusher_tax_table "
				+ "WHERE "
				+ "tax_id = ? "
				+ "AND "
				+ "crusher_id = ? "
				+ "AND "
				+ "crusher_code = ? ";
		
		
		preparedStatement = connection.prepareStatement(sql);
		preparedStatement.setString(1, taxId);
		preparedStatement.setString(2, crusherId);
		preparedStatement.setString(3, crusherCode);

		resultSet = preparedStatement.executeQuery();
		
		while(resultSet.next())
		{
			taxPercentage = resultSet.getFloat(1);
		}
		
	}
	catch (SQLException e) 
	{
		taxPercentage = 0.0f;
		
	}
	catch (Exception e) 
	{
		taxPercentage = 0.0f;
	}
	finally 
	{
		if(resultSet != null)
		{
			try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
		}
		if(preparedStatement != null)
		{
			try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
		}
		
		
	}
	
	return taxPercentage;
	}

	
	
	public static Float getTaxPercentageByIdWithOutSession(String taxId, Connection connection, String crusherId, String crusherCode)
	{
	
		PreparedStatement preparedStatement= null;
	
		ResultSet resultSet = null;
		
		Float taxPercentage = 0.0F;
		
		String sql = "";
		
		try
		{
			sql = "SELECT "
				+ "tax_percentage "
				+ "FROM "
				+ "crusher_tax_table "
				+ "WHERE "
				+ "tax_id = ? "
				+ "AND "
				+ "crusher_id = ? "
				+ "AND "
				+ "crusher_code = ? ";
		
		
		preparedStatement = connection.prepareStatement(sql);
		preparedStatement.setString(1, taxId);
		preparedStatement.setString(2, crusherId);
		preparedStatement.setString(3, crusherCode);

		resultSet = preparedStatement.executeQuery();
		
		while(resultSet.next())
		{
			taxPercentage = resultSet.getFloat(1);
		}
		
	}
	catch (SQLException e) 
	{
		taxPercentage = 0.0f;
		
	}
	catch (Exception e) 
	{
		taxPercentage = 0.0f;
	}
	finally 
	{
		if(resultSet != null)
		{
			try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
		}
		if(preparedStatement != null)
		{
			try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
		}
		
		
	}
	
	return taxPercentage;
	}
}
