package com.stonecrusher.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.db.GetDBConnection;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;

public class GetProductStockByName extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -2236686235982908953L;
	public static String getProductStockByName(String productId, SessionMap<String, Object> sessioMap)
	{
		String productStock = "";
		
		
		Map<String, Object> session = ActionContext.getContext().getSession();
		
		
		
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet  resultSet = null;
		
		String sql = "";
		String db = (String) session.get("db");
	
		String crusherId = (String) session.get("crusherId");
		String crusherCode = (String) session.get("crusherCode");

		try
		{
			
    		
			connection = GetDBConnection.getDBConnection(db);
			sql = "SELECT "
					+ "in_stock_quantity "
					+ "FROM "
					+ "crusher_product_master "
					+ "WHERE "
					+ "product_id = ? "
					+ "AND "
					+ "crusher_id = ? "
					+ "AND "
					+ "crusher_code = ? ";

			
			preparedStatement = connection.prepareStatement(sql);
			
			preparedStatement.setString(1, productId);
			preparedStatement.setString(2, crusherId);
			preparedStatement.setString(3, crusherCode);

			resultSet = preparedStatement.executeQuery();
			
			if(resultSet.next())
			{
				productStock = resultSet.getString(1);
			}
			
		}catch (SQLException e) {
	 		e.printStackTrace();
			productStock = "NA";
	 		
	 	}
		catch (Exception e) {
			productStock = "NA";
		}
		finally
		{
			
			if(resultSet != null)
			{
				try {
					resultSet.close();
					resultSet = null;
				} catch (SQLException e) {
				
				}
			}
			if(preparedStatement != null)
			{
				try {
					preparedStatement.close();
					preparedStatement = null;
				} catch (SQLException e) {
					
				}
			}
			
			if(connection != null)
			{
				try {
					connection.close();
					connection = null;
				} catch (SQLException e) {
					
				}
			}
			
			
		}
		
		
		return productStock;
	}
	
	







}