package com.stonecrusher.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.CustomerPaymentReminderDetailsDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class GetNotificationList extends ActionSupport implements SessionAware{
	
	

	/**
	 * 
	 */
	private static final long serialVersionUID = 8007504384670429244L;
	private SessionMap<String,Object> sessionMap;  
	
	public ArrayList<String> getVehicleNotificationList()
	{
		ArrayList<String> notificationList = new ArrayList<String>();
	
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet  resultSet = null;
		Map<String, Object> session = ActionContext.getContext().getSession();
		String sql = "";
		String db = (String) session.get("db");
		
			try
			{
				String crusherId = (String) session.get("crusherId");
	    		String crusherCode = (String) session.get("crusherCode");
	    		
	    		connection = GetDBConnection.getDBConnection(db);
				
				int numberOfDaysBefore = 10;
				String today = "";
				
				Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	today = dateFormat.format(d);
				
				sql = "SELECT "
						+ "vehicle_make,"
						+ "vehicle_registration_number,"
						+ "DATE_FORMAT(insurance_end_date,'%d-%m-%Y'),"
						+ "DATE_FORMAT(tax_receipt_end_date,'%d-%m-%Y'),"
						+ "DATE_FORMAT(rto_passing_end_date,'%d-%m-%Y'),"
						+ "DATE_FORMAT(puc_passing_end_date,'%d-%m-%Y') "
						+ "FROM "
						+ "crusher_vehicle_details_master "
						+ "WHERE "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? ";
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
				
				while(resultSet.next())
				{
					
					String insuranceEndDate = resultSet.getString(3);
					String taxRecEndDate = resultSet.getString(4);
					String rtoPassingEndDate = resultSet.getString(5);
					String pucPassingEndDate = resultSet.getString(6);
					
					 Date insuranceEDATE = null;
					 Date taxRecEDATE = null;
					 Date rtoPassEDATE = null;
					 Date pucPassEDATE = null;
					 
					if (insuranceEndDate != null && !insuranceEndDate.isEmpty()) {
					   insuranceEDATE = dateFormat.parse(insuranceEndDate);
					   
					}

					if (taxRecEndDate != null && !taxRecEndDate.isEmpty()) {
					    taxRecEDATE = dateFormat.parse(taxRecEndDate);
					   
					}

					if (rtoPassingEndDate != null && !rtoPassingEndDate.isEmpty()) {
					    rtoPassEDATE = dateFormat.parse(rtoPassingEndDate);
					    
					}

					if (pucPassingEndDate != null && !pucPassingEndDate.isEmpty()) {
					    pucPassEDATE = dateFormat.parse(pucPassingEndDate);
					    
					}

					
					int dateDiffInsurance = 0;
					int dateDiffTaxRec = 0;
					int dateDiffRTOPass = 0;
					int dateDiffPUCPass = 0;
					
					long dateDiffInsuranceL = 0;
					long dateDiffTaxRecL = 0;
					long dateDiffRTOPassL = 0;
					long dateDiffPUCPassL = 0;
					
					if (insuranceEDATE != null) {
					    dateDiffInsuranceL = insuranceEDATE.getTime() - d.getTime();
					    dateDiffInsurance = (int) TimeUnit.DAYS.convert(dateDiffInsuranceL, TimeUnit.MILLISECONDS);
					}

					if (taxRecEDATE != null) {
					    dateDiffTaxRecL = taxRecEDATE.getTime() - d.getTime();
					    dateDiffTaxRec = (int) TimeUnit.DAYS.convert(dateDiffTaxRecL, TimeUnit.MILLISECONDS);
					}

					if (rtoPassEDATE != null) {
					    dateDiffRTOPassL = rtoPassEDATE.getTime() - d.getTime();
					    dateDiffRTOPass = (int) TimeUnit.DAYS.convert(dateDiffRTOPassL, TimeUnit.MILLISECONDS);
					}

					if (pucPassEDATE != null) {
						
					    dateDiffPUCPassL = pucPassEDATE.getTime() - d.getTime();
					    dateDiffPUCPass = (int) TimeUnit.DAYS.convert(dateDiffPUCPassL, TimeUnit.MILLISECONDS);
					}

					
				
					if(dateDiffInsurance < numberOfDaysBefore) 
					{
						if(dateDiffInsurance > 0)
						{
						
						notificationList.add("Insurance of Vehicle make "
								+resultSet.getString(1)+" and registration number "+resultSet.getString(2)
								+ " is getting over after "+dateDiffInsurance+" day(s) on "+insuranceEndDate+".");
						}
						else if(dateDiffInsurance < 0)
						{
							notificationList.add("Insurance of Vehicle make "
									+resultSet.getString(1)+" and registration number "+resultSet.getString(2)
									+" is overed! on "+insuranceEndDate+".");
						}
					}
					
					if(dateDiffTaxRec < numberOfDaysBefore)
					{
						if(dateDiffTaxRec > 0)
						{
						notificationList.add("TAX receipt of Vehicle make "
								+resultSet.getString(1)+" and registration number "+resultSet.getString(2)
								+ " is getting over after "+dateDiffTaxRec+" day(s) on "+taxRecEndDate+".");
						}
						
						else if(dateDiffTaxRec < 0)
						{
							notificationList.add("TAX receipt of Vehicle make "
									+resultSet.getString(1)+" and registration number "+resultSet.getString(2)
									+ " is already overed! on "+taxRecEndDate+".");
						}
					}
					
					if(dateDiffRTOPass < numberOfDaysBefore )
					{
						if(dateDiffRTOPass > 0)
						{
						notificationList.add("RTO passing of Vehicle make "
								+resultSet.getString(1)+" and registration number "+resultSet.getString(2)
								+ " is getting over after "+dateDiffRTOPass+" day(s) on "+rtoPassingEndDate+".");
						}else if(dateDiffRTOPass < 0)
						{
							notificationList.add("RTO passing of Vehicle make "
									+resultSet.getString(1)+" and registration number "+resultSet.getString(2)
									+ " is already overed! on "+rtoPassingEndDate+".");
						
						}
					}
					
					
					
					if(dateDiffPUCPass < numberOfDaysBefore )
					{
						if(dateDiffPUCPass > 0)
						{
						notificationList.add("PUC passing of Vehicle make "
								+resultSet.getString(1)+" and registration number "+resultSet.getString(2)
								+ " is getting over after "+dateDiffPUCPass+" day(s) on "+pucPassingEndDate+".");
						}else if(dateDiffPUCPass < 0)
						{
							notificationList.add("PUC passing of Vehicle make "
									+resultSet.getString(1)+" and registration number "+resultSet.getString(2)
									+ " is already overed! on "+pucPassingEndDate+".");
						
						}
					}
					
					
				}
				
			
		
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			
			}catch(Exception e)
			{
				e.printStackTrace();
			}
			finally {
			
			if(resultSet !=null)
			{
				try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
			}
			if(preparedStatement != null)
			{
				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
			}
			if(connection != null)
			{
				
				try {connection.close();
				 connection = null;
				}catch (SQLException e) {}
			}
	
	}
		
		return notificationList;
	}
	
	
	
	
	
	public static ArrayList<CustomerPaymentReminderDetailsDAO> getCustPaymentReminderList(SessionMap<String, Object> sessionMap)
	{
		 ArrayList<CustomerPaymentReminderDetailsDAO> customerPaymentReminderList = new ArrayList<CustomerPaymentReminderDetailsDAO>();


			Connection connection = null;
			PreparedStatement preparedStatement= null;
			ResultSet  resultSet = null;
			String sql = "";
			String db = (String) sessionMap.get("db");

			
    		
    		String crusherId = (String) sessionMap.get("crusherId");
    		String crusherCode = (String) sessionMap.get("crusherCode");
    		
    		
				try
				{
					
				
					connection = GetDBConnection.getDBConnection(db);
					
					int numberOfDaysBefore = 0;
					String today = "";
					
					
					Date d = new Date();
		        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
		        	today = dateFormat.format(d);
		        	
		        	sql = "SELECT "
		        			+ "entry_id,"
		        			+ "DATE_FORMAT(reminder_add_date,'%d-%M-%Y'),"
		        			+ "customer_id,"
		        			+ "customer_name,"
		        			+ "customer_mobile_number,"
		        			+ "outsatnding_amount,"
		        			+ "DATE_FORMAT(payment_promise_date,'%d-%M-%Y'),"
		        			+ "comments,"
		        			+ "status "
		        			+ "FROM "
		        			+ "crusher_customer_payment_reminder_master "
		        			+ "WHERE "
		        			+ "crusher_id = ? "
		        			+ "AND "
		        			+ "crusher_code = ? "
		        			+ "AND "
		        			+ "(payment_promise_date = STR_TO_DATE(?,'%d-%m-%Y') "
		        			+ "OR "
		        			+ "(payment_promise_date < STR_TO_DATE(?,'%d-%m-%Y') AND status = 'NOTIFY')) "
		        			+ "ORDER BY DATE_FORMAT(payment_promise_date,'%d-%M-%Y')";
		        	
		        	preparedStatement = connection.prepareStatement(sql);
		        	
		        	preparedStatement.setString(1, crusherId);
		        	preparedStatement.setString(2, crusherCode);		        	
		        	preparedStatement.setString(3, today);
		        	preparedStatement.setString(4, today);
		        	
		        	resultSet = preparedStatement.executeQuery();
		        	
		        	while(resultSet.next())
		        	{
		        		CustomerPaymentReminderDetailsDAO dao = new CustomerPaymentReminderDetailsDAO();
		        		
		        		dao.setEntryId(resultSet.getString(1));
		        		dao.setPaymentReminderAddDate(resultSet.getString(2));
		        		dao.setCustomerId(resultSet.getString(3));
		        		dao.setCustomerName(resultSet.getString(4));
		        		dao.setCustomerMobileNumber(resultSet.getString(5));
		        		dao.setOutstandingAmount(resultSet.getFloat(6));
		        		dao.setPaymentPromiseDate(resultSet.getString(7));
		        		dao.setComments(resultSet.getString(8));
		        		dao.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)+"#"+resultSet.getString(3)+"#"+resultSet.getString(7)));
		        		customerPaymentReminderList.add(dao);
		        	}
		        			
					
					
				}catch (SQLException e)
				{
					e.printStackTrace();
				
				}catch(Exception e)
				{
					e.printStackTrace();
				}
				finally {
				
				if(resultSet !=null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close();
					 connection = null;
					}catch (SQLException e) {}
				}
		
		}
		 
		 
		 return customerPaymentReminderList;
	}
	
	
	
	
	
	
	
	
	
	
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


}