package com.stonecrusher.utils;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import org.apache.struts2.dispatcher.SessionMap;

import com.stonecrusher.db.GetDBConnection;

public class GetCustomerTotalCreditAmountById {
	
	public static Float getCustomerTotalCreditAmountById(String custId, SessionMap<String, Object> sessionMap)
	{
		Float totalCreditAmount = 0.0F;
		

    	Connection connection = null;
   		PreparedStatement preparedStatement= null;
   		ResultSet resultSet = null;
   		
   		String sql = "";
   		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");

   		String db = (String) sessionMap.get("db");
   		try {
   			
   		
			connection = GetDBConnection.getDBConnection(db);
   			
   			Float openingBalance = 0.0F;
   			PreparedStatement getOpeningBalPSMT = null;
				ResultSet getOpeningBalRs = null;
				String getOpeningBalSQL = "SELECT "
						+ "opening_balance "
						+ "FROM "
						+ "crusher_cust_close_open_bal_master "
						+ "WHERE "
						+ "customer_id = ? " 
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? ";

				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
				
				getOpeningBalPSMT.setString(1, custId);
				getOpeningBalPSMT.setString(2, crusherId);
				getOpeningBalPSMT.setString(3, crusherCode);

				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
				
				if(getOpeningBalRs.next())
				{
					openingBalance = getOpeningBalRs.getFloat(1);
				}
				else
				{
					openingBalance = 0.0F;
				}
   			
				
				if(getOpeningBalRs != null)
   				{
   					getOpeningBalRs.close();
   					getOpeningBalRs = null;
   				}
   				if(getOpeningBalPSMT != null)
   				{
   					getOpeningBalPSMT.close();
   					getOpeningBalPSMT = null;
   				}

   				float floatTotalAmt = 0.0F;
   				float floatAmtReceived = 0.0F;
   				float floatBalanceAmt = 0.0F;
   				float totalBalanceAmt = 0.0F;
   				float totalPaymentDone = 0.0F;
   				
   				sql = "SELECT "	           					
       					+ "bill_total_amount,"
       					+ "bill_amount_received,"
       					+ "bill_amount_return "
       					+ "FROM "
       					+ "crusher_bill_info_master "
       					+ "WHERE "		           					
       					+ "customer_id = ? "
       					+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? ";
       				
   				
   				
   				preparedStatement = connection.prepareStatement(sql);
   				
   				preparedStatement.setString(1, custId);
   				preparedStatement.setString(2, crusherId);
				preparedStatement.setString(3, crusherCode);
				
		
   				ResultSet resultSetBillInfo = preparedStatement.executeQuery();
   				
   				while(resultSetBillInfo.next())
   				{
   					try
   					{
       					floatTotalAmt = Float.parseFloat(resultSetBillInfo.getString(1));
           				floatAmtReceived = Float.parseFloat(resultSetBillInfo.getString(2));
           				floatBalanceAmt = floatTotalAmt - floatAmtReceived;
           				
           				if(floatBalanceAmt > 0)
           				{
           					totalBalanceAmt = totalBalanceAmt+floatBalanceAmt; 	           					
           				}
           				
   					}catch(NumberFormatException nfe)
   					{
   					}
   				}
   				
   				
   				
   				if(resultSetBillInfo != null)
   				{
   					resultSetBillInfo.close();
   					resultSetBillInfo = null;
   					
   				}
   				
   				if(preparedStatement != null)
   				{
   					preparedStatement.close();
   					preparedStatement = null;
   				}
   				
   				
   				
   				sql = "SELECT "	           					
       					+ "bill_total_amount,"
       					+ "bill_amount_received,"
       					+ "amount_return "
       					+ "FROM "
       					+ "crusher_rmc_billinfo "
       					+ "WHERE "		           					
       					+ "customer_id = '"+custId+"' "
       					+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? ";
       				
   				
   				
   				preparedStatement = connection.prepareStatement(sql);
   				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);

   				 resultSetBillInfo = preparedStatement.executeQuery();
   				
   				while(resultSetBillInfo.next())
   				{
   					try
   					{
       					floatTotalAmt = Float.parseFloat(resultSetBillInfo.getString(1));
           				floatAmtReceived = Float.parseFloat(resultSetBillInfo.getString(2));
           				floatBalanceAmt = floatTotalAmt - floatAmtReceived;
           				
           				if(floatBalanceAmt > 0)
           				{
           					totalBalanceAmt = totalBalanceAmt+floatBalanceAmt; 	           					
           				}
           				
   					}catch(NumberFormatException nfe)
   					{
   					}
   				}
   				
   				
   				
   				
   				sql = "select "
   						+ "sum(amount) "
   						+ "from "
   						+ "crusher_customer_payment_details_master "
   						+ "where "
   						+ "customer_id = '"+custId+"' "
   						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? ";
   			
   				preparedStatement = connection.prepareStatement(sql);
   				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);

   				ResultSet resultSetTotalPayment = preparedStatement.executeQuery();
   				
   				resultSetTotalPayment.last();
   				int rowCount2 = resultSetTotalPayment.getRow();
   				resultSetTotalPayment.beforeFirst();
   				
   				if(rowCount2>0)
   				{
   				
       				while(resultSetTotalPayment.next())
       				{
       					try
       					{
       						if(resultSetTotalPayment.getString(1) != null)
       						{		       						
       							totalPaymentDone = resultSetTotalPayment.getFloat(1);
       						}
       					}
       					catch(NumberFormatException nfe)
       					{
       					}
       				}
       						
       				
       				totalBalanceAmt = (openingBalance + totalBalanceAmt) - totalPaymentDone;
       				totalCreditAmount = totalBalanceAmt;
   				}
   				
   				
   				if(resultSetTotalPayment != null)
   				{
   					resultSetTotalPayment.close();
   					resultSetTotalPayment = null;
   				}
   		} catch (SQLException e) {
			//e.printStackTrace();
				
		
		} catch (Exception e) {
			//e.printStackTrace();
			
		}	
			finally
			{
				if(resultSet != null)
				{
					try{resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					try {connection.close(); connection = null;} catch (SQLException e) {}
				}
				
			}
		
		return totalCreditAmount;
	}

}
