package com.stonecrusher.utils;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;

import org.apache.struts2.dispatcher.SessionMap;

import com.stonecrusher.db.GetDBConnection;

public class GetAccountListForDrCr {
	
	public static LinkedHashMap<String,String> getAccountList(SessionMap<String, Object> sessionMap)
	{
		LinkedHashMap<String,String> accountList = new LinkedHashMap<String,String>();
		
		
		Connection connection = null;
   		PreparedStatement preparedStatement= null;
   		ResultSet resultSet = null;
   		
   		
   		String sql = "";
   		String db = (String) sessionMap.get("db");
   		
   		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");
		
		
   	try {
   			
   		
			connection = GetDBConnection.getDBConnection(db);
   			
   			sql = "SELECT "
   					+ "account_id,"
   					+ "account_number,"
   					+ "account_holder_name "
   					+ "FROM "
   					+ "crusher_bank_account "
   					+ "WHERE "
					+ "crusher_id = ? "
					+ "AND "
					+ "crusher_code = ?";
   			
   			preparedStatement = connection.prepareStatement(sql);
   			preparedStatement.setString(1, crusherId);
			preparedStatement.setString(2, crusherCode);
			
			
   			resultSet = preparedStatement.executeQuery();
   			accountList.put("", "--- SELECT ACCOUNT ---");
   			while(resultSet.next())
   			{
   				accountList.put(resultSet.getString(1), resultSet.getString(2)+"-"+resultSet.getString(3));
   			}
   			
   			
   		
		} catch (SQLException e) {
		//e.printStackTrace();
			
	} catch (IOException e) {
		
	}finally {
		if(resultSet != null)
		{
			try {
				resultSet.close(); resultSet = null;
			} catch (SQLException e) {
				
			}
		}
		if(preparedStatement != null)
		{
			try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
		}
		if(connection != null)
		{
			
			try {connection.close(); connection = null;}catch (SQLException e) {}
		}
		
	}
		return accountList;
	}

}
