package com.stonecrusher.update;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class WeightScaleUpdateSettings extends ActionSupport
		implements SessionAware, ServletResponseAware, ServletRequestAware {

	/**
	 * 
	 */
	private static final long serialVersionUID = -4017216362311328126L;
	private HttpSession session;
	private SessionMap<String, Object> sessionMap;
	private Map<String, String> WeightScaleOnlineList = new HashMap<String, String>();

	private Map<String, String> AutoZeroList = new HashMap<String, String>();

	private Map<String, String> BitsPerSecondList = new HashMap<String, String>();
	private Map<String, String> DataBitsList = new HashMap<String, String>();
	private Map<String, String> ParityList = new HashMap<String, String>();
	private Map<String, String> StopBitsList = new HashMap<String, String>();
	private Map<String, String> FlowControlList = new HashMap<String, String>();

	private String WeightScaleOnlineDefault;
	private String AutoZeroDefault;

	private String BitsPerSecondDefault;
	private String DataBitsDefault;
	private String ParityDefault;
	private String StopBitsDefault;
	private String FlowControlDefault;

	private HttpServletRequest request = null;
	private HttpServletResponse response = null;
	private String addSideBarJs;
	
	public String execute() throws IOException {

		String result = "login";
		session = ServletActionContext.getRequest().getSession(false);

		if (session == null || session.getAttribute("login") == null) {
			addActionMessage(this.getText("message.error.plzloginfirst"));
			result = "login";
		} else {

			

			
				Connection connection = null;
				PreparedStatement preparedStatement = null;
				ResultSet resultSet = null;

				String sql = "";
				String db = (String) this.getSessionMap().get("db");

				try {
					connection = GetDBConnection.getDBConnection(db);
					connection.setAutoCommit(false);

					 String crusherId = (String) this.getSessionMap().get("crusherId");
					 String crusherCode = (String) this.getSessionMap().get("crusherCode");

					 String checkSql = "SELECT COUNT(*) FROM crusher_settings_master WHERE name = ? AND crusher_id = ? AND crusher_code = ?";
		  	            String updateSql = "UPDATE crusher_settings_master SET value = ? WHERE name = ? AND crusher_id = ? AND crusher_code = ?";
		  	            String insertSql = "INSERT INTO crusher_settings_master (name, value, crusher_id, crusher_code) VALUES (?, ?, ?, ?)";

		  	            Map<String, String> updateNameValueMap = new HashMap<>();
		  	           updateNameValueMap.put("weight_scale_online", this.getWeightScaleOnlineDefault());
						updateNameValueMap.put("auto_zero_mode", this.getAutoZeroDefault());
						updateNameValueMap.put("bits_per_second", this.getBitsPerSecondDefault());
						updateNameValueMap.put("data_bits", this.getDataBitsDefault());
						updateNameValueMap.put("parity", this.getParityDefault());
						updateNameValueMap.put("stop_bits", this.getStopBitsDefault());
						updateNameValueMap.put("flow_control", this.getFlowControlDefault());

		  	            preparedStatement = connection.prepareStatement(checkSql);

		  	            for (String name : updateNameValueMap.keySet()) {
		  	                
		  	                preparedStatement.setString(1, name);
		  	                preparedStatement.setString(2, crusherId);
		  	                preparedStatement.setString(3, crusherCode);

		  	                resultSet = preparedStatement.executeQuery();
		  	                boolean exists = false;
		  	                if (resultSet.next()) {
		  	                    exists = resultSet.getInt(1) > 0;
		  	                }

		  	                if (resultSet != null) {
		  	                    try {
		  	                        resultSet.close();
		  	                    } catch (SQLException e) {
		  	                        e.printStackTrace();
		  	                    }
		  	                    resultSet = null;
		  	                }

		  	               
		  	                if (exists) {
		  	                    try (PreparedStatement updateStmt = connection.prepareStatement(updateSql)) {
		  	                        updateStmt.setString(1, updateNameValueMap.get(name));
		  	                        updateStmt.setString(2, name);
		  	                        updateStmt.setString(3, crusherId);
		  	                        updateStmt.setString(4, crusherCode);
		  	                        updateStmt.executeUpdate();
		  	                    }
		  	                } else {
		  	                    try (PreparedStatement insertStmt = connection.prepareStatement(insertSql)) {
		  	                        insertStmt.setString(1, name);
		  	                        insertStmt.setString(2, updateNameValueMap.get(name));
		  	                        insertStmt.setString(3, crusherId);
		  	                        insertStmt.setString(4, crusherCode);
		  	                        insertStmt.executeUpdate();
		  	                    }
		  	                }
		  	            }
							
					
						connection.commit();
						
						this.getSessionMap().replace("weight_scale_online", this.getWeightScaleOnlineDefault());
						this.getSessionMap().replace("auto_zero_mode", this.getAutoZeroDefault());
						this.getSessionMap().replace("bits_per_second", this.getBitsPerSecondDefault());
						this.getSessionMap().replace("data_bits", this.getDataBitsDefault());
						this.getSessionMap().replace("parity", this.getParityDefault());
						this.getSessionMap().replace("stop_bits", this.getStopBitsDefault());
						this.getSessionMap().replace("flow_control", this.getFlowControlDefault());

						
						result = "success";
						addActionMessage(this.getText("message.success.weightscaleUpdatedSuccessfully"));
					

				} catch (SQLException e) {
					try {
						connection.rollback();
					} catch (SQLException e1) {
						// TODO Auto-generated catch block
						// e1.printStackTrace();
					}

					result = "error";

					addActionError(e.getErrorCode() + " || " + e.getMessage() + " ||1 "
							+ this.getText("message.error.cannotLoadPage"));
				} finally {
					if (resultSet != null) {
						try {
							resultSet.close();
							resultSet = null;
						} catch (SQLException e) {
						}
					}
					if (preparedStatement != null) {
						try {
							preparedStatement.close();
							preparedStatement = null;
						} catch (SQLException e) {
						}
					}
					if (connection != null) {

						try {
							connection.close();
							connection = null;
						} catch (SQLException e) {
						}
					}
				}
			
		}

		return result;
	}

	@Override
	public void validate() {
		
		this.setAddSideBarJs("FALSE");
		 
		this.getWeightScaleOnlineList().put("TRUE", "ON");
		this.getWeightScaleOnlineList().put("FALSE", "OFF");

		this.getAutoZeroList().put("TRUE", "ON");
		this.getAutoZeroList().put("FALSE", "OFF");

		this.getBitsPerSecondList().put("110", "110");
		this.getBitsPerSecondList().put("300", "300");
		this.getBitsPerSecondList().put("600", "600");
		this.getBitsPerSecondList().put("1200", "1200");
		this.getBitsPerSecondList().put("2400", "2400");
		this.getBitsPerSecondList().put("4800", "4800");
		this.getBitsPerSecondList().put("9600", "9600");
		this.getBitsPerSecondList().put("14400", "14400");
		this.getBitsPerSecondList().put("19200", "19200");
		this.getBitsPerSecondList().put("38400", "38400");
		this.getBitsPerSecondList().put("57600", "57600");
		this.getBitsPerSecondList().put("115200", "115200");
		this.getBitsPerSecondList().put("128000", "128000");
		this.getBitsPerSecondList().put("256000", "256000");

		this.getDataBitsList().put("5", "5");
		this.getDataBitsList().put("6", "6");
		this.getDataBitsList().put("7", "7");
		this.getDataBitsList().put("8", "8");

		this.getParityList().put("None", "None");
		this.getParityList().put("Even", "Even");
		this.getParityList().put("Odd", "Odd");
		this.getParityList().put("Mark", "Mark");
		this.getParityList().put("Space", "Space");

		this.getStopBitsList().put("1", "1");
		this.getStopBitsList().put("1.5", "1.5");
		this.getStopBitsList().put("2", "2");

		this.getFlowControlList().put("None", "None");
		this.getFlowControlList().put("XON/XOFF", "XON/XOFF");
		this.getFlowControlList().put("RTS/CTS", "RTS/CTS");
		this.getFlowControlList().put("DTR/DSR", "DTR/DSR");

	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public void setSession(Map<String, Object> map) {
		// TODO Auto-generated method stub
		sessionMap = (SessionMap<String, Object>) map;

	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public HttpServletRequest getRequest() {
		return request;
	}

	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}

	public HttpServletResponse getResponse() {
		return response;
	}

	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}

	@Override
	public void setServletRequest(HttpServletRequest arg0) {
		// TODO Auto-generated method stub
		this.request = arg0;
	}

	@Override
	public void setServletResponse(HttpServletResponse arg0) {
		// TODO Auto-generated method stub
		this.response = arg0;
	}

	public Map<String, String> getWeightScaleOnlineList() {
		return WeightScaleOnlineList;
	}

	public void setWeightScaleOnlineList(Map<String, String> weightScaleOnlineList) {
		WeightScaleOnlineList = weightScaleOnlineList;
	}

	public String getWeightScaleOnlineDefault() {
		return WeightScaleOnlineDefault;
	}

	public void setWeightScaleOnlineDefault(String weightScaleOnlineDefault) {
		WeightScaleOnlineDefault = weightScaleOnlineDefault;
	}

	public Map<String, String> getAutoZeroList() {
		return AutoZeroList;
	}

	public void setAutoZeroList(Map<String, String> autoZeroList) {
		AutoZeroList = autoZeroList;
	}

	public String getAutoZeroDefault() {
		return AutoZeroDefault;
	}

	public void setAutoZeroDefault(String autoZeroDefault) {
		AutoZeroDefault = autoZeroDefault;
	}

	public Map<String, String> getBitsPerSecondList() {
		return BitsPerSecondList;
	}

	public void setBitsPerSecondList(Map<String, String> bitsPerSecondList) {
		BitsPerSecondList = bitsPerSecondList;
	}

	public Map<String, String> getDataBitsList() {
		return DataBitsList;
	}

	public void setDataBitsList(Map<String, String> dataBitsList) {
		DataBitsList = dataBitsList;
	}

	public Map<String, String> getParityList() {
		return ParityList;
	}

	public void setParityList(Map<String, String> parityList) {
		ParityList = parityList;
	}

	public Map<String, String> getStopBitsList() {
		return StopBitsList;
	}

	public void setStopBitsList(Map<String, String> stopBitsList) {
		StopBitsList = stopBitsList;
	}

	public Map<String, String> getFlowControlList() {
		return FlowControlList;
	}

	public void setFlowControlList(Map<String, String> flowControlList) {
		FlowControlList = flowControlList;
	}

	public String getBitsPerSecondDefault() {
		return BitsPerSecondDefault;
	}

	public void setBitsPerSecondDefault(String bitsPerSecondDefault) {
		BitsPerSecondDefault = bitsPerSecondDefault;
	}

	public String getDataBitsDefault() {
		return DataBitsDefault;
	}

	public void setDataBitsDefault(String dataBitsDefault) {
		DataBitsDefault = dataBitsDefault;
	}

	public String getParityDefault() {
		return ParityDefault;
	}

	public void setParityDefault(String parityDefault) {
		ParityDefault = parityDefault;
	}

	public String getStopBitsDefault() {
		return StopBitsDefault;
	}

	public void setStopBitsDefault(String stopBitsDefault) {
		StopBitsDefault = stopBitsDefault;
	}

	public String getFlowControlDefault() {
		return FlowControlDefault;
	}

	public void setFlowControlDefault(String flowControlDefault) {
		FlowControlDefault = flowControlDefault;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

}
