package com.stonecrusher.update;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;

public class UpdateVehicleTripEntry extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 420906561236446707L;
	private HttpSession session;
	private String key;
	
	private String tripDate;
	private String vehicleId;
	private String customerName;
	private String materialName;
	private Float materialVolume;
	private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private String tripFrom;
	private String tripTo;
	private Integer totalTrips;
	private Float transportationCharges;
	private String billNo;
	

	private Map<String,String> vehicleList = new HashMap<String,String>();
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String tripId  = "";
	        	try 
	        	{
					
	        		tripId = EncryptionDecryption.decrypt(URLDecoder.decode(this.getKey(),"UTF-8"));
				} catch (UnsupportedEncodingException e1) {
					addActionError(this.getText("message.error.errorWhiledecryptionTheKey")+e1.getMessage());
				}
	        	if(!hasActionErrors())
	        	{
	        		String crusherId = (String) session.getAttribute("crusherId");
	    			String crusherCode = (String) session.getAttribute("crusherCode");
	
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		String user = (String) session.getAttribute("userFullName");
				String shortName = "";
	       		
	       		String [] customerDetails = new String[5];
				String customerId = "";
				String customerName = "";
				
				try
				{
					customerDetails = this.getCustomerName().split("-");
					customerId = customerDetails[0];
					customerName = customerDetails[1];
					
				}catch(Exception e)
				{
					
					result = "error";
					addActionError(this.getText("message.error.plzProvideCorrectCustomerIdAndName"));
				}
				
				try
				{
					shortName = user.split(" ")[0];
				}catch(Exception e)
				{
					shortName = user;
				}
				
				
				if(!hasActionErrors())
				{
					
				
	       		try {
	       			
	       			connection = GetDBConnection.getDBConnection(db);
	       			
	       			
	       			if(!this.getBillNo().equals("0"))
	       			{
	       				sql = "UPDATE "
		       					+ "crusher_vehicle_trip_master "
		       					+ "SET "
		       					+ "trip_date = STR_TO_DATE(?,'%d-%m-%Y'),"
		       					+ "vehicle_id = ?,"
		    					+ "customer_id = ?,"
		    					+ "customer_name = ?,"
		    					+ "product_name = ?,"
		    					+ "product_quantity = ?,"
		    					+ "vehicle_km_start = ?,"
		    					+ "vehicle_km_end = ?,"
		    					+ "trip_total_km = ?,"
		    					+ "trip_start_from = ?,"
		    					+ "trip_end_to = ?,"
		    					+ "total_trip_count = ?,"
		    					+ "transportation_charges = ? "
		    					+ "WHERE "
		       					+ "trip_entry_id = ? "
		       					+ "AND "
		       					+ "bill_number = ? "
		       					+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
	       				
	       				
	       				preparedStatement = connection.prepareStatement(sql);
		       			
		       			preparedStatement.setString(1, this.getTripDate());
		       			preparedStatement.setString(2, this.getVehicleId());
		       			preparedStatement.setString(3, customerId);
		       			preparedStatement.setString(4, customerName);
		       			preparedStatement.setString(5, this.getMaterialName());
		       			preparedStatement.setFloat(6, this.getMaterialVolume());
		       			preparedStatement.setFloat(7, this.getKmStart());
		       			preparedStatement.setFloat(8, this.getKmEnd());
		       			preparedStatement.setFloat(9, this.getTotalKm());
		       			preparedStatement.setString(10, this.getTripFrom());
		       			preparedStatement.setString(11, this.getTripTo());
		       			preparedStatement.setInt(12, this.getTotalTrips());
		       			preparedStatement.setFloat(13, this.getTransportationCharges());
		       			preparedStatement.setString(14, tripId);
		       			preparedStatement.setString(15, this.getBillNo());
		       			preparedStatement.setString(16, crusherId);
						preparedStatement.setString(17, crusherCode);
		       			
						
						
	       			}else {
	       				sql = "UPDATE "
		       					+ "crusher_vehicle_trip_other_master "
		       					+ "SET "
		       					+ "trip_date = STR_TO_DATE(?,'%d-%m-%Y'),"
		       					+ "vehicle_id = ?,"
		    					+ "customer_id = ?,"
		    					+ "customer_name = ?,"
		    					+ "product_name = ?,"
		    					+ "product_quantity = ?,"
		    					+ "vehicle_km_start = ?,"
		    					+ "vehicle_km_end = ?,"
		    					+ "trip_total_km = ?,"
		    					+ "trip_start_from = ?,"
		    					+ "trip_end_to = ?,"
		    					+ "total_trip_count = ?,"
		    					+ "transportation_charges = ? "
		    					+ "WHERE " 
		       					+ "trip_entry_id = ? "
		       					+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
		       					
	       			
	       			
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			
	       			preparedStatement.setString(1, this.getTripDate());
	       			preparedStatement.setString(2, this.getVehicleId());
	       			preparedStatement.setString(3, customerId);
	       			preparedStatement.setString(4, customerName);
	       			preparedStatement.setString(5, this.getMaterialName());
	       			preparedStatement.setFloat(6, this.getMaterialVolume());
	       			preparedStatement.setFloat(7, this.getKmStart());
	       			preparedStatement.setFloat(8, this.getKmEnd());
	       			preparedStatement.setFloat(9, this.getTotalKm());
	       			preparedStatement.setString(10, this.getTripFrom());
	       			preparedStatement.setString(11, this.getTripTo());
	       			preparedStatement.setInt(12, this.getTotalTrips());
	       			preparedStatement.setFloat(13, this.getTransportationCharges());
	       			preparedStatement.setString(14, tripId);
	       			preparedStatement.setString(15, crusherId);
					preparedStatement.setString(16, crusherCode);
	       			
	       			}

	       			if(!this.getBillNo().equals("0"))
	       			{
	       			preparedStatement.setString(15, this.getBillNo());
	       			}
	       			
	       			int rowCountUpdated = preparedStatement.executeUpdate();
	       			
	       			if(rowCountUpdated>0)
	       			{
	       				
	       				this.setVehicleId("");
	       				this.setCustomerName("");
	       				this.setMaterialName("");
	       				this.setMaterialVolume(0.0F);
	       				this.setKmStart(0.0F);
	       				this.setKmEnd(0.0F);
	       				this.setTotalKm(0.0F);
	       				this.setTripFrom("");
	       				this.setTripTo("");
	       				this.setTotalTrips(0);
	       				this.setTransportationCharges(0.0F);
	       				
	       				result = "success";
	       				addActionMessage(this.getText("message.success.tripDetailsUpdatedSuccessfully"));
	       			}
	       			else
	       			{
	       				result = "error";
	       				addActionError(this.getText("message.error.whileExecutingUpdateStatementVehicleTripDetailsDidntUpdate"));
	       			}
	       			
	       			
	       		}
	       		catch (SQLException e) 
	       		{
	        		result = "error";
	        		e.printStackTrace();
	        		addActionError(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.tripEntryDetailsNotUpdated"));
	        		
	       		} 
	       		
	       		catch (IOException e) 
	       		{
					
					result = "error";
					e.printStackTrace();
	        		addActionError(e.getMessage()+"|| "+this.getText("message.error.tripEntryDetailsNotUpdated"));
				}	
		   			finally
		   			{
		   				if(resultSet != null)
						{
							try 
							{
								resultSet.close();
							
							}catch (SQLException e) {
								
							}
						}
		   				if(preparedStatement != null)
		   				{
		   					try {preparedStatement.close();} catch (SQLException e) {}
		   				}
		   				if(connection != null)
		   				{
		   					try {connection.close();} catch (SQLException e) {}
		   				}
			   				
		   			}
				}
				else
				{
					result = "error";
					addActionError(this.getText("message.error.errorWhielProcessingProvidedData"));
				}
	        }
    	else
    	{
    		result = "error";
    		addActionError(this.getText("message.error.urlTempered"));
    	}
		        	
		        
	}
		
	 return result;
	}

@Override
public void validate() {
	session=ServletActionContext.getRequest().getSession(false); 
	
	if(this.getVehicleId()!= null)
	{
		if(this.getVehicleId().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectVehicle"));
		}
	}
	if(!hasActionErrors())
	{
		if(this.getCustomerName().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideCustomerName"));
		}
		else
		{
			try
			{
				String [] custDetails = this.getCustomerName().split("-");
				
				String custId = custDetails[0];
				String custName = custDetails[1];


				String isCustomerAdded = "false";
				
				String [] result = new String[2];
				String condition  = "AND customer_name = '"+custName+"'";
				result = new CheckAlreadyAvailable().checkAvaibility("crusher_customer_master", "customer_id", condition, custId);
				
				isCustomerAdded = result[0];
				
				if(isCustomerAdded.equals("false"))
				{
					addActionError(this.getText("message.error.customerNameProvidedByYouIsNotAvailable"));
				}		
				
			}catch(Exception e)
			{
				addActionError(this.getText("message.error.plzProvideCorrectCustomerName"));
			}
		}
	}
	
	if(!hasActionErrors())
	{
		if(this.getMaterialName().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideMaterialName"));
		}
	}
	
	if(!hasActionErrors())
	{
		if(this.getMaterialVolume() ==null || this.getMaterialVolume().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideCorrectMaterialVolume"));
		}
	}
	
	if(!hasActionErrors())
	{
		if(this.getKmStart() == null || this.getKmStart().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideCorrectStartKm"));
		}
	}
	
	if(!hasActionErrors())
	{
		if(this.getKmEnd() == null || this.getKmEnd().equals(""))
		{
			addActionError(this.getText("message.error.plzprovideCorrectEndKm"));
		}
	}
	
	if(!hasActionErrors())
	{
		if(this.getTotalKm() == null || this.getTotalKm().equals(""))
		{
			addActionError(this.getText("message.error.plzprovideCorrectTotalLm"));
		}
	}
	
	if(!hasActionErrors())
	{
		if(this.getTripFrom().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideTripFromDetails"));
		}
	}
	
	if(!hasActionErrors())
	{
		if(this.getTripTo().equals(""))
		{
			addActionError(this.getText("message.error.plzprovideTripToDetails"));
		}
	}
	
	if(!hasActionErrors())
	{
		if(this.getTotalTrips() == null || this.getTotalTrips().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideCorrectTotalTripFigure"));
		}
	}
	
	
	
	
	
	if(!hasActionErrors())
	{
		if(this.getTransportationCharges() == null || this.getTransportationCharges().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideCorrectTransportCharges"));
		}
	}
	
	
	if(!hasActionErrors())
	{
		String isMaterialAdded = "false";
		
		String [] result = new String[2];
		String condition  = "NA";
		result = new CheckAlreadyAvailable().checkAvaibility("crusher_product_master", "product_name_eng", condition, this.getMaterialName().trim().toUpperCase());
		
		isMaterialAdded = result[0];
		
		if(isMaterialAdded.equals("false"))
		{
			addActionError(this.getText("message.error.materialNameProvidedByYouIsNotAvailable"));
		}		
	}
	
	
	
	Connection connection = null;
	PreparedStatement preparedStatement= null;
	ResultSet resultSet = null;
	String sql = "";
	String db = (String) session.getAttribute("db");
	
	try
	{
		
		
		
		connection = GetDBConnection.getDBConnection(db);
			
		
		sql = "SELECT "
				+ "vehicle_id,"
				+ "vehicle_make,"
				+ "vehicle_registration_number "
				+ "FROM "
				+ "crusher_vehicle_details_master";
		
		preparedStatement = connection.prepareStatement(sql);
		resultSet = preparedStatement.executeQuery();


		while(resultSet.next())
		{
			this.getVehicleList().put(resultSet.getString(1), resultSet.getString(2)+" | "+resultSet.getString(3));
		}
	}catch (SQLException e) {
		
		addActionError(e.getErrorCode()+" || "+e.getMessage());
	} catch (Exception e) {
		
							
		addActionError(e.getMessage()+" || "+e.getCause());
	}finally {
		if(resultSet != null)
		{

			try {resultSet.close();} catch (SQLException e) {}
		}
		if(preparedStatement != null)
		{
			try {preparedStatement.close();} catch (SQLException e) {}
		}
		if(connection != null)
		{
			
			try {connection.close();}catch (SQLException e) {}
		}
		
	}
}
public HttpSession getSession() {
	return session;
}

public void setSession(HttpSession session) {
	this.session = session;
}

public String getKey() {
	return key;
}

public void setKey(String key) {
	this.key = key;
}

public String getTripDate() {
	return tripDate;
}

public void setTripDate(String tripDate) {
	this.tripDate = tripDate;
}

public String getVehicleId() {
	return vehicleId;
}

public void setVehicleId(String vehicleId) {
	this.vehicleId = vehicleId;
}

public String getCustomerName() {
	return customerName;
}

public void setCustomerName(String customerName) {
	this.customerName = customerName;
}

public String getMaterialName() {
	return materialName;
}

public void setMaterialName(String materialName) {
	this.materialName = materialName;
}

public Float getMaterialVolume() {
	return materialVolume;
}

public void setMaterialVolume(Float materialVolume) {
	this.materialVolume = materialVolume;
}

public Float getKmStart() {
	return kmStart;
}

public void setKmStart(Float kmStart) {
	this.kmStart = kmStart;
}

public Float getKmEnd() {
	return kmEnd;
}

public void setKmEnd(Float kmEnd) {
	this.kmEnd = kmEnd;
}

public Float getTotalKm() {
	return totalKm;
}

public void setTotalKm(Float totalKm) {
	this.totalKm = totalKm;
}

public String getTripFrom() {
	return tripFrom;
}

public void setTripFrom(String tripFrom) {
	this.tripFrom = tripFrom;
}

public String getTripTo() {
	return tripTo;
}

public void setTripTo(String tripTo) {
	this.tripTo = tripTo;
}

public Integer getTotalTrips() {
	return totalTrips;
}

public void setTotalTrips(Integer totalTrips) {
	this.totalTrips = totalTrips;
}



public Float getTransportationCharges() {
	return transportationCharges;
}

public void setTransportationCharges(Float transportationCharges) {
	this.transportationCharges = transportationCharges;
}

public Map<String, String> getVehicleList() {
	return vehicleList;
}

public void setVehicleList(Map<String, String> vehicleList) {
	this.vehicleList = vehicleList;
}

public static long getSerialversionuid() {
	return serialVersionUID;
}


public String getBillNo() {
	return billNo;
}

public void setBillNo(String billNo) {
	this.billNo = billNo;
}



}
