package com.stonecrusher.update;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class UpdateSupplierPaymentDetails extends ActionSupport implements SessionAware{

	
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 8589455198618810466L;
	private SessionMap<String,Object> sessionMap;
	
	private HttpSession session;
	
	private String paymentId;
	private String paymentDate;
	private String supplierName;
	private String key;
	private Float amountPaid;
	private String paymentDetails;
	private boolean sendSMS;
	
	private String supplierId;
	private String supplierMobile;
	private String debtAmount;
	private String accountId;
	
	private String typeOfPayment;
	
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private List<String> paymentTypeList = new ArrayList<String>();
	private String addSideBarJs;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	
	
   public String execute(){
		
	   
	  String result = "login";
		
		 if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	
	        	
	        	
	        	customerSearchOptionList.put("BYNAME", "BY NAME");
				customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
				customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setDefaultValue("BYNAME");
				setCustomerSearchOption("BYNAME");
				
				String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
			
	       		try 
	       		{
	       			
		        	connection = GetDBConnection.getDBConnection(db);
					connection.setAutoCommit(false);
					

                      String fullUserName = (String) session.getAttribute("userFullName");
		        	
                      
                     
		        	String splitUserName [] = new String[5];
		        	
		        	String entryBy = "";
		        	try
		        	{
		        		splitUserName = fullUserName.split(" ");
		        		entryBy = splitUserName[0];
		        		
		        	}catch(Exception e)
		        	{
		        		entryBy =fullUserName;
		        	}
		        	
		        	
		        	java.util.Date date = new java.util.Date();
		      	      long t = date.getTime();	        	     
		      	      java.sql.Time time = new java.sql.Time(t);
					
		      	      
    				sql = "SELECT "
							+ "credit_debit_id "
							+ "FROM "
							+ "crusher_supplier_payment_details_master "
							+ "WHERE "
							+ "entry_id = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
				
				preparedStatement = connection.prepareStatement(sql);
				
				preparedStatement.setString(1, this.getPaymentId());
				preparedStatement.setString(2, crusherId);
				preparedStatement.setString(3, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
				
				
				if(resultSet.next()){
					
					String crditDebitId = resultSet.getString(1);
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(preparedStatement != null)
					{
						preparedStatement.close();
						preparedStatement = null;
					}
					
					
					sql = "SELECT "
							+ "entry_id,"
							+ "account_id,"
							+ "account_number,"
							+ "entry_date,"
							+ "entry_time,"
							+ "entry_type,"
							+ "amount,"
							+ "payment_type,"
							+ "entry_by,"
							+ "entry_details "
							+ "FROM "
							+ "bank_account_credit_debit_master "
							+ "WHERE "
							+ "entry_id = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crditDebitId);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);

					
					resultSet = preparedStatement.executeQuery();
					
					int m = 0;
					if(resultSet.next())
					{
						
						PreparedStatement  insertIntoDeletedPSMT = null;
						
						String inertDeletedSQL = "INSERT "
								+ "INTO "
								+ "bank_account_credit_debit_updated_entry_master "
								+ "("
								+ "entry_id,"
								+ "crusher_id,"
								+ "crusher_code,"
								+ "account_id,"
								+ "account_number,"
								+ "entry_date,"
								+ "entry_time,"
								+ "entry_type,"
								+ "amount,"
								+ "payment_type,"
								+ "entry_by,"
								+ "entry_details,"
								+ "old_amount,"
								+ "updated_date,"
								+ "updated_time) "
								+ "VALUES "
								+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?)";
						
						insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
						
						insertIntoDeletedPSMT.setString(1, crditDebitId);
						insertIntoDeletedPSMT.setString(2, crusherId);
						insertIntoDeletedPSMT.setString(3, crusherCode);
						insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
						insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
						insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
						insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
						insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
						insertIntoDeletedPSMT.setFloat(9, this.getAmountPaid());
						insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
						insertIntoDeletedPSMT.setString(11, entryBy);
						insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
						insertIntoDeletedPSMT.setFloat(13, resultSet.getFloat(7));
						insertIntoDeletedPSMT.setString(14, this.getPaymentDate());
						insertIntoDeletedPSMT.setTime(15,time);
						
						
						  m = insertIntoDeletedPSMT.executeUpdate();
						  
						  String paymentType = resultSet.getString(6);
						  
						  
						  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
							Date parsedDate = null;

							try {
							    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
							} catch (ParseException e) {
							    e.printStackTrace();  
							}

							if (parsedDate != null) {
							     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
							    String formattedDate = outputDateFormat.format(parsedDate); 
				
							    
						 
						    
						    
						  boolean isCloseingBalMaintained = false;
						  
						  if (paymentType.equals("CREDIT")) {
						   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), entryBy, connection, this.getSessionMap());
						  }else {
							   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), entryBy, connection, this.getSessionMap());
							  
						  }
							}
						  
						if(insertIntoDeletedPSMT != null)
						{
							insertIntoDeletedPSMT.close();
							insertIntoDeletedPSMT = null;
						}
						
					}
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(preparedStatement != null)
					{
						preparedStatement.close();
						preparedStatement = null;
					}
						
	       			sql = "UPDATE "
	       					+ "crusher_supplier_payment_details_master "
	       					+ "SET "
	       					+ "payment_entry_date = STR_TO_DATE(?,'%d-%m-%Y'),"
	       					+ "payment_entry_time = ?,"
	       					+ "amount = ?,"
	       					+ "payment_details = ?,"
	       					+ "payment_type = ?,"
	       					+ "entry_by = ?,"
	       					+ "amount_debit_account_id = ? "
	       					+ "WHERE "
	       					+ "entry_id = ? "
	       					+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";

	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			
	       			preparedStatement.setString(1, this.getPaymentDate());
	       			preparedStatement.setTime(2, time);
	       			preparedStatement.setFloat(3, this.getAmountPaid());
	       			preparedStatement.setString(4, this.getPaymentDetails());
	       			preparedStatement.setString(5, this.getTypeOfPayment());
	       			preparedStatement.setString(6, entryBy);
	       			preparedStatement.setString(7, this.getAccountId());
	       			preparedStatement.setString(8, this.getPaymentId());
	       			preparedStatement.setString(9, crusherId);
					preparedStatement.setString(10, crusherCode);
					

	       			int rowUpdated = preparedStatement.executeUpdate();
	       			
	       			
	       			if(rowUpdated > 0)
	       			{
	       				
	       				
	       				
	       				if(!this.getTypeOfPayment().equals("CHEQUE") && m > 0)
	        			{
						String accountNumber = "";
    	        		sql = "SELECT "
    	        				+ "account_number "
    	        				+ "FROM "
    	        				+ "crusher_bank_account "
    	        				+ "WHERE "
    	        				+ "account_id  = ?"
    	        				+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
    	        			
    	        		preparedStatement = connection.prepareStatement(sql);
    	        		
    	        		preparedStatement.setString(1, this.getAccountId());
    	        		preparedStatement.setString(2, crusherId);
    					preparedStatement.setString(3, crusherCode);
    					
    	        		resultSet = preparedStatement.executeQuery();
    	        		if(resultSet.next())
    	        		{
    	        			accountNumber = resultSet.getString(1);
    	        		}
    	        		

						
						sql = "UPDATE "
								+ "bank_account_credit_debit_master "
								+ "SET "
								+ "entry_date = STR_TO_DATE(?,'%d-%m-%Y'),"
								+ "entry_time = ?,"
								+ "account_id = ?,"
								+ "account_number = ?,"
								+ "entry_type = ?,"
								+ "amount = ?,"
								+ "payment_type = ?,"
								+ "entry_by = ?,"
								+ "entry_details = ? "
								+ "WHERE "
								+ "entry_id = ?"
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
					
						
						
						
						preparedStatement = connection.prepareStatement(sql);
						
					
						preparedStatement.setString(1, this.getPaymentDate());
						preparedStatement.setTime(2, time);
						preparedStatement.setString(3, this.getAccountId());
						preparedStatement.setString(4, accountNumber);
						preparedStatement.setString(5, "DEBIT");
						preparedStatement.setFloat(6, this.getAmountPaid());
						preparedStatement.setString(7, this.getTypeOfPayment());							
						preparedStatement.setString(8, entryBy);
						preparedStatement.setString(9, "UPDATED SUPPLIER PAYMENT TO "+this.getSupplierName().trim().toUpperCase());
						preparedStatement.setString(10, crditDebitId);
						preparedStatement.setString(11, crusherId);
						preparedStatement.setString(12, crusherCode);
						
						int	count = preparedStatement.executeUpdate();
						
						boolean isCloseingBalMaintained1 = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId(),"DEBIT", this.getPaymentDate(), this.getAmountPaid(), entryBy, connection, this.getSessionMap());
							
						if(count > 0 && isCloseingBalMaintained1)
						{
							connection.commit();
							result = "success";
		       				addActionMessage(this.getText("message.success.supplierPaymentDetailsUpdatedSuccessfully"));
	       			}
	        			
	        			}else {
	        				
	    					connection.commit();
							result = SUCCESS;
							 addActionMessage(this.getText("message.success.supplierPaymentDetailsUpdatedSuccessfully"));
	        			}
	        		
						
	        		}
					else
					{
						connection.rollback();
						result = "error";
	       				addActionError(this.getText("message.error.srySupplierPaymentDetailsNotUpdatedPlzTryAgain"));

						
					}
	       			this.setKey(this.getKey());
				     
					
				     
  						
  					}
	       		}
       		catch (SQLException e) {
       			e.printStackTrace();
	       		result = "error";				
				addActionError(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.someErrorWhileGettingInformation"));
		
       	 	} catch (Exception e) {
			
       	 		e.printStackTrace();
			result = "error";
			addActionError(e.getMessage()+"|| "+this.getText("message.error.someErrorWhileUpdatingPaymentDetails"));
			}	
			finally
			{
				if(resultSet != null)
				{
				try {
					resultSet.close();
				} catch (SQLException e) {
					
				}
			}
			if(preparedStatement != null)
			{
				try {preparedStatement.close();} catch (SQLException e) {}
			}
			if(connection != null)
			{
				try {connection.close();} catch (SQLException e) {}
			}
			
		}
	
        	
        
        }
        return result;
}

@Override
public void validate() {
	
	 this.setAddSideBarJs("FALSE");
		
	session=ServletActionContext.getRequest().getSession(false);
 	
	paymentTypeList.add("CASH");
 	paymentTypeList.add("UPI");
 	paymentTypeList.add("RTGS");
 	paymentTypeList.add("NEFT");
 	paymentTypeList.add("CHEQUE");
 	
 	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));     
 	
	
	if(!hasActionErrors())
	{
		if(this.getAmountPaid() ==null || this.getAmountPaid().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideCorrectAmountPaid"));
		}
		else if(this.getAmountPaid() <= 0 )
		{
			addActionError(this.getText("message.error.amountPaidCannnotBeLessThanEqualto0"));
		}
	}
}

public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}

public HttpSession getSession() {
	return session;
}

public void setSession(HttpSession session) {
	this.session = session;
}

public String getPaymentId() {
	return paymentId;
}

public void setPaymentId(String paymentId) {
	this.paymentId = paymentId;
}

public String getPaymentDate() {
	return paymentDate;
}

public void setPaymentDate(String paymentDate) {
	this.paymentDate = paymentDate;
}

public String getSupplierName() {
	return supplierName;
}

public void setSupplierName(String supplierName) {
	this.supplierName = supplierName;
}

public String getKey() {
	return key;
}

public void setKey(String key) {
	this.key = key;
}

public Float getAmountPaid() {
	return amountPaid;
}

public void setAmountPaid(Float amountPaid) {
	this.amountPaid = amountPaid;
}

public String getPaymentDetails() {
	return paymentDetails;
}

public void setPaymentDetails(String paymentDetails) {
	this.paymentDetails = paymentDetails;
}

public String getSupplierId() {
	return supplierId;
}

public void setSupplierId(String supplierId) {
	this.supplierId = supplierId;
}

public String getSupplierMobile() {
	return supplierMobile;
}

public void setSupplierMobile(String supplierMobile) {
	this.supplierMobile = supplierMobile;
}

public String getDebtAmount() {
	return debtAmount;
}

public void setDebtAmount(String debtAmount) {
	this.debtAmount = debtAmount;
}

public String getAccountId() {
	return accountId;
}

public void setAccountId(String accountId) {
	this.accountId = accountId;
}

public String getTypeOfPayment() {
	return typeOfPayment;
}

public void setTypeOfPayment(String typeOfPayment) {
	this.typeOfPayment = typeOfPayment;
}

public Map<String, String> getAccountList() {
	return accountList;
}

public void setAccountList(Map<String, String> accountList) {
	this.accountList = accountList;
}

public List<String> getPaymentTypeList() {
	return paymentTypeList;
}

public void setPaymentTypeList(List<String> paymentTypeList) {
	this.paymentTypeList = paymentTypeList;
}

public String getAddSideBarJs() {
	return addSideBarJs;
}

public void setAddSideBarJs(String addSideBarJs) {
	this.addSideBarJs = addSideBarJs;
}

public Map<String, String> getCustomerSearchOptionList() {
	return customerSearchOptionList;
}

public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
	this.customerSearchOptionList = customerSearchOptionList;
}

public String getCustomerSearchOption() {
	return customerSearchOption;
}

public void setCustomerSearchOption(String customerSearchOption) {
	this.customerSearchOption = customerSearchOption;
}

public String getDefaultValue() {
	return defaultValue;
}

public void setDefaultValue(String defaultValue) {
	this.defaultValue = defaultValue;
}

public static long getSerialversionuid() {
	return serialVersionUID;
}

@Override
public void setSession(Map<String, Object> arg0) {
	// TODO Auto-generated method stub
	sessionMap=(SessionMap<String, Object>)arg0;
}

public boolean isSendSMS() {
	return sendSMS;
}

public void setSendSMS(boolean sendSMS) {
	this.sendSMS = sendSMS;
}




}