package com.stonecrusher.update;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class UpdateSupplierOpeningBalance extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -6492235460509123538L;
	
	private String key;
	private String supplierName;
	private String openingBalanceDate;
	private Float amount;
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	
	private String addSideBarJs;
	private HttpSession session;
	
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
				String crusherCode = (String) session.getAttribute("crusherCode");
				

	        	
	        	
	        	customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				String supplierId = EncryptionDecryption.decrypt(this.getKey());
				
					try
					{
						
						connection = GetDBConnection.getDBConnection(db);
						
						String user = (String) session.getAttribute("userFullName");
						String userName = "";
						
						try
						{
							userName = user.split(" ")[0];
						}catch(Exception e)
						{
							userName = user;
						}
						
						
						int newId = 0;
						sql = "SELECT "
								+ "id "
								+ "FROM "
								+ "crusher_supplier_close_open_bal_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
                                + "ORDER BY "
								+ "id "
								+ "DESC LIMIT 1;";
						
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);

						resultSet = preparedStatement.executeQuery();
					
						
						if(resultSet.next())
						{
							if(!(resultSet.getString(1) == null))
							{
								newId = Integer.parseInt(resultSet.getString(1)) + 1;
								
							}
							else
							{
								newId =1;
								
							}
						}
						else
						{	newId =1;
							
						}
						if(resultSet != null)
		        		{
		        			resultSet.close();
		        			resultSet = null;
		        		}
		        		if(preparedStatement!= null)
		        		{
		        			preparedStatement.close();
		        			preparedStatement = null;
		        		}
		        		
		        		
		        		
		        		sql = "SELECT "
		        				+ "supplier_id,"
		        				+ "supplier_name,"
		        				+ "opening_balance "
		        				+ "FROM "
		        				+ "crusher_supplier_close_open_bal_master "
		        				+ "WHERE "
		        				+ "supplier_id = ? "
		        				+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
		        		
		        		preparedStatement = connection.prepareStatement(sql);
		        		
		        		preparedStatement.setString(1, supplierId);
		        		preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);

		        		resultSet = preparedStatement.executeQuery();
		        		
		        		int rowInsertedUpdatedCount = 0;
		        		if(resultSet.next())
		        		{
		        			sql = "UPDATE "
		        					+ "crusher_supplier_close_open_bal_master "
		        					+ "SET "
		        					+ "opening_balance_date = ?,"
		        					+ "opening_balance = ?,"
		        					+ "update_by = ? "
		        					+ "WHERE "
		        					+ "supplier_id = ? "
		        					+ "AND "
		        					+ "supplier_name = ? "
		        					+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
		        			
		        			preparedStatement = connection.prepareStatement(sql);
		        			
		        			String inputDate = this.getOpeningBalanceDate(); // "03-06-2025"
		        			SimpleDateFormat inputFormat = new SimpleDateFormat("dd-MM-yyyy");
		        			SimpleDateFormat sqlFormat = new SimpleDateFormat("yyyy-MM-dd");

		        			String formattedDate = sqlFormat.format(inputFormat.parse(inputDate));

		        			preparedStatement = connection.prepareStatement(sql);
		        			preparedStatement.setString(1, formattedDate);
                            preparedStatement.setFloat(2, this.getAmount());
		        			preparedStatement.setString(3, userName);
		        			preparedStatement.setString(4, supplierId);
		        			preparedStatement.setString(5, this.getSupplierName());
		        			preparedStatement.setString(6, crusherId);
							preparedStatement.setString(7, crusherCode);

		        			rowInsertedUpdatedCount = preparedStatement.executeUpdate();
		        			
		        		}
		        		else
		        		{
		        			
		        			sql = "INSERT INTO "
		        					+ "crusher_supplier_close_open_bal_master "
		        					+ "(id,"
		        					+ "crusher_id,"
		        					+ "crusher_code,"
		        					+ "supplier_id,"
		        					+ "supplier_name,"
		        					+ "opening_balance_date,"
		        					+ "opening_balance,"
		        					+ "update_by) "
		        					+ "VALUES "
		        					+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?)";
		        			
		        			preparedStatement = connection.prepareStatement(sql);
		        			preparedStatement.setString(1, ""+newId);
		        			preparedStatement.setString(2, crusherId);
		        			preparedStatement.setString(3, crusherCode);
		        			preparedStatement.setString(4, supplierId);
		        			preparedStatement.setString(5, this.getSupplierName());
		        			preparedStatement.setString(6, this.getOpeningBalanceDate());
		        			preparedStatement.setFloat(7, this.getAmount());
		        			preparedStatement.setString(8, userName);
		        			
		        			rowInsertedUpdatedCount = preparedStatement.executeUpdate();
		        			
		        		}
		        		if(rowInsertedUpdatedCount > 0)
	        			{
	        				result = "success";
	        				addActionMessage(this.getText("message.success.supplierOpeningBalanceDetailsUpdatedSuccessfully"));
	        			}
	        			else
	        			{
	        				result = "error";
	        				addActionError(this.getText("message.error.errorSupplierOpeningBalanceDetailsNotUpdatedPlzTryAgain"));
	        				
	        			}
					}catch (SQLException e) {
						result = "error";
						e.printStackTrace();
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" ||"+this.getText("message.error.detailsNotUpdated"));
					} catch (Exception e) {  
						e.printStackTrace();
						
						result = "error";					
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.detailsNotUpdated"));
					}finally {
						if(resultSet != null)
						{
							try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
						}
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close(); connection = null;}catch (SQLException e) {}
						}
						
					}
					
		        	
		        }
		        
		
		
		 return result;
		 
		}
		
		@Override
		public void validate() {
		
			this.setAddSideBarJs("FALSE");
			customerSearchOptionList.put("BYNAME", "BY NAME");
			customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
			customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
			setDefaultValue("BYNAME");
			setCustomerSearchOption("BYNAME");
			
			if(this.getOpeningBalanceDate().equals(""))
			{
				
				addActionError(this.getText("message.error.plzProvideOpeningBalanceDate"));
			}
			
			if(!hasActionErrors())			
			{
				if(this.getAmount() == null || this.getAmount().equals(""))
				{
					addActionError(this.getText("message.error.plzProvideCorrectAmount"));
				}
			}
		}
		

	public String getKey() {
		return key;
	}


	public void setKey(String key) {
		this.key = key;
	}


	public String getSupplierName() {
		return supplierName;
	}


	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}


	public String getOpeningBalanceDate() {
		return openingBalanceDate;
	}


	public void setOpeningBalanceDate(String openingBalanceDate) {
		this.openingBalanceDate = openingBalanceDate;
	}


	public Float getAmount() {
		return amount;
	}


	public void setAmount(Float amount) {
		this.amount = amount;
	}


	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}


	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}


	public String getCustomerSearchOption() {
		return customerSearchOption;
	}


	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}


	public String getDefaultValue() {
		return defaultValue;
	}


	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	
	
	
	

}
