package com.stonecrusher.update;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class UpdateProductStockDetails extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3927832833390378702L;

	private SessionMap<String,Object> sessionMap;  
	
	
	
	public static boolean addStockToCurrentStock(Connection connection, SessionMap<String, Object> sessionMap, String productId, String productName, Float productQuantity)
	{
		
		boolean isStockAdded = false;
		
		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");

		
		PreparedStatement updateStockPSMT= null;
		ResultSet  resultSet = null;
		
		String sql = "";
		String db = (String) sessionMap.get("db");
		
		
		try
		{
	
	
	
		float oldQuantity = 0.0F;
		float newQuantity = 0.0F;
		float stockConversionRatio = 0.0F;
	
		sql = "SELECT "
				+ "in_stock_quantity,"
				+ "stock_conversion_ratio "
				+ "FROM "
				+ "crusher_product_master "
				+ "WHERE "
				+ "product_id = ? "
				+ "AND "
				+ "crusher_id = ? "
				+ "AND "
				+ "crusher_code = ? ";

		
		updateStockPSMT = connection.prepareStatement(sql);
		
		updateStockPSMT.setString(1, productId);
		updateStockPSMT.setString(2, crusherId);
		updateStockPSMT.setString(3, crusherCode);
		

	//	System.out.println(updateStockPSMT.toString());
		
		resultSet = updateStockPSMT.executeQuery();
		
		if(resultSet.next())
		{
			oldQuantity = resultSet.getFloat(1);
			
		}
		
		newQuantity = oldQuantity + productQuantity ; 
		
	/*	System.out.println("oldQuantity : "+oldQuantity);
		System.out.println("productQuantity : "+productQuantity);
		System.out.println("newQuantity : "+ newQuantity);*/
		
		
		
		if(resultSet != null)
		{
			resultSet.close();
			resultSet = null;
		}
		
		if(updateStockPSMT != null)
		{
			updateStockPSMT.close();
			updateStockPSMT = null;
		}
		sql = "UPDATE "
				+ "crusher_product_master "
				+ "SET "
				+ "in_stock_quantity = ? "
				+ "WHERE "
				+ "product_id = ? "
				+ "AND "
				+ "crusher_id = ? "
				+ "AND "
				+ "crusher_code = ? ";

				
		
		updateStockPSMT = connection.prepareStatement(sql);
		
		
		updateStockPSMT.setFloat(1, newQuantity);
		updateStockPSMT.setString(2, productId);
		updateStockPSMT.setString(3, crusherId);
		updateStockPSMT.setString(4, crusherCode);
		

		
		int rowCount = updateStockPSMT.executeUpdate();
		
		if(rowCount>0)
		{			
			isStockAdded = true;
		}
		
		
		}catch (SQLException e) {
	 		//e.printStackTrace();
			isStockAdded = false;
	 		
	 	}
		catch (Exception e) {
			//e.printStackTrace();
			isStockAdded = false;
		}
		finally
		{
			
			if(resultSet != null)
			{
				try {
					resultSet.close();
					resultSet = null;
				} catch (SQLException e) {
				
				}
			}
			if(updateStockPSMT != null)
			{
				try {
					updateStockPSMT.close();
					updateStockPSMT = null;
				} catch (SQLException e) {
					
				}
			}
		
			
		}
		//System.out.println(" in update isStockAdded : "+isStockAdded);
		
	
		return isStockAdded;
		
	}
	

	public static boolean addStockToCurrentStock(SessionMap<String, Object> sessionMap, String productId, Float productQuantity)
	{
		
		boolean isStockAdded = false;
		
		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");

		Connection connection = null;
		PreparedStatement updateStockPSMT= null;
		ResultSet  resultSet = null;
		
		String sql = "";
		String db = (String) sessionMap.get("db");
		
		
		try
		{
			connection = GetDBConnection.getDBConnection(db);
	
		
	
		float oldQuantity = 0.0F;
		float newQuantity = 0.0F;
		float stockConversionRatio = 0.0F;
	
		sql = "SELECT "
				+ "in_stock_quantity,"
				+ "stock_conversion_ratio "
				+ "FROM "
				+ "crusher_product_master "
				+ "WHERE "
				+ "product_id = ? "
				+ "AND "
				+ "crusher_id = ? "
				+ "AND "
				+ "crusher_code = ? ";

		
		updateStockPSMT = connection.prepareStatement(sql);
		
		updateStockPSMT.setString(1, productId);
		updateStockPSMT.setString(2, crusherId);
		updateStockPSMT.setString(3, crusherCode);

	//	System.out.println(updateStockPSMT.toString());
		
		resultSet = updateStockPSMT.executeQuery();
		
		if(resultSet.next())
		{
			oldQuantity = resultSet.getFloat(1);
			
		}
		
		newQuantity = oldQuantity + productQuantity ; 
		
	/*	System.out.println("oldQuantity : "+oldQuantity);
		System.out.println("productQuantity : "+productQuantity);
		System.out.println("newQuantity : "+ newQuantity);*/
		
		
		
		if(resultSet != null)
		{
			resultSet.close();
			resultSet = null;
		}
		
		if(updateStockPSMT != null)
		{
			updateStockPSMT.close();
			updateStockPSMT = null;
		}
		sql = "UPDATE "
				+ "crusher_product_master "
				+ "SET "
				+ "in_stock_quantity = ? "
				+ "WHERE "
				+ "product_id = ? "
				+ "AND "
				+ "crusher_id = ? "
				+ "AND "
				+ "crusher_code = ? ";
				
		
		updateStockPSMT = connection.prepareStatement(sql);
		
		
		updateStockPSMT.setFloat(1, newQuantity);
		updateStockPSMT.setString(2, productId);
		updateStockPSMT.setString(3, crusherId);
		updateStockPSMT.setString(4, crusherCode);

		
		int rowCount = updateStockPSMT.executeUpdate();
		
		if(rowCount>0)
		{			
			isStockAdded = true;
		}
		
		
		}catch (SQLException e) {
	 		//e.printStackTrace();
			isStockAdded = false;
	 		
	 	}
		catch (Exception e) {
			//e.printStackTrace();
			isStockAdded = false;
		}
		finally
		{
			
			if(resultSet != null)
			{
				try {
					resultSet.close();
					resultSet = null;
				} catch (SQLException e) {
				
				}
			}
			if(updateStockPSMT != null)
			{
				try {
					updateStockPSMT.close();
					updateStockPSMT = null;
				} catch (SQLException e) {
					
				}
			}
			if(connection != null)
			{
				try {
					connection.close();
					connection = null;
				} catch (SQLException e) {
				
				}
			}
			
		}
		//System.out.println(" in update isStockAdded : "+isStockAdded);
		
	
		return isStockAdded;
		
	}
	
	
	public static boolean minusStockToCurrentStock(SessionMap<String, Object> sessionMap,String productId, String productName, Float productQuantity)
	{
		
		
		boolean isStockMinus = false;
		
		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");

		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet  resultSet = null;
		String db = (String) sessionMap.get("db");
		
		String sql = "";
		
		
		try
		{
	
			connection = GetDBConnection.getDBConnection(db);
			
		float oldQuantity = 0.0F;
		float newQuantity = 0.0F;
		
		sql = "SELECT "
				+ "in_stock_quantity "			
				+ "FROM "
				+ "crusher_product_master "
				+ "WHERE "
				+ "product_id = ? "
				+ "AND "
				+ "crusher_id = ? "
				+ "AND "
				+ "crusher_code = ? ";
		
		preparedStatement = connection.prepareStatement(sql);
		
		preparedStatement.setString(1, productId);
		preparedStatement.setString(2, crusherId);
		preparedStatement.setString(3, crusherCode);

		
	
		resultSet = preparedStatement.executeQuery();
		
		if(resultSet.next())
		{
			oldQuantity = resultSet.getFloat(1);
			
		}
	
		
		newQuantity = oldQuantity - productQuantity;
		
		if(preparedStatement != null)
		{
			preparedStatement.close();
		}
		sql = "UPDATE "
				+ "crusher_product_master "
				+ "SET "
				+ "in_stock_quantity = ? "
				+ "WHERE "
				+ "product_id = ? "
				+ "AND "
				+ "crusher_id = ? "
				+ "AND "
				+ "crusher_code = ? ";
		
		preparedStatement = connection.prepareStatement(sql);
		
		preparedStatement.setFloat(1, (float) (Math.round(newQuantity * 100.0) / 100.0));
		preparedStatement.setString(2, productId);
		preparedStatement.setString(3, crusherId);
		preparedStatement.setString(4, crusherCode);
		
 
		int rowCount = preparedStatement.executeUpdate();
		
		if(rowCount>0)
		{
			isStockMinus = true;
		}
		
		
		}catch (SQLException e) {
	 		
			isStockMinus = false;
	 		
	 	}
		catch (Exception e) {
			isStockMinus = false;
		}
		finally
		{
			
			if(resultSet != null)
			{
				try {
					resultSet.close();
					resultSet = null;
				} catch (SQLException e) {
				
				}
			}
			if(preparedStatement != null)
			{
				try {
					preparedStatement.close();
					preparedStatement = null;
				} catch (SQLException e) {
					
				}
			}
			if(connection != null)
			{
				try {
					connection.close();
					connection = null;
				} catch (SQLException e) {
					
				}
			}
			
			
			
			
		}
		
		
		
		return isStockMinus;
		
	}
	
	
	public static boolean minusStockToCurrentStock(Connection connection,  SessionMap<String, Object> sessionMap,String productId,  String productDetails, Float productQuantity)
	{
		
		
		boolean isStockMinus = false;
		
		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");

		PreparedStatement preparedStatement= null;
		ResultSet  resultSet = null;
		
		String sql = "";
		
		
		try
		{
	
		
		float oldQuantity = 0.0F;
		float newQuantity = 0.0F;
		
		sql = "SELECT "
				+ "in_stock_quantity "			
				+ "FROM "
				+ "crusher_product_master "
				+ "WHERE "
				+ "product_id = ? "
				+ "AND "
				+ "crusher_id = ? "
				+ "AND "
				+ "crusher_code = ? ";
		
		preparedStatement = connection.prepareStatement(sql);
		
		preparedStatement.setString(1, productId);
		preparedStatement.setString(2, crusherId);
		preparedStatement.setString(3, crusherCode);
		

	
		resultSet = preparedStatement.executeQuery();
		
		if(resultSet.next())
		{
			oldQuantity = resultSet.getFloat(1);
			
		}
	
		
		newQuantity = oldQuantity - productQuantity;
		
		if(preparedStatement != null)
		{
			preparedStatement.close();
		}
		sql = "UPDATE "
				+ "crusher_product_master "
				+ "SET "
				+ "in_stock_quantity = ? "
				+ "WHERE "
				+ "product_id = ? "
				+ "AND "
				+ "crusher_id = ? "
				+ "AND "
				+ "crusher_code = ? ";
		
		
		preparedStatement = connection.prepareStatement(sql);
		
		preparedStatement.setFloat(1, (float) (Math.round(newQuantity * 100.0) / 100.0));
		preparedStatement.setString(2, productId);
		preparedStatement.setString(3, crusherId);
		preparedStatement.setString(4, crusherCode);

		int rowCount = preparedStatement.executeUpdate();
		
		if(rowCount>0)
		{
			isStockMinus = true;
		}
		
		
		}catch (SQLException e) {
	 		
			isStockMinus = false;
	 		
	 	}
		catch (Exception e) {
			isStockMinus = false;
		}
		finally
		{
			
			if(resultSet != null)
			{
				try {
					resultSet.close();
					resultSet = null;
				} catch (SQLException e) {
				
				}
			}
			if(preparedStatement != null)
			{
				try {
					preparedStatement.close();
					preparedStatement = null;
				} catch (SQLException e) {
					
				}
			}
			
			
			
			
		}
		
		
		
		return isStockMinus;
		
	}
	
	
	
	
	
	public static boolean minusStockToCurrentStockForPurchase(Connection connection,  SessionMap<String, Object> sessionMap,String productId, String productName, Float productQuantity)
	{
		
		
		boolean isStockMinus = false;
		
		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");

		PreparedStatement preparedStatement= null;
		ResultSet  resultSet = null;
		
		String sql = "";
		
		
		try
		{
	
		
		float oldQuantity = 0.0F;
		float newQuantity = 0.0F;
		
		sql = "SELECT "
				+ "in_stock_quantity "			
				+ "FROM "
				+ "crusher_product_master "
				+ "WHERE "
				+ "product_id = ? "
				+ "AND "
				+ "crusher_id = ? "
				+ "AND "
				+ "crusher_code = ? ";
		
		preparedStatement = connection.prepareStatement(sql);
		
		preparedStatement.setString(1, productId);
		preparedStatement.setString(2, crusherId);
		preparedStatement.setString(3, crusherCode);

	
	
		resultSet = preparedStatement.executeQuery();
		
		if(resultSet.next())
		{
			oldQuantity = resultSet.getFloat(1);
			
		}
	
		
		newQuantity = oldQuantity - productQuantity;
		
		
		if(preparedStatement != null)
		{
			preparedStatement.close();
			preparedStatement = null;
		}
		
	
			sql = "UPDATE "
					+ "crusher_product_master "
					+ "SET "
					+ "in_stock_quantity = ? "
					+ "WHERE "
					+ "product_id = ? "
					+ "AND "
					+ "crusher_id = ? "
					+ "AND "
					+ "crusher_code = ? ";
			
			preparedStatement = connection.prepareStatement(sql);
			
			
			
			preparedStatement.setFloat(1, newQuantity);
			preparedStatement.setString(2, productId);
			preparedStatement.setString(3, crusherId);
			preparedStatement.setString(4, crusherCode);
			

			int rowCount = preparedStatement.executeUpdate();
			
			if(rowCount>0)
			{
				isStockMinus = true;
			}
			
	
		}catch (SQLException e) {
	 		e.printStackTrace();
			isStockMinus = false;
	 		
	 	}
		catch (Exception e) {
			e.printStackTrace();
			isStockMinus = false;
		}
		finally
		{
			
			if(resultSet != null)
			{
				try {
					resultSet.close();
					resultSet = null;
				} catch (SQLException e) {
				
				}
			}
			if(preparedStatement != null)
			{
				try {
					preparedStatement.close();
					preparedStatement = null;
				} catch (SQLException e) {
					
				}
			}
			
			
		}
		
		
		
		return isStockMinus;
		
	}
	
	
	
	
	public static boolean addStockToCurrentStockForPurchase(Connection connection, SessionMap<String, Object> sessionMap, String productId, String productName, Float productQuantity)
	{
		
		boolean isStockAdded = false;
		
		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");

		
		PreparedStatement updateStockPSMT= null;
		ResultSet  resultSet = null;
		
		String sql = "";
		String db = (String) sessionMap.get("db");
		
		
		try
		{
	
	
	
		float oldQuantity = 0.0F;
		float newQuantity = 0.0F;
		float stockConversionRatio = 0.0F;
	
		sql = "SELECT "
				+ "in_stock_quantity,"
				+ "stock_conversion_ratio "
				+ "FROM "
				+ "crusher_product_master "
				+ "WHERE "
				+ "product_id = ? "
				+ "AND "
				+ "crusher_id = ? "
				+ "AND "
				+ "crusher_code = ? ";
		
		updateStockPSMT = connection.prepareStatement(sql);
		
		updateStockPSMT.setString(1, productId);
		updateStockPSMT.setString(2, crusherId);
		updateStockPSMT.setString(3, crusherCode);
		

	//	System.out.println(updateStockPSMT.toString());
		
		resultSet = updateStockPSMT.executeQuery();
		
		if(resultSet.next())
		{
			oldQuantity = resultSet.getFloat(1);
			stockConversionRatio = resultSet.getFloat(2);
		}
		
		
	//	System.out.println("stockConversionRatio : "+stockConversionRatio);
		 
		newQuantity = oldQuantity + (productQuantity*stockConversionRatio); 
		
		
		 int retval = Float.compare(newQuantity, 0.0F);
		
		/*System.out.println("oldQuantity : "+oldQuantity);
		System.out.println("productQuantity : "+productQuantity);
		System.out.println("newQuantity : "+ newQuantity);*/
		
	
		
		if(resultSet != null)
		{
			resultSet.close();
			resultSet = null;
		}
		
		if(updateStockPSMT != null)
		{
			updateStockPSMT.close();
			updateStockPSMT = null;
		}
		
		if(retval>=0)
		{
		sql = "UPDATE "
				+ "crusher_product_master "
				+ "SET "
				+ "in_stock_quantity = ? "
				+ "WHERE "
				+ "product_id = ? "
				+ "AND "
				+ "crusher_id = ? "
				+ "AND "
				+ "crusher_code = ? ";
				
		
		updateStockPSMT = connection.prepareStatement(sql);
		
		
		updateStockPSMT.setFloat(1, newQuantity);
		updateStockPSMT.setString(2, productId);
		updateStockPSMT.setString(3, crusherId);
		updateStockPSMT.setString(4, crusherCode);
		

		int rowCount = updateStockPSMT.executeUpdate();
		
		if(rowCount>0)
		{			
			isStockAdded = true;
		}
		}else
		{
			isStockAdded = false;
		}
		
		}catch (SQLException e) {
	 		//e.printStackTrace();
			isStockAdded = false;
	 		
	 	}
		catch (Exception e) {
			//e.printStackTrace();
			isStockAdded = false;
		}
		finally
		{
			
			if(resultSet != null)
			{
				try {
					resultSet.close();
					resultSet = null;
				} catch (SQLException e) {
				
				}
			}
			if(updateStockPSMT != null)
			{
				try {
					updateStockPSMT.close();
					updateStockPSMT = null;
				} catch (SQLException e) {
					
				}
			}
		
			
		}
		//System.out.println(" in update isStockAdded : "+isStockAdded);
		
	
		return isStockAdded;
		
	}
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}


	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

}
