package com.stonecrusher.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class UpdateMaintenanceEntry extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -2794397468407641682L;
	private SessionMap<String,Object> sessionMap;  
	
	private String key;
	private String fromDate;
	private String toDate;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	
	private File invoiceImage;
	private Float amount;
	private String comments;
	private String entryDate;
	private String vehicleId;
	private String typeOfPayment;
	private String accountId;
	private String chequePayDate;
	private String chequePayee;
	private String bankName;
	private String branchName;
	private String chequeNumber;
	
	private List<String> paymentTypeList = new ArrayList<String>();
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeList = new ArrayList<String>();
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private String addSideBarJs;
	
	
	@Override
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{ 
		        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		String keyDetails [] = EncryptionDecryption.decrypt(this.getKey()).split("#");
				String entryId = keyDetails[0];
				String vehicleId = keyDetails[1];
				String entryDate = keyDetails[2];
				
				
				        Connection connection = null;
        		   		PreparedStatement preparedStatement= null;	
        		   		ResultSet resultSet = null;
        		   		
        		   		String sql = "";
        		   		String db = (String)  this.getSessionMap().get("db");
        				

        				String vehicleDetails [] = this.getVehicleId().split("-");
        				
                		String fullUserName = (String) this.getSessionMap().get("userFullName");
        	        	
        	        	String splitUserName [] = new String[5];
        	        	
        	        	String entryBy = "";
        	        	try
        	        	{
        	        		splitUserName = fullUserName.split(" ");
        	        		entryBy = splitUserName[0];
        	        		
        	        	}catch(Exception e)
        	        	{
        	        		entryBy =fullUserName;
        	        	}
        	        	
        	        	 java.util.Date date = new java.util.Date();
               	      long t = date.getTime();	        	     
               	      java.sql.Time time = new java.sql.Time(t); 
               	   String crditDebitId = null ;
               	int m = 0 ;
        		   		
        		   		try
        		   		{
        		   			
        		   			
							connection = GetDBConnection.getDBConnection(db);
        		   			connection.setAutoCommit(false);
        		   			
        		   			sql = "SELECT "
    	  							+ "credit_debit_id "
    	  							+ "FROM "
    	  							+ "crusher_vehicle_expense_master "
    	  							+ "WHERE "
    	    						+ "vehicle_expense_entry_id = ? "
    	    						+ "AND "
    								+ "crusher_id = ? "
    								+ "AND "
    								+ "crusher_code = ? ";
      					
      					preparedStatement = connection.prepareStatement(sql);
      					
      					    preparedStatement.setString(1, entryId);
    	    				preparedStatement.setString(2, crusherId);
    	    				preparedStatement.setString(3, crusherCode);
    	    				
      					resultSet = preparedStatement.executeQuery();
      					
      					
      					if(resultSet.next()){
      						 crditDebitId = resultSet.getString(1);
      						
      						
      						
      						if(resultSet != null)
    						{
    							resultSet.close();
    							resultSet = null;
    						}
    						if(preparedStatement != null)
    						{
    							preparedStatement.close();
    							preparedStatement = null;
    						}
    						
    						
    						sql = "SELECT "
    								+ "entry_id,"
    								+ "account_id,"
    								+ "account_number,"
    								+ "entry_date,"
    								+ "entry_time,"
    								+ "entry_type,"
    								+ "amount,"
    								+ "payment_type,"
    								+ "entry_by,"
    								+ "entry_details "
    								+ "FROM "
    								+ "bank_account_credit_debit_master "
    								+ "WHERE "
    								+ "entry_id = ? "
    								+ "AND "
    								+ "crusher_id = ? "
    								+ "AND "
    								+ "crusher_code = ? ";
    						
    						preparedStatement = connection.prepareStatement(sql);
    						preparedStatement.setString(1, crditDebitId);
    						preparedStatement.setString(2, crusherId);
    						preparedStatement.setString(3, crusherCode);

    						
    						resultSet = preparedStatement.executeQuery();
    						
    						 m = 0;
    						if(resultSet.next())
    						{
    							
    							PreparedStatement  insertIntoDeletedPSMT = null;
    							
    							String inertDeletedSQL = "INSERT "
    									+ "INTO "
    									+ "bank_account_credit_debit_updated_entry_master "
    									+ "("
    									+ "entry_id,"
    									+ "crusher_id,"
    									+ "crusher_code,"
    									+ "account_id,"
    									+ "account_number,"
    									+ "entry_date,"
    									+ "entry_time,"
    									+ "entry_type,"
    									+ "amount,"
    									+ "payment_type,"
    									+ "entry_by,"
    									+ "entry_details,"
    									+ "old_amount,"
    									+ "updated_date,"
    									+ "updated_time) "
    									+ "VALUES "
    									+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?)";
    							
    							insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
    							
    							insertIntoDeletedPSMT.setString(1, crditDebitId);
    							insertIntoDeletedPSMT.setString(2, crusherId);
    							insertIntoDeletedPSMT.setString(3, crusherCode);
    							insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
    							insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
    							insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
    							insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
    							insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
    							insertIntoDeletedPSMT.setFloat(9, this.getAmount());
    							insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
    							insertIntoDeletedPSMT.setString(11, entryBy);
    							insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
    							insertIntoDeletedPSMT.setFloat(13, resultSet.getFloat(7));
    							insertIntoDeletedPSMT.setString(14, this.getEntryDate());
    							insertIntoDeletedPSMT.setTime(15,time);
    							
    							
    							  m = insertIntoDeletedPSMT.executeUpdate();
    							  
    							  String paymentType = resultSet.getString(6);
    							  
    							  
    							  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    								Date parsedDate = null;

    								try {
    								    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
    								} catch (ParseException e) {
    								    e.printStackTrace();  
    								}

    								if (parsedDate != null) {
    								     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
    								    String formattedDate = outputDateFormat.format(parsedDate); 
    					
    								    
    							 
    							    
    							    
    							  boolean isCloseingBalMaintained = false;
    							  
    							  if (paymentType.equals("CREDIT")) {
    							   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), entryBy, connection, this.getSessionMap());
    							  }else {
    								   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), entryBy, connection, this.getSessionMap());
    								  
    							  }
    								}
    							  
    							if(insertIntoDeletedPSMT != null)
    							{
    								insertIntoDeletedPSMT.close();
    								insertIntoDeletedPSMT = null;
    							}
    							
    						}
    						
      					}
      					
      					if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(preparedStatement != null)
						{
							preparedStatement.close();
							preparedStatement = null;
						}
						
						
        		   				sql = "UPDATE "
            		   					+ "crusher_vehicle_expense_master "
            		   					+ "SET "            		   					
            		   					+ "vehicle_id=?,"
            		   					+ "exepense_date = STR_TO_DATE(?,'%d-%m-%Y'),"
            							+ "exepense_time=?,"
            		   					+ "exepense_amount=?,"
            		   					+ "entry_by=?,"
            		   					+ "consupmtion_details=? "
            		   					+ "WHERE "
            		   					+ "vehicle_expense_entry_id=? "
            		   					+ "AND "
            							+ "crusher_id = ? "
            							+ "AND "
            							+ "crusher_code = ? ";
        		   				
        		   				preparedStatement = connection.prepareStatement(sql);    
        		   				preparedStatement.setString(1, vehicleDetails[0]);
        		   				preparedStatement.setString(2, this.getEntryDate());
        		   				preparedStatement.setTime(3, time);
        		   				preparedStatement.setFloat(4, this.getAmount());
        		   				preparedStatement.setString(5, entryBy);
        		   				preparedStatement.setString(6, this.getComments().trim().toUpperCase());
        		   				preparedStatement.setString(7, entryId);
        		   				preparedStatement.setString(8, crusherId);
        						preparedStatement.setString(9, crusherCode);

        		   			
        		   		
        		   			int i = preparedStatement.executeUpdate();
    						
    						
    						if(i>0)
    						{
    							this.setVehicleId(vehicleDetails[0]);
    							
    							if(this.getInvoiceImage() != null)
    		        			{
    		        				
    		        				FileInputStream fis  = null;
    		        				fis =  new FileInputStream(this.getInvoiceImage());
    		        				
    		        				
    		        				if(preparedStatement!= null)
    		                		{
    		                			preparedStatement.close();
    		                			preparedStatement = null;
    		                		}
    		                		
    		        				
    		        				sql = "UPDATE "
    		        						+ "crusher_vehicle_expense_master "
    		        						+ "SET "
    		        						+ "expence_image = ? "
    		        						+ "WHERE "
    		        						+ "vehicle_expense_entry_id = ? "
    		        						+ "AND "
    		        						+ "vehicle_id = ? "
    		        						+ "AND "
    		        						+ "crusher_id = ? "
    		    							+ "AND "
    		    							+ "crusher_code = ?";
    		    							
    		        				
    		        				
    		        				preparedStatement = connection.prepareStatement(sql);
    		        				
    		        				preparedStatement.setBinaryStream(1, fis,(int)this.getInvoiceImage().length() );
    		        				preparedStatement.setString(2, entryId);
    		        				preparedStatement.setString(3, vehicleDetails[0]);
    		        				preparedStatement.setString(4, crusherId);
    		        				preparedStatement.setString(5, crusherCode);
    		        				
    		        				 preparedStatement.executeUpdate();
    		        				
    		        				if(fis != null)
    		        				{
    		        					fis.close();
    		        					fis = null;
    		        				}
    		        				
    		        				
    		        			}
    							if(!this.getTypeOfPayment().equals("CHEQUE") && this.getAccountId() != null && !this.getAccountId().trim().equals(""))
    		        			{
    							String accountNumber = "";
    	    	        		sql = "SELECT "
    	    	        				+ "account_number "
    	    	        				+ "FROM "
    	    	        				+ "crusher_bank_account "
    	    	        				+ "WHERE "
    	    	        				+ "account_id  = ?"
    	    	        				+ "AND "
    									+ "crusher_id = ? "
    									+ "AND "
    									+ "crusher_code = ? ";
    	    	        			
    	    	        		preparedStatement = connection.prepareStatement(sql);
    	    	        		
    	    	        		preparedStatement.setString(1, this.getAccountId());
    	    	        		preparedStatement.setString(2, crusherId);
    	    					preparedStatement.setString(3, crusherCode);
    	    					
    	    	        		resultSet = preparedStatement.executeQuery();
    	    	        		if(resultSet.next())
    	    	        		{
    	    	        			accountNumber = resultSet.getString(1);
    	    	        		}
    	    	        		

    	    	        		if(crditDebitId != null && !crditDebitId.trim().equals("") ){
    	    	        			
    	    	        			
    	    	        			sql = "SELECT "
    	    								+ "entry_id "
    	    								+ "FROM "
    	    								+ "bank_account_credit_debit_master "
    	    								+ "WHERE "
    	    	        					+ "crusher_id = ? "
    	        							+ "AND "
    	        							+ "crusher_code = ?"
    	        							+ "ORDER BY "
    	    								+ "entry_id "
    	    								+ "DESC LIMIT 1;";
    	    						
    	    					
    	    					preparedStatement = connection.prepareStatement(sql);
    	    					preparedStatement.setString(1, crusherId);
    	        				preparedStatement.setString(2, crusherCode);
    	        				
    	        				resultSet = preparedStatement.executeQuery();
    	    					
    	    					int entryAccountId = 1;
    	    				
    	    					if(resultSet.next())
    	    					{
    	    						if(!(resultSet.getString(1) == null))
    	    						{
    	    							entryAccountId = Integer.parseInt(resultSet.getString(1));
    	    							entryAccountId = entryAccountId + 1;
    	    							
    	    						}
    	    						
    	    					}
    	    					else
    	    					{	entryAccountId =1;
    	    						
    	    					}
    	    					
    	    	        		
    	            				
    	            				if(resultSet != null)
    	        	        		{
    	        	        			resultSet.close();
    	        	        			resultSet = null;
    	        	        		}
    	        	        		if(preparedStatement!= null)
    	        	        		{
    	        	        			preparedStatement.close();
    	        	        			preparedStatement = null;
    	        	        		}
    	            				
    	    	        			
    	        	        		sql = "INSERT "
    	    								+ "INTO "
    	    								+ "bank_account_credit_debit_master "
    	    								+ "("
    	    								+ "entry_id,"
    	    								+ "crusher_id,"
    	    								+ "crusher_code,"
    	    								+ "account_id,"
    	    								+ "account_number,"
    	    								+ "entry_date,"
    	    								+ "entry_time,"
    	    								+ "entry_type,"
    	    								+ "amount,"
    	    								+ "payment_type,"
    	    								+ "entry_by,"
    	    								+ "entry_details,"
    	    								+ "entry_source) "
    	    								+ "VALUES "
    	    								+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
    	    						
    	    						preparedStatement = connection.prepareStatement(sql);
    	    						
    	    						preparedStatement.setInt(1, entryAccountId);
    	    						preparedStatement.setString(2, crusherId);
    	    						preparedStatement.setString(3, crusherCode);
    	    						preparedStatement.setString(4, this.getAccountId());
    	    						preparedStatement.setString(5, accountNumber);
    	    						preparedStatement.setString(6, this.getEntryDate());
    	    						preparedStatement.setTime(7, time);
    	    						preparedStatement.setString(8, "DEBIT");
    	    						preparedStatement.setFloat(9, this.getAmount());
    	    						preparedStatement.setString(10, this.getTypeOfPayment());
    	    						preparedStatement.setString(11, entryBy);
    	    						preparedStatement.setString(12, "VEHICLE Maintenance TO VehicleRegNo "+vehicleDetails[2].trim().toUpperCase());
    	    						preparedStatement.setString(13, "VEHICLE MAINTENANCE ");
    								
    	    						int rowInsetred = preparedStatement.executeUpdate();
    	        				
    	    						
    	    						boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId(),"DEBIT", this.getEntryDate(), this.getAmount(), entryBy, connection, this.getSessionMap());
    								
    	    						if(rowInsetred > 0 && isCloseingBalMaintained)
    	    						{
    	    	        				
    	    							sql = "UPDATE "
    	        	        					+ "crusher_vehicle_expense_master "
    	        	        					+ "SET "
    	        	        					+ "credit_debit_id = ? "
    	        	        					+ "WHERE "
    	    									+ "vehicle_expense_entry_id = ? "
    	    									+ "AND "
    	    									+ "crusher_id = ? "
    	    									+ "AND "
    	    									+ "crusher_code = ? ";
    	        	        			
    	        	        			
    		    						preparedStatement = connection.prepareStatement(sql);
    		    						
    		    						preparedStatement.setInt(1, entryAccountId);
    		    						preparedStatement.setString(2, entryId);
    		    						preparedStatement.setString(3, crusherId);
    		    		        		preparedStatement.setString(4, crusherCode);
    		    		        		
    		    						int rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
    		        				
    		    						
    		    						
    		    						if(rowCreditDebitIdInsetred > 0 )
    		    						{
    		    							connection.commit();
    		    	        				result = SUCCESS;
    		    	        				addActionMessage(this.getText("message.success.vehicleMaintenance/ExpenceDetailsAddedSuccessfully"));
    		    						}
    	    						}
    	    	        		}else {
    	    	        			sql = "UPDATE "
        									+ "bank_account_credit_debit_master "
        									+ "SET "
        									+ "entry_date = STR_TO_DATE(?,'%d-%m-%Y'),"
        									+ "entry_time = ?,"
        									+ "account_id = ?,"
        									+ "account_number = ?,"
        									+ "entry_type = ?,"
        									+ "amount = ?,"
        									+ "payment_type = ?,"
        									+ "entry_by = ?,"
        									+ "entry_details = ?,"
        									+ "entry_source = ? "
        									+ "WHERE "
        									+ "entry_id = ? "
        									+ "AND "
        									+ "crusher_id = ? "
        									+ "AND "
        									+ "crusher_code = ? ";
        						
        							
        							
        							
        							preparedStatement = connection.prepareStatement(sql);
        							
        						
        							preparedStatement.setString(1, this.getEntryDate());
        							preparedStatement.setTime(2, time);
        							preparedStatement.setString(3, this.getAccountId());
        							preparedStatement.setString(4, accountNumber);
        							preparedStatement.setString(5, "DEBIT");
        							preparedStatement.setFloat(6, this.getAmount());
        							preparedStatement.setString(7, this.getTypeOfPayment());							
        							preparedStatement.setString(8, entryBy);
        							preparedStatement.setString(9, "Update VEHICLE Maintenance TO VehicleRegNo "+vehicleDetails[2].trim().toUpperCase());
        							preparedStatement.setString(10, "VEHICLE MAINTENANCE ");
        							preparedStatement.setString(11, crditDebitId);
        							preparedStatement.setString(12, crusherId);
        							preparedStatement.setString(13, crusherCode);
        							
        							int	count = preparedStatement.executeUpdate();
        							
        							boolean isCloseingBalMaintained1 = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId(),"DEBIT", this.getEntryDate(), this.getAmount(), entryBy, connection, this.getSessionMap());
        								
        							if(count > 0 && isCloseingBalMaintained1)
        							{
        								
        								sql = "UPDATE "
    	        	        					+ "crusher_vehicle_expense_master "
    	        	        					+ "SET "
    	        	        					+ "credit_debit_id = ? "
    	        	        					+ "WHERE "
    	    									+ "vehicle_expense_entry_id = ? "
    	    									+ "AND "
    	    									+ "crusher_id = ? "
    	    									+ "AND "
    	    									+ "crusher_code = ? ";
    	        	        			
    	        	        			
    		    						preparedStatement = connection.prepareStatement(sql);
    		    						
    		    						preparedStatement.setString(1, crditDebitId);
    		    						preparedStatement.setString(2, entryId);
    		    						preparedStatement.setString(3, crusherId);
    		    		        		preparedStatement.setString(4, crusherCode);
    		    		        		
    		    						int rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
    		        				
    		    						
    		    						
    		    						if(rowCreditDebitIdInsetred > 0 )
    		    						{
    		    							connection.commit();
            								result = SUCCESS;
            								 addActionMessage(this.getText("message.success.vehicleMaintenance/ExpenceDetailsUpdatedSuccessfully")); 
            							}
    		    						
        							}
        								
        		        	
    	    	        		}
    							
    							
    					
    		        			}else 
    		        			{
    		        				addActionMessage(this.getText("message.success.vehicleMaintenance/ExpenceDetailsUpdatedSuccessfully"));
    		        				connection.commit();
    		        				result = "success";
    		        			}
    		        			
    							
    						}
    						else
    						{
    							connection.rollback();
    							result = "error";
    							addActionError(this.getText("message.error.productDetailsNotUpdated"));
    						}
    								
        		   			
        		   		}catch (SQLException e) {
        		   			//e.printStackTrace();
        		   			result = "error";
        					addActionError(e.getErrorCode()+" || "+e.getMessage()+"||"+this.getText("message.error.error"));
        					
        					
        				} catch (IOException e) {
        					result = "error";
        					addActionError(e.getMessage() +" || "+e.getCause()+"|| "+this.getText("message.error.error"));
        					
        				}	finally
        	    		{
        					if(resultSet != null)
            				{
            					try {
            						resultSet.close(); resultSet = null;
            					} catch (SQLException e) {
            						
            					}
            				}
        	    			if(preparedStatement != null)
        	    			{
        	    				try {
        	    					
        	    					preparedStatement.close(); preparedStatement = null;
        						} catch (SQLException e) {
        							
        						}
        	    			}
        	    			if(connection != null)
        	    			{
        	    				try {
        	    					
        							connection.close(); connection = null;
        						} catch (SQLException e) {
        						
        						}
        	    			}
        	    			
        	    			
        	    		}
        		   		

        	}
        return result;
	}

	
	@Override
	public void validate() 
	{
		paymentTypeList.add("CASH");
    	paymentTypeList.add("UPI");
    	paymentTypeList.add("RTGS");
    	paymentTypeList.add("NEFT");
    	paymentTypeList.add("CHEQUE");
    	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));     
    	this.setAddSideBarJs("FALSE");
    	
		if(this.getEntryDate() == null || this.getEntryDate().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideCorrectEntryDate"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getVehicleId() == null || this.getVehicleId().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectVehicleDetails"));
			}
			else
			{
				try
				{
					String [] vehicleDetails = this.getVehicleId().split("-");
					
					if(vehicleDetails.length <3)
					{
						addActionError(this.getText("message.error.plzProvideCorrectVehicleDetails"));
					}
				}
				catch (Exception e) {
					addActionError(this.getText("message.error.plzProvideCorrectVehicleDetails"));
				}
			}
		}

		if(!hasActionErrors())
		{
			if(this.getAmount() == null || this.getAmount().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectAmount"));
			}
		}
		if(!hasActionErrors())
    	{
    		if(this.getTypeOfPayment() == null || this.getTypeOfPayment().equals(""))
    		{
    			addActionError(this.getText("message.error.plzProvideTypeOfPayment"));
    		}
    	}
    	
    		
		/*
		 * if(!hasActionErrors()){ if(this.getAccountId() == null ||
		 * this.getAccountId().equals("")) {
		 * addActionError(this.getText("message.error.plzSelectAccountForDebitEntry"));
		 * } }
		 */
		
		
		
		
	}
	

	


	public String getKey() {
		return key;
	}


	public void setKey(String key) {
		this.key = key;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public String getVehicleId() {
		return vehicleId;
	}


	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}


	public Map<String, String> getVehicleList() {
		return vehicleList;
	}


	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}


	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}


	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}


	public String getDownloadType() {
		return downloadType;
	}


	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public File getInvoiceImage() {
		return invoiceImage;
	}


	public void setInvoiceImage(File invoiceImage) {
		this.invoiceImage = invoiceImage;
	}


	public Float getAmount() {
		return amount;
	}


	public void setAmount(Float amount) {
		this.amount = amount;
	}


	public String getComments() {
		return comments;
	}


	public void setComments(String comments) {
		this.comments = comments;
	}


	public String getEntryDate() {
		return entryDate;
	}


	public void setEntryDate(String entryDate) {
		this.entryDate = entryDate;
	}


	public String getTypeOfPayment() {
		return typeOfPayment;
	}


	public void setTypeOfPayment(String typeOfPayment) {
		this.typeOfPayment = typeOfPayment;
	}


	public String getAccountId() {
		return accountId;
	}


	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}


	public String getChequePayDate() {
		return chequePayDate;
	}


	public void setChequePayDate(String chequePayDate) {
		this.chequePayDate = chequePayDate;
	}


	public String getChequePayee() {
		return chequePayee;
	}


	public void setChequePayee(String chequePayee) {
		this.chequePayee = chequePayee;
	}


	public String getBankName() {
		return bankName;
	}


	public void setBankName(String bankName) {
		this.bankName = bankName;
	}


	public String getBranchName() {
		return branchName;
	}


	public void setBranchName(String branchName) {
		this.branchName = branchName;
	}


	public String getChequeNumber() {
		return chequeNumber;
	}


	public void setChequeNumber(String chequeNumber) {
		this.chequeNumber = chequeNumber;
	}


	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}


	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}


	public List<String> getBankList() {
		return bankList;
	}


	public void setBankList(List<String> bankList) {
		this.bankList = bankList;
	}


	public List<String> getBranchList() {
		return branchList;
	}


	public void setBranchList(List<String> branchList) {
		this.branchList = branchList;
	}


	public List<String> getChequeList() {
		return chequeList;
	}


	public void setChequeList(List<String> chequeList) {
		this.chequeList = chequeList;
	}


	public Map<String, String> getAccountList() {
		return accountList;
	}


	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0; 
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}


	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	
	
	
	
	
	
}