package com.stonecrusher.update;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetTypeOfPaymentList;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class UpdateCustomerPaymentDetails extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1968020061798208780L;
	
	
	private SessionMap<String,Object> sessionMap;  
	
	private HttpSession session;
	private String key;
	private String paymentDate;
	private String custName;
	private Float totalAmount;
	private String paymentDetails;
	private String outstandingAmount;
	private boolean sendSMS;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private String outStandingAmtWithoutPayment;
	private String paymentId;
	private String fromDate;
	private String toDate;
	private String custMobile;
	private String accountId1;
	private String typeOfPayment1;
	private Float amount1;
	
	private String accountId2;
	private String typeOfPayment2;
	private Float amount2;
	
	
	private List<String> paymentTypeList = new ArrayList<String>();
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	
	private boolean paymentSaved;
	
	
	@SuppressWarnings({ "static-access", "null" })
	public String execute() throws IOException{
		 
		String result = "login";

        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
        	addActionMessage(this.getText("message.error.plzloginfirst"));
        	result = "login";
        }  
        else{
	        	
	        	customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        	
				String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				String customerMobileNumber="";
					try
					{
						
						String user = (String) session.getAttribute("userFullName");
						String userName = "";
						
						try
						{
							userName = user.split(" ")[0];
						}catch(Exception e)
						{
							userName = user;
						}
						
						java.util.Date date = new java.util.Date();
			      	      long t = date.getTime();	        	     
			      	      java.sql.Time time = new java.sql.Time(t);
						
						String custDetails [] = new String [5];
						String custId = "";
						String custName = "";
						try
						{
							custDetails = this.getCustName().split("-");
							custId = custDetails[0];
							custName = custDetails[1];
						}catch(Exception e)
						{
							addActionError(this.getText("message.error.errorWhilegettingCustomerId"));
						}
						
						
						
						connection = new GetDBConnection().getDBConnection(db);
						connection.setAutoCommit(false);

	    				sql = "SELECT "
  							+ "account1_credit_debit_id,"
  							+ "account2_credit_debit_id "
  							+ "FROM "
  							+ "crusher_customer_payment_details_master "
  							+ "WHERE "
    						+ "payement_entry_id = ? "
    						+ "AND "
    						+ "customer_id = ? "
    						+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, this.getPaymentId());
    				preparedStatement.setString(2, custId);
    				preparedStatement.setString(3, crusherId);
    				preparedStatement.setString(4, crusherCode);
    				
					resultSet = preparedStatement.executeQuery();
					
					
					if(resultSet.next()){
						String acc1CrditDebitId = resultSet.getString(1);
						String acc2CrditDebitId = resultSet.getString(2);
						
						
						
						if(acc1CrditDebitId != null && !acc1CrditDebitId.equals("") )
						{
							
							

							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							
						sql = "SELECT "
								+ "entry_id,"
								+ "account_id,"
								+ "account_number,"
								+ "entry_date,"
								+ "entry_time,"
								+ "entry_type,"
								+ "amount,"
								+ "payment_type,"
								+ "entry_by,"
								+ "entry_details "
								+ "FROM "
								+ "bank_account_credit_debit_master "
								+ "WHERE "
								+ "entry_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, acc1CrditDebitId);
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);

						
						resultSet = preparedStatement.executeQuery();
						boolean isCloseingBalMaintained = false;
						
						if(resultSet.next())
						{
							
							PreparedStatement  insertIntoDeletedPSMT = null;
							
							String inertDeletedSQL = "INSERT "
									+ "INTO "
									+ "bank_account_credit_debit_updated_entry_master "
									+ "("
									+ "entry_id,"
									+ "crusher_id,"
									+ "crusher_code,"
									+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details,"
									+ "old_amount,"
									+ "updated_date,"
									+ "updated_time) "
									+ "VALUES "
									+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?)";
							
							insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
							
							insertIntoDeletedPSMT.setString(1, acc1CrditDebitId);
							insertIntoDeletedPSMT.setString(2, crusherId);
							insertIntoDeletedPSMT.setString(3, crusherCode);
							insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
							insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
							insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
							insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
							insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
							insertIntoDeletedPSMT.setFloat(9, this.getAmount1());
							insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
							insertIntoDeletedPSMT.setString(11, userName);
							insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
							insertIntoDeletedPSMT.setFloat(13, resultSet.getFloat(7));
							insertIntoDeletedPSMT.setString(14, this.getPaymentDate());
							insertIntoDeletedPSMT.setTime(15,time);
							
							
							int m = insertIntoDeletedPSMT.executeUpdate();
							  
							  String paymentType = resultSet.getString(6);
							  
							  
							  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
								Date parsedDate = null;

								try {
								    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
								} catch (ParseException e) {
								    e.printStackTrace();  
								}

								if (parsedDate != null) {
								     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
								    String formattedDate = outputDateFormat.format(parsedDate); 
					
								    
							 
							    
								    
							 
							  if (paymentType.equals("CREDIT")) {
							   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), userName, connection, this.getSessionMap());
							  }else {
								   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), userName, connection, this.getSessionMap());
								  
							  }
								}
							  
							if(insertIntoDeletedPSMT != null)
							{
								insertIntoDeletedPSMT.close();
								insertIntoDeletedPSMT = null;
							}
							
							if(isCloseingBalMaintained)
							{
								

								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
								
							sql = "DELETE "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, acc1CrditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							int k = preparedStatement.executeUpdate();
							
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							sql = "UPDATE "
    	        					+ "crusher_customer_payment_details_master "
    	        					+ "SET "
    	        					+ "account1_credit_debit_id = ? "
    	        					+ "WHERE "
    			        			+ "payement_entry_id = ? "
    			        			+ "AND "
    			        			+ "crusher_id = ? "
    								+ "AND "
    								+ "crusher_code = ?";
    	        			
    	        			
    						preparedStatement = connection.prepareStatement(sql);
    						
    						preparedStatement.setString(1, null);
    						preparedStatement.setString(2,this.getPaymentId());   
    			        	preparedStatement.setString(3, crusherId);
    						preparedStatement.setString(4, crusherCode);
							
    						 preparedStatement.executeUpdate();
	        				
    						
							
							}
						}
						
						}
						
						
						
						if(acc2CrditDebitId != null && !acc2CrditDebitId.equals("") )
						{
							

							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							
						sql = "SELECT "
								+ "entry_id,"
								+ "account_id,"
								+ "account_number,"
								+ "entry_date,"
								+ "entry_time,"
								+ "entry_type,"
								+ "amount,"
								+ "payment_type,"
								+ "entry_by,"
								+ "entry_details "
								+ "FROM "
								+ "bank_account_credit_debit_master "
								+ "WHERE "
								+ "entry_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, acc2CrditDebitId);
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);

						
						resultSet = preparedStatement.executeQuery();
						boolean isCloseingBalMaintained = false;
						
						if(resultSet.next())
						{
							
							PreparedStatement  insertIntoDeletedPSMT = null;
							
							String inertDeletedSQL = "INSERT "
									+ "INTO "
									+ "bank_account_credit_debit_updated_entry_master "
									+ "("
									+ "entry_id,"
									+ "crusher_id,"
									+ "crusher_code,"
									+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details,"
									+ "old_amount,"
									+ "updated_date,"
									+ "updated_time) "
									+ "VALUES "
									+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?)";
							
							insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
							
							insertIntoDeletedPSMT.setString(1, acc2CrditDebitId);
							insertIntoDeletedPSMT.setString(2, crusherId);
							insertIntoDeletedPSMT.setString(3, crusherCode);
							insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
							insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
							insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
							insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
							insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
							if(this.getAmount2() == null || this.getAmount2().equals(""))
							{
								insertIntoDeletedPSMT.setString(9, "0");
							}else {
								insertIntoDeletedPSMT.setFloat(9, this.getAmount2());
							}
							insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
							insertIntoDeletedPSMT.setString(11, userName);
							insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
							insertIntoDeletedPSMT.setFloat(13, resultSet.getFloat(7));
							insertIntoDeletedPSMT.setString(14, this.getPaymentDate());
							insertIntoDeletedPSMT.setTime(15,time);
							
							
							int m = insertIntoDeletedPSMT.executeUpdate();
							  
							  String paymentType = resultSet.getString(6);
							  
							  
							  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
								Date parsedDate = null;

								try {
								    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
								} catch (ParseException e) {
								    e.printStackTrace();  
								}

								if (parsedDate != null) {
								     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
								    String formattedDate = outputDateFormat.format(parsedDate); 
					
								    
							 
							    
								    
							 
							  if (paymentType.equals("CREDIT")) {
							   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), userName, connection, this.getSessionMap());
							  }else {
								   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), userName, connection, this.getSessionMap());
								  
							  }
								}
							  
							if(insertIntoDeletedPSMT != null)
							{
								insertIntoDeletedPSMT.close();
								insertIntoDeletedPSMT = null;
							}
							
							if(isCloseingBalMaintained)
							{
								

								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
								
							sql = "DELETE "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, acc2CrditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							int k = preparedStatement.executeUpdate();
							
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							sql = "UPDATE "
    	        					+ "crusher_customer_payment_details_master "
    	        					+ "SET "
    	        					+ "account2_credit_debit_id = ? "
    	        					+ "WHERE "
    			        			+ "payement_entry_id = ? "
    			        			+ "AND "
    			        			+ "crusher_id = ? "
    								+ "AND "
    								+ "crusher_code = ?";
    	        			
    	        			
    						preparedStatement = connection.prepareStatement(sql);
    						
    						preparedStatement.setString(1, null);
    						preparedStatement.setString(2,this.getPaymentId());   
    			        	preparedStatement.setString(3, crusherId);
    						preparedStatement.setString(4, crusherCode);
							
    						 preparedStatement.executeUpdate();
	        				
    						
							
							}
						}
						
						}
						
						
						
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(preparedStatement != null)
						{
							preparedStatement.close();
							preparedStatement = null;
						}
				
						sql = "select mobile_number "
								+ "from "
								+ "crusher_customer_master "
								+ "where "
								+ "customer_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, custId);
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);

						resultSet = preparedStatement.executeQuery();
						
						if(resultSet.next())
						{
							customerMobileNumber = resultSet.getString(1);
						}
						
						sql = "UPDATE  "
								+ "crusher_customer_payment_details_master "
								+ "SET "
								+ "payment_date = STR_TO_DATE(?,'%d-%m-%Y'),"
								+ "customer_id = ?,"
								+ "customer_name = ?,"
								+ "amount = ?,"
								+ "payemnt_details = ?,"
								+ "payment_entry_by = ?,"
								+ "payment_type1 = ?,"
								+ "amount_debit_account1_id = ?,"
								+ "account1_amount = ?,"
								+ "payment_type2 = ?,"
								+ "amount_debit_account2_id = ?,"
								+ "account2_amount = ? "
								+ "WHERE "
								+ "payement_entry_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
								
						
						
						if(preparedStatement != null)
						{
							preparedStatement.close();
							preparedStatement = null;
						}
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, getPaymentDate());
						preparedStatement.setString(2, custId);
						preparedStatement.setString(3, custName);
						preparedStatement.setFloat(4, getTotalAmount());
						preparedStatement.setString(5, getPaymentDetails());
						preparedStatement.setString(6, userName);
						preparedStatement.setString(7, this.getTypeOfPayment1());
						preparedStatement.setString(8, this.getAccountId1());
						preparedStatement.setFloat(9, this.getAmount1());
						if(this.getTypeOfPayment2() == null || this.getTypeOfPayment2().equals(""))
						{
							preparedStatement.setString(10, null);
						}else {
							preparedStatement.setString(10, this.getTypeOfPayment2());
						}
						
						if(this.getAccountId2() == null || this.getAccountId2().equals(""))
						{
							preparedStatement.setString(11, null);
						}else{
							preparedStatement.setString(11, this.getAccountId2());
						}
						
						if(this.getAmount2() == null || this.getAmount2().equals(""))
						{
							preparedStatement.setString(12, null);
						}else {
							preparedStatement.setFloat(12, this.getAmount2());
						}
						
						preparedStatement.setString(13, this.getPaymentId());
						preparedStatement.setString(14, crusherId);
						preparedStatement.setString(15, crusherCode);

						int rowsInserted = preparedStatement.executeUpdate();
						
						if(rowsInserted>0)
						{
							
							if(resultSet != null)
	    	        		{
	    	        			resultSet.close();
	    	        			resultSet = null;
	    	        		}
	    	        		
	    	        		
							if(!this.getTypeOfPayment1().equals("CHEQUE") && !this.getTypeOfPayment2().equals("CHEQUE") )
		        			{
								   
								
								if(this.getAccountId1() != null && !this.getAccountId1().equals("") && this.getTypeOfPayment1() != null && !this.getTypeOfPayment1().equals(""))
					    		{
									
									sql = "SELECT "
											+ "entry_id "
											+ "FROM "
											+ "bank_account_credit_debit_master "
											+ "WHERE "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? "
											+ "ORDER BY "
											+ "entry_id "
											+ "DESC LIMIT 1;";
									
								
								preparedStatement = connection.prepareStatement(sql);
								preparedStatement.setString(1, crusherId);
								preparedStatement.setString(2, crusherCode);
								
								resultSet = preparedStatement.executeQuery();
								
								
								int bankEntryId = 1;
							
								if(resultSet.next())
								{
									if(!(resultSet.getString(1) == null))
									{
										bankEntryId = Integer.parseInt(resultSet.getString(1));
										bankEntryId = bankEntryId + 1;
										
									}
									
								}
								else
								{	bankEntryId =1;
									
								}
								
				        		if(resultSet != null)
				        		{
				        			resultSet.close();
				        			resultSet = null;
				        		}
				        		if(preparedStatement!= null)
				        		{
				        			preparedStatement.close();
				        			preparedStatement = null;
				        		}
				        		
				        		
							String accountNumber = "";
	    	        		sql = "SELECT "
	    	        				+ "account_number "
	    	        				+ "FROM "
	    	        				+ "crusher_bank_account "
	    	        				+ "WHERE "
	    	        				+ "account_id  = ?"
	    	        				+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
	    	        			
	    	        		preparedStatement = connection.prepareStatement(sql);
	    	        		
	    	        		preparedStatement.setString(1, this.getAccountId1());
	    	        		preparedStatement.setString(2, crusherId);
	    					preparedStatement.setString(3, crusherCode);
	    					
	    	        		resultSet = preparedStatement.executeQuery();
	    	        		if(resultSet.next())
	    	        		{
	    	        			accountNumber = resultSet.getString(1);
	    	        		}
	    	        		

							
	    	        		sql = "INSERT "
									+ "INTO "
									+ "bank_account_credit_debit_master "
									+ "("
									+ "entry_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details,"
									+ "entry_source) "
									+ "VALUES "
									+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setInt(1, bankEntryId);
							preparedStatement.setString(2, crusherId);
			        		preparedStatement.setString(3, crusherCode);
			        		preparedStatement.setString(4, this.getAccountId1());
							preparedStatement.setString(5, accountNumber);
							preparedStatement.setString(6, this.getPaymentDate());
							preparedStatement.setTime(7, time);
							preparedStatement.setString(8, "CREDIT");
							preparedStatement.setFloat(9, this.getAmount1());
							preparedStatement.setString(10, this.getTypeOfPayment1());
							preparedStatement.setString(11, userName);
							preparedStatement.setString(12, "PAID BY "+this.getCustName()+" Against Outstanding amount: "+this.getOutstandingAmount());
							preparedStatement.setString(13, "CUSTOMER PAYMENT ");
							
							int count = preparedStatement.executeUpdate();
							
							boolean isCloseingBalMaintained1 = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId1(),"CREDIT", this.getPaymentDate(), this.getAmount1(), userName, connection, this.getSessionMap());
								
							if(count > 0 && isCloseingBalMaintained1)
							{
								
								sql = "UPDATE "
        	        					+ "crusher_customer_payment_details_master "
        	        					+ "SET "
        	        					+ "account1_credit_debit_id = ? "
        	        					+ "WHERE "
    									+ "payement_entry_id = ? "
    									+ "AND "
    									+ "crusher_id = ? "
    									+ "AND "
    									+ "crusher_code = ? ";
        	        			
        	        			
	    						preparedStatement = connection.prepareStatement(sql);
	    						
	    						preparedStatement.setInt(1, bankEntryId);
	    						preparedStatement.setString(2, this.getPaymentId());
	    						preparedStatement.setString(3, crusherId);
	    		        		preparedStatement.setString(4, crusherCode);
	    		        		preparedStatement.executeUpdate();
	    		        		
	    		        		
								connection.commit();
								result = "success";
								addActionMessage(this.getText("message.success.customerPaymentDetailsUpdatedSuccessfully"));
							}
		        			}
								
								if(this.getAccountId2() != null && !this.getAccountId2().equals("") && this.getTypeOfPayment2() != null && !this.getTypeOfPayment2().equals(""))
					    		{
									
									sql = "SELECT "
											+ "entry_id "
											+ "FROM "
											+ "bank_account_credit_debit_master "
											+ "WHERE "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? "
											+ "ORDER BY "
											+ "entry_id "
											+ "DESC LIMIT 1;";
									
								
								preparedStatement = connection.prepareStatement(sql);
								preparedStatement.setString(1, crusherId);
								preparedStatement.setString(2, crusherCode);
								
								resultSet = preparedStatement.executeQuery();
								
								
								int bankEntryId = 1;
							
								if(resultSet.next())
								{
									if(!(resultSet.getString(1) == null))
									{
										bankEntryId = Integer.parseInt(resultSet.getString(1));
										bankEntryId = bankEntryId + 1;
										
									}
									
								}
								else
								{	bankEntryId =1;
									
								}
								
				        		if(resultSet != null)
				        		{
				        			resultSet.close();
				        			resultSet = null;
				        		}
				        		if(preparedStatement!= null)
				        		{
				        			preparedStatement.close();
				        			preparedStatement = null;
				        		}
				        		
							String accountNumber = "";
	    	        		sql = "SELECT "
	    	        				+ "account_number "
	    	        				+ "FROM "
	    	        				+ "crusher_bank_account "
	    	        				+ "WHERE "
	    	        				+ "account_id  = ?"
	    	        				+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
	    	        			
	    	        		preparedStatement = connection.prepareStatement(sql);
	    	        		
	    	        		preparedStatement.setString(1, this.getAccountId2());
	    	        		preparedStatement.setString(2, crusherId);
	    					preparedStatement.setString(3, crusherCode);
	    					
	    	        		resultSet = preparedStatement.executeQuery();
	    	        		if(resultSet.next())
	    	        		{
	    	        			accountNumber = resultSet.getString(1);
	    	        		}
	    	        		

							
	    	        		sql = "INSERT "
									+ "INTO "
									+ "bank_account_credit_debit_master "
									+ "("
									+ "entry_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details,"
									+ "entry_source) "
									+ "VALUES "
									+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setInt(1, bankEntryId);
							preparedStatement.setString(2, crusherId);
			        		preparedStatement.setString(3, crusherCode);
			        		preparedStatement.setString(4, this.getAccountId2());
							preparedStatement.setString(5, accountNumber);
							preparedStatement.setString(6, this.getPaymentDate());
							preparedStatement.setTime(7, time);
							preparedStatement.setString(8, "CREDIT");
							preparedStatement.setFloat(9, this.getAmount2());
							preparedStatement.setString(10, this.getTypeOfPayment2());
							preparedStatement.setString(11, userName);
							preparedStatement.setString(12, "PAID BY "+this.getCustName()+" Against Outstanding amount: "+this.getOutstandingAmount());
							preparedStatement.setString(13, "CUSTOMER PAYMENT ");
							
							int count = preparedStatement.executeUpdate();
							
							boolean isCloseingBalMaintained1 = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId2(),"CREDIT", this.getPaymentDate(), this.getAmount2(), userName, connection, this.getSessionMap());
								
							if(count > 0 && isCloseingBalMaintained1)
							{
								
									
									sql = "UPDATE "
	        	        					+ "crusher_customer_payment_details_master "
	        	        					+ "SET "
	        	        					+ "account2_credit_debit_id = ? "
	        	        					+ "WHERE "
	    									+ "payement_entry_id = ? "
	    									+ "AND "
	    									+ "crusher_id = ? "
	    									+ "AND "
	    									+ "crusher_code = ? ";
	        	        			
	        	        			
		    						preparedStatement = connection.prepareStatement(sql);
		    						
		    						preparedStatement.setInt(1, bankEntryId);
		    						preparedStatement.setString(2, this.getPaymentId());
		    						preparedStatement.setString(3, crusherId);
		    		        		preparedStatement.setString(4, crusherCode);
		    		        		
		    		        		preparedStatement.executeUpdate();
								
							
								connection.commit();
								result = "success";
								addActionMessage(this.getText("message.success.customerPaymentDetailsUpdatedSuccessfully"));
							}
		        			}
								
								
		        			}else {
		        				
		        				
		        				
		        				
		    					connection.commit();
								result = SUCCESS;
								 addActionMessage(this.getText("message.success.customerPaymentDetailsUpdatedSuccessfully"));
		    				
		        				 
							}
							
							this.setPaymentSaved(true);
		       				
		        		}
						else
						{
							connection.rollback();
							result = "error";
							addActionError(this.getText("message.error.errorPaymentDetailsNotUpdatedPlzTryAgain"));
						}
						this.setKey(this.getKey());
					     
					
					     
	  						
	  					}
							
							
							
						
					}catch (SQLException e) {
						result = "error";
						e.printStackTrace();
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.customerPaymentDetailsNotUpdated"));
					} catch (Exception e) {
						e.printStackTrace();
						result = "error";						
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.customerPaymentDetailsNotUpdated"));
					}finally {
						if(resultSet != null)
		   				{
		   					try {resultSet.close();}catch(SQLException sqe){}   					
		   				}
						if(preparedStatement != null)
						{
							try {preparedStatement.close();} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close();}catch (SQLException e) {}
						}
						
					}
	        	
	        	
	        	
	        	
	        }
	        return result;
	}
	
	@Override
	public void validate() {
		
		session=ServletActionContext.getRequest().getSession(false);
    	
		this.setPaymentTypeList(GetTypeOfPaymentList.getPaymentTypeList());
		   
    	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));     
    	

		if(this.getTotalAmount() == null || this.getTotalAmount().equals("")){
			addActionError(this.getText("message.error.plzProvideAmount"));
		}
		
		
		if(this.getAmount1() == null || this.getAmount1().equals("")){
			addActionError(this.getText("message.error.plzProvideAmount")+"1");
		}
		
		if(!hasActionErrors()){
    		if(this.getAccountId1() == null || this.getAccountId1().equals(""))
    		{
    			addActionError(this.getText("message.error.plzSelectAccount")+"1");
    		}
    	}
		
		if(!hasActionErrors()){
    		if(this.getAccountId1() != null || !this.getAccountId1().equals(""))
    		{
    			if(this.getTypeOfPayment1() == null || this.getTypeOfPayment1().equals("")){
    				addActionError("Please Provide Type Of Payment 1");
    			}
    			
    			
    		}
    	}
		
		
		if (!hasActionErrors()) {
		    if (this.getAccountId1() != null && this.getAccountId2() != null &&
		        this.getAccountId1().equals(this.getAccountId2())) {
		        
		        addActionError("Account 1 and Account 2 cannot be the same. Please select different accounts.");
		    }
		}
    		
    		
		if(!hasActionErrors()){
    		if(this.getAccountId2().trim() != null && !this.getAccountId2().trim().equals(""))
    		{
    			
    			if(this.getTypeOfPayment2() == null || this.getTypeOfPayment2().equals("")){
    				addActionError("Please Provide Type Of Payment 2");
    			}
    			
    			if(this.getAmount2() == null || this.getAmount2().equals("")){
    				addActionError(this.getText("message.error.plzProvideAmount")+"2");
    			}
    		}
    	}
		

		if (!hasActionErrors()) {
		    double amt1 = this.getAmount1() != null ? this.getAmount1() : 0;
		    double amt2 = this.getAmount2() != null ? this.getAmount2() : 0;
		    double totalAmt = this.getTotalAmount() != null ? this.getTotalAmount() : 0;

		    if ((amt1 + amt2) != totalAmt) {
		        addActionError("Total of Amount Received (Amount1 + Amount2) must be equal to Total Amount.");
		    }
		}

		
		
		if(!hasActionErrors())
		{
			if(!getTotalAmount().equals(""))
			{
				float floatAmt = 0.0F;
				float floatOutstandingAmt  = Float.parseFloat(getOutStandingAmtWithoutPayment());
				try
				
				{
					floatAmt = getTotalAmount();
					
					if(floatAmt < 0)
					{
						addActionError(this.getText("message.error.amountCannotBeLessThan0"));
					}
					
					else
					{
						float accepatblePaymentAmount = 0.0F;
						
						accepatblePaymentAmount = floatOutstandingAmt - floatAmt;
						
						if(accepatblePaymentAmount <0)
						{
							addActionError(this.getText("message.error.amountCannotBeGreaterThanTotalOutstandingAmount"));
						}
						
					}
				}
				catch(NumberFormatException nfe)
				{
					addActionError(this.getText("message.error.plzProvideCorrectAmountToAddDetails"));
				}
			}
		}
	}
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public String getKey() {
		return key;
	}
	public void setKey(String key) {
		this.key = key;
	}
	public String getPaymentDate() {
		return paymentDate;
	}
	public void setPaymentDate(String paymentDate) {
		this.paymentDate = paymentDate;
	}
	public String getCustName() {
		return custName;
	}
	public void setCustName(String custName) {
		this.custName = custName;
	}
	

	public Float getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(Float totalAmount) {
		this.totalAmount = totalAmount;
	}

	public String getPaymentDetails() {
		return paymentDetails;
	}
	public void setPaymentDetails(String paymentDetails) {
		this.paymentDetails = paymentDetails;
	}

	public String getOutstandingAmount() {
		return outstandingAmount;
	}

	public void setOutstandingAmount(String outstandingAmount) {
		this.outstandingAmount = outstandingAmount;
	}

	public boolean isSendSMS() {
		return sendSMS;
	}

	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getOutStandingAmtWithoutPayment() {
		return outStandingAmtWithoutPayment;
	}

	public void setOutStandingAmtWithoutPayment(String outStandingAmtWithoutPayment) {
		this.outStandingAmtWithoutPayment = outStandingAmtWithoutPayment;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getPaymentId() {
		return paymentId;
	}

	public void setPaymentId(String paymentId) {
		this.paymentId = paymentId;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public String getCustMobile() {
		return custMobile;
	}

	public void setCustMobile(String custMobile) {
		this.custMobile = custMobile;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	

	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public boolean isPaymentSaved() {
		return paymentSaved;
	}

	public void setPaymentSaved(boolean paymentSaved) {
		this.paymentSaved = paymentSaved;
	}

	public String getAccountId1() {
		return accountId1;
	}

	public void setAccountId1(String accountId1) {
		this.accountId1 = accountId1;
	}

	public String getTypeOfPayment1() {
		return typeOfPayment1;
	}

	public void setTypeOfPayment1(String typeOfPayment1) {
		this.typeOfPayment1 = typeOfPayment1;
	}

	public Float getAmount1() {
		return amount1;
	}

	public void setAmount1(Float amount1) {
		this.amount1 = amount1;
	}

	public String getAccountId2() {
		return accountId2;
	}

	public void setAccountId2(String accountId2) {
		this.accountId2 = accountId2;
	}

	public String getTypeOfPayment2() {
		return typeOfPayment2;
	}

	public void setTypeOfPayment2(String typeOfPayment2) {
		this.typeOfPayment2 = typeOfPayment2;
	}

	public Float getAmount2() {
		return amount2;
	}

	public void setAmount2(Float amount2) {
		this.amount2 = amount2;
	}
	
	
	
	
	

}
