package com.stonecrusher.update;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class UpdateCustOpeningBalance extends ActionSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8548225641825790549L;
	
	
	private String key;
	private String custName;
	private String openingBalanceDate;
	private Float amount;
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	
	
	private HttpSession session;
	
	public String execute() {
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
				String crusherCode = (String) session.getAttribute("crusherCode");

	        	customerSearchOptionList.put("BYNAME", "BY NAME");
				customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
				customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setDefaultValue("BYNAME");
				setCustomerSearchOption("BYNAME");
				
				
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				String custId = EncryptionDecryption.decrypt(key);
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				
				String fullUserName = (String) session.getAttribute("userFullName");
	        	
	        	String splitUserName [] = new String[5];
	        	
	        	String updatedBy = "";
	        	try
	        	{
	        		splitUserName = fullUserName.split(" ");
	        		updatedBy = splitUserName[0];
	        		
	        	}catch(Exception e)
	        	{
	        		updatedBy =fullUserName;
	        	}
	        	
	        	
	        	boolean isSuccess = false;
	        
				
				try
				{
					
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "SELECT "
							+ "* "
							+ "FROM "
							+ "crusher_cust_close_open_bal_master "
							+ "WHERE "
							+ "customer_id = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";

					
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, custId);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);

					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{
						
						PreparedStatement updatePSMT = null;
					
						String updateSQL = "UPDATE "
								+ "crusher_cust_close_open_bal_master "
								+ "SET "
								+ "opening_balance_date = STR_TO_DATE(?,'%d-%m-%Y'),"
								+ "opening_balance = ?,"
								+ "updated_by = ? "
								+ "WHERE "
								+ "customer_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						
						updatePSMT = connection.prepareStatement(updateSQL);
						
						updatePSMT.setString(1, this.getOpeningBalanceDate());
						updatePSMT.setFloat(2, this.getAmount());
						updatePSMT.setString(3, updatedBy);
						updatePSMT.setString(4, custId);
						updatePSMT.setString(5, crusherId);
						updatePSMT.setString(6, crusherCode);

						int rowCount = updatePSMT.executeUpdate();
						
						if(updatePSMT != null)
						{
							updatePSMT.close();
							updatePSMT = null;
						}
						if(rowCount > 0 )
						{
							isSuccess = true;
						}
						
					}
					else
					{
						PreparedStatement insertPSMT = null;
						String insertSQL = "INSERT INTO "
								+ "crusher_cust_close_open_bal_master "
								+ "(customer_id,"
								+ "crusher_id,"
								+ "crusher_code,"
								+ "customer_name,"
								+ "opening_balance_date,"
								+ "opening_balance,"
								+ "closeing_balance_date,"
								+ "closeing_balance,"
								+ "updated_by) "
								+ "VALUES (?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,STR_TO_DATE(?,'%d-%m-%Y'),?,?)";
						
						
						insertPSMT = connection.prepareStatement(insertSQL);
						
						insertPSMT.setString(1, custId);
						insertPSMT.setString(2, crusherId);
						insertPSMT.setString(3, crusherCode);
						insertPSMT.setString(4, this.getCustName());
						insertPSMT.setString(5, this.getOpeningBalanceDate());
						insertPSMT.setFloat(6, this.getAmount());
						insertPSMT.setString(7, this.getOpeningBalanceDate());
						insertPSMT.setFloat(8, this.getAmount());
						insertPSMT.setString(9, updatedBy);
						
						
						int rowInserted = insertPSMT.executeUpdate();
						
						if(rowInserted > 0 )
						{
							isSuccess = true;
						}
						
						
						
						if(insertPSMT != null)
						{
							insertPSMT.close();
							insertPSMT = null;
						}
						
					}
					
					
					if(isSuccess)
					{
						result = "success";
						addActionMessage(this.getText("message.success.detailsUpdatedSuccessfully"));
					}
					else
					{
						result = "error";
						addActionError(this.getText("message.error.detailsNotUpdatedPlzTryAgain"));
					}
					
				}catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" ||"+this.getText("message.error.detailsNotUpdated"));
				} catch (IOException e) {
					
					result = "error";					
					addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.detailsNotUpdated"));
				}finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
				
				
				
				
	        	
	        }
	        
	
	
	 return result;
	 
	}
	
	@Override
	public void validate() {
	
		
		customerSearchOptionList.put("BYNAME", "BY NAME");
		customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
		customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
		setDefaultValue("BYNAME");
		setCustomerSearchOption("BYNAME");
		
		if(this.getOpeningBalanceDate().equals(""))
		{
			
			addActionError(this.getText("message.error.plzProvideOpeningBalanceDate"));
		}
		
		if(!hasActionErrors())			
		{
			if(this.getAmount() == null || this.getAmount().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectAmount"));
			}
		}
	}
	
	

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getCustName() {
		return custName;
	}

	public void setCustName(String custName) {
		this.custName = custName;
	}

	public String getOpeningBalanceDate() {
		return openingBalanceDate;
	}

	public void setOpeningBalanceDate(String openingBalanceDate) {
		this.openingBalanceDate = openingBalanceDate;
	}

	
	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Float getAmount() {
		return amount;
	}

	public void setAmount(Float amount) {
		this.amount = amount;
	}
	
	
	

}

