package com.stonecrusher.update;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class UpdateBankAccountOpeningBalance extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 4319370706821205910L;
	private String key;
	private String openingBalanceDate;
	private Float amount;
	private String accountHolderName;
	private String accountNumber;
	private String bankName;
	private SessionMap<String,Object> sessionMap;  
	
	private Float oldBalance;
	
	private HttpSession session;
	
	public String execute() {
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
				String crusherCode = (String) session.getAttribute("crusherCode");

	        	
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String accountId = EncryptionDecryption.decrypt(this.getKey());
				
	        	String sql = "";
				String db = (String) session.getAttribute("db");
				
				
				String fullUserName = (String) session.getAttribute("userFullName");
	        	
	        	String splitUserName [] = new String[5];
	        	
	        	String updatedBy = "";
	        	try
	        	{
	        		splitUserName = fullUserName.split(" ");
	        		updatedBy = splitUserName[0];
	        		
	        	}catch(Exception e)
	        	{
	        		updatedBy =fullUserName;
	        	}
	        	
	        	
	        	boolean isSuccess = false;
	        
				
				try
				{
					
					connection = GetDBConnection.getDBConnection(db);
					
					
						
						String updateSQL = "UPDATE "
								+ "crusher_bank_account "
								+ "SET "
								+ "updated_date = STR_TO_DATE(?,'%d-%m-%Y'),"
								+ "opening_balance = ?,"
								+ "updated_by = ? "
								+ "WHERE "
								+ "account_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						
						preparedStatement = connection.prepareStatement(updateSQL);
						
						preparedStatement.setString(1, this.getOpeningBalanceDate());
						preparedStatement.setFloat(2, this.getAmount());
						preparedStatement.setString(3, updatedBy);
						preparedStatement.setString(4, accountId);
						preparedStatement.setString(5, crusherId);
						preparedStatement.setString(6, crusherCode);

						int rowCount = preparedStatement.executeUpdate();
						
						
						if(rowCount > 0 )
						{
							
							
							 boolean isCloseingBalMaintained = false;
							 
								
								String accountIdString = String.valueOf(accountId);
								
								
								  isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountIdString, "DEBIT", this.getOpeningBalanceDate(), this.getOldBalance(), updatedBy, connection, this.getSessionMap());
								
							
							if(isCloseingBalMaintained)
							{
								if(!this.getAmount().equals(0))
								{
									
								
								
								
								  isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountIdString, "CREDIT", this.getOpeningBalanceDate(), this.getAmount(), updatedBy, connection, this.getSessionMap());
								
								}
							}
							
							
							
							isSuccess = true;
						}
						
					
					
					
					
					if(isSuccess)
					{
						result = "success";
						addActionMessage(this.getText("message.success.bankAccountDetailsUpdatedSuccessfully"));
					}
					else
					{
						result = "error";
						addActionError(this.getText("message.error.bankAccountDetailsNotUpdatedPlzTryAgain"));
					}
					
				}catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.detailsNotUpdated"));
				} catch (IOException e) {
					
					result = "error";					
					addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.detailsNotUpdated"));
				}finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
				
				
				
				
	        	
	        }
	        
	
	
	 return result;
	 
	}
	
	@Override
	public void validate() {
	
		
		
		if(this.getOpeningBalanceDate().equals(""))
		{
			
			addActionError(this.getText("message.error.plzProvideOpeningBalancedate"));
		}
		
		if(!hasActionErrors())			
		{
			if(this.getAmount() == null || this.getAmount().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectAmount"));
			}
		}
	}
	
	

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}


	public String getAccountHolderName() {
		return accountHolderName;
	}

	public void setAccountHolderName(String accountHolderName) {
		this.accountHolderName = accountHolderName;
	}

	public String getAccountNumber() {
		return accountNumber;
	}

	public void setAccountNumber(String accountNumber) {
		this.accountNumber = accountNumber;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getOpeningBalanceDate() {
		return openingBalanceDate;
	}

	public void setOpeningBalanceDate(String openingBalanceDate) {
		this.openingBalanceDate = openingBalanceDate;
	}

	
	

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Float getAmount() {
		return amount;
	}

	public void setAmount(Float amount) {
		this.amount = amount;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public Float getOldBalance() {
		return oldBalance;
	}

	public void setOldBalance(Float oldBalance) {
		this.oldBalance = oldBalance;
	}
	
	
	

}

