package com.stonecrusher.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;
import com.stonecrusher.resource.GetListResource;

public class EditProduct extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -2794397468407641682L;
	private HttpSession session;
	private String productAddDate;
	private String productName;
	private String puchaseRate;
	private String productNameMarathi ;
	
	private String salesRate;
	private String supplier;
	private String taxPercentage;
	private String Alias;
	private String saleUnit;
	private String purchaseUnit;
	private String lowStockCount;
	private String hsnCode;
	private String convertQuantity;
	private String oldEnglishProductName;
	private String id;
	private File productImage;
	
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	
	@Override
	public String execute() throws IOException {
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage(this.getText("message.error.plzloginfirst"));
        	result = "login";
        }  
        else
        {     
		        	taxList = GetListResource.GetTaxList();
		        	unitList = GetListResource.GetUnitList();
		        	
		        	String crusherId = (String) session.getAttribute("crusherId");
					String crusherCode = (String) session.getAttribute("crusherCode");

        				Connection connection = null;
        		   		PreparedStatement preparedStatement= null;	
        		   		ResultSet resultSet = null;
        		   		
        		   		String sql = "";
        		   		String db = (String) session.getAttribute("db");
	        		   	
        		   		FileInputStream fis =  null;
	    				 
	     				if(getProductImage() != null )
	     				{
	     					fis =  new FileInputStream(getProductImage());
	     				}
        		   		
        		   		try
        		   		{
        		   			
        		   			HashMap<String,String> taxDetails = GetListResource.GetTaxNamePercentage(this.getTaxPercentage());
        					
        		   		
							connection = GetDBConnection.getDBConnection(db);
        		   			connection.setAutoCommit(false);
        		   			if(this.getProductImage() == null)
    						{

        		   				sql = "UPDATE "
            		   					+ "crusher_product_master "
            		   					+ "SET "            		   					
            		   					+ "product_name_eng=?,"
            		   					+ "product_name_mar=?,"
            		   					+ "product_alias=?,"
            		   					+ "low_stock_count=?,"
            		   					+ "purchase_rate=?,"
            		   					+ "customer_sales_price=?,"
            		   					+ "dealer_sales_price=?,"
            		   					+ "retailer_sales_price=?,"
            		   					+ "tax_id=?,"
            		   					+ "tax_percentage =?,"
            		   					+ "purchase_unit=?,"
            		   					+ "sales_unit=?,"
            		   					+ "hsn_sac_code=?,"
            		   					+ "stock_conversion_ratio=? "
            		   					+ "WHERE "
            		   					+ "product_id=? "
            		   					+ "AND "
            							+ "crusher_id = ? "
            							+ "AND "
            							+ "crusher_code = ? ";

        		   				
        		   				preparedStatement = connection.prepareStatement(sql);    
        		   				preparedStatement.setString(1, this.getProductName());
        		   				preparedStatement.setString(2, this.getProductNameMarathi());
        		   				preparedStatement.setString(3, this.getAlias());
        		   				preparedStatement.setString(4, this.getLowStockCount());
        		   				preparedStatement.setString(5, this.getPuchaseRate());
        		   				preparedStatement.setString(6, this.getSalesRate());
        		   				preparedStatement.setString(7, this.getSalesRate());
        		   				preparedStatement.setString(8, this.getSalesRate());
        		   				preparedStatement.setString(9, this.getTaxPercentage());
        		   				preparedStatement.setString(10, taxDetails.get("TAX-PERCENTAGE"));
        		   				preparedStatement.setString(11, this.getPurchaseUnit());
        		   				preparedStatement.setString(12, this.getSaleUnit());
        		   				preparedStatement.setString(13, this.getHsnCode());
        		   				preparedStatement.setString(14, this.getConvertQuantity());
        		   				preparedStatement.setString(15, this.getId());
        		   				preparedStatement.setString(16, crusherId);
        						preparedStatement.setString(17, crusherCode);

    						}
        		   			else
        		   			{
        		   				sql = "UPDATE "
            		   					+ "crusher_product_master "
            		   					+ "SET "            		   					
            		   					+ "product_name_eng=?,"
            		   					+ "product_name_mar=?,"
            		   					+ "product_alias=?,"
            		   					+ "low_stock_count=?,"
            		   					+ "purchase_rate=?,"
            		   					+ "customer_sales_price=?,"
            		   					+ "dealer_sales_price=?,"
            		   					+ "retailer_sales_price=?,"
            		   					+ "tax_id=?,"
            		   					+ "tax_percentage =?,"
            		   					+ "purchase_unit=?,"
            		   					+ "sales_unit=?,"
            		   					+ "hsn_sac_code=?,"
            		   					+ "stock_conversion_ratio=?,"
            		   					+ "product_image "
            		   					+ "WHERE "
            		   					+ "product_id=? "
            		   					+ "AND "
            							+ "crusher_id = ? "
            							+ "AND "
            							+ "crusher_code = ? ";
        		   				
        		   				preparedStatement = connection.prepareStatement(sql);    
        		   				preparedStatement.setString(1, this.getProductName());
        		   				preparedStatement.setString(2, this.getProductNameMarathi());
        		   				preparedStatement.setString(3, this.getAlias());
        		   				preparedStatement.setString(4, this.getLowStockCount());
        		   				preparedStatement.setString(5, this.getPuchaseRate());
        		   				preparedStatement.setString(6, this.getSalesRate());
        		   				preparedStatement.setString(7, this.getSalesRate());
        		   				preparedStatement.setString(8, this.getSalesRate());
        		   				preparedStatement.setString(9, this.getTaxPercentage());
        		   				preparedStatement.setString(10, taxDetails.get("TAX-PERCENTAGE"));
        		   				preparedStatement.setString(11, this.getPurchaseUnit());
        		   				preparedStatement.setString(12, this.getSaleUnit());
        		   				preparedStatement.setString(13, this.getHsnCode());
        		   				preparedStatement.setString(14, this.getConvertQuantity());	
        		   				preparedStatement.setBinaryStream(15, fis,(int)getProductImage().length());
        		   				preparedStatement.setString(16, this.getId());
        		   				preparedStatement.setString(17, crusherId);
        						preparedStatement.setString(18, crusherCode);

        		   				
        		   			}
        		   			
        		   		
        		   			int i = preparedStatement.executeUpdate();
    						
    						
    						if(i>0)
    						{
    							
    								connection.commit();
    								result = "success";
        							addActionMessage(this.getText("message.success.productDetailsUpdatedSuccessfully"));	
    						
    							
    							
    						}
    						else
    						{
    							connection.rollback();
    							result = "error";
    							addActionError(this.getText("message.error.productDetailsNotUpdated"));
    						}
    								
        		   			
        		   		}catch (SQLException e) {
        		   			//e.printStackTrace();
        		   			result = "error";
        					addActionError(e.getErrorCode()+" || "+e.getMessage()+"||"+this.getText("message.error.error"));
        					
        					
        				} catch (IOException e) {
        					result = "error";
        					addActionError(e.getMessage() +" || "+e.getCause()+"|| "+this.getText("message.error.error"));
        					
        				}	finally
        	    		{
        					if(resultSet != null)
            				{
            					try {
            						resultSet.close(); resultSet = null;
            					} catch (SQLException e) {
            						
            					}
            				}
        	    			if(preparedStatement != null)
        	    			{
        	    				try {
        	    					
        	    					preparedStatement.close(); preparedStatement = null;
        						} catch (SQLException e) {
        							
        						}
        	    			}
        	    			if(connection != null)
        	    			{
        	    				try {
        	    					
        							connection.close(); connection = null;
        						} catch (SQLException e) {
        						
        						}
        	    			}
        	    			
        	    			
        	    		}
        		   		if(fis != null)
        		   		{
        		   			try
        		   			{
        		   				fis.close();
        		   				fis = null;
        		   			}
        		   			catch(IOException ioe)
        		   			{
        		   				
        		   			}
        		   		}

        	}
        return result;
	}

	
	@Override
	public void validate() 
	{
		try {
			taxList = GetListResource.GetTaxList();
			unitList = GetListResource.GetUnitList();
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	
    	
		if(getProductName().equals("") || getProductNameMarathi().equals("" )
				 || getAlias().equals("") || getLowStockCount().equals("") 
				|| getPuchaseRate().equals("") || getSalesRate().equals("") || getTaxPercentage().equals("") 
				|| getSaleUnit().equals("") || getPurchaseUnit().equals("") || getHsnCode().equals("") 
				|| getConvertQuantity().equals(""))
		{
			addActionError(this.getText("message.error.PlzProvideDetailsForFields*Astrick"));
		}
		
		String condition = "AND product_id != '"+getId()+"'";
		if(!hasActionErrors())
		{
			String isAliasAdded = "false";
			
			String [] result = new String[2];
			
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_product_master", "product_name_eng", condition , getProductName());
			
			isAliasAdded = result[0];
			
			if(isAliasAdded.equals("true"))
			{
				addActionError(this.getText("message.error.productIsAlreadyAddedWithSameName"));
			}				
			
		}
		if(!hasActionErrors())
		{
			String isAliasAdded = "false";
			
			String [] result = new String[2];
			
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_product_master", "product_name_mar", condition, getProductNameMarathi());
			
			isAliasAdded = result[0];
			
			if(isAliasAdded.equals("true"))
			{
				addActionError(this.getText("message.error.productIsAlreadyAddedWithSameMarathiName"));
			}				
			
		}
		if(!hasActionErrors())
		{
			String isAliasAdded = "false";
			
			String [] result = new String[2];
			
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_product_master", "product_alias", condition, getAlias());
			
			isAliasAdded = result[0];
			
			if(isAliasAdded.equals("true"))
			{
				addActionError(this.getText("message.error.aliasIsAlreadyAdded"));
			}				
			
		}
		if(!hasActionErrors())
		{
			try
			{
				Float.parseFloat(getPuchaseRate());
			}
			catch(NumberFormatException nfe)
			{
				addActionError(this.getText("message.error.plzProvideCorrectPurchaseRate"));
			}
		}
		
		if(!hasActionErrors())
		{
			try
			{
				Float.parseFloat(getSalesRate());
			}
			catch(NumberFormatException nfe)
			{
				addActionError(this.getText("message.error.plzprovideCorrectSalesRate"));
			}
		}
		if(!hasActionErrors())
		{
			try
			{
				Integer.parseInt(getLowStockCount());
			}
			catch(NumberFormatException nfe)
			{
				addActionError(this.getText("message.error.plzProvideCorrectLowStockCount"));
			}
		}
		
		
		
		
	}
	

	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public String getProductAddDate() {
		return productAddDate;
	}


	public void setProductAddDate(String productAddDate) {
		this.productAddDate = productAddDate;
	}


	public String getProductName() {
		return productName;
	}


	public void setProductName(String productName) {
		this.productName = productName;
	}


	public String getPuchaseRate() {
		return puchaseRate;
	}


	public void setPuchaseRate(String puchaseRate) {
		this.puchaseRate = puchaseRate;
	}


	public String getProductNameMarathi() {
		return productNameMarathi;
	}


	public void setProductNameMarathi(String productNameMarathi) {
		this.productNameMarathi = productNameMarathi;
	}


	public String getSalesRate() {
		return salesRate;
	}


	public void setSalesRate(String salesRate) {
		this.salesRate = salesRate;
	}


	public String getSupplier() {
		return supplier;
	}


	public void setSupplier(String supplier) {
		this.supplier = supplier;
	}


	public String getTaxPercentage() {
		return taxPercentage;
	}


	public void setTaxPercentage(String taxPercentage) {
		this.taxPercentage = taxPercentage;
	}


	public String getAlias() {
		return Alias;
	}


	public void setAlias(String alias) {
		Alias = alias;
	}


	public String getSaleUnit() {
		return saleUnit;
	}


	public void setSaleUnit(String saleUnit) {
		this.saleUnit = saleUnit;
	}


	public String getPurchaseUnit() {
		return purchaseUnit;
	}


	public void setPurchaseUnit(String purchaseUnit) {
		this.purchaseUnit = purchaseUnit;
	}


	public String getLowStockCount() {
		return lowStockCount;
	}


	public void setLowStockCount(String lowStockCount) {
		this.lowStockCount = lowStockCount;
	}


	public String getHsnCode() {
		return hsnCode;
	}


	public void setHsnCode(String hsnCode) {
		this.hsnCode = hsnCode;
	}


	public String getConvertQuantity() {
		return convertQuantity;
	}


	public void setConvertQuantity(String convertQuantity) {
		this.convertQuantity = convertQuantity;
	}


	public File getProductImage() {
		return productImage;
	}


	public void setProductImage(File productImage) {
		this.productImage = productImage;
	}


	public Map<String, String> getTaxList() {
		return taxList;
	}


	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}


	public Map<String, String> getUnitList() {
		return unitList;
	}


	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}




	public String getOldEnglishProductName() {
		return oldEnglishProductName;
	}


	public void setOldEnglishProductName(String oldEnglishProductName) {
		this.oldEnglishProductName = oldEnglishProductName;
	}


	public String getId() {
		return id;
	}


	public void setId(String id) {
		this.id = id;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	
	
	
	
	
	
}