package com.stonecrusher.update;

import java.io.IOException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class ChequeUpdate extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -2942749354173568867L;
	private HttpSession session;
	private String key;
	private String chequeStatus;
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String crusherId = (String) session.getAttribute("crusherId");
				String crusherCode = (String) session.getAttribute("crusherCode");

	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       		
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			
	       			String []  keyDetails = new String [5];
	       			
	       			//KEY = BANK_NAME#BRANCH_NAME#ACC_NUMBER#CHEQUE_NUMBER
	       			String bankName = "";
	       			String branchName = "";
	       			String accNumber = "";
	       			String chequeNumber = "";
	       			
	       			try
	       			{
	       				keyDetails = EncryptionDecryption.decrypt(URLDecoder.decode(this.getKey(),"UTF-8")).split("#");
	       				
	       				bankName = keyDetails[0];
	       				branchName = keyDetails[1];
	       				accNumber = keyDetails[2];
	       				chequeNumber = keyDetails[3];
	       				
	       			}catch(Exception e)
	       			{
	       				//e.printStackTrace();
	       				result = "error";
	       				addActionError(this.getText("message.error.errorWhileParsingKey"));
	       			}
	       			
	       			if(!hasActionErrors())
	       			{
	       				String user = (String) session.getAttribute("userFullName");
						String shortName = "";
						
						try
						{
							shortName = user.split(" ")[0];
						}catch(Exception e)
						{
							shortName = user;
						}
						Date d = new Date();
			        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");			        	
			        	String today = dateFormat.format(d);
			        	
	       				sql = "UPDATE "
	        					+ "cheque_book_details_master "
	        					+ "SET "	        					
	        					+ "cheque_status = ?,"
	        					+ "chaque_status_change_date = STR_TO_DATE(?,'%d-%m-%Y'),"	        				
	        					+ "status_changed_by = ? "
	        					+ "WHERE "
	        					+ "cheque_number = ? "
	        					+ "AND "
	        					+ "cheque_book_bank_name = ? "
	        					+ "AND "
	        					+ "cheque_book_branch_name = ? "
	        					+ "AND "
	        					+ "cheque_book_account_number = ? "
	        					+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";

	        			
	        			preparedStatement = connection.prepareStatement(sql);
	        			
	        			preparedStatement.setString(1, this.getChequeStatus());
	        			preparedStatement.setString(2, today);
	        			preparedStatement.setString(3, shortName);
	        			preparedStatement.setString(4, chequeNumber);
	        			preparedStatement.setString(5, bankName);
	        			preparedStatement.setString(6, branchName);
	        			preparedStatement.setString(7, accNumber);
	        			preparedStatement.setString(8, crusherId);
						preparedStatement.setString(9, crusherCode);

	        			int rowCountUpdated = preparedStatement.executeUpdate();
	        			
	        			if(rowCountUpdated > 0)
	        			{
	        				result = "success";
	        				
	        				addActionMessage(this.getText("message.success.chequeStatusUpdatedSuccessfully"));
	        			}
	        			else
	        			{
	        				result = "error";
	        				addActionError(this.getText("message.error.cannotUpdatedChequeStatus"));
	        			}
	       			}
	       			else
	       			{
	       				addActionError(this.getText("message.error.cannotUpdateCheque"));
	       			}
	       		}catch (SQLException e) 
	       		{
	        		result = "error";
	        		addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.someError"));
			
	       		} 
	       		
	       		catch (IOException e) {
					
					result = "error";
					addActionMessage(e.getMessage()+"|| "+this.getText("message.error.someError"));
				}	
	   			finally
	   			{
	   				if(resultSet != null)
					{
						try 
						{
							resultSet.close();
						
						}catch (SQLException e) {
							
						}
					}
	   				if(preparedStatement != null)
	   				{
	   					try {preparedStatement.close();} catch (SQLException e) {}
	   				}
	   				if(connection != null)
	   				{
	   					try {connection.close();} catch (SQLException e) {}
	   				}
	   				
	   			}
	        }
	        return result;
	   }

	@Override
	public void validate() {
		if(this.getChequeStatus().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectChequeStatus"));
		}
	}
	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getChequeStatus() {
		return chequeStatus;
	}

	public void setChequeStatus(String chequeStatus) {
		this.chequeStatus = chequeStatus;
	}
	
	

}
