package com.stonecrusher.update;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckOldPasswordCorrect;

public class ChangePassword extends ActionSupport implements SessionAware{
/**
	 * 
	 */
	private static final long serialVersionUID = 5991522839988676165L;
	private SessionMap<String,Object> sessionMap;
	private String oldPassword;
	private String newPassword;
	private String confirmPassword;
	
	public String execute(){
		
		String result = "login";
		   if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");

	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    		
	    		String sql = "";
	    		String db = (String) this.getSessionMap().get("db");
	    		
	    			try
	    			{
	    				
	    				String userNameS = (String) this.getSessionMap().get("username");
	    				connection = GetDBConnection.getDBConnection(db);
	    				
	    				sql = "UPDATE "
	    						+ "crusher_user_details "
	    						+ "SET "
	    						+ "user_password = ? "
	    						+ "WHERE "
	    						+ "user_name = ? "
	    						+ "AND "
	    						+ "user_password = ? "
	    						+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";

	    				
	    				preparedStatement = connection.prepareStatement(sql);
	    				
	    				preparedStatement.setString(1, EncryptionDecryption.encrypt(this.getNewPassword().trim()));
	    				preparedStatement.setString(2, userNameS);
	    				preparedStatement.setString(3, EncryptionDecryption.encrypt(this.getOldPassword().trim()));
	    				preparedStatement.setString(4, crusherId);
						preparedStatement.setString(5, crusherCode);

	    				int updatedCount = preparedStatement.executeUpdate();
	    				
	    				if(updatedCount>0)
	    				{
	    					this.getSessionMap().invalidate();
	    					result = LOGIN;
	    					addActionMessage(this.getText("message.success.passwordChangedSuccessfully"));
	    				}
	    				else
	    				{
	    					result = ERROR;
	    					
	    					addActionError(this.getText("message.error.couldntUpdatePasswordPlzTryAgain"));
	    				}
	    				
	    			} catch (SQLException e) {
	    				e.printStackTrace();
	    				result = ERROR;
	    				
	    			} catch (Exception e) {
	    				e.printStackTrace();
	    				
	    				result = ERROR;
	    			}finally {
	    				if(resultSet != null)
	    				{
	    					try {
	    						resultSet.close(); resultSet = null;
	    					} catch (SQLException e) {
	    						
	    					}
	    				}
	    				if(preparedStatement != null)
	    				{
	    					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    				}
	    				if(connection != null)
	    				{
	    					
	    					try {connection.close(); connection = null;}catch (SQLException e) {}
	    				}
	    				
	    			}
	    		
	        	
	        	
	        	
	        }
		   
		   return result;
}
	        
	@Override
		public void validate() {
			
		if(this.getOldPassword() == null || this.getOldPassword().equals("")){
			addActionError(this.getText("message.error.plzProvideOldPassword"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getNewPassword() == null || this.getNewPassword().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideNewPassword"));
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getConfirmPassword() == null || this.getConfirmPassword().equals(""))
			{
				
				addActionError(this.getText("message.error.plzProvideConfirmPassword"));
			}
		}
		
		
		if(!hasActionErrors())
		{
			String userNameS = (String) this.getSessionMap().get("username");
			String encryptedPass = EncryptionDecryption.encrypt(this.getOldPassword());
			boolean oldPasswordCorrect = CheckOldPasswordCorrect.getOldPasswordCorrect(userNameS, encryptedPass, this.getSessionMap());
			
			if(!oldPasswordCorrect)
			{
				addActionError(this.getText("message.error.oldPasswordDoesNotMatchPlzProvideCorrectOldPassword"));
			
			}
			
			
		}
		
		
		if(!this.getNewPassword().trim().equals(this.getConfirmPassword().trim()))
		{
			addActionError(this.getText("message.error.newPasswordAndConfirmPasswordDoesNotMatch"));
		}
	}
	
	public String getOldPassword() {
		return oldPassword;
	}


	public void setOldPassword(String oldPassword) {
		this.oldPassword = oldPassword;
	}


	public String getNewPassword() {
		return newPassword;
	}


	public void setNewPassword(String newPassword) {
		this.newPassword = newPassword;
	}


	public String getConfirmPassword() {
		return confirmPassword;
	}


	public void setConfirmPassword(String confirmPassword) {
		this.confirmPassword = confirmPassword;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
}
