package com.stonecrusher.resource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.struts2.dispatcher.SessionMap;

public class GetNewIdForNewEntry {
	
	
	public static int getNewIdForNewEntry(String tableName, String columnName, SessionMap<String, Object> sessionMap, Connection connection)
	{
		int newId = 1;
		

		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
		
		
		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");
	
			try
			{
				if(sessionMap != null)
				{
					sql = "SELECT "
							+ columnName
							+ " FROM "
							+ tableName
							+ " WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "ORDER BY "
							+ columnName
							+ " DESC LIMIT 1";
					
					
				
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
					
						resultSet = preparedStatement.executeQuery();
					
						if(resultSet.next())
						{
							
							newId = resultSet.getInt(1) + 1;					
						
						}else
						{
							newId = 1;
						}
				}
				
			
			} catch (SQLException e) {
				//e.printStackTrace();
				newId = 0;
				
			}finally {
				if(resultSet != null)
				{
					try {
						resultSet.close(); resultSet = null;
					} catch (SQLException e) {
						
					}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				
				
			}
		
		
		return newId;
	}

}
