package com.stonecrusher.resource;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.struts2.dispatcher.SessionMap;

import com.stonecrusher.db.GetDBConnection;

public class CheckOldPasswordCorrect {
	
	
	
	public static boolean getOldPasswordCorrect(String userName, String oldPassword, SessionMap<String, Object> session)
	{
		boolean oldPasswordCorrect = false;
		
		String crusherId = (String) session.get("crusherId");
		String crusherCode = (String) session.get("crusherCode");

		
		
		
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
		String db = (String) session.get("db");
		
		
		
			try
			{
				
				connection = GetDBConnection.getDBConnection(db);
				
				
				sql = "SELECT "
						+ "user_name,"
						+ "user_password "
						+ "FROM "
						+ "crusher_user_details "
						+ "WHERE "
						+ "user_name = ? "
						+ "AND "
						+ "user_password = ? "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? ";

				
				preparedStatement = connection.prepareStatement(sql);
				
				preparedStatement.setString(1, userName);
				preparedStatement.setString(2, oldPassword);
				preparedStatement.setString(3, crusherId);
				preparedStatement.setString(4, crusherCode);
				

				resultSet = preparedStatement.executeQuery();
				
				if(resultSet.next()){
					oldPasswordCorrect = true;
				}
						
				
				
			} catch (SQLException e) {
				
				oldPasswordCorrect = false;
				
			} catch (IOException e) {
			
				
				oldPasswordCorrect = false;
			}finally {
				if(resultSet != null)
				{
					try {
						resultSet.close(); resultSet = null;
					} catch (SQLException e) {
						
					}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
			}
		
		
		return oldPasswordCorrect;
	}

}
