package com.stonecrusher.resource;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;
import javax.websocket.Session;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;

import com.stonecrusher.db.GetDBConnection;

public class CheckAlreadyAvailable {
	
	private HttpSession session;
	private String[] result = new String[2];
	
	public String[] checkAvaibility(String tableName, String columnName, String condition, String value)
	{
		
		
		session=ServletActionContext.getRequest().getSession(false); 
		
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
		String db = (String) session.getAttribute("db");
		
		String crusherId = (String) session.getAttribute("crusherId");
		String crusherCode = (String) session.getAttribute("crusherCode");
		
			try
			{
				if(session != null)
				{
						if(condition.equals("NA"))						
						{
							connection = GetDBConnection.getDBConnection(db);
							connection.setAutoCommit(false);
							
							sql = "SELECT * FROM "
									+ tableName + ""
									+ " WHERE " + columnName + " = ? "
											+ "AND "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ?";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setString(1, value);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							resultSet = preparedStatement.executeQuery();
									
							if(resultSet.next())
							{
								result[0] = "true";
								result[1] = "success";
							}
							else
							{
								result[0] = "false";
								result[1] = "success";
							}
						
						
					}
					else
					{
						
						connection = GetDBConnection.getDBConnection(db);
						connection.setAutoCommit(false);
						
						sql = "SELECT * FROM "
								+ tableName + ""
								+ " WHERE " + columnName + " = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+condition;
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, value);
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						
						//System.out.println(preparedStatement.toString());
						resultSet = preparedStatement.executeQuery();
								
						if(resultSet.next())
						{
							result[0] = "true";
							result[1] = "success";
						}
						else
						{
							result[0] = "false";
							result[1] = "success";
						}
					
					}
				}
			} catch (SQLException e) {
				
				result[1] = result[1] + e.getErrorCode()+" || "+e.getMessage() +" || Unable to Check Availablity";
				
			} catch (IOException e) {
			
				result[1] = result[1] + e.getMessage()+" || "+e.getCause()+" || Unable to Check Availablity";
				
			}finally {
				if(resultSet != null)
				{
					try {
						resultSet.close(); resultSet = null;
					} catch (SQLException e) {
						
					}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
			}
       
		
		
		return result;
		
	}
	
	
	
	public String[] checkCustomerAvaibilityWithOnlyOneCheck(SessionMap<String, Object> sessionMap, String tableName, String mobileColumnName, String custNameColumnName, String mobileNumber, String custName, String condition)
	{
		
		

    	String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");
		
    
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
		String db = (String) sessionMap.get("db");
		
	
			try
			{
				
							connection = GetDBConnection.getDBConnection(db);
							connection.setAutoCommit(false);
							
							if(condition.equals("NA"))						
							{
								
								
								sql = "SELECT * "
										+ "FROM "
										+ tableName + ""
										+ " WHERE " 
										+ mobileColumnName + " = ? "
										+ " AND "
										+ custNameColumnName + " = ? "
												+ "AND "
												+ "crusher_id = ? "
												+ "AND "
												+ "crusher_code = ? ";
								
								preparedStatement = connection.prepareStatement(sql);
								
								preparedStatement.setString(1, mobileNumber);
								preparedStatement.setString(2, custName);
								preparedStatement.setString(3, crusherId);
								preparedStatement.setString(4, crusherCode);
								
								resultSet = preparedStatement.executeQuery();
										
								if(resultSet.next())
								{
									result[0] = "true";
									result[1] = "success";
								}
								else
								{
									result[0] = "false";
									result[1] = "success";
								}
							}
							else
							{
								sql = "SELECT * "
										+ "FROM "
										+ tableName + ""
										+ " WHERE " 
										+ mobileColumnName + " = ? "
										+ " AND "
										+ custNameColumnName + " = ? "
												+ "AND "
												+ "crusher_id = ? "
												+ "AND "
												+ "crusher_code = ? "
												+  condition;
								
								preparedStatement = connection.prepareStatement(sql);
								
								preparedStatement.setString(1, mobileNumber);
								preparedStatement.setString(2, custName);
								preparedStatement.setString(3, crusherId);
								preparedStatement.setString(4, crusherCode);
								
								resultSet = preparedStatement.executeQuery();
										
								if(resultSet.next())
								{
									result[0] = "true";
									result[1] = "success";
								}
								else
								{
									result[0] = "false";
									result[1] = "success";
								}
							}
			
			} catch (SQLException e) {
				
				//e.printStackTrace();
				result[1] = result[1] + e.getErrorCode()+" || "+e.getMessage() +" || Unable to Check Availablity";
				
			} catch (IOException e) {
			
				result[1] = result[1] + e.getMessage()+" || "+e.getCause()+" || Unable to Check Availablity";
				
			}finally {
				if(resultSet != null)
				{
					try {
						resultSet.close();
					} catch (SQLException e) {
						
					}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close();} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close();}catch (SQLException e) {}
				}
				
			}
       
		
		
		
		return result;
		
	}

}
