package com.stonecrusher.report;

import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.VehicleConsumptionInfoDAO;
import com.stonecrusher.DAO.VehicleMaintenanceInfoDAO;
import com.stonecrusher.DAO.VehicleTripEntryDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetVehicleList;

public class GetVehicleTripReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3604902358120972556L;
	
	private String fromDate;
	private String toDate;
	private HttpSession session;
	private String vehicleId;
	private Float totalQuantityInBrass;
	private Float totalKm;
	private Float totalTrip;
	private Float totalTransportataionCharges ;
	private Float totalCharges;
	private Float totalDiesel;
	private Float totalDieselAmount;
	private Float vehicleAvgPerLiter;
	private Float nettProfit;
	private String addSideBarJs;
	private String billNo;
	private String customerName;
	private List<VehicleTripEntryDAO> vehicleTripEntryInfoList = new ArrayList<VehicleTripEntryDAO>();
	
	private LinkedHashMap<String,String> vehicleList = new LinkedHashMap<String,String>();
	
	private ArrayList<VehicleConsumptionInfoDAO> vehicleConInfoList = new ArrayList<VehicleConsumptionInfoDAO> ();
	private Float totalConsumptionAmount = 0.0F;
	private Float totalQuantity = 0.0F;
	private ArrayList<VehicleMaintenanceInfoDAO> vehicleMainInfoList = new ArrayList<VehicleMaintenanceInfoDAO>();
	private Float totalMaintenanceAmount = 0.0F;
	private List<Map<String, Object>> productQuantityList = new ArrayList<>();
    


	private SessionMap<String,Object> sessionMap;  
	
	public String execute(){
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	vehicleList = GetVehicleList.getVehicleList(session);
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		
	    		String customerId = null;
	    		
	    		if(this.getCustomerName()!= null)
	    		{
	    			customerId = this.getCustomerName().split("-")[0];
	    		}
	    		
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
	    		
	    		float totalQuantityInBrass = 0.0F;
	    	    float totalKm = 0.0F;
	    	    float totalTrips = 0.0F;
	    	    float totalTransportationCharges = 0.0F;
	    	    
	    	    
	    		try
	    		{
	    			
					connection = GetDBConnection.getDBConnection(db);
	    			
					if (this.getCustomerName() == null || this.getCustomerName().trim().isEmpty()) {
					    
							
						
						sql = "SELECT "
		    					+ "vt.trip_entry_id,"
		    					+ "DATE_FORMAT(vt.trip_date,'%d-%m-%Y'),"
		    					+ "vt.vehicle_id,"
		    					+ "vd.vehicle_make,"
		    					+ "vd.vehicle_registration_number,"
		    					+ "vt.customer_id,"
		    					+ "vt.customer_name,"
		    					+ "vt.vehicle_km_start,"
		    					+ "vt.vehicle_km_end,"
		    					+ "vt.trip_total_km,"
		    					+ "vt.trip_start_from,"
		    					+ "vt.trip_end_to,"
		    					+ "vt.total_trip_count,"
		    					+ "vt.trip_driver_name,"
		    					+ "vt.trip_driver_mobile_number,"
		    					+ "vt.bill_number,"
		    					+ "vt.bill_type,"
		    					+ "vt.transportation_charges "
		    					+ "FROM "
		    					+ "crusher_vehicle_trip_master as vt "
		    					+ "INNER JOIN "
		    					+ "crusher_vehicle_details_master as vd "
		    					+ "ON "
		    					+ "vd.vehicle_id = vt.vehicle_id "
		    					+ "WHERE "
		    					+ "vt.vehicle_id = ? "
		    					+ "AND "
		    					+ "(trip_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
		    					+ "AND "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y')) "
		    					+ "AND "
		    					+ "vt.crusher_id = ? "
		    					+ "AND "
		    					+ "vd.crusher_code = ? "
		    					+ "AND "
		    					+ "vt.crusher_id = ? "
		    					+ "AND "
		    					+ "vd.crusher_code = ? "
		    					+ "ORDER BY "
		    					+ "vt.trip_entry_id";
		    			
		    			preparedStatement = connection.prepareStatement(sql);
		    			
		    			preparedStatement.setString(1, this.getVehicleId());
		    			preparedStatement.setString(2, this.getFromDate());
		    			preparedStatement.setString(3, this.getToDate());
		    			preparedStatement.setString(4, crusherId);
		    			preparedStatement.setString(5, crusherCode);
		    			preparedStatement.setString(6, crusherId);
		    			preparedStatement.setString(7, crusherCode);
		    			
		    			
		    			
						
					}else {
						
						

						sql = "SELECT "
		    					+ "vt.trip_entry_id,"
		    					+ "DATE_FORMAT(vt.trip_date,'%d-%m-%Y'),"
		    					+ "vt.vehicle_id,"
		    					+ "vd.vehicle_make,"
		    					+ "vd.vehicle_registration_number,"
		    					+ "vt.customer_id,"
		    					+ "vt.customer_name,"
		    					+ "vt.vehicle_km_start,"
		    					+ "vt.vehicle_km_end,"
		    					+ "vt.trip_total_km,"
		    					+ "vt.trip_start_from,"
		    					+ "vt.trip_end_to,"
		    					+ "vt.total_trip_count,"
		    					+ "vt.trip_driver_name,"
		    					+ "vt.trip_driver_mobile_number,"
		    					+ "vt.bill_number,"
		    					+ "vt.bill_type,"
		    					+ "vt.transportation_charges "
		    					+ "FROM "
		    					+ "crusher_vehicle_trip_master as vt "
		    					+ "INNER JOIN "
		    					+ "crusher_vehicle_details_master as vd "
		    					+ "ON "
		    					+ "vd.vehicle_id = vt.vehicle_id "
		    					+ "WHERE "
		    					+ "vt.vehicle_id = ? "
		    					+ "AND "
		    					+ "(trip_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
		    					+ "AND "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y')) "
		    					+ "AND "
		    					+ "vt.crusher_id = ? "
		    					+ "AND "
		    					+ "vd.crusher_code = ? "
		    					+ "AND "
		    					+ "vt.crusher_id = ? "
		    					+ "AND "
		    					+ "vd.crusher_code = ? "
		    					+ "AND "
		    					+ "vt.customer_id = ? "
		    					+ "ORDER BY "
		    					+ "vt.trip_entry_id";
		    			
		    			preparedStatement = connection.prepareStatement(sql);
		    			
		    			preparedStatement.setString(1, this.getVehicleId());
		    			preparedStatement.setString(2, this.getFromDate());
		    			preparedStatement.setString(3, this.getToDate());
		    			preparedStatement.setString(4, crusherId);
		    			preparedStatement.setString(5, crusherCode);
		    			preparedStatement.setString(6, crusherId);
		    			preparedStatement.setString(7, crusherCode);
		    			preparedStatement.setString(8, customerId);
						
		    			
		    			
					}
	    			
	    		
	    			resultSet = preparedStatement.executeQuery();
	    		
	    			
	    			this.setTotalCharges(0.0F);
	    			this.setTotalQuantityInBrass(0.0F);
	    			this.setTotalKm(0.0F);
	    			this.setTotalDiesel(0.0F);
	    			this.setTotalDieselAmount(0.0F);
	    			this.setTotalTrip(0.0F);
	    			this.setTotalMaintenanceAmount(0.0F);
	    			
	    			
	    				while(resultSet.next())
	    				{
	    				
	    					VehicleTripEntryDAO entryDAO = new VehicleTripEntryDAO();
	    					
	    					entryDAO.setTripId(resultSet.getString(1));
	    					entryDAO.setTripDate(resultSet.getString(2));
	    					entryDAO.setTripVehicleMake(resultSet.getString(4));
	    					entryDAO.setTripVehicleRCNumber(resultSet.getString(5));
	    					entryDAO.setCustomerId(resultSet.getString(6));
	    					entryDAO.setCustomerName(resultSet.getString(7));
	    					entryDAO.setVehicleKmStart(resultSet.getString(8));
	    					entryDAO.setVehicleKmEnd(resultSet.getString(9));
	    					entryDAO.setTripTotalKm(resultSet.getString(10));
	    					entryDAO.setTripFrom(resultSet.getString(11));	    					
	    					entryDAO.setTripTo(resultSet.getString(12));	    					
	    					entryDAO.setTotalTrips(resultSet.getString(13));
	    					entryDAO.setTransportataionCharges(resultSet.getString(18));
	    					entryDAO.setKey(URLEncoder.encode(EncryptionDecryption.encrypt(resultSet.getString(1)),"UTF-8"));
	    					this.setBillNo(resultSet.getString(16));
	    					
	    					String billNo = resultSet.getString(16);
	    					String billType = resultSet.getString(17);
	    					  
	    					
	    					 String getProductInfoSQL = "";
							  PreparedStatement getProductInfoPSMT = null;
							  ResultSet getProductInfoRS = null;
							 
							 
							  getProductInfoSQL = "SELECT "
								  		+ "product_name,"
								  		+ "sale_quantity "
								  		+ "FROM "
								  		+ "crusher_bill_product_info "
								  		+ "WHERE "
								  		+ "bill_number = ? "
								  		+ "AND "
								  		+ "bill_type = ? "
								  		+ "AND "
								  		+ "crusher_id = ? "
								  		+ "AND "
								  		+ "crusher_code = ? ";
	    					

							  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
							  
							  getProductInfoPSMT.setString(1, billNo);
							  getProductInfoPSMT.setString(2, billType);
							  getProductInfoPSMT.setString(3, crusherId);
							  getProductInfoPSMT.setString(4, crusherCode);
							  
							  getProductInfoRS = getProductInfoPSMT.executeQuery();
						 
							  
							  
							  StringBuilder productNames = new StringBuilder();
							  StringBuilder quantities = new StringBuilder();
							  
							 
							  
							  while(getProductInfoRS.next())
							  {
								  
								  String productName = getProductInfoRS.getString(1);
								    float quantity = getProductInfoRS.getFloat(2);

								     boolean found = false;
								    for (Map<String, Object> productInfo : productQuantityList) {
								        if (productInfo.get("productName").equals(productName)) {
								            float existingQuantity = (float) productInfo.get("quantity");
								            productInfo.put("quantity", existingQuantity + quantity);
								            found = true;
								            break;
								        }
								    }

								   if (!found) {
								        Map<String, Object> newProduct = new LinkedHashMap<>();
								        newProduct.put("productName", productName);
								        newProduct.put("quantity", quantity);
								        productQuantityList.add(newProduct);
								    }
								

								  if (productNames.length() > 0) {
								        productNames.append(" / ");
								        quantities.append(" / ");
								    }
								  
								  productNames.append(getProductInfoRS.getString(1));  
								    quantities.append(getProductInfoRS.getString(2));    

								    entryDAO.setMaterialName(productNames.toString());  
								    entryDAO.setMaterialVolume(quantities.toString());
								    
								    totalQuantityInBrass += getProductInfoRS.getFloat(2);
			    		            
								    
							  }
	    					
	    					totalKm += resultSet.getFloat(10);
	    		            totalTrips += resultSet.getFloat(13);
	    		            totalTransportationCharges += resultSet.getFloat(18);
	    					
	    		            
	    		          
	    					this.getVehicleTripEntryInfoList().add(entryDAO);
	    					
	    				}
	    				
	    				
	    				if(resultSet != null)
	    				{
	    					resultSet.close();
	    					resultSet = null;
	    				}
	    				
	    				if(preparedStatement != null)
	    				{
	    					preparedStatement.close();
	    					preparedStatement = null;
	    				}
	    				
	    				
	    				
	    				if (this.getCustomerName() == null || this.getCustomerName().trim().isEmpty()) {
	    				    	
	    					
	    					
	    					
	    					sql = "SELECT "
			    					+ "vt.trip_entry_id,"
			    					+ "DATE_FORMAT(vt.trip_date,'%d-%m-%Y'),"
			    					+ "vt.vehicle_id,"
			    					+ "vd.vehicle_make,"
			    					+ "vd.vehicle_registration_number,"
			    					+ "vt.customer_id,"
			    					+ "vt.customer_name,"
			    					+ "vt.product_name,"
			    					+ "vt.product_quantity,"
			    					+ "vt.vehicle_km_start,"
			    					+ "vt.vehicle_km_end,"
			    					+ "vt.trip_total_km,"
			    					+ "vt.trip_start_from,"
			    					+ "vt.trip_end_to,"
			    					+ "vt.total_trip_count,"
			    					+ "vt.trip_driver_name,"
			    					+ "vt.trip_driver_mobile_number,"
			    					+ "vt.transportation_charges "
			    					+ "FROM "
			    					+ "crusher_vehicle_trip_other_master as vt "
			    					+ "INNER JOIN "
			    					+ "crusher_vehicle_details_master as vd "
			    					+ "ON "
			    					+ "vd.vehicle_id = vt.vehicle_id "
			    					+ "WHERE "
			    					+ "vt.vehicle_id = ? "
			    					+ "AND "
			    					+ "(trip_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
			    					+ "AND "
			    					+ "STR_TO_DATE(?,'%d-%m-%Y')) "
			    					+ "AND "
			    					+ "vt.crusher_id = ? "
			    					+ "AND "
			    					+ "vd.crusher_code = ? "
			    					+ "AND "
			    					+ "vt.crusher_id = ? "
			    					+ "AND "
			    					+ "vd.crusher_code = ? "
			    					+ "ORDER BY "
			    					+ "vt.trip_entry_id";
			    			
			    			preparedStatement = connection.prepareStatement(sql);
			    			
			    			preparedStatement.setString(1, this.getVehicleId());
			    			preparedStatement.setString(2, this.getFromDate());
			    			preparedStatement.setString(3, this.getToDate());
			    			preparedStatement.setString(4, crusherId);
			    			preparedStatement.setString(5, crusherCode);
			    			preparedStatement.setString(6, crusherId);
			    			preparedStatement.setString(7, crusherCode);
			    			
			    			
	    					
	    				}else {
	    					
	    					sql = "SELECT "
			    					+ "vt.trip_entry_id,"
			    					+ "DATE_FORMAT(vt.trip_date,'%d-%m-%Y'),"
			    					+ "vt.vehicle_id,"
			    					+ "vd.vehicle_make,"
			    					+ "vd.vehicle_registration_number,"
			    					+ "vt.customer_id,"
			    					+ "vt.customer_name,"
			    					+ "vt.product_name,"
			    					+ "vt.product_quantity,"
			    					+ "vt.vehicle_km_start,"
			    					+ "vt.vehicle_km_end,"
			    					+ "vt.trip_total_km,"
			    					+ "vt.trip_start_from,"
			    					+ "vt.trip_end_to,"
			    					+ "vt.total_trip_count,"
			    					+ "vt.trip_driver_name,"
			    					+ "vt.trip_driver_mobile_number,"
			    					+ "vt.transportation_charges "
			    					+ "FROM "
			    					+ "crusher_vehicle_trip_other_master as vt "
			    					+ "INNER JOIN "
			    					+ "crusher_vehicle_details_master as vd "
			    					+ "ON "
			    					+ "vd.vehicle_id = vt.vehicle_id "
			    					+ "WHERE "
			    					+ "vt.vehicle_id = ? "
			    					+ "AND "
			    					+ "(trip_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
			    					+ "AND "
			    					+ "STR_TO_DATE(?,'%d-%m-%Y')) "
			    					+ "AND "
			    					+ "vt.crusher_id = ? "
			    					+ "AND "
			    					+ "vd.crusher_code = ? "
			    					+ "AND "
			    					+ "vt.crusher_id = ? "
			    					+ "AND "
			    					+ "vd.crusher_code = ? "
			    					+ "AND "
			    					+ "vt.customer_id = ? "
			    					+ "ORDER BY "
			    					+ "vt.trip_entry_id";
			    			
			    			preparedStatement = connection.prepareStatement(sql);
			    			
			    			preparedStatement.setString(1, this.getVehicleId());
			    			preparedStatement.setString(2, this.getFromDate());
			    			preparedStatement.setString(3, this.getToDate());
			    			preparedStatement.setString(4, crusherId);
			    			preparedStatement.setString(5, crusherCode);
			    			preparedStatement.setString(6, crusherId);
			    			preparedStatement.setString(7, crusherCode);
			    			preparedStatement.setString(8, customerId);
			    			
	    				}
	    				
		    			resultSet = preparedStatement.executeQuery();
		    	
		    		
		    				while(resultSet.next())
		    				{
		    				
		    					VehicleTripEntryDAO entryDAO = new VehicleTripEntryDAO();
		    					
		    					entryDAO.setTripId(resultSet.getString(1));
		    					entryDAO.setTripDate(resultSet.getString(2));
		    					entryDAO.setTripVehicleMake(resultSet.getString(4));
		    					entryDAO.setTripVehicleRCNumber(resultSet.getString(5));
		    					entryDAO.setCustomerId(resultSet.getString(6));
		    					entryDAO.setCustomerName(resultSet.getString(7));
		    					entryDAO.setMaterialName(resultSet.getString(8));
		    					entryDAO.setMaterialVolume(resultSet.getString(9));
		    					entryDAO.setVehicleKmStart(resultSet.getString(10));
		    					entryDAO.setVehicleKmEnd(resultSet.getString(11));
		    					entryDAO.setTripTotalKm(resultSet.getString(12));
		    					entryDAO.setTripFrom(resultSet.getString(13));	    					
		    					entryDAO.setTripTo(resultSet.getString(14));	    					
		    					entryDAO.setTotalTrips(resultSet.getString(15));
		    					entryDAO.setTransportataionCharges(resultSet.getString(18));
		    					entryDAO.setKey(URLEncoder.encode(EncryptionDecryption.encrypt(resultSet.getString(1)),"UTF-8"));
		    					this.setBillNo("0");
		    					
		    					
		    					totalQuantityInBrass += resultSet.getFloat(9);
		    		            totalKm += resultSet.getFloat(12);
		    		            totalTrips += resultSet.getFloat(15);
		    		            totalTransportationCharges += resultSet.getFloat(18);
		    					
		    		            
		    		            
		    					
		    					this.getVehicleTripEntryInfoList().add(entryDAO);
		    					
		    				}
		    				
		    				
		    				
		    				
		    				
		    				

		    				if(resultSet != null)
		    				{
		    					resultSet.close();
		    					resultSet = null;
		    				}
		    				
		    				if(preparedStatement != null)
		    				{
		    					preparedStatement.close();
		    					preparedStatement = null;
		    				}
		    				
		    				
		    				


		    				
		    				if (this.getCustomerName() == null || this.getCustomerName().trim().isEmpty()) {
							    
								
								
								sql = "SELECT "
				    					+ "vt.trip_id,"
				    					+ "DATE_FORMAT(vt.trip_date,'%d-%m-%Y'),"
				    					+ "vt.trip_vehicle_id,"
				    					+ "vd.vehicle_make,"
				    					+ "vd.vehicle_registration_number,"
				    					+ "vt.customer_id,"
				    					+ "vt.customer_name,"
				    					+ "vt.vehicle_km_start,"
				    					+ "vt.vehicle_km_end,"
				    					+ "vt.trip_total_km,"
				    					+ "vt.trip_from,"
				    					+ "vt.trip_to,"
				    					+ "vt.total_trips,"
				    					+ "vt.trip_driver_name,"
				    					+ "vt.trip_driver_mobile_number,"
				    					+ "vt.bill_number,"
				    					+ "vt.bill_type,"
				    					+ "vt.total_transportataion_charges "
				    					+ "FROM "
				    					+ "crusher_rmc_vehicle_trip_master as vt "
				    					+ "INNER JOIN "
				    					+ "crusher_vehicle_details_master as vd "
				    					+ "ON "
				    					+ "vd.vehicle_id = vt.trip_vehicle_id "
				    					+ "WHERE "
				    					+ "vt.trip_vehicle_id = ? "
				    					+ "AND "
				    					+ "(trip_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
				    					+ "AND "
				    					+ "STR_TO_DATE(?,'%d-%m-%Y')) "
				    					+ "AND "
				    					+ "vt.crusher_id = ? "
				    					+ "AND "
				    					+ "vd.crusher_code = ? "
				    					+ "AND "
				    					+ "vt.crusher_id = ? "
				    					+ "AND "
				    					+ "vd.crusher_code = ? "
				    					+ "ORDER BY "
				    					+ "vt.trip_id";
				    			
				    			preparedStatement = connection.prepareStatement(sql);
				    			
				    			preparedStatement.setString(1, this.getVehicleId());
				    			preparedStatement.setString(2, this.getFromDate());
				    			preparedStatement.setString(3, this.getToDate());
				    			preparedStatement.setString(4, crusherId);
				    			preparedStatement.setString(5, crusherCode);
				    			preparedStatement.setString(6, crusherId);
				    			preparedStatement.setString(7, crusherCode);
				    			
				    			
				    			
								
							}else {
								
								

								sql = "SELECT "
				    					+ "vt.trip_id,"
				    					+ "DATE_FORMAT(vt.trip_date,'%d-%m-%Y'),"
				    					+ "vt.trip_vehicle_id,"
				    					+ "vd.vehicle_make,"
				    					+ "vd.vehicle_registration_number,"
				    					+ "vt.customer_id,"
				    					+ "vt.customer_name,"
				    					+ "vt.vehicle_km_start,"
				    					+ "vt.vehicle_km_end,"
				    					+ "vt.trip_total_km,"
				    					+ "vt.trip_from,"
				    					+ "vt.trip_to,"
				    					+ "vt.total_trips,"
				    					+ "vt.trip_driver_name,"
				    					+ "vt.trip_driver_mobile_number,"
				    					+ "vt.bill_number,"
				    					+ "vt.bill_type,"
				    					+ "vt.total_transportataion_charges "
				    					+ "FROM "
				    					+ "crusher_rmc_vehicle_trip_master as vt "
				    					+ "INNER JOIN "
				    					+ "crusher_vehicle_details_master as vd "
				    					+ "ON "
				    					+ "vd.vehicle_id = vt.trip_vehicle_id "
				    					+ "WHERE "
				    					+ "vt.trip_vehicle_id = ? "
				    					+ "AND "
				    					+ "(trip_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
				    					+ "AND "
				    					+ "STR_TO_DATE(?,'%d-%m-%Y')) "
				    					+ "AND "
				    					+ "vt.crusher_id = ? "
				    					+ "AND "
				    					+ "vd.crusher_code = ? "
				    					+ "AND "
				    					+ "vt.crusher_id = ? "
				    					+ "AND "
				    					+ "vd.crusher_code = ? "
				    					+ "AND "
				    					+ "vt.customer_id = ? "
				    					+ "ORDER BY "
				    					+ "vt.trip_id";
				    			
				    			preparedStatement = connection.prepareStatement(sql);
				    			
				    			preparedStatement.setString(1, this.getVehicleId());
				    			preparedStatement.setString(2, this.getFromDate());
				    			preparedStatement.setString(3, this.getToDate());
				    			preparedStatement.setString(4, crusherId);
				    			preparedStatement.setString(5, crusherCode);
				    			preparedStatement.setString(6, crusherId);
				    			preparedStatement.setString(7, crusherCode);
				    			preparedStatement.setString(8, customerId);
								
				    			
				    			
							}
			    			
			    		
			    			resultSet = preparedStatement.executeQuery();
			    		
			    			
			    				while(resultSet.next())
			    				{
			    				
			    					VehicleTripEntryDAO entryDAO = new VehicleTripEntryDAO();
			    					
			    					entryDAO.setTripId(resultSet.getString(1));
			    					entryDAO.setTripDate(resultSet.getString(2));
			    					entryDAO.setTripVehicleMake(resultSet.getString(4));
			    					entryDAO.setTripVehicleRCNumber(resultSet.getString(5));
			    					entryDAO.setCustomerId(resultSet.getString(6));
			    					entryDAO.setCustomerName(resultSet.getString(7));
			    					entryDAO.setVehicleKmStart(resultSet.getString(8));
			    					entryDAO.setVehicleKmEnd(resultSet.getString(9));
			    					entryDAO.setTripTotalKm(resultSet.getString(10));
			    					entryDAO.setTripFrom(resultSet.getString(11));	    					
			    					entryDAO.setTripTo(resultSet.getString(12));	    					
			    					entryDAO.setTotalTrips(resultSet.getString(13));
			    					entryDAO.setTransportataionCharges(resultSet.getString(18));
			    					entryDAO.setKey(URLEncoder.encode(EncryptionDecryption.encrypt(resultSet.getString(1)),"UTF-8"));
			    					this.setBillNo(resultSet.getString(16));
			    					
			    					String billNo = resultSet.getString(16);
			    					String billType = resultSet.getString(17);
			    					  
			    					
			    					 String getProductInfoSQL = "";
									  PreparedStatement getProductInfoPSMT = null;
									  ResultSet getProductInfoRS = null;
									 
									 
									  getProductInfoSQL = "SELECT "
										  		+ "product_name,"
										  		+ "quanity "
										  		+ "FROM "
										  		+ "crusher_rmc_productbillinfo "
										  		+ "WHERE "
										  		+ "bill_number = ? "
										  		+ "AND "
										  		+ "bill_type = ? "
										  		+ "AND "
										  		+ "crusher_id = ? "
										  		+ "AND "
										  		+ "crusher_code = ? ";
			    					

									  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
									  
									  getProductInfoPSMT.setString(1, billNo);
									  getProductInfoPSMT.setString(2, billType);
									  getProductInfoPSMT.setString(3, crusherId);
									  getProductInfoPSMT.setString(4, crusherCode);
									  
									  getProductInfoRS = getProductInfoPSMT.executeQuery();
								 
									  
									  
									  StringBuilder productNames = new StringBuilder();
									  StringBuilder quantities = new StringBuilder();
									  
									 
									  
									  while(getProductInfoRS.next())
									  {
										  
										  String productName = getProductInfoRS.getString(1);
										    float quantity = getProductInfoRS.getFloat(2);

										     boolean found = false;
										    for (Map<String, Object> productInfo : productQuantityList) {
										        if (productInfo.get("productName").equals(productName)) {
										            float existingQuantity = (float) productInfo.get("quantity");
										            productInfo.put("quantity", existingQuantity + quantity);
										            found = true;
										            break;
										        }
										    }

										   if (!found) {
										        Map<String, Object> newProduct = new LinkedHashMap<>();
										        newProduct.put("productName", productName);
										        newProduct.put("quantity", quantity);
										        productQuantityList.add(newProduct);
										    }
										

										  if (productNames.length() > 0) {
										        productNames.append(" / ");
										        quantities.append(" / ");
										    }
										  
										  productNames.append(getProductInfoRS.getString(1));  
										    quantities.append(getProductInfoRS.getString(2));    

										    entryDAO.setMaterialName(productNames.toString());  
										    entryDAO.setMaterialVolume(quantities.toString());
										    
										    totalQuantityInBrass += getProductInfoRS.getFloat(2);
					    		            
										    
									  }
			    					
			    					totalKm += resultSet.getFloat(10);
			    		            totalTrips += resultSet.getFloat(13);
			    		            totalTransportationCharges += resultSet.getFloat(18);
			    					
			    		            
			    		          
			    					this.getVehicleTripEntryInfoList().add(entryDAO);
			    					
			    				}
			    				
			    				
			    				
			    				
		    				
		    				   this.setTotalQuantityInBrass(totalQuantityInBrass);
		    				    this.setTotalKm(totalKm);
		    				    this.setTotalTrip(totalTrips);
		    				    this.setTotalTransportataionCharges(totalTransportationCharges);
		    				   
		    				    
		    				   
		    	    			
		    				    
		    				    sql  = "SELECT "
										+ "coninfo.vehicle_expense_entry_id,"
										+ "coninfo.vehicle_id,"
										+ "vinfo.vehicle_make,"
										+ "vinfo.vehicle_registration_number,"
										+ "DATE_FORMAT(coninfo.consumption_date,'%d-%m-%Y'),"
										+ "coninfo.consupmtion_time,"									
										+ "coninfo.consumption_product_id,"
										+ "coninfo.consumption_product_name,"
										+ "coninfo.quantity,"
										+ "coninfo.product_rate,"
										+ "coninfo.amount,"
										+ "coninfo.entry_by,"
										+ "coninfo.consupmtion_details "
										+ "FROM "
										+ "crusher_vehicle_consumption_master AS coninfo "
										+ "INNER JOIN "
										+ "crusher_vehicle_details_master AS vinfo "
										+ "ON coninfo.vehicle_id = vinfo.vehicle_id "
										+ "WHERE "
										+ "coninfo.vehicle_id = ? "
										+ "AND "
										+ "(coninfo.consumption_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
										+ "AND "
										+ "coninfo.crusher_id = ? "
										+ "AND "
										+ "coninfo.crusher_code = ? "
										+ "AND "
										+ "vinfo.crusher_id = ? "
										+ "AND "
										+ "vinfo.crusher_code = ? ";
								
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, this.getVehicleId());
									preparedStatement.setString(2, this.getFromDate());
									preparedStatement.setString(3, this.getToDate());
									preparedStatement.setString(4, crusherId);
									preparedStatement.setString(5, crusherCode);
									preparedStatement.setString(6, crusherId);
									preparedStatement.setString(7, crusherCode);
									
									resultSet = preparedStatement.executeQuery();
									
									
									while(resultSet.next())
									{
										VehicleConsumptionInfoDAO infoDAO = new VehicleConsumptionInfoDAO();
										
										infoDAO.setEntryId(resultSet.getString(1));
										infoDAO.setVehicleId(resultSet.getString(2));
										infoDAO.setVehicleMake(resultSet.getString(3));
										infoDAO.setVehicleRegNumber(resultSet.getString(4));
										infoDAO.setConsumptionDate(resultSet.getString(5));
										infoDAO.setConsumptionTime(resultSet.getString(6));
										infoDAO.setProductId(resultSet.getString(7));
										infoDAO.setProductName(resultSet.getString(8));
										infoDAO.setQuantity(resultSet.getFloat(9));
										infoDAO.setRate(resultSet.getFloat(10));
										infoDAO.setAmount(resultSet.getFloat(11));
										infoDAO.setEntryBy(resultSet.getString(12));
										infoDAO.setConsumptionDetails(resultSet.getString(13));
										
										
										this.setTotalConsumptionAmount(this.getTotalConsumptionAmount() + resultSet.getFloat(11));
										this.setTotalQuantity(this.getTotalQuantity() + resultSet.getFloat(9));
										this.getVehicleConInfoList().add(infoDAO);
										
									}


									
									sql = "SELECT "
											+ "maininfo.vehicle_expense_entry_id,"
											+ "maininfo.vehicle_id,"
											+ "vinfo.vehicle_make,"
											+ "vinfo.vehicle_registration_number,"
											+ "maininfo.exepense_date,"
											+ "maininfo.exepense_time,"
											+ "maininfo.exepense_amount,"
											+ "maininfo.entry_by,"
											+ "maininfo.consupmtion_details,"
											+ "maininfo.expence_image "
											+ "FROM "
											+ "crusher_vehicle_expense_master AS maininfo "
											+ "INNER JOIN "
											+ "crusher_vehicle_details_master AS vinfo "
											+ "ON maininfo.vehicle_id = vinfo.vehicle_id "
											+ "WHERE "
											+ "maininfo.vehicle_id = ? "
											+ "AND "
											+ "(maininfo.exepense_date "
											+ "BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
											+ "AND "
											+ "maininfo.crusher_id = ? "
											+ "AND "
											+ "maininfo.crusher_code = ? "
											+ "AND "
											+ "vinfo.crusher_id = ? "
											+ "AND "
											+ "vinfo.crusher_code = ? ";
									
										preparedStatement = connection.prepareStatement(sql);
										preparedStatement.setString(1, this.getVehicleId());
										preparedStatement.setString(2, this.getFromDate());
										preparedStatement.setString(3, this.getToDate());
										preparedStatement.setString(4, crusherId);
										preparedStatement.setString(5, crusherCode);
										preparedStatement.setString(6, crusherId);
										preparedStatement.setString(7, crusherCode);
										
										
										resultSet = preparedStatement.executeQuery();
										
										while(resultSet.next())
										{
											VehicleMaintenanceInfoDAO infoDAO = new VehicleMaintenanceInfoDAO();
											infoDAO.setEntryId(resultSet.getString(1));
											infoDAO.setVehicleId(resultSet.getString(2));
											infoDAO.setVehicleMake(resultSet.getString(3));
											infoDAO.setVehicleRegNumber(resultSet.getString(4));
											infoDAO.setEntryDate(resultSet.getString(5));
											infoDAO.setEntryTime(resultSet.getString(6));
											infoDAO.setAmount(resultSet.getFloat(7));
											infoDAO.setEntryBy(resultSet.getString(8));
											infoDAO.setComments(resultSet.getString(9));
											if(resultSet.getBlob(10) != null)
											{
												infoDAO.setImageAvailable(true);
											}
											else
											{
												infoDAO.setImageAvailable(false);
											}
											
											
											this.setTotalMaintenanceAmount(this.getTotalMaintenanceAmount() + resultSet.getFloat(7));
											
											this.getVehicleMainInfoList().add(infoDAO);
											
											
										}
										
		    				if(this.getVehicleTripEntryInfoList().size() > 0)
		    				{
		    					this.setVehicleAvgPerLiter(this.getTotalKm()/this.getTotalQuantity());
			    				this.setNettProfit(this.getTotalTransportataionCharges()-this.getTotalConsumptionAmount()-this.getTotalMaintenanceAmount());
			    				
			    				
		    					result = "success";
		    				}
		    				else
		    				{
		    					result = "error";
		    					addActionError(this.getText("message.error.detailsNotFound"));
		    				}
	    				
	    				
	    			
	    			
	    		} catch (SQLException e) {
	    			e.printStackTrace();
	    			result = "error";
	    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
	    		} catch (Exception e) {
	    			result = "error";
	    			e.printStackTrace();
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.somethingWentWrong"));
	    		} finally {
	    			if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    			
	    		}
	    	
	        }
	    	return result;
	}

	@Override
	public void validate() {
		
		
		session=ServletActionContext.getRequest().getSession(false); 
		 
       
        	vehicleList = GetVehicleList.getVehicleList(session);
        	
        	
		this.setAddSideBarJs("FALSE");
		
		if(this.getFromDate().equals("") && this.getToDate().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectDates"));
		}
	}

	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public String getVehicleId() {
		return vehicleId;
	}


	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public List<VehicleTripEntryDAO> getVehicleTripEntryInfoList() {
		return vehicleTripEntryInfoList;
	}

	public void setVehicleTripEntryInfoList(List<VehicleTripEntryDAO> vehicleTripEntryInfoList) {
		this.vehicleTripEntryInfoList = vehicleTripEntryInfoList;
	}

	public LinkedHashMap<String, String> getVehicleList() {
		return vehicleList;
	}

	public void setVehicleList(LinkedHashMap<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}

	public Float getTotalQuantityInBrass() {
		return totalQuantityInBrass;
	}

	public void setTotalQuantityInBrass(Float totalQuantityInBrass) {
		this.totalQuantityInBrass = totalQuantityInBrass;
	}

	public Float getTotalKm() {
		return totalKm;
	}

	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}

	public Float getTotalTrip() {
		return totalTrip;
	}

	public void setTotalTrip(Float totalTrip) {
		this.totalTrip = totalTrip;
	}

	public Float getTotalCharges() {
		return totalCharges;
	}

	public void setTotalCharges(Float totalCharges) {
		this.totalCharges = totalCharges;
	}

	public Float getTotalDiesel() {
		return totalDiesel;
	}

	public void setTotalDiesel(Float totalDiesel) {
		this.totalDiesel = totalDiesel;
	}

	public Float getTotalDieselAmount() {
		return totalDieselAmount;
	}

	public void setTotalDieselAmount(Float totalDieselAmount) {
		this.totalDieselAmount = totalDieselAmount;
	}

	public Float getTotalMaintenanceAmount() {
		return totalMaintenanceAmount;
	}

	public void setTotalMaintenanceAmount(Float totalMaintenanceAmount) {
		this.totalMaintenanceAmount = totalMaintenanceAmount;
	}

	public Float getVehicleAvgPerLiter() {
		return vehicleAvgPerLiter;
	}

	public void setVehicleAvgPerLiter(Float vehicleAvgPerLiter) {
		this.vehicleAvgPerLiter = vehicleAvgPerLiter;
	}

	public Float getNettProfit() {
		return nettProfit;
	}

	public void setNettProfit(Float nettProfit) {
		this.nettProfit = nettProfit;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public String getBillNo() {
		return billNo;
	}

	public void setBillNo(String billNo) {
		this.billNo = billNo;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public Float getTotalTransportataionCharges() {
		return totalTransportataionCharges;
	}

	public void setTotalTransportataionCharges(Float totalTransportataionCharges) {
		this.totalTransportataionCharges = totalTransportataionCharges;
	}

	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	public ArrayList<VehicleConsumptionInfoDAO> getVehicleConInfoList() {
		return vehicleConInfoList;
	}

	public void setVehicleConInfoList(ArrayList<VehicleConsumptionInfoDAO> vehicleConInfoList) {
		this.vehicleConInfoList = vehicleConInfoList;
	}

	public Float getTotalConsumptionAmount() {
		return totalConsumptionAmount;
	}

	public void setTotalConsumptionAmount(Float totalConsumptionAmount) {
		this.totalConsumptionAmount = totalConsumptionAmount;
	}

	public Float getTotalQuantity() {
		return totalQuantity;
	}

	public void setTotalQuantity(Float totalQuantity) {
		this.totalQuantity = totalQuantity;
	}

	public ArrayList<VehicleMaintenanceInfoDAO> getVehicleMainInfoList() {
		return vehicleMainInfoList;
	}

	public void setVehicleMainInfoList(ArrayList<VehicleMaintenanceInfoDAO> vehicleMainInfoList) {
		this.vehicleMainInfoList = vehicleMainInfoList;
	}

	public List<Map<String, Object>> getProductQuantityList() {
		return productQuantityList;
	}

	public void setProductQuantityList(List<Map<String, Object>> productQuantityList) {
		this.productQuantityList = productQuantityList;
	}

	
	
	
	
}
