package com.stonecrusher.report;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.VehicleDetailsDAO;
import com.stonecrusher.DAO.VehicleEntryDetailsDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class GetVehicleEmptyEntryDetails extends ActionSupport  implements SessionAware{

	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2400443911477718230L;
	private HttpSession session;
	private List<VehicleEntryDetailsDAO> vehicleEntryList = new ArrayList<VehicleEntryDetailsDAO>();
	private SessionMap<String,Object> sessionMap;  
	private String fromDate;
	private String toDate;
	private String addSideBarJs;
	
	
	
	public String execute() throws Exception {
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else
	        {
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		
	    		this.setAddSideBarJs("FALSE");
	    		
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				try
				{
					
					connection = GetDBConnection.getDBConnection(db);		
					
					sql = "SELECT "
							+ "entry_id,"
							+ "DATE_FORMAT(entry_date,'%d-%M-%Y'),"
							+ "entry_time,"
							+ "vehicle_id,"
							+ "vehicle_name,"
							+ "vehicle_reg_no,"
							+ "photo_1,"
							+ "empty_weight,"
							+ "status "
							+ "FROM "
							+ "crusher_vehicle_entry_details "
							+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "AND entry_date BETWEEN STR_TO_DATE(?, '%d-%m-%Y') AND STR_TO_DATE(?, '%d-%m-%Y') "
							+ "AND status = 'OPEN' "  
						    + "ORDER BY entry_date ASC";
					
					preparedStatement = connection.prepareStatement(sql);
				
					preparedStatement.setString(1, crusherId); 
					preparedStatement.setString(2, crusherCode);
					preparedStatement.setString(3, this.getFromDate());
					preparedStatement.setString(4, this.toDate);

					
					resultSet = preparedStatement.executeQuery();
					resultSet.last();
					int rowCount = resultSet.getRow();
					resultSet.beforeFirst();
					if(rowCount >  0)
					{
						while(resultSet.next())
						{
							VehicleEntryDetailsDAO dao = new VehicleEntryDetailsDAO();
							dao.setKeyVehicle(EncryptionDecryption.encrypt(resultSet.getString(1)));
							dao.setEntryId(resultSet.getString(1));
							dao.setEntryDate(resultSet.getString(2));
							dao.setEntryTime(resultSet.getString(3));
							dao.setVehicleId(resultSet.getString(4));
							dao.setVehicleName(resultSet.getString(5));
							dao.setVehicleRegNo(resultSet.getString(6));
							dao.setPhoto1PDF(resultSet.getBlob(7));
							dao.setEmptyWeight(resultSet.getFloat(8));
							dao.setStatus(resultSet.getString(9));
							dao.setIsFromVehicleEntryDetails(true);
							
							this.getVehicleEntryList().add(dao);
							
						}
						
						if(this.getVehicleEntryList().size() > 0)
						{
							result = "success";
						}else {
							result = "success";
							addActionError(this.getText("message.error.vehicleEmptyEntryDetailsNotFound"));
						}
						
						
					}
					else
					{
						result = "error";
						addActionError(this.getText("message.error.vehicleEmptyEntryDetailsNotFound"));
					}
					
				} catch (SQLException e) {
					result = "error";
					//e.printStackTrace();
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() );
				} catch (IOException e) {
					result = "error";
					
					addActionError(e.getMessage()+" || "+e.getCause());
				}finally {
					if(resultSet != null)
    				{
    					try {
    						resultSet.close();
    					} catch (SQLException e) {
    						
    					}
    				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close();} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	     
		return result;
	}
	
	
	@Override
	public void validate() {
		
		if(this.getFromDate() == null || this.getFromDate().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectFromDate"));
		}
		
		if(this.getToDate() == null || this.getToDate().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectToDate"));
		}
	}
	
	

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	

	public List<VehicleEntryDetailsDAO> getVehicleEntryList() {
		return vehicleEntryList;
	}

	public void setVehicleEntryList(List<VehicleEntryDetailsDAO> vehicleEntryList) {
		this.vehicleEntryList = vehicleEntryList;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		 sessionMap=(SessionMap<String, Object>)arg0;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	
	
	
}