package com.stonecrusher.report;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.RMCBillIngredientsUsedDAO;
import com.stonecrusher.db.GetDBConnection;

public class GetProductWiseMaterialUsedReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -8907737529743060727L;
	
	

	private  HttpSession session;

	private String fromDate;
	private String toDate;
	private String addSideBarJs;
	private Float totalTenMMUsed;
	private Float totalTwentyMMUsed;
	private Float totalWashSandUsed;
	private Float totalCrushSandUsed;
	private Float totalAddMixtureUsed;
	private Float totalOPCUsed;
	private Float totalPPCUsed;
	private Float totalWaterUsed;
	
	private SessionMap<String,Object> sessionMap;  
	
	private List<RMCBillIngredientsUsedDAO> rmcUsedIngreDAOList = new ArrayList<RMCBillIngredientsUsedDAO>();
    
        public String execute() {
		
		String result = "login";
		  session=ServletActionContext.getRequest().getSession(false);  
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result= "login";  
	        }  
	        else
	        {
	        	this.setAddSideBarJs("FALSE");
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
	    	
	        	
	        session=ServletActionContext.getRequest().getSession(false);  
			Connection connection = null;
			PreparedStatement preparedStatement = null;
			ResultSet resultSet = null;
			String sql = "";
			
			String db = (String) session.getAttribute("db");
			
			  
			
			 
			  
			try {
				
				connection = GetDBConnection.getDBConnection(db);
				
				
				sql = "SELECT "
    					+ "rmcused.rmc_bill_number,"
    					+ "rmcused.10mm,"
    					+ "rmcused.20mm,"
    					+ "rmcused.crushsand,"
    					+ "rmcused.washsand,"
    					+ "rmcused.water,"
    					+ "rmcused.addmixture,"
    					+ "rmcused.cementopc,"
    					+ "rmcused.cementppc,"
    					+ "rmcused.bill_type "
    					+ "FROM "
    					+ "rmc_bill_ingredients_used_details_master AS rmcused "    					
    					+ "WHERE (rmcused.entry_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
						+ "AND STR_TO_DATE(?,'%d-%m-%Y')) "
						+ "AND rmcused.crusher_id = ? "
        		        + "AND rmcused.crusher_code = ? "
        		        + "ORDER BY rmcused.entry_date,rmcused.entry_time,rmcused.rmc_bill_number,rmcused.bill_type" ;
    			
    			

    			preparedStatement = connection.prepareStatement(sql);
    			preparedStatement.setString(1, this.getFromDate());
				preparedStatement.setString(2, this.getToDate());
				preparedStatement.setString(3, crusherId); 
        		preparedStatement.setString(4, crusherCode); 
        		
        		//System.out.println(preparedStatement.toString());
        		
        		
        		resultSet = preparedStatement.executeQuery();
        		
        		
        		this.setTotalTenMMUsed(0.0f);
        		this.setTotalTwentyMMUsed(0.0f);
        		this.setTotalWashSandUsed(0.0f);
        		this.setTotalCrushSandUsed(0.0f);
        		this.setTotalWaterUsed(0.0f);
        		this.setTotalAddMixtureUsed(0.0f);
        		this.setTotalOPCUsed(0.0f);
        		this.setTotalPPCUsed(0.0f);
        		
        		
        		Map<String, RMCBillIngredientsUsedDAO> productWiseMap = new LinkedHashMap<>();

        		while (resultSet.next()) {
        		    String billNumber = resultSet.getString(1);
        		    float tenmm = resultSet.getFloat(2);
        		    float twentymm = resultSet.getFloat(3);
        		    float crushsand = resultSet.getFloat(4);
        		    float washsand = resultSet.getFloat(5);
        		    float water = resultSet.getFloat(6);
        		    float addmixture = resultSet.getFloat(7);
        		    float cementopc = resultSet.getFloat(8);
        		    float cementppc = resultSet.getFloat(9);

        		    String getRMCProductName = "SELECT product_name FROM crusher_rmc_productbillinfo "
        		                             + "WHERE crusher_id = ? AND crusher_code = ? AND bill_number = ?";
        		    PreparedStatement getRMCProductNamePSMT = connection.prepareStatement(getRMCProductName);
        		    getRMCProductNamePSMT.setString(1, crusherId);
        		    getRMCProductNamePSMT.setString(2, crusherCode);
        		    getRMCProductNamePSMT.setString(3, billNumber);

        		    ResultSet getRMCPRoductNameRS = getRMCProductNamePSMT.executeQuery();
        		    String productName = null;

        		    if (getRMCPRoductNameRS.next()) {
        		        productName = getRMCPRoductNameRS.getString(1);
        		    }

        		    getRMCPRoductNameRS.close();
        		    getRMCProductNamePSMT.close();

        		    if (productName == null) continue;

        		    RMCBillIngredientsUsedDAO existing = productWiseMap.get(productName);
        		    if (existing == null) {
        		        existing = new RMCBillIngredientsUsedDAO();
        		        existing.setProductName(productName);
        		        existing.setTenmm(tenmm);
        		        existing.setTwentymm(twentymm);
        		        existing.setCrushsand(crushsand);
        		        existing.setWashsand(washsand);
        		        existing.setWater(water);
        		        existing.setAddmixture(addmixture);
        		        existing.setCementOPC(cementopc);
        		        existing.setCementPPC(cementppc);

        		        productWiseMap.put(productName, existing);
        		    } else {
        		        existing.setTenmm(existing.getTenmm() + tenmm);
        		        existing.setTwentymm(existing.getTwentymm() + twentymm);
        		        existing.setCrushsand(existing.getCrushsand() + crushsand);
        		        existing.setWashsand(existing.getWashsand() + washsand);
        		        existing.setWater(existing.getWater() + water);
        		        existing.setAddmixture(existing.getAddmixture() + addmixture);
        		        existing.setCementOPC(existing.getCementOPC() + cementopc);
        		        existing.setCementPPC(existing.getCementPPC() + cementppc);
        		    }

        		   
        		    this.setTotalTenMMUsed(this.getTotalTenMMUsed() + tenmm);
        		    this.setTotalTwentyMMUsed(this.getTotalTwentyMMUsed() + twentymm);
        		    this.setTotalCrushSandUsed(this.getTotalCrushSandUsed() + crushsand);
        		    this.setTotalWashSandUsed(this.getTotalWashSandUsed() + washsand);
        		    this.setTotalWaterUsed(this.getTotalWaterUsed() + water);
        		    this.setTotalAddMixtureUsed(this.getTotalAddMixtureUsed() + addmixture);
        		    this.setTotalOPCUsed(this.getTotalOPCUsed() + cementopc);
        		    this.setTotalPPCUsed(this.getTotalPPCUsed() + cementppc);
        		}

        		
        		this.getRmcUsedIngreDAOList().addAll(productWiseMap.values());

        			
        		
				
				
				
				if(this.getRmcUsedIngreDAOList().size() > 0)
				{
					result = SUCCESS;
					
				}
				else
				{
					result = ERROR;
					addActionError(this.getText("message.error.recordsNotFoundForSpecificDates"));
				}
				
				
				
			}catch (SQLException e) {
				e.printStackTrace();
				result = "error";
				addActionError(this.getText("message.error.recordsNotFoundForSpecificDates"));
				
				
			} catch (IOException e) {
			
				result="error";
				e.printStackTrace();
				addActionError(this.getText("message.error.recordsNotFoundForSpecificDates"));
			}finally
			{
				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
				
			}
			
			
			
	        }
	        
	        return result;
}
	
@Override
public void validate() {
	if(this.getFromDate() == null || this.getFromDate().equals(""))
	{
		addActionError(this.getText("message.error.plzSelectFromDate"));
	}
	
	if(this.getToDate() == null || this.getFromDate().equals(""))
	{
		addActionError(this.getText("message.error.plzSelectToDate"));
	}
}

	public HttpSession getSession() {
	return session;
}


public void setSession(HttpSession session) {
	this.session = session;
}






public String getFromDate() {
	return fromDate;
}


public void setFromDate(String fromDate) {
	this.fromDate = fromDate;
}


public String getToDate() {
	return toDate;
}


public void setToDate(String toDate) {
	this.toDate = toDate;
}


public static long getSerialversionuid() {
	return serialVersionUID;
}


	


	
	public List<RMCBillIngredientsUsedDAO> getRmcUsedIngreDAOList() {
	return rmcUsedIngreDAOList;
}

public void setRmcUsedIngreDAOList(List<RMCBillIngredientsUsedDAO> rmcUsedIngreDAOList) {
	this.rmcUsedIngreDAOList = rmcUsedIngreDAOList;
}

	public void setSession(Map<String, Object> map) {
		// TODO Auto-generated method stub
		 sessionMap=(SessionMap<String, Object>)map;  
		
	}

	

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}


	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public Float getTotalTenMMUsed() {
		return totalTenMMUsed;
	}

	public void setTotalTenMMUsed(Float totalTenMMUsed) {
		this.totalTenMMUsed = totalTenMMUsed;
	}

	public Float getTotalTwentyMMUsed() {
		return totalTwentyMMUsed;
	}

	public void setTotalTwentyMMUsed(Float totalTwentyMMUsed) {
		this.totalTwentyMMUsed = totalTwentyMMUsed;
	}

	public Float getTotalWashSandUsed() {
		return totalWashSandUsed;
	}

	public void setTotalWashSandUsed(Float totalWashSandUsed) {
		this.totalWashSandUsed = totalWashSandUsed;
	}

	public Float getTotalCrushSandUsed() {
		return totalCrushSandUsed;
	}

	public void setTotalCrushSandUsed(Float totalCrushSandUsed) {
		this.totalCrushSandUsed = totalCrushSandUsed;
	}

	public Float getTotalAddMixtureUsed() {
		return totalAddMixtureUsed;
	}

	public void setTotalAddMixtureUsed(Float totalAddMixtureUsed) {
		this.totalAddMixtureUsed = totalAddMixtureUsed;
	}

	public Float getTotalOPCUsed() {
		return totalOPCUsed;
	}

	public void setTotalOPCUsed(Float totalOPCUsed) {
		this.totalOPCUsed = totalOPCUsed;
	}

	public Float getTotalPPCUsed() {
		return totalPPCUsed;
	}

	public void setTotalPPCUsed(Float totalPPCUsed) {
		this.totalPPCUsed = totalPPCUsed;
	}

	public Float getTotalWaterUsed() {
		return totalWaterUsed;
	}

	public void setTotalWaterUsed(Float totalWaterUsed) {
		this.totalWaterUsed = totalWaterUsed;
	}
	

}
