package com.stonecrusher.report;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.ItemWiseSaleReportDAO;
import com.stonecrusher.db.GetDBConnection;

public class GetItemWiseSalesReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -8907737529743060727L;
	
	

	private  HttpSession session;

	private Float allBillMatrialCostTotal = 0.0F;
	private Float allMaterialQuantity = 0.0F;
	private String fromDate;
	private String toDate;
	private String addSideBarJs;
	
	private SessionMap<String,Object> sessionMap;  
	
		List<ItemWiseSaleReportDAO> itemWiseSaleList = new ArrayList<ItemWiseSaleReportDAO>();
		private List<String> typeList = new ArrayList<String>();
		private String type;
		
public String execute() {
		
		String result = "login";
		  session=ServletActionContext.getRequest().getSession(false);  
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result= "login";  
	        }  
	        else
	        {
	        	this.setAddSideBarJs("FALSE");
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
	    	
	        	
	        session=ServletActionContext.getRequest().getSession(false);  
			Connection connection = null;
			PreparedStatement preparedStatement = null;
			ResultSet resultSet = null;
			String sql = "";
			
			String db = (String) session.getAttribute("db");
			
			  
			Map<String, ItemWiseSaleReportDAO> productMap = new LinkedHashMap<>();
			
			DecimalFormat df= new DecimalFormat("##.##");
			  
			try {
				
				connection = GetDBConnection.getDBConnection(db);
				
				if(this.getType().equals("ALL") || this.getType().equals("CRUSHER"))
				{
					
				
				sql =   "SELECT proInfo.product_name,"
						+ "SUM(proInfo.product_sale_amount_after_discount),"
						+ "SUM(proInfo.sale_quantity) "
						+ "FROM "
						+ "crusher_bill_product_info as proInfo "
						+ "WHERE "
						+ "bill_number IN "
						+ "(SELECT bill_number "
						+ "FROM crusher_bill_info_master WHERE (bill_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
						+ "AND STR_TO_DATE(?,'%d-%m-%Y')) "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ?  "
						+ ") "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ?  "
						+ "group by proInfo.product_name";
				
				
				preparedStatement = connection.prepareStatement(sql);
				
				preparedStatement.setString(1, this.getFromDate());
				preparedStatement.setString(2, this.getToDate());
				preparedStatement.setString(3, crusherId);
				preparedStatement.setString(4, crusherCode);
				preparedStatement.setString(5, crusherId);
				preparedStatement.setString(6, crusherCode);
			
				this.setAllBillMatrialCostTotal(0.0F);
				this.setAllMaterialQuantity(0.0F);
				resultSet = preparedStatement.executeQuery();
				
				while(resultSet.next()){
				
					String productName = resultSet.getString(1);
				    float saleAmount = resultSet.getFloat(2);
				    float quantity = resultSet.getFloat(3);

				    if (productMap.containsKey(productName)) {
				       
				        ItemWiseSaleReportDAO existingDao = productMap.get(productName);
				        existingDao.setSaleAmount(df.format(Float.parseFloat(existingDao.getSaleAmount()) + saleAmount));
				        existingDao.setProductQuantity(df.format(Float.parseFloat(existingDao.getProductQuantity()) + quantity));
				    } else {
				       
				        ItemWiseSaleReportDAO dao = new ItemWiseSaleReportDAO();
				        dao.setProductName(productName);
				        dao.setSaleAmount(df.format(saleAmount));
				        dao.setProductQuantity(df.format(quantity));
				        productMap.put(productName, dao);
				    }
				    this.setAllBillMatrialCostTotal(this.getAllBillMatrialCostTotal() + saleAmount);
				    this.setAllMaterialQuantity(this.getAllMaterialQuantity() + quantity);
				}
				}
				
				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				
				if(this.getType().equals("ALL") || this.getType().equals("RMC"))
				{
					
				
				sql =   "SELECT proInfo.product_name,"
						+ "SUM(proInfo.product_amt_after_discount),"
						+ "SUM(proInfo.quanity) "
						+ "FROM "
						+ "crusher_rmc_productbillinfo as proInfo "
						+ "WHERE "
						+ "bill_number IN "
						+ "(SELECT bill_number "
						+ "FROM crusher_rmc_billinfo WHERE (bill_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
						+ "AND STR_TO_DATE(?,'%d-%m-%Y')) "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ?  "
						+ ") "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ?  "
						+ "group by proInfo.product_name";
				
				
				preparedStatement = connection.prepareStatement(sql);
				
				preparedStatement.setString(1, this.getFromDate());
				preparedStatement.setString(2, this.getToDate());
				preparedStatement.setString(3, crusherId);
				preparedStatement.setString(4, crusherCode);
				preparedStatement.setString(5, crusherId);
				preparedStatement.setString(6, crusherCode);
			
				resultSet = preparedStatement.executeQuery();
				while(resultSet.next()){
				
					String productName = resultSet.getString(1);
				    float saleAmount = resultSet.getFloat(2);
				    float quantity = resultSet.getFloat(3);

				    if (productMap.containsKey(productName)) {
				        
				        ItemWiseSaleReportDAO existingDao = productMap.get(productName);
				        existingDao.setSaleAmount(df.format(Float.parseFloat(existingDao.getSaleAmount()) + saleAmount));
				        existingDao.setProductQuantity(df.format(Float.parseFloat(existingDao.getProductQuantity()) + quantity));
				    } else {
				        
				        ItemWiseSaleReportDAO dao = new ItemWiseSaleReportDAO();
				        dao.setProductName(productName);
				        dao.setSaleAmount(df.format(saleAmount));
				        dao.setProductQuantity(df.format(quantity));
				        productMap.put(productName, dao);
				    }
				    this.setAllBillMatrialCostTotal(this.getAllBillMatrialCostTotal() + saleAmount);
				    this.setAllMaterialQuantity(this.getAllMaterialQuantity() + quantity);
				}
				}
				
				int k = 1;
				for (ItemWiseSaleReportDAO dao : productMap.values()) {
				    dao.setSrNo(k++);
				    this.getItemWiseSaleList().add(dao);
				}
				
				
				if(this.getItemWiseSaleList().size() > 0)
				{
					result = SUCCESS;
					
				}
				else
				{
					result = ERROR;
					addActionError(this.getText("message.error.recordsNotFoundForSpecificDates"));
				}
				
				
				
			}catch (SQLException e) {
				//e.printStackTrace();
				result = "error";
				addActionError(this.getText("message.error.recordsNotFoundForSpecificDates"));
				
				
			} catch (IOException e) {
			
				result="error";
				//e.printStackTrace();
				addActionError(this.getText("message.error.recordsNotFoundForSpecificDates"));
			}finally
			{
				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
				
			}
			
			
			
	        }
	        
	        return result;
}
	
@Override
public void validate() {
	
	typeList.add("ALL");
		typeList.add("CRUSHER");
		typeList.add("RMC");
		
		
		
	if(this.getFromDate() == null || this.getFromDate().equals(""))
	{
		addActionError(this.getText("message.error.plzSelectFromDate"));
	}
	
	if(this.getToDate() == null || this.getFromDate().equals(""))
	{
		addActionError(this.getText("message.error.plzSelectToDate"));
	}
	
	if(this.getType() == null || this.getType().equals(""))
	{
		addActionError("Please Select Type !");
	}
	
	
}

	public HttpSession getSession() {
	return session;
}


public void setSession(HttpSession session) {
	this.session = session;
}



public Float getAllBillMatrialCostTotal() {
	return allBillMatrialCostTotal;
}


public void setAllBillMatrialCostTotal(Float allBillMatrialCostTotal) {
	this.allBillMatrialCostTotal = allBillMatrialCostTotal;
}




public String getFromDate() {
	return fromDate;
}


public void setFromDate(String fromDate) {
	this.fromDate = fromDate;
}


public String getToDate() {
	return toDate;
}


public void setToDate(String toDate) {
	this.toDate = toDate;
}


public static long getSerialversionuid() {
	return serialVersionUID;
}


	


	public List<ItemWiseSaleReportDAO> getItemWiseSaleList() {
	return itemWiseSaleList;
}

public void setItemWiseSaleList(List<ItemWiseSaleReportDAO> itemWiseSaleList) {
	this.itemWiseSaleList = itemWiseSaleList;
}

	public void setSession(Map<String, Object> map) {
		// TODO Auto-generated method stub
		 sessionMap=(SessionMap<String, Object>)map;  
		
	}

	

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public Float getAllMaterialQuantity() {
		return allMaterialQuantity;
	}

	public void setAllMaterialQuantity(Float allMaterialQuantity) {
		this.allMaterialQuantity = allMaterialQuantity;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}


	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public List<String> getTypeList() {
		return typeList;
	}

	public void setTypeList(List<String> typeList) {
		this.typeList = typeList;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

}
