package com.stonecrusher.report;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.GSTSaleBillInfoDAO;
import com.stonecrusher.db.GetDBConnection;

public class GetGSTSalesReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3502790352342908340L;
	private List<GSTSaleBillInfoDAO> fromDateToGSTReportDAOList = new ArrayList<GSTSaleBillInfoDAO>();
	
	private  HttpSession session;

	private String fromDate;
	private String toDate;
	private String reportFormat;
	private String addSideBarJs;

   private ArrayList<String> reportFormatList = new ArrayList<String>();
	
	
	private SessionMap<String,Object> sessionMap;  


	public String execute() {
		
		String result = "login";
		  session=ServletActionContext.getRequest().getSession(false);  
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result= "login";  
	        }  
	        else
	        {
	        	this.setAddSideBarJs("FALSE");
	        	
	        session=ServletActionContext.getRequest().getSession(false);  
	        
			Connection connection = null;
			PreparedStatement preparedStatement = null;
			ResultSet resultSet = null;
			String sql = "";
			String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    	
    	
			String db = (String) session.getAttribute("db");
			
			
			  
			try {
				
				DecimalFormat df = new DecimalFormat("##.##");
				
				connection = GetDBConnection.getDBConnection(db);
				
				
				LinkedHashMap<String,GSTSaleBillInfoDAO> billMap = new LinkedHashMap<String,GSTSaleBillInfoDAO>();
				 
				 sql = "SELECT "
				  		+ "bi.bill_number,"
				  		+ "DATE_FORMAT(bi.bill_date,'%d-%m-%Y'),"
				  		+ "bi.customer_id,"
				  		+ "bi.customer_name,"
				  		+ "cust.billing_address,"
				  		+ "cust.gst_number,"
				  		+ "bi.transportation_charges,"
				  		+ "bi.bill_total_amount,"
				  		+ "bi.billed_by,"
				  		+ "bi.comments "
				  		+ "FROM "
				  		+ "crusher_bill_info_tax_invoice_master as bi "
				  		+ "INNER JOIN "
				  		+ "crusher_customer_master as cust "
				  		+ "ON "
				  		+ "bi.customer_id = cust.customer_id "
				  		+ "WHERE "
				  		+ "(bill_date  "
				  		+ "BETWEEN "
				  		+ "STR_TO_DATE(?,'%d-%m-%Y') "
				  		+ "AND "
				  		+ "STR_TO_DATE(?,'%d-%m-%Y')) "
				  		+ "AND "
				  		+ "bill_amount_received != 'null' "
				  		+ "AND "
				  		+ "bill_type = 'TAX-INVOICE' "
				  		+ "AND "
				  		+ "bi.crusher_id = ? "
				  		+ "AND "
				  		+ "bi.crusher_code = ? "
				  		+ "AND "
				  		+ "cust.crusher_id = ? "
				  		+ "AND "
				  		+ "cust.crusher_code = ? "
				  		+ "ORDER BY bi.bill_date,bi.bill_number";
				  
				  preparedStatement = connection.prepareStatement(sql);
				  
				  
				  preparedStatement.setString(1, this.getFromDate());
				  preparedStatement.setString(2, this.getToDate());
				  preparedStatement.setString(3, crusherId);
				  preparedStatement.setString(4, crusherCode);
				  preparedStatement.setString(5, crusherId);
				  preparedStatement.setString(6, crusherCode);
				  
				  
				  resultSet = preparedStatement.executeQuery();
				  
				  while(resultSet.next())
				  {
					  
					  GSTSaleBillInfoDAO dao = new GSTSaleBillInfoDAO();
					
					  dao.setBillNumber(resultSet.getString(1));
					  dao.setBillDate(resultSet.getString(2));
					  dao.setCustId(resultSet.getString(3));
					  dao.setCustName(resultSet.getString(4).split("-")[1]);
					  dao.setCustAddress(resultSet.getString(5));
					  dao.setCustGstNumber(resultSet.getString(6));
					  dao.setTransportCharges(resultSet.getFloat(7));
					  dao.setBillTotalAmount(resultSet.getString(8));
					  dao.setBilledBy(resultSet.getString(9));
					  dao.setComments(resultSet.getString(10));
					  
					  billMap.put(resultSet.getString(1), dao);
				  }
				  
				  
				  if(resultSet != null)
				  {
					  resultSet.close();
					  resultSet = null;
				  }
				  
				  if(preparedStatement != null)
				  {
					  preparedStatement.close();
					  preparedStatement = null;
				  }
				  int srNo = 1;
				  for(String billNumber:billMap.keySet())
				  {
					  
					  String getProductInfoSQL = "";
					  PreparedStatement getProductInfoPSMT = null;
					  ResultSet getProductInfoRS = null;
					  
					  GSTSaleBillInfoDAO dao = billMap.get(billNumber);
					  
					  getProductInfoSQL = "SELECT "
					  		+ "product_name,"
					  		+ "product_sale_amount_after_discount,"
					  		+ "sale_quantity,"
					  		+ "sales_rate,"
					  		+ "product_gross_amount,"
					  		+ "product_igst,"
					  		+ "product_cgst_amount,"
					  		+ "product_sgst_amount "
					  		+ "FROM "
					  		+ "crusher_bill_tax_invoice_product_info "
					  		+ "WHERE "
					  		+ "bill_number = ? "
					  		+ "AND "
					  		+ "bill_type = 'TAX-INVOICE' "
					  		+ "AND "
					  		+ "crusher_id = ? "
					  		+ "AND "
					  		+ "crusher_code = ? ";
					  
					  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
					  
					  getProductInfoPSMT.setString(1, billNumber);
					  getProductInfoPSMT.setString(2, crusherId);
					  getProductInfoPSMT.setString(3, crusherCode);
					  
					  getProductInfoRS = getProductInfoPSMT.executeQuery();
					  
					  StringBuilder productNames = new StringBuilder();
						StringBuilder quantities = new StringBuilder();

					
						while(getProductInfoRS.next()) {
						    GSTSaleBillInfoDAO productDao = new GSTSaleBillInfoDAO();

						  
						    productDao.setBillNumber(dao.getBillNumber());
						    productDao.setBillDate(dao.getBillDate());
						    productDao.setCustId(dao.getCustId());
						    productDao.setCustName(dao.getCustName());
						    productDao.setCustAddress(dao.getCustAddress());
						    productDao.setCustGstNumber(dao.getCustGstNumber());
						    productDao.setTransportCharges(dao.getTransportCharges());
						    productDao.setBillTotalAmount(dao.getBillTotalAmount());
						    productDao.setBilledBy(dao.getBilledBy());
						    productDao.setComments(dao.getComments());

						   
						    productDao.setSrNo("" + srNo);
						    productDao.setItemName(getProductInfoRS.getString(1));
						    productDao.setItemQuantity(getProductInfoRS.getString(3));
						    productDao.setItemRate(getProductInfoRS.getString(4));
						    productDao.setTaxableAmount(df.format(getProductInfoRS.getFloat(5)));
						    productDao.setIgst(df.format(getProductInfoRS.getFloat(6)));
						    productDao.setSgst(df.format(getProductInfoRS.getFloat(7)));
						    productDao.setCgst(df.format(getProductInfoRS.getFloat(8)));

						    float tcs = 0.0f;
						    productDao.setTcs(df.format(tcs));
						    productDao.setTotalAmount(df.format(
						        getProductInfoRS.getFloat(5) + 
						        getProductInfoRS.getFloat(7) + 
						        getProductInfoRS.getFloat(8)
						    ));

						    productDao.setGrandTotal(df.format(
						        getProductInfoRS.getFloat(5) +
						        getProductInfoRS.getFloat(6) +
						        getProductInfoRS.getFloat(7) +
						        getProductInfoRS.getFloat(8) +
						        dao.getTransportCharges() + tcs
						    ));

						    srNo++;

						   
						    this.getFromDateToGSTReportDAOList().add(productDao);
						}

				
					  billMap.put(billNumber, dao);
					  
					  if(getProductInfoRS != null)
					  {
						  getProductInfoRS.close();
						  getProductInfoRS = null;
					  }
					  
					  if(getProductInfoPSMT != null)
					  {
						  getProductInfoPSMT.close();
						  getProductInfoPSMT = null;
					  }
					  
					  
					  
				  }
				  
				  
				  
					  
					
		    			
					  result = SUCCESS;
				 
			}
			catch (SQLException e) {
				e.printStackTrace();
				result = "error";
				addActionError(this.getText("message.error.recordsNotFoundForSpecificDates"));
				
				
			} catch (IOException e) {
			
				result="error";
				//e.printStackTrace();
				addActionError(this.getText("message.error.recordsNotFoundForSpecificDates"));
			}finally
			{
				if(resultSet != null)
   				{
   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
   				}
				if(preparedStatement != null)
				{
					try {
						preparedStatement.close(); preparedStatement = null;
					} catch (SQLException e) {
						
					}
				}
				
				if(connection != null)
				{
					try {
						connection.close(); connection = null;
					} catch (SQLException e) {
						
					}
				}
				
				
			}
			
			
			
	        }
	        
	        return result;
}
	
	@Override
	public void validate() {
		if(this.getFromDate().equals("") && this.getToDate().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectDates"));
		}
		
		
		
    	this.getReportFormatList().add("EXCEL");
    	this.getReportFormatList().add("PDF");
    	
	}
	
	
	public void setSession(Map<String, Object> map) {
		// TODO Auto-generated method stub
		 sessionMap=(SessionMap<String, Object>)map;  
		
	}

	

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}


	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}








	public List<GSTSaleBillInfoDAO> getFromDateToGSTReportDAOList() {
		return fromDateToGSTReportDAOList;
	}

	public void setFromDateToGSTReportDAOList(List<GSTSaleBillInfoDAO> fromDateToGSTReportDAOList) {
		this.fromDateToGSTReportDAOList = fromDateToGSTReportDAOList;
	}


	public String getFromDate() {
		return fromDate;
	}




	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}




	public ArrayList<String> getReportFormatList() {
		return reportFormatList;
	}

	public void setReportFormatList(ArrayList<String> reportFormatList) {
		this.reportFormatList = reportFormatList;
	}

	public String getToDate() {
		return toDate;
	}




	public void setToDate(String toDate) {
		this.toDate = toDate;
	}




	public String getReportFormat() {
		return reportFormat;
	}

	public void setReportFormat(String reportFormat) {
		this.reportFormat = reportFormat;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	
	
}

