package com.stonecrusher.report;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;


import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.GSTSaleBillInfoDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;

public class GetGSTR_1Report extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 3889256261560470795L;
	private HttpSession session;
	private String fromDate;
	private String toDate;
	private String Source;
	private String customerName;
	private String Sheet;
	
	
	private List<GSTSaleBillInfoDAO> fromDateToGSTReportDAOList = new ArrayList<GSTSaleBillInfoDAO>();
	
	private Map<String,String> SourceList = new HashMap<String,String>();
	private Map<String,String> SheetList = new HashMap<String,String>();
	
	public HttpServletRequest request;
	public HttpServletResponse response;
	
	private SessionMap<String,Object> sessionMap;  
	private String addSideBarJs;

	 
	@SuppressWarnings("resource")
	public String execute() {
		
		String result = "login";
		  session=ServletActionContext.getRequest().getSession(false);  
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result= "login";  
	        }  
	        else
	        {
		
			
		
		session=ServletActionContext.getRequest().getSession(false);  
		Connection connection = null;
		PreparedStatement preparedStatement = null;
		ResultSet resultSet = null;
		String sql = "";
		
		String db = (String) session.getAttribute("db");
		
		String crusherId = (String) this.getSessionMap().get("crusherId");
		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	
		  
		try {
			
			DecimalFormat df = new DecimalFormat("##.##");
			
			String splitCustomerName [] = new String[5];
        	
        	String customerId = "";
        	try
        	{
        		splitCustomerName = customerName.split("-");
        		customerId = splitCustomerName[0];
        		
        	}catch(Exception e)
        	{
        		customerId = customerName;
        	}
        	
        	
        	connection = GetDBConnection.getDBConnection(db);
			
			
			LinkedHashMap<String,GSTSaleBillInfoDAO> billMap = new LinkedHashMap<String,GSTSaleBillInfoDAO>();
   if(this.getSource().equals("ALL") || this.getSource().equals("CRUSHER"))
				
			{
				if(this.getCustomerName().equals("ALL") || this.getCustomerName() == "NULL" || this.getCustomerName().equals(""))
				{
			 sql = "SELECT "
			  		+ "bi.bill_number,"
			  		+ "DATE_FORMAT(bi.bill_date,'%d-%m-%Y'),"
			  		+ "bi.customer_id,"
			  		+ "bi.customer_name,"
			  		+ "cust.billing_address,"
			  		+ "cust.gst_number,"
			  		+ "bi.transportation_charges,"
			  		+ "bi.bill_total_amount,"
			  		+ "bi.billed_by,"
			  		+ "bi.comments "
			  		+ "FROM "
			  		+ "crusher_bill_info_tax_invoice_master as bi "
			  		+ "INNER JOIN "
			  		+ "crusher_customer_master as cust "
			  		+ "ON "
			  		+ "bi.customer_id = cust.customer_id "
			  		+ "WHERE "
			  		+ "(bill_date  "
			  		+ "BETWEEN "
			  		+ "STR_TO_DATE(?,'%d-%m-%Y') "
			  		+ "AND "
			  		+ "STR_TO_DATE(?,'%d-%m-%Y')) "
			  		+ "AND "
			  		+ "bill_type = 'TAX-INVOICE' "
			  		+ "AND "
			  	    + "bi.crusher_id = ? " 
			  	    + "AND "
			        + "bi.crusher_code = ? " 
			        + "AND "
			  	    + "cust.crusher_id = ? " 
			  	    + "AND "
			        + "cust.crusher_code = ? " 
			        + "ORDER BY bi.bill_date,bi.bill_number";
			  
			  preparedStatement = connection.prepareStatement(sql);
			  
			  preparedStatement.setString(1, this.getFromDate());
			  preparedStatement.setString(2, this.getToDate());
			  preparedStatement.setString(3, crusherId);
			  preparedStatement.setString(4, crusherCode);
			  preparedStatement.setString(5, crusherId);
			  preparedStatement.setString(6, crusherCode);
			  
				}
				
				else{
					
					
					
					 sql = "SELECT "
						  		+ "bi.bill_number,"
						  		+ "DATE_FORMAT(bi.bill_date,'%d-%m-%Y'),"
						  		+ "bi.customer_id,"
						  		+ "bi.customer_name,"
						  		+ "cust.billing_address,"
						  		+ "cust.gst_number,"
						  		+ "bi.transportation_charges,"
						  		+ "bi.bill_total_amount,"
						  		+ "bi.billed_by,"
						  		+ "bi.comments "
						  		+ "FROM "
						  		+ "crusher_bill_info_tax_invoice_master as bi "
						  		+ "INNER JOIN "
						  		+ "crusher_customer_master as cust "
						  		+ "ON "
						  		+ "bi.customer_id = cust.customer_id "
						  		+ "WHERE "
						  		+ "(bill_date  "
						  		+ "BETWEEN "
						  		+ "STR_TO_DATE(?,'%d-%m-%Y') "
						  		+ "AND "
						  		+ "STR_TO_DATE(?,'%d-%m-%Y')) "
						  		+ "AND "
						  		+ "bill_type = 'TAX-INVOICE' "
						  		+ "AND "
					            + "bi.customer_id = ? "
					            + "AND "
						  	    + "bi.crusher_id = ? " 
						  	    + "AND "
						        + "bi.crusher_code = ? " 
						        + "AND "
						  	    + "cust.crusher_id = ? " 
						  	    + "AND "
						        + "cust.crusher_code = ? " 
						        + "ORDER BY bi.bill_date,bi.bill_number";
						  
						  preparedStatement = connection.prepareStatement(sql);
						  
						  preparedStatement.setString(1, this.getFromDate());
						  preparedStatement.setString(2, this.getToDate());
					      preparedStatement.setString(3, customerId);
					      preparedStatement.setString(4, crusherId);
						  preparedStatement.setString(5, crusherCode);
						  preparedStatement.setString(6, crusherId);
						  preparedStatement.setString(7, crusherCode);
						  
					
				}
				resultSet = preparedStatement.executeQuery();
				  
				  while(resultSet.next())
				  {
					  GSTSaleBillInfoDAO dao = new GSTSaleBillInfoDAO();
					
					  dao.setBillNumber(resultSet.getString(1));
					  dao.setBillDate(resultSet.getString(2));
					  dao.setCustId(resultSet.getString(3));
					  dao.setCustName(resultSet.getString(4).split("-")[1]);
					  dao.setCustAddress(resultSet.getString(5));
					  dao.setCustGstNumber(resultSet.getString(6));
					  dao.setTransportCharges(resultSet.getFloat(7));
					  dao.setBillTotalAmount(resultSet.getString(8));
					  dao.setBilledBy(resultSet.getString(9));
					  dao.setComments(resultSet.getString(10));
					  
					  billMap.put(resultSet.getString(1), dao);
				  }
				  
				
			 } 
   if(resultSet !=null)
	{
		try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
	}
	if(preparedStatement != null)
	{
		try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	}
				
				  if(this.getSource().equals("ALL") || this.getSource().equals("RMC"))
				  
				  {
				  
				  
				  if (this.getCustomerName().equals("ALL") || this.getCustomerName() == "NULL"
				  || this.getCustomerName().equals("")) {
				  
				  
					  sql = "SELECT " 
						         + "bi.bill_number," 
								 + "DATE_FORMAT(bi.bill_date,'%d-%m-%Y')," 
						         + "bi.customer_id," 
								 + "bi.customer_name," 
						         + "cust.billing_address," 
								 + "cust.gst_number," 
						         + "bi.transport_charges," 
								 + "bi.bill_total_amount," 
						         + "bi.billed_by," 
								 + "bi.comments " 
						         + "FROM " 
								 + "crusher_rmc_billinfo as bi " 
						         + "INNER JOIN " 
								 + "crusher_customer_master as cust " 
						         + "ON " 
								 + "bi.customer_id = cust.customer_id " 
								 + "WHERE " 
								 + "(bill_date  " 
						         + "BETWEEN " 
								 + "STR_TO_DATE(?,'%d-%m-%Y') " 
								 + "AND " 
						         + "STR_TO_DATE(?,'%d-%m-%Y')) " 
								 + "AND " 
						         + "bill_type = 'TAX-INVOICE' " 
						         + "AND "
								 + "bi.crusher_id = ? " 
								 + "AND "
								 + "bi.crusher_code = ? " 
								 + "AND "
								 + "cust.crusher_id = ? " 
							     + "AND "
							     + "cust.crusher_code = ? " 
								 + "ORDER BY bi.bill_date,bi.bill_number";
					  
					  
					  
					  preparedStatement = connection.prepareStatement(sql);
					  
					  preparedStatement.setString(1, this.getFromDate());
					  preparedStatement.setString(2, this.getToDate());
					  preparedStatement.setString(3, crusherId);
					  preparedStatement.setString(4, crusherCode);
					  preparedStatement.setString(5, crusherId);
					  preparedStatement.setString(6, crusherCode);
				  
				  
				  
				  }else {
				  
					  sql = "SELECT " 
						        + "bi.bill_number, " 
								+ "DATE_FORMAT(bi.bill_date, '%d-%m-%Y'), " 
						        + "bi.customer_id, " 
								+ "bi.customer_name, " 
						        + "cust.billing_address, " 
								+ "cust.gst_number, " 
						        + "bi.transport_charges, " 
								+ "bi.bill_total_amount, " 
						        + "bi.billed_by, " 
								+ "bi.comments " 
						        + "FROM " 
								+ "crusher_rmc_billinfo AS bi " 
						        + "INNER JOIN " 
								+ "crusher_customer_master AS cust " 
						        + "ON bi.customer_id = cust.customer_id " 
								+ "WHERE " 
						        + "(bi.bill_date BETWEEN STR_TO_DATE(?, '%d-%m-%Y') AND STR_TO_DATE(?, '%d-%m-%Y')) "
						        + "AND bi.bill_type = 'TAX-INVOICE' " 
						        + "AND bi.customer_id = ? " 
						        + "AND "
								+ "bi.crusher_id = ? " 
								+ "AND "
								+ "bi.crusher_code = ? " 
								+ "AND "
								+ "cust.crusher_id = ? " 
							    + "AND "
							    + "cust.crusher_code = ? " 
								+ "ORDER BY bi.bill_date, bi.bill_number";
						  
						  preparedStatement = connection.prepareStatement(sql);
						  
						  preparedStatement.setString(1, this.getFromDate());
						  preparedStatement.setString(2, this.getToDate());
						  preparedStatement.setString(3, customerId);
						  preparedStatement.setString(4, crusherId);
						  preparedStatement.setString(5, crusherCode);
						  preparedStatement.setString(6, crusherId);
						  preparedStatement.setString(7, crusherCode);
						  }
				  
				  resultSet = preparedStatement.executeQuery();
				  
				  while(resultSet.next()) {
				  
				  GSTSaleBillInfoDAO dao = new GSTSaleBillInfoDAO();
				  
				  dao.setBillNumber(resultSet.getString(1));
				  dao.setBillDate(resultSet.getString(2));
				  dao.setCustId(resultSet.getString(3));
				  dao.setCustName(resultSet.getString(4).split("-")[1]);
				  dao.setCustAddress(resultSet.getString(5));
				  dao.setCustGstNumber(resultSet.getString(6));
				  dao.setTransportCharges(resultSet.getFloat(7));
				  dao.setBillTotalAmount(resultSet.getString(8));
				  dao.setBilledBy(resultSet.getString(9));
				  dao.setComments(resultSet.getString(10));
				  
				  billMap.put(resultSet.getString(1), dao); }
				  
				  }
				 
			  if(resultSet != null)
			  {
				  resultSet.close();
				  resultSet = null;
			  }
			  
			  if(preparedStatement != null)
			  {
				  preparedStatement.close();
				  preparedStatement = null;
			  }
			  int srNo = 1;
			  for(String billNumber:billMap.keySet())
			  {
				  
				  String getProductInfoSQL = "";
				  PreparedStatement getProductInfoPSMT = null;
				  ResultSet getProductInfoRS = null;
				  
				  GSTSaleBillInfoDAO dao = billMap.get(billNumber);
				  if(this.getSource().equals("ALL") || this.getSource().equals("CRUSHER"))
						
					{
				  getProductInfoSQL = "SELECT "
				  		+ "product_name,"
				  		+ "product_sale_amount_after_discount,"
				  		+ "sale_quantity,"
				  		+ "sales_rate,"
				  		+ "product_gross_amount,"
				  		+ "product_igst,"
				  		+ "product_cgst_amount,"
				  		+ "product_sgst_amount, "
				  		+ "tax_percentage, "
				  		+ "sales_unit "
				  		+ "FROM "
				  		+ "crusher_bill_tax_invoice_product_info "
				  		+ "WHERE "
				  		+ "bill_number = ? "
				  		+ "AND "
				  		+ "bill_type = 'TAX-INVOICE' "
				  		+ "AND "
				  	    + "crusher_id = ? " 
				  	    + "AND "
				        + "crusher_code = ? "; 
				        
				  
				  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
				  
				  getProductInfoPSMT.setString(1, billNumber);
				  getProductInfoPSMT.setString(2, crusherId);
				  getProductInfoPSMT.setString(3, crusherCode);
				  
				  getProductInfoRS = getProductInfoPSMT.executeQuery();
				  
					
				  while(getProductInfoRS.next())
				  {
					
					  GSTSaleBillInfoDAO newDAO  = new GSTSaleBillInfoDAO();
					  
					 
			            
					  newDAO.setBillNumber(dao.getBillNumber());
					  newDAO.setBillDate(dao.getBillDate());
					  newDAO.setCustId(dao.getCustId());
					  newDAO.setCustName(dao.getCustName());
					  newDAO.setCustAddress(dao.getCustAddress());
					  newDAO.setCustGstNumber(dao.getCustGstNumber());
					  newDAO.setTransportCharges(dao.getTransportCharges());
					  newDAO.setBillTotalAmount(dao.getBillTotalAmount());
					  newDAO.setBilledBy(dao.getBilledBy());
					  newDAO.setComments(dao.getComments());
					  
					  newDAO.setSrNo(""+srNo);
					  newDAO.setItemName(getProductInfoRS.getString(1));
					  newDAO.setItemQuantity(getProductInfoRS.getString(3));
					  newDAO.setItemRate(getProductInfoRS.getString(4));
					  newDAO.setTaxableAmount(df.format(getProductInfoRS.getFloat(5)));
					  newDAO.setIgst(df.format(getProductInfoRS.getFloat(6)));
					  newDAO.setSgst(df.format(getProductInfoRS.getFloat(7)));
					  newDAO.setCgst(df.format(getProductInfoRS.getFloat(8)));
					  
					  newDAO.setSalesUnit(getProductInfoRS.getString(10));
						  
					  
				        String taxid = df.format(getProductInfoRS.getFloat(9));
				        Map<String, String> taxInfo = GetListResource.GetTaxNamePercentage(taxid);
				       
				        String taxPercentage = taxInfo.get("TAX-PERCENTAGE");
				       
				       
				        newDAO.setTaxPercentage(taxPercentage);

					  
						float tcs = 0.0f;
							  newDAO.setTcs(df.format(tcs));
							  newDAO.setTotalAmount(df.format(getProductInfoRS.getFloat(5) + getProductInfoRS.getFloat(7) + getProductInfoRS.getFloat(8)));
							  newDAO.setGrandTotal(df.format( getProductInfoRS.getFloat(5) 
									  	+ getProductInfoRS.getFloat(6) 
									  	+ getProductInfoRS.getFloat(7) 
									  	+ getProductInfoRS.getFloat(8) 
									  	+ newDAO.getTransportCharges() + tcs));
						  
							  
							  
							 
					            
							  this.getFromDateToGSTReportDAOList().add(newDAO);
							 
					            
						        srNo++;
						
						  
                           
							 
						        
						        
					}
				  
					}
				  
				 
					
					  if(this.getSource().equals("ALL") || this.getSource().equals("RMC"))
					  
					  {
					  
					  
						  getProductInfoSQL = "SELECT " 
				                     + "product_name," 
						             + "product_amt_after_discount," 
				                     + "quanity," 
						             + "sales_rate," 
				                     + "gross_amount," 
						             + "igst," 
				                     + "cgst," 
						             + "sgst, " 
				                     + "tax_percentage, " 
						             + "sales_unit " 
				                     + "FROM " 
						             + "crusher_rmc_productbillinfo " 
				                     + "WHERE " 
						             + "bill_number = ? " 
				                     + "AND " 
						             + "bill_type = 'TAX-INVOICE' "
						             + "AND "
								  	 + "crusher_id = ? " 
								  	 + "AND "
								     + "crusher_code = ? "; 
				  
				  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
				  
				  getProductInfoPSMT.setString(1, billNumber); 
				  getProductInfoPSMT.setString(2, crusherId);
				  getProductInfoPSMT.setString(3, crusherCode);
				  
				  
				  getProductInfoRS  = getProductInfoPSMT.executeQuery();
					  
					  
					  while(getProductInfoRS.next()) {
					  
					  GSTSaleBillInfoDAO newDAO = new GSTSaleBillInfoDAO();
					  
					  newDAO.setBillNumber(dao.getBillNumber());
					  newDAO.setBillDate(dao.getBillDate()); newDAO.setCustId(dao.getCustId());
					  newDAO.setCustName(dao.getCustName());
					  newDAO.setCustAddress(dao.getCustAddress());
					  newDAO.setCustGstNumber(dao.getCustGstNumber());
					  newDAO.setTransportCharges(dao.getTransportCharges());
					  newDAO.setBillTotalAmount(dao.getBillTotalAmount());
					  newDAO.setBilledBy(dao.getBilledBy()); newDAO.setComments(dao.getComments());
					  
					  newDAO.setSrNo(""+srNo); newDAO.setItemName(getProductInfoRS.getString(1));
					  newDAO.setItemQuantity(getProductInfoRS.getString(3));
					  newDAO.setItemRate(getProductInfoRS.getString(4));
					  newDAO.setTaxableAmount(df.format(getProductInfoRS.getFloat(5)));
					  newDAO.setIgst(df.format(getProductInfoRS.getFloat(6)));
					  newDAO.setSgst(df.format(getProductInfoRS.getFloat(7)));
					  newDAO.setCgst(df.format(getProductInfoRS.getFloat(8)));
					  newDAO.setTaxPercentage(df.format(getProductInfoRS.getFloat(9)));
					  newDAO.setSalesUnit(getProductInfoRS.getString(10));
					  
					  
					  String taxid = df.format(getProductInfoRS.getFloat(9)); Map<String, String>
					  taxInfo = GetListResource.GetTaxNamePercentage(taxid);
					  
					  String taxPercentage = taxInfo.get("TAX-PERCENTAGE");
					  
					  
					  newDAO.setTaxPercentage(taxPercentage);
					  
					  float tcs = 0.0f; newDAO.setTcs(df.format(tcs));
					  newDAO.setTotalAmount(df.format(getProductInfoRS.getFloat(5) +
					  getProductInfoRS.getFloat(7) + getProductInfoRS.getFloat(8)));
					  newDAO.setGrandTotal(df.format( getProductInfoRS.getFloat(5) +
					  getProductInfoRS.getFloat(6) + getProductInfoRS.getFloat(7) +
					  getProductInfoRS.getFloat(8) + newDAO.getTransportCharges() + tcs));
					  
					  
					  
					  
					  this.getFromDateToGSTReportDAOList().add(newDAO);
					  
					  srNo++;
					  
					  }
					  
					  
					  
					  
					  
					  }
					 
				 
				 
				  if(getProductInfoRS != null)
				  {
					  getProductInfoRS.close();
					  getProductInfoRS = null;
				  }
				  
				  if(getProductInfoPSMT != null)
				  {
					  getProductInfoPSMT.close();
					  getProductInfoPSMT = null;
				  }
				  
				  
				  
			  }
			 
			  if(this.getSheet().equals("hsn"))
			  {
			  
			  for (GSTSaleBillInfoDAO dao : this.getFromDateToGSTReportDAOList()) {
				    
				    String productName = dao.getItemName();
				    
				    
				    String getHSNCodeSQL = "SELECT product_id,hsn_sac_code FROM crusher_product_master WHERE product_name_eng = ? "
				    		+ "AND "
					  	    + "crusher_id = ? " 
					  	    + "AND "
					        + "crusher_code = ? "; 
					        
				    try (PreparedStatement getHSNCodePSMT = connection.prepareStatement(getHSNCodeSQL)) {
				        getHSNCodePSMT.setString(1, productName);
				        getHSNCodePSMT.setString(2, crusherId);
				        getHSNCodePSMT.setString(3, crusherCode);
						  
				        try (ResultSet getHSNCodeRS = getHSNCodePSMT.executeQuery()) {
				            if (getHSNCodeRS.next()) {
				            	 String idproduct = getHSNCodeRS.getString(1);
				                String hsnCode = getHSNCodeRS.getString(2);
				                
				                
				                dao.setHsnCode(hsnCode);
				                dao.setIdProduct(idproduct);
				            }else {
				            	dao.setHsnCode("null");
				            }
				        }
				        
				    } catch (SQLException e) {
				        e.printStackTrace();
				        
				    }
				}


			 
			  List<GSTSaleBillInfoDAO> reportList = this.getFromDateToGSTReportDAOList();

			   
			    Map<String, GSTSaleBillInfoDAO> aggregatedDataMap = new LinkedHashMap<>();

			    
			    for (GSTSaleBillInfoDAO dao : reportList) {
			        String idProduct = dao.getIdProduct();  
			        String salesUnit = dao.getSalesUnit();

			        
			        String key = idProduct + "_" + salesUnit;

			        if (aggregatedDataMap.containsKey(key)) {
			            
			            GSTSaleBillInfoDAO existingDAO = aggregatedDataMap.get(key);

			            
			            float newQuantity = Float.parseFloat(existingDAO.getItemQuantity()) + Float.parseFloat(dao.getItemQuantity());
			            float newTaxableAmount = Float.parseFloat(existingDAO.getTaxableAmount()) + Float.parseFloat(dao.getTaxableAmount());
			            float newTotalAmount = Float.parseFloat(existingDAO.getTotalAmount()) + Float.parseFloat(dao.getTotalAmount());
			            float newIgst = Float.parseFloat(existingDAO.getIgst()) + Float.parseFloat(dao.getIgst());
			            float newCgst = Float.parseFloat(existingDAO.getCgst()) + Float.parseFloat(dao.getCgst());
			            float newSgst = Float.parseFloat(existingDAO.getSgst()) + Float.parseFloat(dao.getSgst());

			            
			            float newRate = (Float.parseFloat(existingDAO.getItemRate()) + Float.parseFloat(dao.getItemRate())) / 2;

			            
			            existingDAO.setItemQuantity(String.valueOf(newQuantity));
			            existingDAO.setTaxableAmount(String.valueOf(newTaxableAmount));
			            existingDAO.setTotalAmount(String.valueOf(newTotalAmount));
			            existingDAO.setIgst(String.valueOf(newIgst));
			            existingDAO.setCgst(String.valueOf(newCgst));
			            existingDAO.setSgst(String.valueOf(newSgst));
			            existingDAO.setItemRate(String.valueOf(newRate));

			        } else {
			            
			            aggregatedDataMap.put(key, dao);
			        }
			    }

			    
			    List<GSTSaleBillInfoDAO> sortedList = aggregatedDataMap.values().stream()
			        .sorted(Comparator
			            .comparing((GSTSaleBillInfoDAO dao) -> dao.getIdProduct(), Comparator.nullsLast(Comparator.naturalOrder()))
			            .thenComparing((GSTSaleBillInfoDAO dao) -> dao.getSalesUnit(), Comparator.nullsLast(Comparator.naturalOrder())))
			        .collect(Collectors.toList());

			   
			    reportList.clear();
			    reportList.addAll(sortedList);
			    
			    this.setFromDateToGSTReportDAOList(reportList); 
			
			  }
	    			
				  result = SUCCESS;
			 
		}
		catch (SQLException e) {
			e.printStackTrace();
			result = "error";
			addActionError(this.getText("message.error.recordsNotFoundForSpecificDates"));
			
			
		} catch (IOException e) {
		
			result="error";
			e.printStackTrace();
			addActionError(this.getText("message.error.recordsNotFoundForSpecificDates"));
		}catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
		
		
		finally
		{
			if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
				}
			if(preparedStatement != null)
			{
				try {
					preparedStatement.close(); preparedStatement = null;
				} catch (SQLException e) {
					
				}
			}
			
			if(connection != null)
			{
				try {
					connection.close(); connection = null;
				} catch (SQLException e) {
					
				}
			}
			
			
		
 				
 				
 			}
		
		
		}
	       return result;
	        
	        
			
			}


public void validate() {
	
	this.setAddSideBarJs("FALSE");
	
	
	SourceList.put("ALL", "ALL");
	SourceList.put("CRUSHER", "CRUSHER");
	SourceList.put("RMC","RMC");
	
	
	SheetList.put("b2b", "b2b");
	SheetList.put("b2cl", "b2cl");
	SheetList.put("b2cs","b2cs");
	SheetList.put("hsn","hsn");
	/* SheetList.put("Docs_issued","Docs_issued"); */
	
	
	
	
	if(this.getFromDate() == null || this.getFromDate().equals(""))
	{
		addActionError(this.getText("message.error.plzSelectFromDate"));
	}
	
	if(this.getToDate() == null || this.getFromDate().equals(""))
	{
		addActionError(this.getText("message.error.plzSelectToDate"));
	}
	
	
	
	
}
				



	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}




	public HttpSession getSession() {
		return session;
	}




	public void setSession(HttpSession session) {
		this.session = session;
	}




	public String getFromDate() {
		return fromDate;
	}




	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}




	public String getToDate() {
		return toDate;
	}




	public void setToDate(String toDate) {
		this.toDate = toDate;
	}




	




	


	

	


	public String getSource() {
		return Source;
	}


	public void setSource(String source) {
		Source = source;
	}


	public Map<String, String> getSourceList() {
		return SourceList;
	}


	public void setSourceList(Map<String, String> sourceList) {
		SourceList = sourceList;
	}


	


	


	public Map<String, String> getSheetList() {
		return SheetList;
	}


	public void setSheetList(Map<String, String> sheetList) {
		SheetList = sheetList;
	}


	public String getCustomerName() {
		return customerName;
	}




	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}




	public String getSheet() {
		return Sheet;
	}




	public void setSheet(String sheet) {
		Sheet = sheet;
	}




	public List<GSTSaleBillInfoDAO> getFromDateToGSTReportDAOList() {
		return fromDateToGSTReportDAOList;
	}




	public void setFromDateToGSTReportDAOList(List<GSTSaleBillInfoDAO> fromDateToGSTReportDAOList) {
		this.fromDateToGSTReportDAOList = fromDateToGSTReportDAOList;
	}




	public HttpServletRequest getRequest() {
		return request;
	}




	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}




	public HttpServletResponse getResponse() {
		return response;
	}




	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}




	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}



	 


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
		}
	
	