package com.stonecrusher.report;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.laborBalanceDetailsDAO;
import com.stonecrusher.db.GetDBConnection;

public class GetEmployeeBalanceReport extends ActionSupport implements SessionAware{

	
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2505579516172145683L;

	private SessionMap<String,Object> sessionMap;
	
	private HttpSession session;
	private String fromDate;
	private String toDate;
	
	private List<laborBalanceDetailsDAO> laborBalanceDetailsList = new ArrayList<laborBalanceDetailsDAO>();
	

	private Float totalSalaryAmount = 0.0f;
	private Float totalAmount = 0.0f;
	private String addSideBarJs;
	
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	this.setAddSideBarJs("FALSE");
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	

	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		
	       		String sql = "";
	       		String db = (String) this.getSessionMap().get("db");
	       		try {
	       			
	       			
	       			
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			
       			
	       			
					Map<String, laborBalanceDetailsDAO> employeeMap = new HashMap<>();

					
					sql = "SELECT "
					        + "entry_id,"
					        + "employee_id,"
					        + "DATE_FORMAT(payment_date, '%d/%m/%Y'),"
					        + "payment_amount,"
					        + "employee_name "
					        + "FROM crusher_employee_payment_details "
					        + "WHERE (payment_date BETWEEN STR_TO_DATE(?, '%d-%m-%Y') "
					        + "AND STR_TO_DATE(?, '%d-%m-%Y')) "
					        + "AND crusher_id = ? "
					        + "AND crusher_code = ? ";

					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, this.getFromDate());
					preparedStatement.setString(2, this.getToDate());
					preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);

					resultSet = preparedStatement.executeQuery();
					while (resultSet.next()) {
					    String employeeId = resultSet.getString(2);
					    
					   
					    laborBalanceDetailsDAO dao = employeeMap.getOrDefault(employeeId, new laborBalanceDetailsDAO());
					    
					    dao.setEntryId(resultSet.getString(1));
					    dao.setEmployeeName(resultSet.getString(5));
					    dao.setDate(resultSet.getString(3));
					    dao.setAmount(dao.getAmount() + resultSet.getFloat(4)); // Accumulate payment amount

					    employeeMap.put(employeeId, dao);
					}

					
					if (resultSet != null) resultSet.close();
					if (preparedStatement != null) preparedStatement.close();

					
					sql = "SELECT "
					        + "entry_id,"
					        + "DATE_FORMAT(salary_from_date, '%d/%m/%Y'),"
					        + "DATE_FORMAT(salary_to_date, '%d/%m/%Y'),"
					        + "total_calculated_salary_amount,"
					        + "employee_id,"
					        + "employee_name "
					        + "FROM crusher_employee_salary_calculation_details "
					        + "WHERE (salary_to_date BETWEEN STR_TO_DATE(?, '%d-%m-%Y') "
					        + "AND STR_TO_DATE(?, '%d-%m-%Y')) "
					        + "AND crusher_id = ? "
					        + "AND crusher_code = ? ";

					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, this.getFromDate());
					preparedStatement.setString(2, this.getToDate());
					preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);

					resultSet = preparedStatement.executeQuery();
					while (resultSet.next()) {
					    String employeeId = resultSet.getString(5);
					    
					    
					    laborBalanceDetailsDAO dao = employeeMap.getOrDefault(employeeId, new laborBalanceDetailsDAO());

					    dao.setEntryId(resultSet.getString(1));
					    dao.setEmployeeName(resultSet.getString(6));
					    dao.setDate(resultSet.getString(2) + " - TO -" + resultSet.getString(3));
					    dao.setSalaryAmount(dao.getSalaryAmount() + resultSet.getFloat(4)); // Accumulate salary amount

					    employeeMap.put(employeeId, dao);
					}

					
				
					
					this.getLaborBalanceDetailsList().clear();
					this.getLaborBalanceDetailsList().addAll(employeeMap.values());

					
					
					this.setTotalSalaryAmount((float) employeeMap.values().stream().mapToDouble(laborBalanceDetailsDAO::getSalaryAmount).sum());
					this.setTotalAmount((float) employeeMap.values().stream().mapToDouble(laborBalanceDetailsDAO::getAmount).sum());

	       				
	       		
	       					result = SUCCESS;
	       				
       				
	       			
	       			
       				
       				
       				
	       			
	       		}catch (SQLException e) {
	    			result = "error";
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.detailsNotFound"));
	    		} catch (IOException e) {
	    			
	    			result = "error";
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.detailsNotFound"));
	    		}finally {
	    			if(resultSet != null)
					{
						try {
							resultSet.close(); resultSet = null;
						} catch (SQLException e) {
							
						}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection= null;}catch (SQLException e) {}
	    			}
	    			
	    		}
	       		
	        }
	       return result;
}



public HttpSession getSession() {
	return session;
}



public void setSession(HttpSession session) {
	this.session = session;
}






public String getFromDate() {
	return fromDate;
}



public void setFromDate(String fromDate) {
	this.fromDate = fromDate;
}



public String getToDate() {
	return toDate;
}



public void setToDate(String toDate) {
	this.toDate = toDate;
}

public static long getSerialversionuid() {
	return serialVersionUID;
}




@Override  
public void setSession(Map<String, Object> map) {  
    sessionMap=(SessionMap<String, Object>)map;  
}


public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}



public String getAddSideBarJs() {
	return addSideBarJs;
}



public void setAddSideBarJs(String addSideBarJs) {
	this.addSideBarJs = addSideBarJs;
}



public Float getTotalSalaryAmount() {
	return totalSalaryAmount;
}



public void setTotalSalaryAmount(Float totalSalaryAmount) {
	this.totalSalaryAmount = totalSalaryAmount;
}



public Float getTotalAmount() {
	return totalAmount;
}



public void setTotalAmount(Float totalAmount) {
	this.totalAmount = totalAmount;
}



public List<laborBalanceDetailsDAO> getLaborBalanceDetailsList() {
	return laborBalanceDetailsList;
}



public void setLaborBalanceDetailsList(List<laborBalanceDetailsDAO> laborBalanceDetailsList) {
	this.laborBalanceDetailsList = laborBalanceDetailsList;
}





	
}