package com.stonecrusher.report;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.AccountBalaceReportDAO;
import com.stonecrusher.DAO.BankAccountStatementDAO;
import com.stonecrusher.DAO.CustomerPaymentDetailsDAO;
import com.stonecrusher.DAO.DailyExpenseDAO;
import com.stonecrusher.DAO.TodayBillingListDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetBankAccountEntryDetails;
import com.stonecrusher.utils.GetVehicleDetailsById;

public class GetDailySalesReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3502790352342908340L;
	private List<TodayBillingListDAO> fromDateToDateBillingList = new ArrayList<TodayBillingListDAO>();
	
	private  HttpSession session;

	private Float materialTotal;
	
	private Float matrialCostTotal;
	
	private Float allBillMatrialCostTotal;
	private Float transportTotal;
	private Float totalBillAmount;
	private Float totalBalanceAmount;
	private Float totalReceivedAmount;
	private Float totalRoyalty;
	private Float totalCashAmt = 0.0f;
	private Float totalOnlineAmt = 0.0f;
	
	private String fromDate;
	private String toDate;
	
	private String addSideBarJs;
	private SessionMap<String,Object> sessionMap;  
	
	private List<CustomerPaymentDetailsDAO> custPaymentDetailsDAOList = new ArrayList<CustomerPaymentDetailsDAO>();
	private List<DailyExpenseDAO> dailyExpenseList = new ArrayList<DailyExpenseDAO>();
	private List<BankAccountStatementDAO> reportList = new ArrayList<BankAccountStatementDAO>();
	private List<AccountBalaceReportDAO> accountBalaceList = new ArrayList<AccountBalaceReportDAO>();
	
	private Float totalExpenseAmount = 0.0F;
	
	private List<BankAccountStatementDAO> bankAccountReportDAOList = new ArrayList<BankAccountStatementDAO>();
	
	private Float totalCredit = 0.0F;
	private Float totalDebit = 0.0F;
	private Float balance = 0.0F;
	Map<String,String> accountList = new LinkedHashMap<String,String>();
	private List<Map<String, Object>> productQuantityList = new ArrayList<>();
	private List<String> typeList = new ArrayList<String>();
	private String type;
	
	private Float totalTaxableAmtAllTheTime;
	private Float totalCgstAllTheTime;
	private Float totalSgstAllTheTime;
	private Float totalPumpAmtAllTheTime;
	private Float totalLaborAmtAllTheTime;
	
	
	
	
	public String execute() {
		
		String result = "login";
		  session=ServletActionContext.getRequest().getSession(false);  
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result= "login";  
	        }  
	        else
	        {
	        
	        	this.setAddSideBarJs("FALSE");
	        session=ServletActionContext.getRequest().getSession(false);  
			Connection connection = null;
			PreparedStatement preparedStatement = null;
			ResultSet resultSet = null;
			String sql = "";
			
			String db = (String) session.getAttribute("db");
			
			String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    	
    	
			 float totalMaterial = 0.0F;
			  
			  allBillMatrialCostTotal = 0.0F;
			  transportTotal = 0.0F;
			  totalBillAmount = 0.0F;
			  totalBalanceAmount = 0.0F;
			  totalReceivedAmount = 0.0F;
			  totalLaborAmtAllTheTime = 0.0f;
   			totalPumpAmtAllTheTime = 0.0f;
   			
			  
			try {
				
				connection = GetDBConnection.getDBConnection(db);
				
				
				LinkedHashMap<String,TodayBillingListDAO> billMap = new LinkedHashMap<String,TodayBillingListDAO>();
				  
				if(this.getType().equals("ALL") || this.getType().equals("CRUSHER"))
				{
					
				
				sql = "SELECT "
				  		+ "bi.bill_number,"
				  		+ "DATE_FORMAT(bi.bill_date,'%d-%m-%Y'),"
				  		+ "bi.customer_id,"
				  		+ "bi.customer_name,"
				  		+ "cust.billing_address,"
				  		+ "bi.transportation_charges,"
				  		+ "bi.bill_total_amount,"
				  		+ "bi.bill_amount_received,"
				  		+ "bi.billed_by,"
				  		+ "bi.chalan_number,"
				  		+ "bi.bill_type,"
				  		+ "bi.comments,"
				  		+ "bill_time,"
				  		+ "bi.account1_credit_debit_id,"
						+ "bi.account2_credit_debit_id " 
						+ ""
				  		+ "FROM "
				  		+ "crusher_bill_info_master as bi "
				  		+ "INNER JOIN "
				  		+ "crusher_customer_master as cust "
				  		+ "ON "
				  		+ "bi.customer_id = cust.customer_id "
				  		+ "WHERE "
				  		+ "(bill_date  "
				  		+ "BETWEEN "
				  		+ "STR_TO_DATE(?,'%d-%m-%Y') "
				  		+ "AND "
				  		+ "STR_TO_DATE(?,'%d-%m-%Y'))  "
				  		+ "AND "
				  		+ "bi.crusher_id = ? "
				  		+ "AND "
				  		+ "bi.crusher_code = ? "
				  		+ "AND "
				  		+ "cust.crusher_id = ? "
				  		+ "AND "
				  		+ "cust.crusher_code = ? "
						+ "ORDER BY bi.bill_date,bi.bill_number";
				  
				  preparedStatement = connection.prepareStatement(sql);
				  
				  preparedStatement.setString(1, this.getFromDate());
				  preparedStatement.setString(2, this.getToDate());
				  preparedStatement.setString(3, crusherId);
				  preparedStatement.setString(4, crusherCode);
				  preparedStatement.setString(5, crusherId);
				  preparedStatement.setString(6, crusherCode);
				  
				  
				  resultSet = preparedStatement.executeQuery();
				  
				  while(resultSet.next())
				  {
					  transportTotal = transportTotal + resultSet.getFloat(6);
					  totalBillAmount = totalBillAmount + resultSet.getFloat(7);
					  totalReceivedAmount  = totalReceivedAmount + resultSet.getFloat(8);
					 
					  
					  float balAmt = totalBillAmount - totalReceivedAmount;
					  
					  if(balAmt>=0)
					  {
						  totalBalanceAmount = totalBalanceAmount + balAmt;
					  }
					  
					  TodayBillingListDAO dao = new TodayBillingListDAO();
					
					  dao.setBillNumber(resultSet.getString(1));
					  dao.setBillDate(resultSet.getString(2));
					  dao.setCustId(resultSet.getString(3));
					  dao.setCustName(resultSet.getString(4).split("-")[1]);
					  dao.setCustAddress(resultSet.getString(5));
					  dao.setTransportCharges(resultSet.getString(6));
					  dao.setBillTotalAmount(resultSet.getString(7));
					  dao.setBillAmountRecieved(resultSet.getString(8));
					  dao.setBilledBy(resultSet.getString(9));
					  dao.setChalanNumber(resultSet.getString(10));
					  dao.setBillType(resultSet.getString(11));
					  dao.setComments(resultSet.getString(12));
					  dao.setBillTime(resultSet.getString(13));
					  dao.setAccount1CreditDebitId(resultSet.getString(14));
					  dao.setAccount2CreditDebitId(resultSet.getString(15));
					  dao.setPumpAmount("0");
					  dao.setLaborAmount("0");
					  dao.setOriginateSource("CRUSHER");
					  
					  
					  String getVehicleIdSQL  =  "SELECT"
					  		+ " vehicle_id "
					  		+ "FROM "
					  		+ "crusher_vehicle_trip_master "
					  		+ "WHERE "
					  		+ "bill_number = ? "
					  		+ "AND "
					  		+ "crusher_id = ? "
					  		+ "AND "
					  		+ "crusher_code = ? ";
					  PreparedStatement getVehicleIdPSMT = connection.prepareStatement(getVehicleIdSQL);
					  getVehicleIdPSMT.setString(1, resultSet.getString(1));
					  getVehicleIdPSMT.setString(2, crusherId);
					  getVehicleIdPSMT.setString(3, crusherCode);
					  
					  ResultSet getVehicleIdRS = getVehicleIdPSMT.executeQuery();
					  if(getVehicleIdRS.next())
					  {
						  String vehicleId = getVehicleIdRS.getString(1);
						  
						  HashMap<String,String> vehicleDetails = GetVehicleDetailsById.getVehicleDetailsById(vehicleId, this.getSessionMap(), connection);
						  
						  dao.setVehicleMake(vehicleDetails.get("VEHICLEMAKE"));
						  dao.setVehicleNumber(vehicleDetails.get("REGISTRATIONNUMBER"));
					  }
					  
					  
					  if(getVehicleIdRS != null)
					  {
						  getVehicleIdRS.close();
						  getVehicleIdRS = null;
					  }
					  
					  if(getVehicleIdPSMT != null)
					  {
						  getVehicleIdPSMT.close();
						  getVehicleIdPSMT = null;
					  }
					  
					  
					  billMap.put(resultSet.getString(1)+"#"+resultSet.getString(11), dao);
				  }
				}
				  
				  if(resultSet != null)
				  {
					  resultSet.close();
					  resultSet = null;
				  }
				  
				  if(preparedStatement != null)
				  {
					  preparedStatement.close();
					  preparedStatement = null;
				  }
				  
				  
				  // rmc details 
				 
				  if(this.getType().equals("ALL") || this.getType().equals("RMC"))
					{
						
					  
				  sql = "SELECT "
					  		+ "bi.bill_number,"
					  		+ "DATE_FORMAT(bi.bill_date,'%d-%m-%Y'),"
					  		+ "bi.customer_id,"
					  		+ "bi.customer_name,"
					  		+ "cust.billing_address,"
					  		+ "bi.transport_charges,"
					  		+ "bi.bill_total_amount,"
					  		+ "bi.bill_amount_received,"
					  		+ "bi.billed_by,"
					  		+ "bi.chalan_number,"
					  		+ "bi.bill_type,"
					  		+ "bi.comments,"
					  		+ "bill_time,"
					  		+ "bi.account1_credit_debit_id,"
							+ "bi.account2_credit_debit_id," 
							+ "bi.pumpAmount,"
           					+ "bi.labourAmount "
	           				+ "FROM "
					  		+ "crusher_rmc_billinfo as bi "
					  		+ "INNER JOIN "
					  		+ "crusher_customer_master as cust "
					  		+ "ON "
					  		+ "bi.customer_id = cust.customer_id "
					  		+ "WHERE "
					  		+ "(bill_date  "
					  		+ "BETWEEN "
					  		+ "STR_TO_DATE(?,'%d-%m-%Y') "
					  		+ "AND "
					  		+ "STR_TO_DATE(?,'%d-%m-%Y'))  "
					  		+ "AND "
					  		+ "bi.crusher_id = ? "
					  		+ "AND "
					  		+ "bi.crusher_code = ? "
					  		+ "AND "
					  		+ "cust.crusher_id = ? "
					  		+ "AND "
					  		+ "cust.crusher_code = ? "
							+ "ORDER BY bi.bill_date,bi.bill_number";
					  
					  preparedStatement = connection.prepareStatement(sql);
					  
					  preparedStatement.setString(1, this.getFromDate());
					  preparedStatement.setString(2, this.getToDate());
					  preparedStatement.setString(3, crusherId);
					  preparedStatement.setString(4, crusherCode);
					  preparedStatement.setString(5, crusherId);
					  preparedStatement.setString(6, crusherCode);
					  
					  
					  resultSet = preparedStatement.executeQuery();
					  
					  while(resultSet.next())
					  {
						  transportTotal = transportTotal + resultSet.getFloat(6);
						  totalBillAmount = totalBillAmount + resultSet.getFloat(7);
						  totalReceivedAmount  = totalReceivedAmount + resultSet.getFloat(8);
						 
						  
						  float balAmt = totalBillAmount - totalReceivedAmount;
						  
						  if(balAmt>=0)
						  {
							  totalBalanceAmount = totalBalanceAmount + balAmt;
						  }
						  
						  TodayBillingListDAO dao = new TodayBillingListDAO();
						
						  dao.setBillNumber(resultSet.getString(1));
						  dao.setBillDate(resultSet.getString(2));
						  dao.setCustId(resultSet.getString(3));
						  dao.setCustName(resultSet.getString(4).split("-")[1]);
						  dao.setCustAddress(resultSet.getString(5));
						  dao.setTransportCharges(resultSet.getString(6));
						  dao.setBillTotalAmount(resultSet.getString(7));
						  dao.setBillAmountRecieved(resultSet.getString(8));
						  dao.setBilledBy(resultSet.getString(9));
						  dao.setChalanNumber(resultSet.getString(10));
						  dao.setBillType(resultSet.getString(11));
						  dao.setComments(resultSet.getString(12));
						  dao.setBillTime(resultSet.getString(13));
						  dao.setAccount1CreditDebitId(resultSet.getString(14));
						  dao.setAccount2CreditDebitId(resultSet.getString(15));
						  dao.setPumpAmount(resultSet.getString(16));
						  dao.setLaborAmount(resultSet.getString(17));
						  dao.setOriginateSource("RMC");
							 
						  
						 totalPumpAmtAllTheTime = totalPumpAmtAllTheTime + resultSet.getFloat(16);
	        		        totalLaborAmtAllTheTime = totalLaborAmtAllTheTime + resultSet.getFloat(17);
	        		        
						  String getVehicleIdSQL  =  "SELECT"
						  		+ " trip_vehicle_id "
						  		+ "FROM "
						  		+ "crusher_rmc_vehicle_trip_master "
						  		+ "WHERE "
						  		+ "bill_number = ? "
						  		+ "AND "
						  		+ "crusher_id = ? "
						  		+ "AND "
						  		+ "crusher_code = ? ";
						  PreparedStatement getVehicleIdPSMT = connection.prepareStatement(getVehicleIdSQL);
						  getVehicleIdPSMT.setString(1, resultSet.getString(1));
						  getVehicleIdPSMT.setString(2, crusherId);
						  getVehicleIdPSMT.setString(3, crusherCode);
						  
						  ResultSet getVehicleIdRS = getVehicleIdPSMT.executeQuery();
						  if(getVehicleIdRS.next())
						  {
							  String vehicleId = getVehicleIdRS.getString(1);
							  
							  HashMap<String,String> vehicleDetails = GetVehicleDetailsById.getVehicleDetailsById(vehicleId, this.getSessionMap(), connection);
							  
							  dao.setVehicleMake(vehicleDetails.get("VEHICLEMAKE"));
							  dao.setVehicleNumber(vehicleDetails.get("REGISTRATIONNUMBER"));
						  }
						  
						  
						  if(getVehicleIdRS != null)
						  {
							  getVehicleIdRS.close();
							  getVehicleIdRS = null;
						  }
						  
						  if(getVehicleIdPSMT != null)
						  {
							  getVehicleIdPSMT.close();
							  getVehicleIdPSMT = null;
						  }
						  
						  
						  billMap.put(resultSet.getString(1)+"#"+resultSet.getString(11), dao);
					  }
				  
					}
				  
				  
				  float royalty = 0.0F;
				  float totalcgst = 0.0F;
				  float totalsgst = 0.0F;
				  totalTaxableAmtAllTheTime = 0.0f;
				  totalCgstAllTheTime = 0.0f;
				  totalSgstAllTheTime = 0.0f;
				  
				  
				  
				  for(String billNumber:billMap.keySet())
				  {
					 
					  float totalMaterialCost = 0.0F;
						 
					  
					  String getProductInfoSQL = "";
					  PreparedStatement getProductInfoPSMT = null;
					  ResultSet getProductInfoRS = null;
					  
					  TodayBillingListDAO dao = billMap.get(billNumber);
					  if(this.getType().equals("ALL") || this.getType().equals("CRUSHER"))
						{
						  if(dao.getOriginateSource().equals("CRUSHER"))
						  { 
						
					  getProductInfoSQL = "SELECT "
					  		+ "product_name,"
					  		+ "product_sale_amount_after_discount,"
					  		+ "sale_quantity,"
					  		+ "sales_rate,"
					  		+ "product_cgst_amount,"
					  		+ "product_sgst_amount,"
					  		+ "product_igst,"
					  		+ "product_gross_amount,"
					  		+ "royalty "
					  		+ "FROM "
					  		+ "crusher_bill_product_info "
					  		+ "WHERE "
					  		+ "bill_number = ? "
					  		+ "AND "
					  		+ "bill_type = ? "
					  		+ "AND "
					  		+ "crusher_id = ? "
					  		+ "AND "
					  		+ "crusher_code = ? ";
					  
					  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
					  
					  getProductInfoPSMT.setString(1, billNumber.split("#")[0]);
					  getProductInfoPSMT.setString(2, dao.getBillType());					  
					  getProductInfoPSMT.setString(3, crusherId);
					  getProductInfoPSMT.setString(4, crusherCode);
					  
					  getProductInfoRS = getProductInfoPSMT.executeQuery();
					
					  
					  StringBuilder productNames = new StringBuilder();
					  StringBuilder quantities = new StringBuilder();
					 
					  while(getProductInfoRS.next())
					  {
						  
						  String productName = getProductInfoRS.getString(1);
						    float quantity = getProductInfoRS.getFloat(3);

						     boolean found = false;
						    for (Map<String, Object> productInfo : productQuantityList) {
						        if (productInfo.get("productName").equals(productName)) {
						            float existingQuantity = (float) productInfo.get("quantity");
						            productInfo.put("quantity", existingQuantity + quantity);
						            found = true;
						            break;
						        }
						    }
						    

							   if (!found) {
							        Map<String, Object> newProduct = new LinkedHashMap<>();
							        newProduct.put("productName", productName);
							        newProduct.put("quantity", quantity);
							        productQuantityList.add(newProduct);
							    }
							

							  if (productNames.length() > 0) {
							        productNames.append(" / ");
							        quantities.append(" / ");
							    }
							  
							  productNames.append(getProductInfoRS.getString(1));  
							    quantities.append(getProductInfoRS.getString(3));    

							    dao.setItemNameAll(productNames.toString());  
							    dao.setItemQuantityAll(quantities.toString());
							    
							    
							    
						  totalMaterialCost = totalMaterialCost + getProductInfoRS.getFloat(2);
						  allBillMatrialCostTotal = allBillMatrialCostTotal + getProductInfoRS.getFloat(2);;
						
							  dao.setItemName(getProductInfoRS.getString(1));
							  dao.setItemQuantity(getProductInfoRS.getString(3));
							  dao.setItemRate(getProductInfoRS.getString(4));
							  dao.setCgst(getProductInfoRS.getFloat(5));
								 dao.setSgst(getProductInfoRS.getFloat(6));
								 dao.setIgst(getProductInfoRS.getString(7));
								   
								 dao.setTaxableAmt(getProductInfoRS.getString(8));

								  
								  totalCgstAllTheTime = totalCgstAllTheTime + getProductInfoRS.getFloat(5);
								  totalSgstAllTheTime = totalSgstAllTheTime + getProductInfoRS.getFloat(6);
								  totalTaxableAmtAllTheTime = totalTaxableAmtAllTheTime + getProductInfoRS.getFloat(8);
								  
								  
								 totalcgst = totalcgst + getProductInfoRS.getFloat(5);
								 totalsgst = totalsgst + getProductInfoRS.getFloat(6);
								 
							 totalMaterial = totalMaterial + getProductInfoRS.getFloat(3);
							 
							  royalty = royalty + getProductInfoRS.getFloat("royalty");
							  
							 	 
							  float royalty1 = getProductInfoRS.getFloat("royalty") ;
							  
							  
							  dao.setRoyalty(royalty1 + dao.getRoyalty());
								
							  
							  
				
					  }
						  }
					  
						}
					  if(resultSet != null)
					  {
						  resultSet.close();
						  resultSet = null;
					  }
					  
					  if(preparedStatement != null)
					  {
						  preparedStatement.close();
						  preparedStatement = null;
					  }
					  
					  
					  
					  //rmc details
					  
					  
					  if(this.getType().equals("ALL") || this.getType().equals("RMC"))
						{
						  if(dao.getOriginateSource().equals("RMC"))
						  {
						
					  getProductInfoSQL = "SELECT "
						  		+ "product_name,"
						  		+ "product_amt_after_discount,"
						  		+ "quanity,"
						  		+ "sales_rate,"
						  		+ "cgst,"
						  		+ "sgst,"
						  		+ "igst,"
						  		+ "gross_amount "
						  		+ "FROM "
						  		+ "crusher_rmc_productbillinfo "
						  		+ "WHERE "
						  		+ "bill_number = ? "
						  		+ "AND "
						  		+ "bill_type = ? "
						  		+ "AND "
						  		+ "crusher_id = ? "
						  		+ "AND "
						  		+ "crusher_code = ? ";
						  
						  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
						  
						  getProductInfoPSMT.setString(1, billNumber.split("#")[0]);
						  getProductInfoPSMT.setString(2, dao.getBillType());					  
						  getProductInfoPSMT.setString(3, crusherId);
						  getProductInfoPSMT.setString(4, crusherCode);
						  
						  getProductInfoRS = getProductInfoPSMT.executeQuery();
						
						  StringBuilder productNames = new StringBuilder();
						  StringBuilder quantities = new StringBuilder();
						 
						  while(getProductInfoRS.next())
						  {
							  
							  String productName = getProductInfoRS.getString(1);
							    float quantity = getProductInfoRS.getFloat(3);

							     boolean found = false;
							    for (Map<String, Object> productInfo : productQuantityList) {
							        if (productInfo.get("productName").equals(productName)) {
							            float existingQuantity = (float) productInfo.get("quantity");
							            productInfo.put("quantity", existingQuantity + quantity);
							            found = true;
							            break;
							        }
							    }
							    

								   if (!found) {
								        Map<String, Object> newProduct = new LinkedHashMap<>();
								        newProduct.put("productName", productName);
								        newProduct.put("quantity", quantity);
								        productQuantityList.add(newProduct);
								    }
								

								  if (productNames.length() > 0) {
								        productNames.append(" / ");
								        quantities.append(" / ");
								    }
								  
								  productNames.append(getProductInfoRS.getString(1));  
								    quantities.append(getProductInfoRS.getString(3));    

								    dao.setItemNameAll(productNames.toString());  
								    dao.setItemQuantityAll(quantities.toString());
								    
								    
								    
							  totalMaterialCost = totalMaterialCost + getProductInfoRS.getFloat(2);
							  allBillMatrialCostTotal = allBillMatrialCostTotal + getProductInfoRS.getFloat(2);;
							
								  dao.setItemName(getProductInfoRS.getString(1));
								  dao.setItemQuantity(getProductInfoRS.getString(3));
								  dao.setItemRate(getProductInfoRS.getString(4));
								  dao.setCgst(getProductInfoRS.getFloat(5));
								 dao.setSgst(getProductInfoRS.getFloat(6));
								dao.setIgst(getProductInfoRS.getString(7));
								   
								 dao.setTaxableAmt(getProductInfoRS.getString(8));

								  
								  totalCgstAllTheTime = totalCgstAllTheTime + getProductInfoRS.getFloat(5);
								  totalSgstAllTheTime = totalSgstAllTheTime + getProductInfoRS.getFloat(6);
								  totalTaxableAmtAllTheTime = totalTaxableAmtAllTheTime + getProductInfoRS.getFloat(8);
								  
								  
								  
									 totalcgst = totalcgst + getProductInfoRS.getFloat(5);
									 totalsgst = totalsgst + getProductInfoRS.getFloat(6);
									 
								 totalMaterial = totalMaterial + getProductInfoRS.getFloat(3);
								 
								
								
								  
					
						  }
						  }
						}
					  
					  this.setTotalRoyalty(royalty);
					  
					  this.setMaterialTotal(totalMaterial);
					  float amountReceived = Float.parseFloat(dao.getBillAmountRecieved());
					  
					
					  float totalAmount = Float.parseFloat(dao.getBillTotalAmount());
					  dao.setMaterialAmount(""+totalMaterialCost);
					  dao.setBalanceAmount(""+(totalAmount-amountReceived));
					  billMap.put(billNumber, dao);
					  
					  if(getProductInfoRS != null)
					  {
						  getProductInfoRS.close();
						  getProductInfoRS = null;
					  }
					  
					  if(getProductInfoPSMT != null)
					  {
						  getProductInfoPSMT.close();
						  getProductInfoPSMT = null;
					  }
					  

			            
						String getCashOnlineAmtCode = "SELECT payment_type,"
								+ "amount "
								+ " FROM "
								+ "bank_account_credit_debit_master WHERE entry_id = ? " + "AND " + "crusher_id = ? " + "AND "
								+ "crusher_code = ?";

						PreparedStatement getCashOnlineAmtPSMT = connection.prepareStatement(getCashOnlineAmtCode);

						getCashOnlineAmtPSMT.setString(1, dao.getAccount1CreditDebitId());
						getCashOnlineAmtPSMT.setString(2, crusherId);
						getCashOnlineAmtPSMT.setString(3, crusherCode);

						ResultSet getCashOnlineAmtRs = getCashOnlineAmtPSMT.executeQuery();
						if (getCashOnlineAmtRs.next()) {
							dao.setAcc1PaymentType(getCashOnlineAmtRs.getString(1));
							dao.setAcc1Amount(getCashOnlineAmtRs.getFloat(2));
						} else {
							dao.setAcc1PaymentType("NA");
							dao.setAcc1Amount(0.0f);
							
						}

						if (getCashOnlineAmtRs != null) {
							getCashOnlineAmtRs.close();
							getCashOnlineAmtRs = null;
						}

						if (getCashOnlineAmtPSMT != null) {
							getCashOnlineAmtPSMT.close();
							getCashOnlineAmtPSMT = null;
						}
						
						
						
						 getCashOnlineAmtCode = "SELECT payment_type,"
								+ "amount "
								+ " FROM "
								+ "bank_account_credit_debit_master WHERE entry_id = ? " + "AND " + "crusher_id = ? " + "AND "
								+ "crusher_code = ?";

						 getCashOnlineAmtPSMT = connection.prepareStatement(getCashOnlineAmtCode);

						getCashOnlineAmtPSMT.setString(1, dao.getAccount2CreditDebitId());
						getCashOnlineAmtPSMT.setString(2, crusherId);
						getCashOnlineAmtPSMT.setString(3, crusherCode);

						 getCashOnlineAmtRs = getCashOnlineAmtPSMT.executeQuery();
						if (getCashOnlineAmtRs.next()) {
							dao.setAcc2PaymentType(getCashOnlineAmtRs.getString(1));
							dao.setAcc2Amount(getCashOnlineAmtRs.getFloat(2));
						} else {
							dao.setAcc2PaymentType("NA");
							dao.setAcc2Amount(0.0f);
							
						}

						if (getCashOnlineAmtRs != null) {
							getCashOnlineAmtRs.close();
							getCashOnlineAmtRs = null;
						}

						if (getCashOnlineAmtPSMT != null) {
							getCashOnlineAmtPSMT.close();
							getCashOnlineAmtPSMT = null;
						}

						
				  
						
						
						if(dao.getAcc1PaymentType().equals("CASH"))
						{
							dao.setCashAmt(dao.getAcc1Amount()); 
							
						}else if(dao.getAcc2PaymentType().equals("CASH"))
						{
							dao.setCashAmt(dao.getAcc2Amount());
							
						}
						
						if(!dao.getAcc1PaymentType().equals("CASH"))
						{
							dao.setOnlineAmt(dao.getAcc1Amount());
							
						}else if(!dao.getAcc2PaymentType().equals("CASH"))
						{
							dao.setOnlineAmt(dao.getAcc2Amount());
							
						}
						
						this.setTotalCashAmt(this.getTotalCashAmt() + dao.getCashAmt());
						this.setTotalOnlineAmt(this.getTotalOnlineAmt() + dao.getOnlineAmt());
					  
				  }
				  
				  allBillMatrialCostTotal = allBillMatrialCostTotal - totalRoyalty;
				  
					 
				  for(String billNumber:billMap.keySet())
				  {
					  this.getFromDateToDateBillingList().add(billMap.get(billNumber));
				  }
				  
				  totalBalanceAmount = totalBillAmount - totalReceivedAmount;
				  
			
				 
					  
					  
					  sql = "SELECT "
		    					+ "cpd.payement_entry_id,"
		    					+ "cpd.customer_id,"
		    					+ "cpd.customer_name,"
		    					+ "DATE_FORMAT(cpd.payment_date,'%d-%m-%Y'),"
		    					+ "cpd.amount,"
		    					+ "cpd.payemnt_details,"
		    					+ "cust.billing_address "
		    					+ "FROM "
		    					+ "crusher_customer_payment_details_master AS cpd "
		    					+ "INNER JOIN "
		    					+ "crusher_customer_master AS cust "
		    					+ "ON "
		    					+ "cpd.customer_id = cust.customer_id "
		    					+ "WHERE "
		    					+ "(cpd.payment_date "
		    					+ "BETWEEN "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
		    					+ "AND "
		    					+ "cpd.crusher_id = ? "
		    					+ "AND "
		    					+ "cpd.crusher_code = ? "
		    					+ "AND "
		    					+ "cust.crusher_id = ? "
		    					+ "AND "
		    					+ "cust.crusher_code = ? ";
		    			
		    			preparedStatement = connection.prepareStatement(sql);
		    			preparedStatement.setString(1, this.getFromDate());
		    			preparedStatement.setString(2, this.getToDate());
		    			preparedStatement.setString(3, crusherId);
		    			preparedStatement.setString(4, crusherCode);
		    			preparedStatement.setString(5, crusherId);
		    			preparedStatement.setString(6, crusherCode);
		    			
		    			
					  
		    			resultSet = preparedStatement.executeQuery();
		    			
		    			int rowCount = 0;
		    			resultSet.last();
		    			rowCount = resultSet.getRow();
		    			resultSet.beforeFirst();
		    			
		    			if(rowCount > 0)
		    			{
		    				
		    				
		    				while(resultSet.next())
		    				{
		    					CustomerPaymentDetailsDAO dao = new CustomerPaymentDetailsDAO();
		    					
		    					dao.setPaymentId(resultSet.getString(1));
		    					dao.setCustId(resultSet.getString(2));
		    					dao.setCustName(resultSet.getString(3));
		    					dao.setPaymentDate(resultSet.getString(4));
		    					dao.setAmount(resultSet.getFloat(5));
		    					dao.setDetails(resultSet.getString(6));
		    					dao.setCustAddess(resultSet.getString(7));
		    					
		    					
		    					this.getCustPaymentDetailsDAOList().add(dao);
		    				}
		    				
		    				
		    			}
		    			else
		    			{
		    				addActionError(this.getText("message.error.customerPaymentDetailsNotFound"));
		    			}
		    			
		    			  
						  if(resultSet != null)
						  {
							  resultSet.close();
							  resultSet = null;
						  }
						  
						  if(preparedStatement != null)
						  {
							  preparedStatement.close();
							  preparedStatement = null;
						  }
		    			
		    			sql = "SELECT "
		    					+ "entry_id,"
		    					+ "DATE_FORMAT(expense_date,'%d-%m-%Y'),"
		    					+ "expense_reason,"
		    					+ "expense_amount,"
		    					+ "type_of_payment,"
		    					+ "expense_details,"
		    					+ "expense_bill_image,"
		    					+ "head_name "
		    					+ "FROM "
		    					+ "crusher_daily_expenses "
		    					+ "WHERE "
		    					+ "(expense_date BETWEEN "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
		    					+ "AND "
		    					+ "crusher_id = ? "
		    					+ "AND "
		    					+ "crusher_code = ? ";
		    			
		    			preparedStatement = connection.prepareStatement(sql);
		    			
		    			preparedStatement.setString(1, this.getFromDate());
		    			preparedStatement.setString(2, this.getToDate());
		    			preparedStatement.setString(3, crusherId);
		    			preparedStatement.setString(4, crusherCode);
		    			
		    			resultSet = preparedStatement.executeQuery();
		    			resultSet.last();
		    			int resultCount = resultSet.getRow();
		    			resultSet.beforeFirst();
		    			
		    			if(resultCount > 0)
		    			{
		    				while(resultSet.next())
		    				{
		    					DailyExpenseDAO dailyExpenseDAO = new DailyExpenseDAO();
		    					dailyExpenseDAO.setId(resultSet.getString(1));
		    					dailyExpenseDAO.setExpenseDate(resultSet.getString(2));
		    					dailyExpenseDAO.setExpenseReason(resultSet.getString(3));
		    					dailyExpenseDAO.setAmount(resultSet.getString(4));
		    					dailyExpenseDAO.setTypeOfPayment(resultSet.getString(5));
		    					dailyExpenseDAO.setDescription(resultSet.getString(6));
		    					dailyExpenseDAO.setExpenseImage(resultSet.getBlob(7));
		    					dailyExpenseDAO.setHeadName(resultSet.getString(8));
		    					this.setTotalExpenseAmount(this.getTotalExpenseAmount()+Float.parseFloat(resultSet.getString(4)));
		    					
		    					this.getDailyExpenseList().add(dailyExpenseDAO);
		    					
		    				}
		    				
		    			}else
		    			{
		    				addActionError(this.getText("message.error.dailyExpenseDetailsNotFound"));
		    			}
		    			
		    			
		    			 if(resultSet != null)
						  {
							  resultSet.close();
							  resultSet = null;
						  }
						  
						  if(preparedStatement != null)
						  {
							  preparedStatement.close();
							  preparedStatement = null;
						  }
						  
						  
						  HashMap<String,String> bankNameMapping = new HashMap<String,String>();
						  sql = "SELECT "
						  		+ "account_id,"
						  		+ "account_holder_name "
						  		+ "FROM "
						  		+ "crusher_bank_account "
						  		+ "WHERE "
						  		+ "crusher_id = ? "
						  		+ "AND "
						  		+ "crusher_code = ? ";
						  
						  preparedStatement = connection.prepareStatement(sql);
						  preparedStatement.setString(1, crusherId);
						  preparedStatement.setString(2, crusherCode);
					
						  
						  resultSet = preparedStatement.executeQuery();
						
						  while(resultSet.next())
						  {
							  bankNameMapping.put(resultSet.getString(1), resultSet.getString(2));
						  }
						  
							 if(resultSet != null)
							  {
								  resultSet.close();
								  resultSet = null;
							  }
							  
							  if(preparedStatement != null)
							  {
								  preparedStatement.close();
								  preparedStatement = null;
							  }
						  
						  sql = "SELECT "
									+ "entry_id,"
									+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "DATE_FORMAT(entry_date,'%d-%m-%Y'),"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_type = 'DEBIT' "
									+ "AND "
									+ "(entry_date BETWEEN "
			    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
			    					+ "AND "
			    					+ "crusher_id = ? "
			    					+ "AND "
			    					+ "crusher_code = ? " 
									+ "ORDER BY "
									+ "entry_date,account_id";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, this.getFromDate());
							preparedStatement.setString(2, this.getToDate());
							preparedStatement.setString(3, crusherId);
							preparedStatement.setString(4, crusherCode);
							
							resultSet = preparedStatement.executeQuery();
							
							resultSet.last();
							
							rowCount = resultSet.getRow();
							
							resultSet.beforeFirst();
							
							if(rowCount > 0)
							{
								
								while(resultSet.next())
								{
									BankAccountStatementDAO dao = new BankAccountStatementDAO();
									dao.setAccountId(resultSet.getString(2));
									dao.setDateAsString(resultSet.getString(5));
									dao.setEntryId(resultSet.getString(1));
									dao.setEntryType(resultSet.getString(7));
									dao.setAmount(resultSet.getFloat(8));
									dao.setPaymentType(resultSet.getString(9));
									dao.setEntryBy(resultSet.getString(10));
									dao.setAccountNumber(resultSet.getString(3));
									dao.setEntryDetails(resultSet.getString(11));
									dao.setAccountName(bankNameMapping.get(resultSet.getString(2)));
									this.getReportList().add(dao);
								}
							}
								this.setBankAccountReportDAOList(GetBankAccountEntryDetails.getBankAccountDetails(this.getFromDate(), this.getToDate(), this.getSessionMap()));  
							
								
								for(BankAccountStatementDAO dao:this.getBankAccountReportDAOList())
								{
									if(dao.getEntryType().equals("CREDIT"))
									{
										this.setTotalCredit(this.getTotalCredit() + dao.getAmount());
									}
									
									if(dao.getEntryType().equals("DEBIT"))
									{
										this.setTotalDebit(this.getTotalDebit() + dao.getAmount());
									}
								}
								
								this.setBalance(this.getTotalCredit() - this.getTotalDebit());
		    			
								if(resultSet != null)
				        		{
				        			resultSet.close();
				        			resultSet = null;
				        		}
				        		if(preparedStatement!= null)
				        		{
				        			preparedStatement.close();
				        			preparedStatement = null;
				        		}
				        		
				        		
								
				        		
				        		sql = "SELECT account_id FROM crusher_bank_account WHERE crusher_id = ? AND crusher_code = ?";
				        		preparedStatement = connection.prepareStatement(sql);
				        		preparedStatement.setString(1, crusherId);
				        		preparedStatement.setString(2, crusherCode);
				        		resultSet = preparedStatement.executeQuery();

				        		while (resultSet.next()) {
				        		    String accountId = resultSet.getString(1);

				        		   
				        		    sql = "SELECT account_id, closeing_bal_amount, closeing_bal_date FROM datewise_closing_balance "
				        		        + "WHERE account_id = ? AND crusher_id = ? AND crusher_code = ? "
				        		        + "AND closeing_bal_date <= STR_TO_DATE(?, '%d-%m-%Y') "
				        		        + "ORDER BY closeing_bal_date DESC LIMIT 1";
				        		        
				        		    PreparedStatement balanceStmt = connection.prepareStatement(sql);
				        		    balanceStmt.setString(1, accountId);
				        		    balanceStmt.setString(2, crusherId);
				        		    balanceStmt.setString(3, crusherCode);
				        		    balanceStmt.setString(4, this.getToDate());

				        		    ResultSet balanceResult = balanceStmt.executeQuery();

				        		    AccountBalaceReportDAO dao = new AccountBalaceReportDAO();
				        		    dao.setAccountId(accountId);
				        		    dao.setAccountNoName(accountList.getOrDefault(accountId, "Unknown Account"));

				        		    if (balanceResult.next()) {
				        		       
				        		        dao.setBallanceAmt(balanceResult.getString("closeing_bal_amount"));
				        		        dao.setCloseingBalDate(balanceResult.getString("closeing_bal_date"));
				        		    } else {
				        		       
				        		        sql = "SELECT opening_balance FROM crusher_bank_account WHERE account_id = ? AND crusher_id = ? AND crusher_code = ?";
				        		        
				        		        PreparedStatement openingBalanceStmt = connection.prepareStatement(sql);
				        		        openingBalanceStmt.setString(1, accountId);
				        		        openingBalanceStmt.setString(2, crusherId);
				        		        openingBalanceStmt.setString(3, crusherCode);

				        		        ResultSet openingBalanceResult = openingBalanceStmt.executeQuery();

				        		        if (openingBalanceResult.next()) {
				        		          
				        		            dao.setBallanceAmt(openingBalanceResult.getString("opening_balance"));
				        		        } else {
				        		            
				        		            dao.setBallanceAmt("0");
				        		        }
				        		        dao.setCloseingBalDate(this.getToDate());
				        		    }

				        		   
				        		    this.getAccountBalaceList().add(dao);

				        		   
				        		    balanceResult.close();
				        		    balanceStmt.close();
				        		}

				        		
				        		
				        		
				        		
					  result = SUCCESS;
				 
			}
			catch (SQLException e) {
				e.printStackTrace();
				result = "error";
				addActionError(this.getText("message.error.recordsNotFoundForSpecificDates"));
				
				
			} catch (Exception e) {
			
				result="error";
				e.printStackTrace();
				addActionError(this.getText("message.error.recordsNotFoundForSpecificDates"));
			}finally
			{
				if(resultSet != null)
   				{
   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
   				}
				if(preparedStatement != null)
				{
					try {
						preparedStatement.close(); preparedStatement = null;
					} catch (SQLException e) {
						
					}
				}
				
				if(connection != null)
				{
					try {
						connection.close(); connection = null;
					} catch (SQLException e) {
						
					}
				}
				
				
			}
			
			
			
	        }
	        
	        return result;
}
	
	@Override
	public void validate() {
		this.setAccountList( GetAccountListForDrCr.getAccountList(this.getSessionMap()));     
		
		typeList.add("ALL");
   		typeList.add("CRUSHER");
   		typeList.add("RMC");
   		
   		
		if(this.getFromDate().equals("") && this.getToDate().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectDates"));
		}
		
		
		if(this.getType().equals("") && this.getType() == null)
		{
			addActionError("Please Select Type !");
		}
		
		
		
		this.setAddSideBarJs("FALSE");
	}
	
	
	public void setSession(Map<String, Object> map) {
		// TODO Auto-generated method stub
		 sessionMap=(SessionMap<String, Object>)map;  
		
	}

	

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}


	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}




	public List<TodayBillingListDAO> getFromDateToDateBillingList() {
		return fromDateToDateBillingList;
	}




	public void setFromDateToDateBillingList(List<TodayBillingListDAO> fromDateToDateBillingList) {
		this.fromDateToDateBillingList = fromDateToDateBillingList;
	}







	public Float getMaterialTotal() {
		return materialTotal;
	}

	public void setMaterialTotal(Float materialTotal) {
		this.materialTotal = materialTotal;
	}

	public Float getMatrialCostTotal() {
		return matrialCostTotal;
	}




	public void setMatrialCostTotal(Float matrialCostTotal) {
		this.matrialCostTotal = matrialCostTotal;
	}




	public Float getAllBillMatrialCostTotal() {
		return allBillMatrialCostTotal;
	}




	public void setAllBillMatrialCostTotal(Float allBillMatrialCostTotal) {
		this.allBillMatrialCostTotal = allBillMatrialCostTotal;
	}




	public Float getTransportTotal() {
		return transportTotal;
	}




	public void setTransportTotal(Float transportTotal) {
		this.transportTotal = transportTotal;
	}




	public Float getTotalBillAmount() {
		return totalBillAmount;
	}




	public void setTotalBillAmount(Float totalBillAmount) {
		this.totalBillAmount = totalBillAmount;
	}




	public Float getTotalBalanceAmount() {
		return totalBalanceAmount;
	}




	public void setTotalBalanceAmount(Float totalBalanceAmount) {
		this.totalBalanceAmount = totalBalanceAmount;
	}




	public Float getTotalReceivedAmount() {
		return totalReceivedAmount;
	}




	public void setTotalReceivedAmount(Float totalReceivedAmount) {
		this.totalReceivedAmount = totalReceivedAmount;
	}




	public String getFromDate() {
		return fromDate;
	}




	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}




	public String getToDate() {
		return toDate;
	}




	public void setToDate(String toDate) {
		this.toDate = toDate;
	}




	public List<DailyExpenseDAO> getDailyExpenseList() {
		return dailyExpenseList;
	}

	public void setDailyExpenseList(List<DailyExpenseDAO> dailyExpenseList) {
		this.dailyExpenseList = dailyExpenseList;
	}

	public Float getTotalExpenseAmount() {
		return totalExpenseAmount;
	}

	public void setTotalExpenseAmount(Float totalExpenseAmount) {
		this.totalExpenseAmount = totalExpenseAmount;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public List<CustomerPaymentDetailsDAO> getCustPaymentDetailsDAOList() {
		return custPaymentDetailsDAOList;
	}

	public void setCustPaymentDetailsDAOList(List<CustomerPaymentDetailsDAO> custPaymentDetailsDAOList) {
		this.custPaymentDetailsDAOList = custPaymentDetailsDAOList;
	}

	public List<BankAccountStatementDAO> getReportList() {
		return reportList;
	}

	public void setReportList(List<BankAccountStatementDAO> reportList) {
		this.reportList = reportList;
	}

	public List<BankAccountStatementDAO> getBankAccountReportDAOList() {
		return bankAccountReportDAOList;
	}

	public void setBankAccountReportDAOList(List<BankAccountStatementDAO> bankAccountReportDAOList) {
		this.bankAccountReportDAOList = bankAccountReportDAOList;
	}

	public Float getTotalCredit() {
		return totalCredit;
	}

	public void setTotalCredit(Float totalCredit) {
		this.totalCredit = totalCredit;
	}

	public Float getTotalDebit() {
		return totalDebit;
	}

	public void setTotalDebit(Float totalDebit) {
		this.totalDebit = totalDebit;
	}

	public Float getBalance() {
		return balance;
	}

	public void setBalance(Float balance) {
		this.balance = balance;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public List<AccountBalaceReportDAO> getAccountBalaceList() {
		return accountBalaceList;
	}

	public void setAccountBalaceList(List<AccountBalaceReportDAO> accountBalaceList) {
		this.accountBalaceList = accountBalaceList;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public Float getTotalRoyalty() {
		return totalRoyalty;
	}

	public void setTotalRoyalty(Float totalRoyalty) {
		this.totalRoyalty = totalRoyalty;
	}

	public List<Map<String, Object>> getProductQuantityList() {
		return productQuantityList;
	}

	public void setProductQuantityList(List<Map<String, Object>> productQuantityList) {
		this.productQuantityList = productQuantityList;
	}

	public Float getTotalCashAmt() {
		return totalCashAmt;
	}

	public void setTotalCashAmt(Float totalCashAmt) {
		this.totalCashAmt = totalCashAmt;
	}

	public Float getTotalOnlineAmt() {
		return totalOnlineAmt;
	}

	public void setTotalOnlineAmt(Float totalOnlineAmt) {
		this.totalOnlineAmt = totalOnlineAmt;
	}

	public List<String> getTypeList() {
		return typeList;
	}

	public void setTypeList(List<String> typeList) {
		this.typeList = typeList;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	

	public Float getTotalTaxableAmtAllTheTime() {
		return totalTaxableAmtAllTheTime;
	}

	public void setTotalTaxableAmtAllTheTime(Float totalTaxableAmtAllTheTime) {
		this.totalTaxableAmtAllTheTime = totalTaxableAmtAllTheTime;
	}

	public Float getTotalCgstAllTheTime() {
		return totalCgstAllTheTime;
	}

	public void setTotalCgstAllTheTime(Float totalCgstAllTheTime) {
		this.totalCgstAllTheTime = totalCgstAllTheTime;
	}

	public Float getTotalSgstAllTheTime() {
		return totalSgstAllTheTime;
	}

	public void setTotalSgstAllTheTime(Float totalSgstAllTheTime) {
		this.totalSgstAllTheTime = totalSgstAllTheTime;
	}

	public Float getTotalPumpAmtAllTheTime() {
		return totalPumpAmtAllTheTime;
	}

	public void setTotalPumpAmtAllTheTime(Float totalPumpAmtAllTheTime) {
		this.totalPumpAmtAllTheTime = totalPumpAmtAllTheTime;
	}

	public Float getTotalLaborAmtAllTheTime() {
		return totalLaborAmtAllTheTime;
	}

	public void setTotalLaborAmtAllTheTime(Float totalLaborAmtAllTheTime) {
		this.totalLaborAmtAllTheTime = totalLaborAmtAllTheTime;
	}

	
	

	
	
}

