package com.stonecrusher.report;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.CustomerPaymentDetailsDAO;
import com.stonecrusher.db.GetDBConnection;

public class GetCustPaymentDetailsReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6602710107876580601L;
	
	private String fromDate;
	private String toDate;
	private HttpSession session;
	private List<CustomerPaymentDetailsDAO> custPaymentDetailsDAOList = new ArrayList<CustomerPaymentDetailsDAO>();
	private String customerNameCode;
	private String addSideBarJs;
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	private Float totalAmount;

	private SessionMap<String,Object> sessionMap;
	
	
	public String execute() throws Exception {
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";
	        }  
	        else{
	        	
	        	downloadTypeList.add("pdf");
	        	downloadTypeList.add("xl");
	        	
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		

	    		String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
	    		totalAmount = 0.0f;
	    		
	    		try
	    		{
	    			this.setAddSideBarJs("FALSE");
	    			
					connection = GetDBConnection.getDBConnection(db);
	    			
	    			if(this.getCustomerNameCode() == null || this.getCustomerNameCode().equals(""))
	    			{
	    			
		    			sql = "SELECT "
		    					+ "payement_entry_id,"
		    					+ "customer_id,"
		    					+ "customer_name,"
		    					+ "DATE_FORMAT(payment_date,'%d-%m-%Y'),"
		    					+ "amount,"
		    					+ "payemnt_details "
		    					+ "FROM "
		    					+ "crusher_customer_payment_details_master "
		    					+ "WHERE "
		    					+ "(payment_date "
		    					+ "BETWEEN "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
		    					+ "AND "
		    					+ "crusher_id = ? "
		    					+ "AND "
		    					+ "crusher_code = ? ";
		    			
		    			preparedStatement = connection.prepareStatement(sql);
		    			preparedStatement.setString(1, this.getFromDate());
		    			preparedStatement.setString(2, this.getToDate());
		    			preparedStatement.setString(3, crusherId);
		    			preparedStatement.setString(4, crusherCode);
		    			
		    			
		    			
		    			
	    			}
	    			else
	    			{
	    				sql = "SELECT "
		    					+ "payement_entry_id,"
		    					+ "customer_id,"
		    					+ "customer_name,"
		    					+ "DATE_FORMAT(payment_date,'%d-%m-%Y'),"
		    					+ "amount,"
		    					+ "payemnt_details "
		    					+ "FROM "
		    					+ "crusher_customer_payment_details_master "
		    					+ "WHERE "
		    					+ "(customer_name LIKE '%"+this.getCustomerNameCode().trim()+"%' "
		    					+ "OR "
		    					+ "customer_id LIKE '%"+this.getCustomerNameCode().trim()+"%' ) "
		    							+ "AND "
		    							+ "crusher_id = ? "
		    							+ "AND "
		    							+ "crusher_code = ? ";
	    				
	    				preparedStatement = connection.prepareStatement(sql);
	    				preparedStatement.setString(1, crusherId);
	    				preparedStatement.setString(2, crusherCode);
	    				
		    			
		    		
	    			}
	    			
	    			
	    			
	    			resultSet = preparedStatement.executeQuery();
	    			
	    			int rowCount = 0;
	    			resultSet.last();
	    			rowCount = resultSet.getRow();
	    			resultSet.beforeFirst();
	    			
	    			if(rowCount > 0)
	    			{
	    				
	    				
	    				while(resultSet.next())
	    				{
	    					CustomerPaymentDetailsDAO dao = new CustomerPaymentDetailsDAO();
	    					
	    					dao.setPaymentId(resultSet.getString(1));
	    					dao.setCustId(resultSet.getString(2));
	    					dao.setCustName(resultSet.getString(3));
	    					dao.setPaymentDate(resultSet.getString(4));
	    					dao.setAmount(resultSet.getFloat(5));
	    					dao.setDetails(resultSet.getString(6));
	    					
	    					totalAmount = totalAmount + resultSet.getFloat(5);
	    					
	    					this.getCustPaymentDetailsDAOList().add(dao);
	    				}
	    				
	    				result = "success";
	    			}
	    			else
	    			{
	    				result = "error";
	    				addActionError("Records not found for provided information!");
	    			}
	    			
	    		}	    		
	    		catch (SQLException e) {
	    			
	    			result = "error";
	    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong!");
	    		}finally {
	    			if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
       	
       	
       	
       	
       }
       
       return result;
}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public List<CustomerPaymentDetailsDAO> getCustPaymentDetailsDAOList() {
		return custPaymentDetailsDAOList;
	}


	public void setCustPaymentDetailsDAOList(List<CustomerPaymentDetailsDAO> custPaymentDetailsDAOList) {
		this.custPaymentDetailsDAOList = custPaymentDetailsDAOList;
	}


	public String getCustomerNameCode() {
		return customerNameCode;
	}


	public void setCustomerNameCode(String customerNameCode) {
		this.customerNameCode = customerNameCode;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}


	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}


	public String getDownloadType() {
		return downloadType;
	}


	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public Float getTotalAmount() {
		return totalAmount;
	}


	public void setTotalAmount(Float totalAmount) {
		this.totalAmount = totalAmount;
	}
	
	
}


