package com.stonecrusher.report;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.DAO.VehicleConsumptionInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.opensymphony.xwork2.ActionSupport;

public class GetConsumptionReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap;
	
	private String fromDate;
	private String toDate;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private String addSideBarJs;
	private String vehicleId;
	private ArrayList<VehicleConsumptionInfoDAO> vehicleConInfoList = new ArrayList<VehicleConsumptionInfoDAO> ();
	private Float totalConsumptionAmount = 0.0F;
	private Float totalQuantity = 0.0F;
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	this.setAddSideBarJs("FALSE");
	        
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
				
	    		String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
	        
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					if(!this.getVehicleId().equals("ALL"))
					{
							sql  = "SELECT "
									+ "coninfo.vehicle_expense_entry_id,"
									+ "coninfo.vehicle_id,"
									+ "vinfo.vehicle_make,"
									+ "vinfo.vehicle_registration_number,"
									+ "DATE_FORMAT(coninfo.consumption_date,'%d-%m-%Y'),"
									+ "coninfo.consupmtion_time,"									
									+ "coninfo.consumption_product_id,"
									+ "coninfo.consumption_product_name,"
									+ "coninfo.quantity,"
									+ "coninfo.product_rate,"
									+ "coninfo.amount,"
									+ "coninfo.entry_by,"
									+ "coninfo.consupmtion_details,"
									+ "coninfo.entry_type "
									+ "FROM "
									+ "crusher_vehicle_consumption_master AS coninfo "
									+ "INNER JOIN "
									+ "crusher_vehicle_details_master AS vinfo "
									+ "ON coninfo.vehicle_id = vinfo.vehicle_id "
									+ "WHERE "
									+ "coninfo.vehicle_id = ? "
									+ "AND "
									+ "(coninfo.consumption_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
									+ "AND "
									+ "coninfo.crusher_id = ? "
									+ "AND "
									+ "coninfo.crusher_code = ? "
									+ "AND "
									+ "vinfo.crusher_id = ? "
									+ "AND "
									+ "vinfo.crusher_code = ? ";
							
								preparedStatement = connection.prepareStatement(sql);
								preparedStatement.setString(1, this.getVehicleId());
								preparedStatement.setString(2, this.getFromDate());
								preparedStatement.setString(3, this.getToDate());
								preparedStatement.setString(4, crusherId);
								preparedStatement.setString(5, crusherCode);
								preparedStatement.setString(6, crusherId);
								preparedStatement.setString(7, crusherCode);
								
						
					
					}
					else if(this.getVehicleId().equals("ALL"))
					{
						sql  = "SELECT "
								+ "coninfo.vehicle_expense_entry_id,"
								+ "coninfo.vehicle_id,"
								+ "vinfo.vehicle_make,"
								+ "vinfo.vehicle_registration_number,"
								+ "DATE_FORMAT(coninfo.consumption_date,'%d-%m-%Y'),"
								+ "coninfo.consupmtion_time,"
								+ "coninfo.consumption_product_id,"
								+ "coninfo.consumption_product_name,"
								+ "coninfo.quantity,"
								+ "coninfo.product_rate,"
								+ "coninfo.amount,"
								+ "coninfo.entry_by,"
								+ "coninfo.consupmtion_details,"
								+ "coninfo.entry_type "
								+ "FROM "
								+ "crusher_vehicle_consumption_master AS coninfo "
								+ "INNER JOIN "
								+ "crusher_vehicle_details_master AS vinfo "
								+ "ON coninfo.vehicle_id = vinfo.vehicle_id "
								+ "WHERE "
								+ "(coninfo.consumption_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
								+ "AND "
								+ "coninfo.crusher_id = ? "
								+ "AND "
								+ "coninfo.crusher_code = ? "
								+ "AND "
								+ "vinfo.crusher_id = ? "
								+ "AND "
								+ "vinfo.crusher_code = ? ";
						
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, this.getFromDate());
							preparedStatement.setString(2, this.getToDate());
							preparedStatement.setString(3, crusherId);
							preparedStatement.setString(4, crusherCode);
							preparedStatement.setString(5, crusherId);
							preparedStatement.setString(6, crusherCode);
					}
					
					resultSet = preparedStatement.executeQuery();
					
					while(resultSet.next())
					{
						VehicleConsumptionInfoDAO infoDAO = new VehicleConsumptionInfoDAO();
						
						infoDAO.setEntryId(resultSet.getString(1));
						infoDAO.setVehicleId(resultSet.getString(2));
						infoDAO.setVehicleMake(resultSet.getString(3));
						infoDAO.setVehicleRegNumber(resultSet.getString(4));
						infoDAO.setConsumptionDate(resultSet.getString(5));
						infoDAO.setConsumptionTime(resultSet.getString(6));
						infoDAO.setProductId(resultSet.getString(7));
						infoDAO.setProductName(resultSet.getString(8));
						infoDAO.setQuantity(resultSet.getFloat(9));
						infoDAO.setRate(resultSet.getFloat(10));
						infoDAO.setAmount(resultSet.getFloat(11));
						infoDAO.setEntryBy(resultSet.getString(12));
						infoDAO.setConsumptionDetails(resultSet.getString(13));
						infoDAO.setEntryType(resultSet.getString(14));
						
						this.setTotalConsumptionAmount(this.getTotalConsumptionAmount() + resultSet.getFloat(11));
						this.setTotalQuantity(this.getTotalQuantity() + resultSet.getFloat(9));
						infoDAO.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)+"#"+resultSet.getString(2)+"#"+resultSet.getString(5)));
						this.getVehicleConInfoList().add(infoDAO);
						
					}
					
					if(this.getVehicleConInfoList().size() == 0)
					{
						addActionError(this.getText("message.error.noDetailsFoundForProvidedInputs"));
					}else {
					   
					    SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
					    Collections.sort(this.getVehicleConInfoList(), new Comparator<VehicleConsumptionInfoDAO>() {
					        @Override
					        public int compare(VehicleConsumptionInfoDAO o1, VehicleConsumptionInfoDAO o2) {
					            try {
					                Date date1 = dateFormat.parse(o1.getConsumptionDate());
					                Date date2 = dateFormat.parse(o2.getConsumptionDate());
					                return date1.compareTo(date2); 
					            } catch (ParseException e) {
					                e.printStackTrace();
					                return 0; 
					            }
					        }
					    });
					}

					
					result = SUCCESS;
					
				}
				catch (SQLException e) {
					e.printStackTrace();
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
					e.printStackTrace();
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	@Override
	public void validate() 
	{
		this.setAddSideBarJs("FALSE");
		downloadTypeList.add("pdf");
    	downloadTypeList.add("xl");
    	
		if(this.getVehicleId().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectVehicle"));
		}
		
		this.setVehicleList(GetListResource.getVehicleList(true, this.getSessionMap()));
	}
	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public Map<String, String> getVehicleList() {
		return vehicleList;
	}


	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	public String getVehicleId() {
		return vehicleId;
	}


	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public ArrayList<VehicleConsumptionInfoDAO> getVehicleConInfoList() {
		return vehicleConInfoList;
	}

	public void setVehicleConInfoList(ArrayList<VehicleConsumptionInfoDAO> vehicleConInfoList) {
		this.vehicleConInfoList = vehicleConInfoList;
	}

	public Float getTotalConsumptionAmount() {
		return totalConsumptionAmount;
	}

	public void setTotalConsumptionAmount(Float totalConsumptionAmount) {
		this.totalConsumptionAmount = totalConsumptionAmount;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}

	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}

	public String getDownloadType() {
		return downloadType;
	}

	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}

	public Float getTotalQuantity() {
		return totalQuantity;
	}

	public void setTotalQuantity(Float totalQuantity) {
		this.totalQuantity = totalQuantity;
	}
	

}



