package com.stonecrusher.report;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BankAccountStatementDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;

public class GetBankAccountReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4897790099069628703L;
	
	private HttpSession session; 

	private String accountNumber;
	private String ifscCode;
	private String branch;
	private String accHolderName;
	private String accountId;	
	private String fromDate;
	private String toDate;
	Map<String,String> accountList = new LinkedHashMap<String,String>();
	private List<BankAccountStatementDAO> reportList = new ArrayList<BankAccountStatementDAO>();
	
	private Float totalCreditAmount;
	private Float totalDebitAmount;
	private Float balanceAmount;
	private SessionMap<String,Object> sessionMap;  
	
	
	
	private Float yesterdayBallanceAmt  ;
	
	
	
	private String addSideBarJs;
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	
	    		String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
	        	float ttlCrAmt = 0.0F;
	        	float ttlDrAmt = 0.0F;
	        	float balAmt = 0.0F;
	        	
	        	this.setAccountList( GetAccountListForDrCr.getAccountList(this.getSessionMap())); 
	        	
	        	
	        	this.setAddSideBarJs("FALSE");

	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) this.getSession().getAttribute("db");
	        	
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
		            DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
		            
		            LocalDate fromDateLocal = LocalDate.parse(fromDate, inputFormatter);
		            LocalDate yesterdayDate = fromDateLocal.minusDays(1);

		            String yesterdayDateFormatted = yesterdayDate.format(outputFormatter);

		            
		            
		            
		            sql = "SELECT "
		                    + "closeing_bal_amount "
		                    + "FROM "
		                    + "datewise_closing_balance "
		                    + "WHERE "
		                    + "account_id = ? "
		                    + "AND "
		                    + "crusher_id = ? "
		                    + "AND "
		                    + "crusher_code = ? "
		                    + "AND "
		                    + "closeing_bal_date <= ? "
		                    + "ORDER BY "
		                    + "closeing_bal_date DESC "
		                    + "LIMIT 1";

		            preparedStatement = connection.prepareStatement(sql);

		            preparedStatement.setString(1, this.getAccountId());
		            preparedStatement.setString(2, crusherId);
		            preparedStatement.setString(3, crusherCode);
		            preparedStatement.setString(4, yesterdayDateFormatted);


	        		resultSet = preparedStatement.executeQuery();
	        		if(resultSet.next())
	        		{
	        			yesterdayBallanceAmt = resultSet.getFloat(1);
	        			
	        		}
	        		
	        		
	        		
	        		if(resultSet != null)
	        		{
	        			resultSet.close();
	        			resultSet = null;
	        		}
	        		if(preparedStatement!= null)
	        		{
	        			preparedStatement.close();
	        			preparedStatement = null;
	        		}
	        		
					float openingBal = 0.0F;
	        		sql = "SELECT "
	        				+ "opening_balance,"
	        				+ "account_holder_name,"
	        				+ "account_number,"
	        				+ "ifsc_code,"
	        				+ "bank_name,"
	        				+ "branch "
	        				+ "FROM "
	        				+ "crusher_bank_account "
	        				+ "WHERE "
	        				+ "account_id  = ? "
	        				+ "AND "
	        				+ "crusher_id = ? "
	        				+ "AND "
	        				+ "crusher_code = ? ";
	        			
	        		preparedStatement = connection.prepareStatement(sql);
	        		
	        		preparedStatement.setString(1, this.getAccountId());
	        		preparedStatement.setString(2, crusherId);
	        		preparedStatement.setString(3, crusherCode);
	        		
	        		
	        		resultSet = preparedStatement.executeQuery();
	        		if(resultSet.next())
	        		{
	        			openingBal = resultSet.getFloat(1);
	        		}
	        		
	        		if(resultSet != null)
	        		{
	        			resultSet.close();
	        			resultSet = null;
	        		}
	        		if(preparedStatement!= null)
	        		{
	        			preparedStatement.close();
	        			preparedStatement = null;
	        		}
					sql = "SELECT "
							+ "entry_id,"
							+ "account_id,"
							+ "account_number,"
							+ "entry_date,"
							+ "DATE_FORMAT(entry_date,'%d-%m-%Y'),"
							+ "entry_time,"
							+ "entry_type,"
							+ "amount,"
							+ "payment_type,"
							+ "entry_by,"
							+ "entry_details,"
							+ "entry_source "
							+ "FROM "
							+ "bank_account_credit_debit_master "
							+ "WHERE "
							+ "account_id = ? "
							+ "AND "
							+ "(entry_date "
							+ "BETWEEN "
							+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "order by "
							+ "entry_date";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, this.getAccountId());
					preparedStatement.setString(2, this.getFromDate());
					preparedStatement.setString(3, this.getToDate());
					preparedStatement.setString(4, crusherId);
					preparedStatement.setString(5, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					resultSet.last();
					
					int rowCount = resultSet.getRow();
					
					resultSet.beforeFirst();
					
					if(rowCount > 0)
					{
						float balance;
						
						if(yesterdayBallanceAmt == null) {
							 balance = openingBal ;
							 yesterdayBallanceAmt = openingBal;
						}else {
							 balance = this.getYesterdayBallanceAmt() ;
						}
						
						while(resultSet.next())
						{
							BankAccountStatementDAO dao = new BankAccountStatementDAO();
							dao.setDateAsString(resultSet.getString(5));
							dao.setEntryId(resultSet.getString(1));
							dao.setEntryType(resultSet.getString(7));
							dao.setAmount(resultSet.getFloat(8));
							dao.setPaymentType(resultSet.getString(9));
							dao.setEntryBy(resultSet.getString(10));
							dao.setAccountId(resultSet.getString(2));
							String entrySource = resultSet.getString(12);
							
							boolean isEntryFromBank = "BANK CREDIT ".equalsIgnoreCase(entrySource) || "BANK DEBIT ".equalsIgnoreCase(entrySource);
							dao.setEntryFromBank(isEntryFromBank);

							if(resultSet.getString(7).equals("CREDIT"))
							{
								ttlCrAmt = ttlCrAmt + resultSet.getFloat(8);
								balance = balance + resultSet.getFloat(8);
							}
							if(resultSet.getString(7).equals("DEBIT"))
							{
								ttlDrAmt = ttlDrAmt + resultSet.getFloat(8);
								balance = balance - resultSet.getFloat(8);
							}
							
							balAmt = balance;
							
							dao.setBalance(balance);
							dao.setEntryDetails(resultSet.getString(11));
							
							dao.setEntrySaved(true);
							dao.setEntryIdNew(EncryptionDecryption.encrypt(String.valueOf(dao.getEntryId())));
							
							dao.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)+"#"+this.getAccountId()+"#"+resultSet.getString(7)));
							this.getReportList().add(dao);
						}
						
						
						this.setTotalCreditAmount(ttlCrAmt);
						this.setTotalDebitAmount(ttlDrAmt );
						this.setBalanceAmount(balAmt );
						
						result = "success";
						
						
					}
					else
					{
						result = "error";
						addActionError(this.getText("message.error.detailsNotFoundPlzTryAgain"));
					}
					
					
					
				}catch (SQLException e) {
					result = "error";
					e.printStackTrace();
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.accountDetailsNotFound"));
				} catch (IOException e) {
					
					result = "error";						
					addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.accountDetailsNotFound"));
				}finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	result = "success";
	        }
        
        return result;
}

@Override
public void validate() {
	session=ServletActionContext.getRequest().getSession(false); 
	this.setAccountList( GetAccountListForDrCr.getAccountList(this.getSessionMap()));     
	this.setAddSideBarJs("FALSE");
	
	
	if(this.getAccountId().equals(""))
	{
		addActionError(this.getText("message.error.plzSelectAccount"));
	}
	
	if(!hasActionErrors())
	{
		if(this.getFromDate().equals("") && this.getToDate().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectDates"));
		}
	}
}

public HttpSession getSession() {
	return session;
}

public void setSession(HttpSession session) {
	this.session = session;
}

public String getAccountId() {
	return accountId;
}

public void setAccountId(String accountId) {
	this.accountId = accountId;
}

public String getFromDate() {
	return fromDate;
}

public void setFromDate(String fromDate) {
	this.fromDate = fromDate;
}

public String getToDate() {
	return toDate;
}

public void setToDate(String toDate) {
	this.toDate = toDate;
}

public Map<String, String> getAccountList() {
	return accountList;
}

public void setAccountList(Map<String, String> accountList) {
	this.accountList = accountList;
}

public static long getSerialversionuid() {
	return serialVersionUID;
}

public List<BankAccountStatementDAO> getReportList() {
	return reportList;
}

public void setReportList(List<BankAccountStatementDAO> reportList) {
	this.reportList = reportList;
}

public String getAccountNumber() {
	return accountNumber;
}

public void setAccountNumber(String accountNumber) {
	this.accountNumber = accountNumber;
}

public String getIfscCode() {
	return ifscCode;
}

public void setIfscCode(String ifscCode) {
	this.ifscCode = ifscCode;
}

public String getBranch() {
	return branch;
}

public void setBranch(String branch) {
	this.branch = branch;
}

public String getAccHolderName() {
	return accHolderName;
}

public void setAccHolderName(String accHolderName) {
	this.accHolderName = accHolderName;
}

public Float getTotalCreditAmount() {
	return totalCreditAmount;
}

public void setTotalCreditAmount(Float totalCreditAmount) {
	this.totalCreditAmount = totalCreditAmount;
}

public Float getTotalDebitAmount() {
	return totalDebitAmount;
}

public void setTotalDebitAmount(Float totalDebitAmount) {
	this.totalDebitAmount = totalDebitAmount;
}

public Float getBalanceAmount() {
	return balanceAmount;
}

public void setBalanceAmount(Float balanceAmount) {
	this.balanceAmount = balanceAmount;
}

public String getAddSideBarJs() {
	return addSideBarJs;
}

public void setAddSideBarJs(String addSideBarJs) {
	this.addSideBarJs = addSideBarJs;
}

public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}

public void setSession(Map<String, Object> map) {  
    sessionMap=(SessionMap<String, Object>)map;  
}

public Float getYesterdayBallanceAmt() {
	return yesterdayBallanceAmt;
}

public void setYesterdayBallanceAmt(Float yesterdayBallanceAmt) {
	this.yesterdayBallanceAmt = yesterdayBallanceAmt;
}


}
