package com.stonecrusher.report;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.DayWiseCollectionDAO;
import com.stonecrusher.db.GetDBConnection;

public class DaywiseCollectionReport extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = -5638605039448515442L;

	private SessionMap<String,Object> sessionMap;
	private String fromDate;
	private String toDate;
	private HttpSession session;
	private List<DayWiseCollectionDAO> collectionDAOList = new ArrayList<DayWiseCollectionDAO>();
	private String defaultValue;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	
	private String totalBilling;
	private String totalCashCollected;
	private String totalCreditCollected;
	private String totalCreditGiven;
	private String totalCollection;
	private String addSideBarJs;
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	
	
	
	@Override
	public String execute(){
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	
	        	customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        	
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		try
	    		{
	    			
					connection = GetDBConnection.getDBConnection(db);
	    			
	    			 Date fromD=new SimpleDateFormat("dd-MM-yyyy").parse(this.getFromDate());  
	    			 Date toD=new SimpleDateFormat("dd-MM-yyyy").parse(this.getToDate());  
	    			 DateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	    			 
	    			 long diff = toD.getTime() -fromD.getTime() ;
	    			
	    			 long fromDateMillies = fromD.getTime();
	    			 
	    			 
	    			 List<String> listOfDays = new ArrayList<String>();
	    			 
	    			
	    			 	listOfDays.add(this.getFromDate());
	    			 	
	    				long diffDays = diff / (24 * 60 * 60 * 1000);
	    				
	    				int intDays = Integer.parseInt(""+diffDays);
	    				
	    				for(int i = intDays;i>0;i--)
	    				{
	    					fromDateMillies = fromDateMillies+(24 * 60 * 60 * 1000);
	    					Date d = new Date(fromDateMillies);	    					
	    					listOfDays.add(dateFormat.format(d));    					
	    				}
	    				
	    				 float floatTotalBilling=0.0F;
	    				 float floatTotalCashCollected=0.0F;
	    				 float floatTotalCreditCollected=0.0F;
	    				 float floatTotalCreditGiven=0.0F;
	    				 float floatTotalCollection=0.0F;
	    				 
	    				
	    				
	    				for(int i = 0;i<listOfDays.size();i++)
	    				{
	    					
	    					
	    					DayWiseCollectionDAO collectionDAO = new DayWiseCollectionDAO();
	    					
	    					
	    					// cash collection 
	    	    			sql = "SELECT "
	    	    					+ "bill_date,"
	    	    					+ "bill_total_amount,"
	    	    					+ "bill_amount_received,"
	    	    					+ "bill_amount_return "
	    	    					+ "FROM "
	    	    					+ "crusher_bill_info_master "
	    	    					+ "WHERE "
	    	    					+ "bill_date = STR_TO_DATE(?, '%d-%m-%Y') "
	    	    					+ "AND "
	    	    					+ "crusher_id = ? "
	    	    					+ "AND "
	    	    					+ "crusher_code = ? ";
	    	    			
	    	    			preparedStatement =connection.prepareStatement(sql);
	    	    			preparedStatement.setString(1, listOfDays.get(i));
	    	    			preparedStatement.setString(2, crusherId);
	    	    			preparedStatement.setString(3, crusherCode);
	    	    			
	    	    			resultSet = preparedStatement.executeQuery();
	    	    			
	    	    			float totalBillAmount = 0.0F;
	    	    			float totalCreditGiven = 0.0F;
	    	    			float totalAmountCollected = 0.0F;
	    	    			float totalCreditCollection =0.0F;
	    	    			while(resultSet.next())	    				
	    	    			{
	    	    				
    	    				if(resultSet.getString(2) != null && resultSet.getString(3) != null && resultSet.getString(4) != null)
    	    				{
	    	    				totalBillAmount = totalBillAmount + (Float.parseFloat(resultSet.getString(2)));
	    	    				
	    	    				float amtReceived = Float.parseFloat(resultSet.getString(3));
	    	    				float amountReturn  = Float.parseFloat(resultSet.getString(4));
	    	    				
	    	    				if(amountReturn > 0 )
	    	    				{
	    	    					totalAmountCollected = totalAmountCollected + Float.parseFloat(resultSet.getString(2));
	    	    				}
	    	    				else
	    	    				{
	    	    					totalAmountCollected = totalAmountCollected + amtReceived;
	    	    					totalCreditGiven = totalCreditGiven 
	    	    							+ (Float.parseFloat(resultSet.getString(2)) - amtReceived);
	    	    				}
	    	    				
	    	    				
	    	    			}
	    	    			
	    	    			
	    	    		}
	    	    			
	    	    			sql = "SELECT sum(amount) "
	    	    					+ "FROM "
	    	    					+ "crusher_customer_payment_details_master "
	    	    					+ "WHERE "
	    	    					+ "payment_date = STR_TO_DATE(?, '%d-%m-%Y') "
	    	    					+ "AND "
	    	    					+ "crusher_id = ? "
	    	    					+ "AND "
	    	    					+ "crusher_code = ? ";
	    	    			
	    	    			PreparedStatement ps = connection.prepareStatement(sql);
	    	    			
	    	    			ps.setString(1, listOfDays.get(i));
	    	    			ps.setString(2, crusherId);
	    	    			ps.setString(3, crusherCode);
	    	    			
	    	    			ResultSet rs = ps.executeQuery();
	    	    			
	    	    			
	    	    			if(rs.next())
	    	    			{
	    	    				try
	    	    				{
		    	    				if(rs.getString(1) != null)
		    	    				{
		    	    				
		    	    					totalCreditCollection = Float.parseFloat(rs.getString(1));
		    	    				}
		    	    				else
		    	    				{
		    	    					totalCreditCollection = 0.0F;
		    	    				}
	    	    				}catch(NumberFormatException nfe)
	    	    				{}
	    	    			}
	    	    			
	    	    			collectionDAO.setCollectionDate(listOfDays.get(i));
	    	    			collectionDAO.setTotalBilling(""+totalBillAmount);
	    	    			collectionDAO.setTotalCashCollection(""+totalAmountCollected);
	    	    			collectionDAO.setTotalCreditCollection(""+totalCreditCollection);
	    	    			collectionDAO.setTotalCreeditGiven(""+totalCreditGiven);
	    	    			collectionDAO.setTotalCollection(""+(totalCreditCollection+totalAmountCollected));
	    	    			
	    	    			floatTotalBilling = floatTotalBilling+ totalBillAmount;
	    	    			floatTotalCashCollected = floatTotalCashCollected + totalAmountCollected;
	    	    			floatTotalCreditCollected = floatTotalCreditCollected + totalCreditCollection;
	    	    			floatTotalCreditGiven = floatTotalCreditGiven + totalCreditGiven;
	    	    			floatTotalCollection = floatTotalCollection + (totalCreditCollection+totalAmountCollected);
	    	    			
	    	    			
	    	    			collectionDAOList.add(collectionDAO);	
	    	    			
	    	    			if(rs != null)
	    	    			{
	    	    				rs.close();
	    	    				rs = null;
	    	    			}
	    	    			if(ps != null)
	    	    			{
	    	    				ps.close();
	    	    				ps = null;
	    	    			}
	    				}
	    				
	    				
	    				this.setTotalBilling(""+floatTotalBilling);
	    				this.setTotalCashCollected(""+floatTotalCashCollected);
	    				this.setTotalCreditCollected(""+floatTotalCreditCollected);
	    				this.setTotalCreditGiven(""+floatTotalCreditGiven);
	    				this.setTotalCollection(""+floatTotalCollection);
	    				
	    				this.setAddSideBarJs("FALSE");
	    				result = "success";

	    		}
	    		 catch (SQLException e) {
		    			
		    			result = "error";
		    			
		    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" ||"+this.getText("message.error.somethingWentWrong"));
		    		} catch (IOException e) {
		    			result = "error";
		    			
		    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.somethingWentWrong"));
		    		} catch (ParseException e) {
		    			result = "error";
		    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.somethingWentWrong"));
					}finally {
		    			if(resultSet != null)
						{
							try {
								resultSet.close(); resultSet= null;
							} catch (SQLException e) {
								
							}
						}
		    			if(preparedStatement != null)
		    			{
		    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
		    			}
		    			if(connection != null)
		    			{
		    				
		    				try {connection.close(); connection = null;}catch (SQLException e) {}
		    			}
		    			
		    		}
	        	
	        }
	        
	        return result;
	}

	@Override
	public void validate() {
		
		downloadTypeList.add("pdf");
    	downloadTypeList.add("xl");
    	
    	this.setAddSideBarJs("FALSE");
		
    	
		try
		{
		 Date fromD=new SimpleDateFormat("dd-MM-yyyy").parse(this.getFromDate());  
		 Date toD=new SimpleDateFormat("dd-MM-yyyy").parse(this.getToDate());
		 long diff = toD.getTime() -fromD.getTime() ;
		 

			
			long diffDays = diff / (24 * 60 * 60 * 1000);
			
			if(diffDays > 31)
			{
				addActionError(this.getText("message.error.countOfDaysMoreThan31IsNotAllowed"));
			}
		}catch(Exception e)
		{
			   
		}
	}
	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public List<DayWiseCollectionDAO> getCollectionDAOList() {
		return collectionDAOList;
	}

	public void setCollectionDAOList(List<DayWiseCollectionDAO> collectionDAOList) {
		this.collectionDAOList = collectionDAOList;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getTotalBilling() {
		return totalBilling;
	}

	public void setTotalBilling(String totalBilling) {
		this.totalBilling = totalBilling;
	}

	public String getTotalCashCollected() {
		return totalCashCollected;
	}

	public void setTotalCashCollected(String totalCashCollected) {
		this.totalCashCollected = totalCashCollected;
	}

	public String getTotalCreditCollected() {
		return totalCreditCollected;
	}

	public void setTotalCreditCollected(String totalCreditCollected) {
		this.totalCreditCollected = totalCreditCollected;
	}

	public String getTotalCreditGiven() {
		return totalCreditGiven;
	}

	public void setTotalCreditGiven(String totalCreditGiven) {
		this.totalCreditGiven = totalCreditGiven;
	}

	public String getTotalCollection() {
		return totalCollection;
	}

	public void setTotalCollection(String totalCollection) {
		this.totalCollection = totalCollection;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}

	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}

	public String getDownloadType() {
		return downloadType;
	}

	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}
	   
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	

}
