package com.stonecrusher.print;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;
import static org.vandeseer.easytable.settings.VerticalAlignment.BOTTOM;
import static org.vandeseer.easytable.settings.VerticalAlignment.MIDDLE;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;
import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.ChallanInfoDAO;
import com.stonecrusher.DAO.ChallanProductInfoDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetVehicleDetailsById;

public class ChallanPrintOnly extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -1414976236123269184L;
	/**
	 * 
	 */

	
	private HttpSession session;
	private SessionMap<String,Object> sessionMap;
	private ChallanInfoDAO challanInfoDAO = null;
	private List<ChallanProductInfoDAO> challanProductInfoList = null;
	public HttpServletRequest request;
	public HttpServletResponse response;
	private String challanNumber;
	private String size;
	private String lang;
 
	
	  private final static Color BLUE_DARK = new Color(76, 129, 190);
	    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
	    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

	    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
	    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
	    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
	    private static final float PADDING20 = 20f;
	    public void printChallanOnly() throws Exception {
		String vehicleNumber = "";
    	String tripFrom = "";
    	String tripTo = "";
    	String vehicleMake = "";
    	String driverName = "";
    	String driverMobileNumber = "";
    	String custNameMarathi = "";
    	String custAddMarathi = "";
    	String billTime = "";
		boolean isBillNumberFound = false;
		DecimalFormat df = new DecimalFormat("##.##");
				
		String crusherId = (String) this.getSessionMap().get("crusherId");
		String crusherCode = (String) this.getSessionMap().get("crusherCode");
		

		
		        Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = "crushererpsoft";
				try
	        	{
	        		
					challanInfoDAO = new ChallanInfoDAO();
					challanProductInfoList = new ArrayList<ChallanProductInfoDAO>();
	        	      
	        
				connection = GetDBConnection.getDBConnection(db);
	        	
	        	sql = "select "
	        			+ "DATE_FORMAT(challan_date,'%d-%M-%Y'),"
	        			+ "challan_entry_time,"
	        			+ "payment_type,"
	        			+ "customer_id,"
	        			+ "customer_name,"
	        			+ "vehicle_id,"
	        			+ "veihcle_reg_number,"
	        			+ "trip_start_location,"
	        			+ "trip_end_location,"
	        			+ "total_trip_count,"
	        			+ "comments "
	        			+ "FROM "
	        			+ "crusher_delivery_challan_master "
	        			+ "WHERE "
	        			+ "challan_number = ? "
	        			+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ?";
	        	
	        	preparedStatement = connection.prepareStatement(sql);
	        	preparedStatement.setString(1, this.getChallanNumber());
	        	preparedStatement.setString(2, crusherId);
				preparedStatement.setString(3, crusherCode);
				
	        	resultSet = preparedStatement.executeQuery();
	        	
	        	resultSet.last();
	        	int rowCount = resultSet.getRow();
	        	resultSet.beforeFirst();	        	
	        	
	        	if(rowCount>0)
	        	{
	        		
	        		isBillNumberFound = true;
			        	
	        		
	        			while(resultSet.next())
			        	{
			        		challanInfoDAO.setChallanDate(resultSet.getString(1));
			        		billTime = resultSet.getString(2);
			        		challanInfoDAO.setChallanNumber(getChallanNumber());
			        		challanInfoDAO.setPaymentType(resultSet.getString(3));
			        		challanInfoDAO.setCustomerId(resultSet.getString(4));
			        		challanInfoDAO.setCustomerName(resultSet.getString(5)); 
			        		challanInfoDAO.setVehicleId(resultSet.getString(6));
			        		challanInfoDAO.setVehicleRegNumber(resultSet.getString(7));
			        		
			        		challanInfoDAO.setTransportCharges(0.0F);
			        		challanInfoDAO.setTripFrom(resultSet.getString(8));
			        		challanInfoDAO.setTripTo(resultSet.getString(9));
			        		challanInfoDAO.setTotalTripCount(resultSet.getInt(10));
			        		challanInfoDAO.setComments(resultSet.getString(11));
			        	}
	        	
    			
    			
			        	if(resultSet != null)
			        	{
			        		resultSet.close();
			        		resultSet = null;
			        	}
			        	if(preparedStatement != null)
			        	{
			        		preparedStatement.close();
			        		preparedStatement = null;
			        	
			        	}
			        	
			        	sql = "SELECT "
			        			+ "customer_id,"
			        			+ "customer_name,"
			        			+ "cust_name_marathi,"
			        			+ "billing_address,"
			        			+ "billing_address_marathi,"
			        			+ "pincode_number,"
			        			+ "gst_number "
			        			+ "FROM "
			        			+ "crusher_customer_master "
			        			+ "WHERE "
			        			+ "customer_id = ? "
			        			+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
			        	
			        	preparedStatement = connection.prepareStatement(sql);
			        	preparedStatement.setString(1, challanInfoDAO.getCustomerId());
			        	preparedStatement.setString(2, crusherId);
        				preparedStatement.setString(3, crusherCode);
        				
			        	resultSet = preparedStatement.executeQuery();
			        	
			        	if(resultSet.next())
			        	{
			        		
			        		challanInfoDAO.setCustomerAddress(resultSet.getString(4));
			        		custNameMarathi = resultSet.getString(3);
			        		custAddMarathi = resultSet.getString(5);
			        		resultSet.getString(6);
			        		resultSet.getString(7);
			        	}
			        	else
			        	{
			        		challanInfoDAO.setCustomerAddress("");
			        	}
			        	
			        	if(resultSet != null)
			        	{
			        		resultSet.close();
			        		resultSet = null;
			        	}
			        	if(preparedStatement != null)
			        	{
			        		preparedStatement.close();
			        		preparedStatement = null;
			        	
			        	}
			        	sql = "SELECT "
			        			+ "product_id,"
			        			+ "product_name_eng,"
			        			+ "sale_unit,"
			        			+ "quantity "
			        			+ "FROM "
			        			+ "challan_product_details "
			        			+ "WHERE "
			        			+ "challan_number = ? "
			        			+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
			        	
			        	
			        	preparedStatement = connection.prepareStatement(sql);
			        	preparedStatement.setString(1, this.getChallanNumber());
			        	preparedStatement.setString(2, crusherId);
        				preparedStatement.setString(3, crusherCode);
        				
        				resultSet = preparedStatement.executeQuery();
			        	
			        	while(resultSet.next())
			        	{
			        	 
			        		ChallanProductInfoDAO productInfoDAO = new ChallanProductInfoDAO();
			        		productInfoDAO.setProductName(resultSet.getString(2));
			        		productInfoDAO.setSalesUnit(resultSet.getString(3));
			        		productInfoDAO.setQuantity(resultSet.getFloat(4));
			        		this.getChallanProductInfoList().add(productInfoDAO);
			        	}
			        	
	        	}
	        	
				
				if(isBillNumberFound)
				{

			 	
					HashMap<String,String> vehicleDetails = GetVehicleDetailsById.getVehicleDetailsById(this.getChallanInfoDAO().getVehicleId(), this.getSessionMap(), connection);
		        
		        	
		        	/*System.out.println("Total Amount : "+floatTotalAmount);
		        	System.out.println("Total Discount : "+floatTotalDiscount);
		        	System.out.println("Total amount Payble : "+floatTotalAmtAfterDiscount);*/
		        	
		        
		        	
		        	response = ServletActionContext.getResponse();
		 			
		 			request = ServletActionContext.getRequest();
		 			
		 			String path = request.getSession().getServletContext().getRealPath("/images/");
		 			
					if(this.getLang().equalsIgnoreCase("eng") && this.getSize().equals("A4"))
					{
						
						//System.out.println("Bill Type:"+billInfoDAO.getBillType());
						PDDocument document = new PDDocument(); 
						PDPage page = null;
						 page = new PDPage(PDRectangle.A4);
					
					
				         document.addPage(page);
				         PDPageContentStream contentStream = new PDPageContentStream(document, page);
		 			
				         request.getSession().getServletContext().getRealPath("/images/");
			        		
				         
				         
	     		
				        String companyName = (String) this.getSessionMap().get("crushernameenglish");
				        String address = (String) this.getSessionMap().get("dcaddress");
				       	  
				         Table header;
				         Table billNumberTable;
				         Table customerDetails;				      
				         Table productDetails;
				         Table vehicleDetailsTable;
				         Table bottomInfo;
				         Table signature;
				         
				         
				         
				         
				          TableBuilder tableHeaderBuilder = Table.builder()
					                .addColumnsOfWidth(550)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				       
				          //System.out.println("Bill Type -"+sagarBillDAO.getTypeOfBill());
				          Row taxInvoice = Row.builder()
					                .add(TextCell.builder().text("DELIVERY CHALLAN").horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(12)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         
				          Row headerName = Row.builder()
					                .add(TextCell.builder().text(companyName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(30)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          
				          Row addressRow = Row.builder()
					                .add(TextCell.builder().text(address).borderWidthBottom(0.5F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row contactRow = Row.builder()
					                .add(TextCell.builder().text("").borderWidthBottom(1F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row gstRow = Row.builder()
					                .add(TextCell.builder().text("").borderWidthBottom(0.5F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          
				         tableHeaderBuilder.addRow(taxInvoice);
				         tableHeaderBuilder.addRow(headerName);
				         tableHeaderBuilder.addRow(addressRow);
				         tableHeaderBuilder.addRow(contactRow);
				         tableHeaderBuilder.addRow(gstRow);
				         
				         header = tableHeaderBuilder.build();
				         
				         
				      
				         TableBuilder billNumberDate = Table.builder()
					                .addColumnsOfWidth(139,135,135,135)				                
					                .font(HELVETICA)
					                .borderWidth(1)
					                .borderColor(Color.BLACK);
				         
				         
				         Row billNumberDateRow1 = Row.builder()
					                .add(TextCell.builder().text("Challan Number").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(challanInfoDAO.getChallanNumber()).horizontalAlignment(LEFT).fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Challan Date").horizontalAlignment(RIGHT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(challanInfoDAO.getChallanDate()).horizontalAlignment(LEFT).fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         Row billNumberDateRow2 = Row.builder()
					                .add(TextCell.builder().text("Mode Of Payment").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(challanInfoDAO.getPaymentType()).horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())		               
						            .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)				              
					                .horizontalAlignment(CENTER)
					                .build();
				       
				         
				         billNumberDate.addRow(billNumberDateRow1);
				         billNumberDate.addRow(billNumberDateRow2);
				     
				         billNumberTable =billNumberDate.build();
				         
				         TableBuilder tableCustDetailsBuilder = Table.builder()
					                .addColumnsOfWidth(475)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				         Row custDetailsRow1 = Row.builder()
					                .add(TextCell.builder().text("Details Of Receiver (Billed To)").horizontalAlignment(CENTER).borderWidth(0).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         Row custDetailsRow2 = Row.builder()
					                .add(TextCell.builder().text("Customer Name:  ").horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(9)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         Row custDetailsRow3 = Row.builder()
					                .add(TextCell.builder().text("Address: "+challanInfoDAO.getCustomerAddress()).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         Row custDetailsRow4 = Row.builder()
					                .add(TextCell.builder().text("Mobile:  ").horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(9)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				        
				         tableCustDetailsBuilder.addRow(custDetailsRow1);
				         tableCustDetailsBuilder.addRow(custDetailsRow2);
				         tableCustDetailsBuilder.addRow(custDetailsRow3);
				         tableCustDetailsBuilder.addRow(custDetailsRow4);
				      
				         
				         customerDetails = tableCustDetailsBuilder.build();
				        
				   
				         TableBuilder tableproductDetailsBuilder = Table.builder()
					                .addColumnsOfWidth(30,230,90)				                
					                .font(HELVETICA)
					                .borderWidth(0.5F)
					                .borderColor(Color.BLACK);
				         
				         Row productDetailsRow1 = Row.builder()
					                .add(TextCell.builder().text("Sr.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("Description Of Goods").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Qty").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(Color.LIGHT_GRAY)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         tableproductDetailsBuilder.addRow(productDetailsRow1);
				            
				         int srNo = 1;
				         
				         for(int i=0;i<=5;i++)
				         {
				        	
				        	 
				        	 ChallanProductInfoDAO dao = null;
				        	 try
				        	 {
				        		 dao =this.getChallanProductInfoList().get(i);
				        	 }
				        	 catch(Exception e)
				        	 {
				        		 dao = null;
				        	 }
				        			
				        	 if(dao != null)
				        	 {
				        		 
				        		
				        		
				        		 Row productDetailsRow = Row.builder()
							                .add(TextCell.builder().text(""+srNo).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())				                
							                .add(TextCell.builder().text(dao.getProductName().toUpperCase()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text(df.format(dao.getQuantity())).horizontalAlignment(LEFT).borderWidth(0.5F).verticalAlignment(MIDDLE).lineSpacing(1F).build())					                
							                .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(11)				              
							                .horizontalAlignment(CENTER)
							                .height(22F)					                
							                .build();
						         tableproductDetailsBuilder.addRow(productDetailsRow);
					         
					         srNo++;
				        	 }
				        	 
				        	 else
				        	 {

					        	  Row productDetailsRow = Row.builder()
							                .add(TextCell.builder().text("").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(10F).build())				                
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())
							                .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(9)				              
							                .horizontalAlignment(CENTER)
							                .height(22F)	
							                .build();
						         tableproductDetailsBuilder.addRow(productDetailsRow);
						         
						         srNo++;
				        	 }
				         
				         }
				         
				         productDetails = tableproductDetailsBuilder.build();
				         
				         
				         
				       
				        
				        TableBuilder vehicleDetailsBuilder = Table.builder()
				                .addColumnsOfWidth(100,100)				                
				                .font(HELVETICA)
				                .borderWidth(1)
				                .horizontalAlignment(LEFT)
				                .borderColor(Color.BLACK);
				        
				        
				        Row vehicleRow = Row.builder()
				                .add(TextCell.builder().text("Trip Details").colSpan(2).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(10F).build())				                
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD)
				                .fontSize(9)				              
				                .horizontalAlignment(CENTER)
				                .height(23F)	
				                .build();
				        vehicleDetailsBuilder.addRow(vehicleRow);  
				        
				        Row vehicleRow1 = Row.builder()
				                .add(TextCell.builder().text("Vehicle Make").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())				                
				                .add(TextCell.builder().text(vehicleMake).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD)
				                .fontSize(9)				              
				                .horizontalAlignment(CENTER)
				                .height(23F)	
				                .build();
				        vehicleDetailsBuilder.addRow(vehicleRow1);  
						        	
						        	 
				        Row vehicleRow2 = Row.builder()
				                .add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())				                
				                .add(TextCell.builder().text(vehicleNumber).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD)
				                .fontSize(9)				              
				                .horizontalAlignment(CENTER)
				                .height(23F)	
				                .build();
				        vehicleDetailsBuilder.addRow(vehicleRow2);  
					
					Row vehicleRow3 = Row.builder()
							                .add(TextCell.builder().text("From").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())				                
							                .add(TextCell.builder().text(tripFrom).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())
							                .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD)
							                .fontSize(9)				              
							                .horizontalAlignment(CENTER)
							                .height(23F)	
							                .build();
					vehicleDetailsBuilder.addRow(vehicleRow3);
					
					
					
					
					
		        	Row vehicleRow4 = Row.builder()
			                .add(TextCell.builder().text("To").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())				                
			                .add(TextCell.builder().text(tripTo).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())
			                .backgroundColor(Color.WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD)
			                .fontSize(9)				              
			                .horizontalAlignment(CENTER)
			                .height(23F)	
			                .build();
		        	vehicleDetailsBuilder.addRow(vehicleRow4);  
		        	
		        	vehicleDetailsTable = vehicleDetailsBuilder.build();
		        	
		        	
				       
				         
				         TableBuilder tableBottomInfoBuilder = Table.builder()
					                .addColumnsOfWidth(520)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK);
				         

				         Row bottomInfoRow2 = Row.builder()
					                .add(TextCell.builder().text(""
					                		+ "Declaration : We declare that this bill shows the "
					                		+ "actual price of the goods described, that all perticulers "
					                		+ "are true and correct. "
					                		).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.0F).verticalAlignment(BOTTOM).lineSpacing(10F).build())
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA)
					                .fontSize(9)				              
					                .horizontalAlignment(CENTER)
					                .height(20F)	
					                .build();
				         
				         
				       
				     
				       if(challanInfoDAO.getComments() == null || challanInfoDAO.getComments().equals(""))
				       {
				    	   challanInfoDAO.setComments("NA");
				       }
				       if(challanInfoDAO.getComments().equals("NA"))
				         {
				         Row bottomInfoRowComments = Row.builder()
					                .add(TextCell.builder().text("Comments:").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA)
					                .fontSize(10)
					                .height(30F)
					                .horizontalAlignment(CENTER)					               	
					                .build();
				         tableBottomInfoBuilder.addRow(bottomInfoRowComments);
				         
				         }
				         else
				         {
				        	 Row bottomInfoRowComments = Row.builder()
						                .add(TextCell.builder().text("Comments:"+challanInfoDAO.getComments()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
						                .backgroundColor(Color.WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA)
						                .fontSize(10)
						                .height(30F)
						                .horizontalAlignment(CENTER)					               	
						                .build();
					         tableBottomInfoBuilder.addRow(bottomInfoRowComments);
				         }
				       tableBottomInfoBuilder.addRow(bottomInfoRow2);			        
				       bottomInfo = tableBottomInfoBuilder.build();
				         
				         
				         
				         TableBuilder signatureBuiler = Table.builder()
					                .addColumnsOfWidth(260,260)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				         
				         Row signRow1 = Row.builder()
					                .add(TextCell.builder().text("Receiver Signature").verticalAlignment(BOTTOM).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())
					                .add(TextCell.builder().text("For Propriter").verticalAlignment(BOTTOM).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())					               
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)
					                .fontSize(9)				              
					                .horizontalAlignment(CENTER)
					                .height(20F)	
					                .build();
				         signatureBuiler.addRow(signRow1);
				       
				         
				         signature = signatureBuiler.build(); 
			        
				         float startY = page.getMediaBox().getHeight() - PADDING20;
					        
					       
				         page.getCropBox().getUpperRightY();
				         page.getCropBox().getLowerLeftX();
				         page.getCropBox().getUpperRightX();
				       
				    
				        
				        
				       TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(header)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				       
				        
				      
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(billNumberTable)
		                .startX(PADDING20)
		                .startY(startY-100)
		                .build()
		                .draw();
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(customerDetails)
		                .startX(70)
		                .startY(startY-150)
		                .build()
		                .draw();
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(productDetails)
		                .startX(PADDING20)
		                .startY(startY-230)
		                .build()
		                .draw();
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(vehicleDetailsTable)
		                .startX(PADDING20)
		                .startY(startY-385)
		                .build()
		                .draw();
				        
				     
				       
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(bottomInfo)
		                .startX(PADDING20)
		                .startY(startY-505)
		                .build()
		                .draw();
				        
				      TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(signature)
		                .startX(PADDING20)
		                .startY(startY-780)
		                .build()
		                .draw();
			        	 
						
		
				      contentStream.close();
				        
				       // System.out.println(path);
								
				        
				        document.save(path+"/bill.pdf");
				        document.close();
				        
				        

						response.setHeader("Content-disposition", "inline; filename=bill.pdf");
						response.setContentType("application/pdf");
						FileInputStream fileInputStream = new FileInputStream(path+"/bill.pdf");
						PrintWriter out = response.getWriter();  
						int bytes;
						while ((bytes = fileInputStream.read()) != -1) {
							out.write(bytes);
						}
						fileInputStream.close();
						out.flush();
						out.close();
			        
					}
					
					if(this.getLang().equalsIgnoreCase("eng") && this.getSize().equals("A5"))
					{

						PDDocument document = new PDDocument(); 
						PDPage page = null;
						 page = new PDPage(PDRectangle.A5);
					

					        String companyName = (String) this.getSessionMap().get("crushernameenglish");
					        String address = (String) this.getSessionMap().get("dcaddress");
					     
					        String contactNum = (String) this.getSessionMap().get("crushercustcarenumber");
					        String emailId = (String) this.getSessionMap().get("dcemailaddress");
							  
					        
				         document.addPage(page);
				         PDPageContentStream contentStream = new PDPageContentStream(document, page);
		 			
				         request.getSession().getServletContext().getRealPath("/images/");
			        		
	     		
				        // PDImageXObject pdImageNirmitiLogo = PDImageXObject.createFromFile(imagePath+"/nirmiti-logo.jpg", document);
					    
				       	  
				         Table header;
				         Table billNumberTable;
				         Table customerDetails;				      
				         Table productDetails;
				         Table vehicleDetailsTable;
				         Table bottomInfo;
				         Table signature;
				         
				         
				         
				         
				          TableBuilder tableHeaderBuilder = Table.builder()
					                .addColumnsOfWidth(380)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				       
				          //System.out.println("Bill Type -"+sagarBillDAO.getTypeOfBill());
				          Row taxInvoice = Row.builder()
					                .add(TextCell.builder().text("DELIVERY CHALLAN").horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(6)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         
				          Row headerName = Row.builder()
					                .add(TextCell.builder().text(companyName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(15)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          
				         // System.out.println("address : "+address);
				          Row addressRow = Row.builder()
					                .add(TextCell.builder().text(address).borderWidthBottom(0.5F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row contactRow = Row.builder()
					                .add(TextCell.builder().text("Contact : "+contactNum).borderWidthBottom(1F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          
				          Row emailRow = Row.builder()
					                .add(TextCell.builder().text("Email : "+emailId).borderWidthBottom(1F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				         
				          
				         tableHeaderBuilder.addRow(taxInvoice);
				         tableHeaderBuilder.addRow(headerName);
				         tableHeaderBuilder.addRow(addressRow);
				         tableHeaderBuilder.addRow(contactRow);
				         tableHeaderBuilder.addRow(emailRow);
						    
				       //  tableHeaderBuilder.addRow(gstRow);
				         
				         header = tableHeaderBuilder.build();
				         
				         
				      
				         TableBuilder billNumberDate = Table.builder()
					                .addColumnsOfWidth(60,60,60,60,40,100)				                
					                .font(HELVETICA)
					                .borderWidth(1)
					                .borderColor(Color.BLACK);
				         
				         
				         Row billNumberDateRow1 = Row.builder()
					                .add(TextCell.builder().text("Challan Number").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(6).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(challanInfoDAO.getChallanNumber()).horizontalAlignment(LEFT).fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Mode Of Payment").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(6).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(challanInfoDAO.getPaymentType()).horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(6).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text("Challan Date").horizontalAlignment(RIGHT).borderWidth(0.5F).fontSize(6).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(challanInfoDAO.getChallanDate()).horizontalAlignment(LEFT).fontSize(8).borderWidth(0.5F).lineSpacing(1F).build())
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				       /*  Row billNumberDateRow2 = Row.builder()
					                .add(TextCell.builder().text("Mode Of Payment").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(billInfoDAO.getPaymentType()).horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text("Buyer Order Number").horizontalAlignment(RIGHT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())		               
						            .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         Row billNumberDateRow3 = Row.builder()
					                .add(TextCell.builder().text("State: Maharatshtra ").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(10).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text("Code : 27").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(10).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Dispatch Doc. Number").horizontalAlignment(RIGHT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
					                .add(TextCell.builder().text("").horizontalAlignment(LEFT).fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         */
				         billNumberDate.addRow(billNumberDateRow1);
				   //      billNumberDate.addRow(billNumberDateRow2);
				    //     billNumberDate.addRow(billNumberDateRow3);
				         billNumberTable =billNumberDate.build();
				         
				         TableBuilder tableCustDetailsBuilder = Table.builder()
					                .addColumnsOfWidth(380)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				         Row custDetailsRow1 = Row.builder()
					                .add(TextCell.builder().text("Details Of Customer (Billed To)").horizontalAlignment(CENTER).borderWidth(0).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
					                .horizontalAlignment(CENTER)
					                .build();
				        
				         Row custDetailsRow2 = Row.builder()
					                .add(TextCell.builder().text("Customer Name:  "+challanInfoDAO.getCustomerName()).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				        // System.out.println(billInfoDAO.getCustomerAddress());
				         
				         Row custDetailsRow3 = Row.builder()
					                .add(TextCell.builder().text("Address: "+challanInfoDAO.getCustomerAddress()).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         Row custDetailsRow4 = Row.builder()
					                .add(TextCell.builder().text("Mobile:  "+challanInfoDAO.getCustomerMobile()).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				        
				         tableCustDetailsBuilder.addRow(custDetailsRow1);
				         tableCustDetailsBuilder.addRow(custDetailsRow2);
				         tableCustDetailsBuilder.addRow(custDetailsRow3);
				         tableCustDetailsBuilder.addRow(custDetailsRow4);
				      
				         
				         customerDetails = tableCustDetailsBuilder.build();
				        
				   
				         TableBuilder tableproductDetailsBuilder = Table.builder()
					                .addColumnsOfWidth(20,170,90,90)				                
					                .font(HELVETICA)
					                .borderWidth(0.5F)
					                .borderColor(Color.BLACK);
				         
				         Row productDetailsRow1 = Row.builder()
					                .add(TextCell.builder().text("Sr.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("Description Of Goods").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Qty").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("Unit").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						              .backgroundColor(Color.LIGHT_GRAY)
					                .textColor(Color.BLACK)
					                .height(12.0F)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         tableproductDetailsBuilder.addRow(productDetailsRow1);
				            
				         int srNo = 1;
				         
				         for(int i=0;i<=5;i++)
				         {
				        	
				        	 
				        	 ChallanProductInfoDAO dao = null;
				        	 try
				        	 {
				        		 dao =this.getChallanProductInfoList().get(i);
				        	 }
				        	 catch(Exception e)
				        	 {
				        		 dao = null;
				        	 }
				        			
				        	 if(dao != null)
				        	 {
				        	
				        		// int qty = Integer.parseInt(dao.getProductQuantity());
				        	
				        		// totalMaterialCost = totalMaterialCost + totalUnitAmount;
				       	
				        		 Row productDetailsRow = Row.builder()
							                .add(TextCell.builder().text(""+srNo).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())				                
							                .add(TextCell.builder().text(dao.getProductName().toUpperCase()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text(df.format(dao.getQuantity())).horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE).lineSpacing(1F).build())					                
							                .add(TextCell.builder().text(dao.getSalesUnit()).horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE).lineSpacing(1F).build())					                
								            .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(9)				              
							                .horizontalAlignment(CENTER)
							                .height(15F)					                
							                .build();
						         tableproductDetailsBuilder.addRow(productDetailsRow);
					         
					         srNo++;
				        	 }
				        	 
				        	 else
				        	 {

					        	  Row productDetailsRow = Row.builder()
							                .add(TextCell.builder().text("").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())				                
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								             .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(9)				              
							                .horizontalAlignment(CENTER)
							                .height(15F)	
							                .build();
						         tableproductDetailsBuilder.addRow(productDetailsRow);
						         
						         srNo++;
				        	 }
				         
				         }
				         
				         productDetails = tableproductDetailsBuilder.build();
				         
				         
				         
				       
				        
				        TableBuilder vehicleDetailsBuilder = Table.builder()
				                .addColumnsOfWidth(70,90)				                
				                .font(HELVETICA)
				                .borderWidth(1)
				                .horizontalAlignment(LEFT)
				                .borderColor(Color.BLACK);
				        
				        
				        Row vehicleRow = Row.builder()
				                .add(TextCell.builder().text("Trip Details").colSpan(2).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())				                
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD)
				                .fontSize(8)				              
				                .horizontalAlignment(CENTER)
				                .height(15F)	
				                .build();
				        vehicleDetailsBuilder.addRow(vehicleRow);  
				        
				        Row vehicleRow1 = Row.builder()
				                .add(TextCell.builder().text("Vehicle Make").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
				                .add(TextCell.builder().text(vehicleDetails.get("VEHICLEMAKE")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD)
				                .fontSize(8)				              
				                .horizontalAlignment(CENTER)
				                .height(15F)	
				                .build();
				        vehicleDetailsBuilder.addRow(vehicleRow1);  
						        	
						        	 
				        Row vehicleRow2 = Row.builder()
				                .add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
				                .add(TextCell.builder().text(vehicleDetails.get("REGISTRATIONNUMBER")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD)
				                .fontSize(7)				              
				                .horizontalAlignment(CENTER)
				                .height(15F)	
				                .build();
				        vehicleDetailsBuilder.addRow(vehicleRow2);  
					
					Row vehicleRow3 = Row.builder()
							                .add(TextCell.builder().text("From").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())				                
							                .add(TextCell.builder().text(this.getChallanInfoDAO().getTripFrom()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())
							                .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD)
							                .fontSize(7)				              
							                .horizontalAlignment(CENTER)
							                .height(15F)	
							                .build();
					vehicleDetailsBuilder.addRow(vehicleRow3);
					
					
					
					
					
		        	Row vehicleRow4 = Row.builder()
			                .add(TextCell.builder().text("To").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())				                
			                .add(TextCell.builder().text(this.getChallanInfoDAO().getTripTo()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())
			                .backgroundColor(Color.WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD)
			                .fontSize(7)				              
			                .horizontalAlignment(CENTER)
			                .height(15F)	
			                .build();
		        	vehicleDetailsBuilder.addRow(vehicleRow4);  
		        	
		        	
		        	Row vehicleRow5 = Row.builder()
			                .add(TextCell.builder().text("Driver").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())				                
			                .add(TextCell.builder().text(vehicleDetails.get("DRIVERNAME")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())
			                .backgroundColor(Color.WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD)
			                .fontSize(7)				              
			                .horizontalAlignment(CENTER)
			                .height(15F)	
			                .build();
		        	vehicleDetailsBuilder.addRow(vehicleRow5);  
		        	
		        	Row vehicleRow6 = Row.builder()
			                .add(TextCell.builder().text("Mobile").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())				                
			                .add(TextCell.builder().text(vehicleDetails.get("DRIVERMOBILE")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())
			                .backgroundColor(Color.WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD)
			                .fontSize(7)				              
			                .horizontalAlignment(CENTER)
			                .height(15F)	
			                .build();
		        	vehicleDetailsBuilder.addRow(vehicleRow6);  
		        	
		        	vehicleDetailsTable = vehicleDetailsBuilder.build();
				       
				         
				         TableBuilder tableBottomInfoBuilder = Table.builder()
					                .addColumnsOfWidth(380)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK);
				         

				         Row bottomInfoRow2 = Row.builder()
					                .add(TextCell.builder().text(""
					                		+ "Declaration : We declare that this bill shows the "
					                		+ "actual price of the goods described, that all perticulers "
					                		+ "are true and correct. "
					                		).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.0F).verticalAlignment(BOTTOM).lineSpacing(1F).build())
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA)
					                .fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .height(15F)	
					                .build();
				         
				         
				       
				         
				      
				       if(challanInfoDAO.getComments() == null || challanInfoDAO.getComments().equals(""))
				       {
				    	   challanInfoDAO.setComments("NA");
				       }
				       if(challanInfoDAO.getComments().equals("NA"))
				         {
				         Row bottomInfoRowComments = Row.builder()
					                .add(TextCell.builder().text("Comments:").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA)
					                .fontSize(8)
					                .height(20F)
					                .horizontalAlignment(CENTER)					               	
					                .build();
				         tableBottomInfoBuilder.addRow(bottomInfoRowComments);
				         
				         }
				         else
				         {
				        	 Row bottomInfoRowComments = Row.builder()
						                .add(TextCell.builder().text("Comments:"+challanInfoDAO.getComments()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
						                .backgroundColor(Color.WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA)
						                .fontSize(8)
						                .height(20F)
						                .horizontalAlignment(CENTER)					               	
						                .build();
					         tableBottomInfoBuilder.addRow(bottomInfoRowComments);
				         }
				       tableBottomInfoBuilder.addRow(bottomInfoRow2);			        
				       bottomInfo = tableBottomInfoBuilder.build();
				         
				         
				         
				         TableBuilder signatureBuiler = Table.builder()
					                .addColumnsOfWidth(190,190)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				         
				         Row signRow1 = Row.builder()
					                .add(TextCell.builder().text("Customer Signature").verticalAlignment(BOTTOM).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())
					                .add(TextCell.builder().text("For "+companyName).verticalAlignment(BOTTOM).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())					               
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)
					                .fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .height(20F)	
					                .build();
				         signatureBuiler.addRow(signRow1);
				       
				         
				         signature = signatureBuiler.build(); 
			        
				         float startY = page.getMediaBox().getHeight() - PADDING20;
					        
					       
				         page.getCropBox().getUpperRightY();
				         page.getCropBox().getLowerLeftX();
				         page.getCropBox().getUpperRightX();
				       
				    
				        
				        
				       TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(header)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				       
				        
				      
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(billNumberTable)
		                .startX(PADDING20)
		                .startY(startY-70)
		                .build()
		                .draw();
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(customerDetails)
		                .startX(PADDING20)
		                .startY(startY-110)
		                .build()
		                .draw();
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(productDetails)
		                .startX(PADDING20)
		                .startY(startY-170)
		                .build()
		                .draw();
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(vehicleDetailsTable)
		                .startX(PADDING20)
		                .startY(startY-275)
		                .build()
		                .draw();
				        
				  
				       
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(bottomInfo)
		                .startX(PADDING20)
		                .startY(startY-390)
		                .build()
		                .draw();
				        
				      TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(signature)
		                .startX(PADDING20)
		                .startY(startY-530)
		                .build()
		                .draw();
			        	 
						
				   //   contentStream.drawImage(pdImageNirmitiLogo, 30, 550, 100, 30);
				      contentStream.close();
				        
				       // System.out.println(path);
								
				        
				        document.save(path+"/bill.pdf");
				        document.close();
				        
				        

						response.setHeader("Content-disposition", "inline; filename=bill.pdf");
						response.setContentType("application/pdf");
						FileInputStream fileInputStream = new FileInputStream(path+"/bill.pdf");
						PrintWriter out = response.getWriter();  
						int bytes;
						while ((bytes = fileInputStream.read()) != -1) {
							out.write(bytes);
						}
						fileInputStream.close();
						out.flush();
						out.close();
			        
					
					}
					
					if(this.getLang().equalsIgnoreCase("mar") && this.getSize().equals("A5"))
					{

						PDDocument document = new PDDocument(); 
						PDPage page = null;
						 page = new PDPage(PDRectangle.A5);
					
					
				         document.addPage(page);
				         PDPageContentStream contentStream = new PDPageContentStream(document, page);
		 			
				         String imagePath=	request.getSession().getServletContext().getRealPath("/images/");
			        		
	     		
				         PDImageXObject pdImagejagdambaLogo = PDImageXObject.createFromFile(imagePath+"mrbillhead.jpg", document);
				       //PDImageXObject pdImageNirmitiHeading = PDImageXObject.createFromFile(imagePath+"/nirmiti-heading.png", document);
				      //   PDImageXObject pdImageYashSCAddress = PDImageXObject.createFromFile(imagePath+"/yash-sc-address.jpg", document);
				         /*  PDImageXObject pdImageNirmitiContact = PDImageXObject.createFromFile(imagePath+"/nirmiti-contact.png", document);
				         PDImageXObject pdImageNirmitiSiteContact = PDImageXObject.createFromFile(imagePath+"/nirmiti-site-contact.png", document);
						   
				         	*/
				         File fontFile  =  new File( request.getSession().getServletContext().getRealPath("/fonts/Nirmala.ttf"));
				         File fontFileBold  =  new File( request.getSession().getServletContext().getRealPath("/fonts/nirmala-bold.ttf"));
				 		
						 TrueTypeFont ttf1 = new TTFParser().parse(fontFile);
						 TrueTypeFont ttf2 = new TTFParser().parse(fontFileBold);
						 
						 File fontFilekrutiDev  =  new File( request.getSession().getServletContext().getRealPath("/fonts/Krutidev.ttf"));
						 
						 TrueTypeFont ttf3 = new TTFParser().parse(fontFilekrutiDev);
						 
						 
						 PDFont fontMarathi = PDType0Font.load(document, ttf1, true);
						 PDType0Font.load(document, ttf2, true);
						 PDFont krutiDev = PDType0Font.load(document, ttf3, true);
				       	  
				         Table header;
				         Table billNumberTable;
				         Table customerDetails;				      
				         Table productDetails;
				         Table vehicleDetailsTable;
				         Table bottomInfo;
				         Table signature;
				         
				         
				         
				         
				          TableBuilder tableHeaderBuilder = Table.builder()
					                .addColumnsOfWidth(380)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				       
				          //System.out.println("Bill Type -"+sagarBillDAO.getTypeOfBill());
				          Row taxInvoice = Row.builder()
					                .add(TextCell.builder().text("BILL-OF-SUPPLY").horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(6)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         
				          Row.builder()
					                .add(TextCell.builder().text("JAGDAMBA STONE CRUSHER").horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(fontMarathi).fontSize(15)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row.builder()
					                .add(TextCell.builder().text("").borderWidthBottom(0.5F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(fontMarathi).fontSize(7)
					                .horizontalAlignment(CENTER)
					                .build();
				        
				          Row.builder()
					                .add(TextCell.builder().text("").borderWidthBottom(1F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(fontMarathi).fontSize(7)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row.builder()
					                .add(TextCell.builder().text("GST NO : ").borderWidthBottom(0.5F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          
				         tableHeaderBuilder.addRow(taxInvoice);
				     //    tableHeaderBuilder.addRow(headerName);
				         //tableHeaderBuilder.addRow(addressRow);
				        // tableHeaderBuilder.addRow(contactRow);
				       //  tableHeaderBuilder.addRow(gstRow);
				         
				         header = tableHeaderBuilder.build();
				         
				         
				      
				         TableBuilder billNumberDate = Table.builder()
					                .addColumnsOfWidth(60,60,60,60,40,100)				                
					                .font(HELVETICA)
					                .borderWidth(1)
					                .borderColor(Color.BLACK);
				         
				         Row billNumberDateRow1 = Row.builder()
					                .add(TextCell.builder().text("Ã Â¤Â¿Ã Â¤Â¬Ã Â¤Â² Ã Â¤Â¨Ã Â¤â€šÃ Â¤Â¬Ã Â¤Â°").font(fontMarathi).fontSize(9).horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(challanInfoDAO.getChallanNumber()).font(fontMarathi).fontSize(9).horizontalAlignment(LEFT).fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("ns; izdkj").font(krutiDev).fontSize(15).horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(challanInfoDAO.getPaymentType()).font(fontMarathi).fontSize(9).horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text("Ã Â¤Â¿Ã Â¤Â¦Ã Â¤Â¨Ã Â¤Â¾Ã Â¤â€šÃ Â¤â€¢").font(fontMarathi).fontSize(9).horizontalAlignment(RIGHT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(challanInfoDAO.getChallanDate()).font(fontMarathi).fontSize(9).horizontalAlignment(LEFT).fontSize(8).borderWidth(0.5F).lineSpacing(1F).build())
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .horizontalAlignment(CENTER)
					                .build();
				         
				       /*  Row billNumberDateRow2 = Row.builder()
					                .add(TextCell.builder().text("Mode Of Payment").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(billInfoDAO.getPaymentType()).horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text("Buyer Order Number").horizontalAlignment(RIGHT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())		               
						            .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         Row billNumberDateRow3 = Row.builder()
					                .add(TextCell.builder().text("State: Maharatshtra ").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(10).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text("Code : 27").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(10).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Dispatch Doc. Number").horizontalAlignment(RIGHT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
					                .add(TextCell.builder().text("").horizontalAlignment(LEFT).fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         */
				         billNumberDate.addRow(billNumberDateRow1);
				   //      billNumberDate.addRow(billNumberDateRow2);
				    //     billNumberDate.addRow(billNumberDateRow3);
				         billNumberTable =billNumberDate.build();
				         
				         TableBuilder tableCustDetailsBuilder = Table.builder()
					                .addColumnsOfWidth(380)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				         Row custDetailsRow1 = Row.builder()
					                .add(TextCell.builder().text("fcy riÃ¢â‚¬ï¿½khy").horizontalAlignment(CENTER).borderWidth(0).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(krutiDev).fontSize(16)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         String custDetails [] = challanInfoDAO.getCustomerName().split("-");
				         
				         Row custDetailsRow2 = Row.builder()
					                .add(TextCell.builder().text("Ã Â¤â€“Ã Â¤Â°Ã Â¥â€¡Ã Â¤Â¦Ã Â¥â‚¬Ã Â¤Â¦Ã Â¤Â¾Ã Â¤Â° : "+custNameMarathi).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(fontMarathi).fontSize(10)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         Row custDetailsRow3 = Row.builder()
					                .add(TextCell.builder().text("Ã Â¤Â°Ã Â¤Â¾: "+custAddMarathi).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(fontMarathi).fontSize(10)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         Row custDetailsRow4 = Row.builder()
					                .add(TextCell.builder().text("Ã Â¤Â®Ã Â¥â€¹Ã Â¤Â¬Ã Â¤Â¾Ã Â¤Ë†Ã Â¤Â²:  "+custDetails[2]).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(fontMarathi).fontSize(10)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				        
				         tableCustDetailsBuilder.addRow(custDetailsRow1);
				         tableCustDetailsBuilder.addRow(custDetailsRow2);
				         tableCustDetailsBuilder.addRow(custDetailsRow3);
				         tableCustDetailsBuilder.addRow(custDetailsRow4);
				      
				         
				         customerDetails = tableCustDetailsBuilder.build();
				        
				   
				         TableBuilder tableproductDetailsBuilder = Table.builder()
					                .addColumnsOfWidth(30,160,90)				                
					                .font(HELVETICA)
					                .borderWidth(0.5F)
					                .borderColor(Color.BLACK);
				         
				         Row productDetailsRow1 = Row.builder()
					                .add(TextCell.builder().text("va-dz").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("riÃ¢â‚¬ï¿½khy").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("ux").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(Color.LIGHT_GRAY)
					                .textColor(Color.BLACK)
					                .height(12.0F)
					                .font(krutiDev).fontSize(10)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         tableproductDetailsBuilder.addRow(productDetailsRow1);
				            
				         int srNo = 1;
				         
				         for(int i=0;i<=5;i++)
				         {
				        	
				        	 
				        	 ChallanProductInfoDAO dao = null;
				        	 try
				        	 {
				        		 dao =this.getChallanProductInfoList().get(i);
				        	 }
				        	 catch(Exception e)
				        	 {
				        		 dao = null;
				        	 }
				        			
				        	 if(dao != null)
				        	 {
				        		 
				        		 
				        		 Row productDetailsRow = Row.builder()
							                .add(TextCell.builder().text(""+srNo).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())				                
							                .add(TextCell.builder().text(dao.getProductName().toUpperCase()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text(df.format(dao.getQuantity())).horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE).lineSpacing(1F).build())					                
							                .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(fontMarathi)
							                .fontSize(9)				              
							                .horizontalAlignment(CENTER)
							                .height(15F)					                
							                .build();
						         tableproductDetailsBuilder.addRow(productDetailsRow);
					         
					         srNo++;
				        	 }
				        	 
				        	 else
				        	 {

					        	  Row productDetailsRow = Row.builder()
							                .add(TextCell.builder().text("").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())				                
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(9)				              
							                .horizontalAlignment(CENTER)
							                .height(15F)	
							                .build();
						         tableproductDetailsBuilder.addRow(productDetailsRow);
						         
						         srNo++;
				        	 }
				         
				         }
				         
				         productDetails = tableproductDetailsBuilder.build();
				         
				         
				         
				       
				        
				        TableBuilder vehicleDetailsBuilder = Table.builder()
				                .addColumnsOfWidth(70,120)				                
				                .font(HELVETICA)
				                .borderWidth(1)
				                .horizontalAlignment(LEFT)
				                .borderColor(Color.BLACK);
				        
				        
				        Row vehicleRow = Row.builder()
				                .add(TextCell.builder().text("").colSpan(2).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())				                
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(krutiDev)
				                .fontSize(12)				              
				                .horizontalAlignment(CENTER)
				                .height(15F)	
				                .build();
				        vehicleDetailsBuilder.addRow(vehicleRow);  
				        
				        Row vehicleRow1 = Row.builder()
				                .add(TextCell.builder().text("xkMh").font(krutiDev).fontSize(10).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
				                .add(TextCell.builder().text(vehicleMake).font(fontMarathi).fontSize(8).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)              
				                .horizontalAlignment(CENTER)
				                .height(15F)	
				                .build();
				        vehicleDetailsBuilder.addRow(vehicleRow1);  
						        	
						        	 
				        Row vehicleRow2 = Row.builder()
				                .add(TextCell.builder().text("xkMh uacj").font(krutiDev).fontSize(10).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
				                .add(TextCell.builder().text(vehicleNumber).font(fontMarathi).fontSize(8).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .fontSize(7)				              
				                .horizontalAlignment(CENTER)
				                .height(15F)	
				                .build();
				        vehicleDetailsBuilder.addRow(vehicleRow2);  
					
					/*Row vehicleRow3 = Row.builder()
							                .add(TextCell.builder().text("From").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())				                
							                .add(TextCell.builder().text(tripFrom).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())
							                .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD)
							                .fontSize(7)				              
							                .horizontalAlignment(CENTER)
							                .height(23F)	
							                .build();
					vehicleDetailsBuilder.addRow(vehicleRow3);*/
					
					
					
					
					
		        	Row vehicleRow4 = Row.builder()
			                .add(TextCell.builder().text("à¤¸à¥�à¤¥à¤¾à¤¨").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())				                
			                .add(TextCell.builder().text(tripTo).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())
			                .backgroundColor(Color.WHITE)
			                .textColor(Color.BLACK)
			                .font(fontMarathi)
			                .fontSize(7)				              
			                .horizontalAlignment(CENTER)
			                .height(15F)	
			                .build();
		        	vehicleDetailsBuilder.addRow(vehicleRow4);  
		        	
		        	
		        	Row vehicleRow5 = Row.builder()
			                .add(TextCell.builder().text("à¤¡à¥�à¤°à¤¾à¤¯à¤µà¤° à¤¨à¤¾à¤µ").font(krutiDev).fontSize(10).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())				                
			                .add(TextCell.builder().text(driverName).font(fontMarathi).fontSize(7).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())
			                .backgroundColor(Color.WHITE)
			                .textColor(Color.BLACK)	              
			                .horizontalAlignment(CENTER)
			                .height(15F)	
			                .build();
		        	vehicleDetailsBuilder.addRow(vehicleRow5);  
		        	
		        
		        	Row vehicleRow6 = Row.builder()
			                .add(TextCell.builder().text("à¤®à¥‹à¤¬à¤¾à¤ˆà¤² à¤¨à¤‚à¤¬à¤°").font(krutiDev).fontSize(10).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())				                
			                .add(TextCell.builder().text(driverMobileNumber).font(fontMarathi).fontSize(8).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(10F).build())
			                .backgroundColor(Color.WHITE)
			                .textColor(Color.BLACK)             
			                .horizontalAlignment(CENTER)
			                .height(15F)	
			                .build();
		        	vehicleDetailsBuilder.addRow(vehicleRow6);  
		        	
		        	vehicleDetailsTable = vehicleDetailsBuilder.build();
		        	
		        	
		                
				         
				        
				         
				   
				      
				      
				         TableBuilder tableBottomInfoBuilder = Table.builder()
					                .addColumnsOfWidth(80,300)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK);
				         

				         Row.builder()
					                .add(TextCell.builder().text(""
					                		+ "Declaration : We declare that this bill shows the "
					                		+ "actual price of the goods described, that all perticulers "
					                		+ "are true and correct. "
					                		).colSpan(2).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.0F).verticalAlignment(BOTTOM).lineSpacing(1F).build())
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA)
					                .fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .height(15F)	
					                .build();
				         
				         
				       
				       
				         
				       
				       
				       if(challanInfoDAO.getComments() == null || challanInfoDAO.getComments().equals(""))
				       {
				    	   challanInfoDAO.setComments("NA");
				       }
				       if(challanInfoDAO.getComments().equals("NA"))
				         {
				         Row bottomInfoRowComments = Row.builder()
					                .add(TextCell.builder().text("Comments:").colSpan(2).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(fontMarathi)
					                .fontSize(8)
					                .height(20F)
					                .horizontalAlignment(CENTER)					               	
					                .build();
				         tableBottomInfoBuilder.addRow(bottomInfoRowComments);
				         
				         }
				         else
				         {
				        	 Row bottomInfoRowComments = Row.builder()
						                .add(TextCell.builder().text("Comments:"+challanInfoDAO.getComments()).colSpan(2).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
						                .backgroundColor(Color.WHITE)
						                .textColor(Color.BLACK)
						                .font(fontMarathi)
						                .fontSize(8)
						                .height(20F)
						                .horizontalAlignment(CENTER)					               	
						                .build();
					         tableBottomInfoBuilder.addRow(bottomInfoRowComments);
				         }
				      // tableBottomInfoBuilder.addRow(bottomInfoRow2);	
				       
				       bottomInfo = tableBottomInfoBuilder.build();
				       
				       
				       TableBuilder signatureBuiler = Table.builder()
				                .addColumnsOfWidth(100,90,100,90)				                
				                .font(HELVETICA)
				                .borderColor(Color.BLACK)
				                .horizontalAlignment(CENTER);
				       
				       SimpleDateFormat _24HourSDF = new SimpleDateFormat("HH:mm");
				       Date _24HourDt = _24HourSDF.parse(billTime);
				       SimpleDateFormat _12HourSDF = new SimpleDateFormat("hh:mm a");
				       
				       Row bottomInfoRowBillTime = Row.builder()
				                .add(TextCell.builder().text("xkMh fu?k.;kph osG%").font(krutiDev).fontSize(11).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
				                .add(TextCell.builder().text(_12HourSDF.format(_24HourDt)).font(fontMarathi).fontSize(9).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
				                .add(TextCell.builder().text("xkMh iksgp.;kph osG%").font(krutiDev).fontSize(11).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
					            .add(TextCell.builder().text("").font(fontMarathi).fontSize(9).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .height(20F)
				                .horizontalAlignment(CENTER)					               	
				                .build();
				       signatureBuiler.addRow(bottomInfoRowBillTime);
				       
				         
				         
				         Row signRow1 = Row.builder()
					                .add(TextCell.builder().text("eky ?ks.kkj;kps uko o lgh").colSpan(2).verticalAlignment(BOTTOM).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())
					                .add(TextCell.builder().text("Tkxnack LVksu dzÃ¢â‚¬ï¿½kjlkBh").colSpan(2).verticalAlignment(BOTTOM).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())					               
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(krutiDev)
					                .fontSize(12)				              
					                .horizontalAlignment(CENTER)
					                .height(130F)	
					                .build();
				         signatureBuiler.addRow(signRow1);
				       
				         
				         signature = signatureBuiler.build(); 
			        
				         float startY = page.getMediaBox().getHeight() - PADDING20;
					        
					       
				         page.getCropBox().getUpperRightY();
				         page.getCropBox().getLowerLeftX();
				         page.getCropBox().getUpperRightX();
				       
				    
				         
				        
				         TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(header)
		                .startX(PADDING20)
		                .startY(startY+10)
		                .build()
		                .draw();
				       
				       
				      
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(billNumberTable)
		                .startX(PADDING20)
		                .startY(startY-90)
		                .build()
		                .draw();
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(customerDetails)
		                .startX(PADDING20)
		                .startY(startY-110)
		                .build()
		                .draw();
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(productDetails)
		                .startX(PADDING20)
		                .startY(startY-170)
		                .build()
		                .draw();
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(vehicleDetailsTable)
		                .startX(PADDING20)
		                .startY(startY-275)
		                .build()
		                .draw();
				        
				     
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(bottomInfo)
		                .startX(PADDING20)
		                .startY(startY-370)
		                .build()
		                .draw();
				        
				      TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(signature)
		                .startX(PADDING20)
		                .startY(startY-410)
		                .build()
		                .draw();
			        	 
						
				     // contentStream.drawImage(pdImagejagdambaLogo, 20, 540, 100, 40);			      
				     contentStream.drawImage(pdImagejagdambaLogo, 60, 550, 300, 25);
				    // contentStream.drawImage(pdImageYashSCAddress, 120, 530, 170, 12);
				     /*contentStream.drawImage(pdImageNirmitiContact, 60, 510, 310, 25);
				      contentStream.drawImage(pdImageNirmitiSiteContact, 90, 495, 250, 12);*/
				      contentStream.close();
				        
				       // System.out.println(path);
								
				        
				        document.save(path+"/bill.pdf");
				        document.close();
				        
				        

						response.setHeader("Content-disposition", "inline; filename=bill.pdf");
						response.setContentType("application/pdf");
						FileInputStream fileInputStream = new FileInputStream(path+"/bill.pdf");
						PrintWriter out = response.getWriter();  
						int bytes;
						while ((bytes = fileInputStream.read()) != -1) {
							out.write(bytes);
						}
						fileInputStream.close();
						out.flush();
						out.close();
						ttf1.close();
						ttf2.close();
						ttf3.close();
					
					}
					}
				
	        	}
	        	catch (SQLException e) {
					e.printStackTrace();
				} catch (IOException e) {
					e.printStackTrace();
				} catch (Exception e) {
					e.printStackTrace();
				}finally {
					if(resultSet != null)
    				{
    					try {
    						resultSet.close(); resultSet = null;
    					} catch (SQLException e) {
    						
    					}
    				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					
					if(connection != null)
					{
						try {connection.close(); connection = null;} catch (SQLException e) {}
						
					}
					
					
	        	}
		       
		   }

		public HttpSession getSession() {
			return session;
		}

		public void setSession(HttpSession session) {
			this.session = session;
		}

		public SessionMap<String, Object> getSessionMap() {
			return sessionMap;
		}

		public void setSessionMap(SessionMap<String, Object> sessionMap) {
			this.sessionMap = sessionMap;
		}

	

		public ChallanInfoDAO getChallanInfoDAO() {
			return challanInfoDAO;
		}

		public void setChallanInfoDAO(ChallanInfoDAO challanInfoDAO) {
			this.challanInfoDAO = challanInfoDAO;
		}

		public List<ChallanProductInfoDAO> getChallanProductInfoList() {
			return challanProductInfoList;
		}

		public void setChallanProductInfoList(List<ChallanProductInfoDAO> challanProductInfoList) {
			this.challanProductInfoList = challanProductInfoList;
		}

		public String getChallanNumber() {
			return challanNumber;
		}

		public void setChallanNumber(String challanNumber) {
			this.challanNumber = challanNumber;
		}

		@Override  
		public void setSession(Map<String, Object> map) {  
		    sessionMap=(SessionMap<String, Object>)map;  
		}

		public HttpServletRequest getRequest() {
			return request;
		}

		public void setRequest(HttpServletRequest request) {
			this.request = request;
		}

		public HttpServletResponse getResponse() {
			return response;
		}

		public void setResponse(HttpServletResponse response) {
			this.response = response;
		}

	

		public String getSize() {
			return size;
		}

		public void setSize(String size) {
			this.size = size;
		}

		public String getLang() {
			return lang;
		}

		public void setLang(String lang) {
			this.lang = lang;
		}

	
		
		

	}
